program egaorb;

uses dos,crt,orbega;

type
 mon=record
       name: string[8];
       shp: array[1..29] of shape;
       h,ml,m,s,ms: integer;
      end;
 monsters= array[1..8] of mon;
 class=record
        name: string[8];
        shp: array[1..24] of shape;
        h,a,ml,m,s,ms: integer;
        rt: boolean;
       end;
 classes=array[1..4] of class;
 menustrings=array[1..8] of string;
 highscores=array[1..10] of record
                             name: string[10];
                             score: longint;
                             winner: boolean;
                             class: byte;
                            end;
 dungeons=record
           l: array[1..32,1..32] of shortint;
           m: array[1..16] of record
                               t,h,x,y,mdir,mx,my: integer;
                              end;
           g: array[1..16] of record
                               t,h,x,y: integer;
                              end;
           sx,sy,ex,ey: byte;
          end;

 dungeonwalls= array[1..32,1..32] of boolean;

var
 f: array[32..127] of charshape;
 ffile: file of charshape;
 m: monsters;
 mfile: file of monsters;
 c: classes;
 cfile: file of classes;
 t: terrain;
 tfile: file of terrain;
 d: dungeons;
 dfile: file of dungeons;
 r,z: registers;
 delayfile: file of longint;
 joysticknumber,delaynumber,centerx,centery,button: longint;
 i,mr,mr2,level: byte;
 pstr: string;
 border: charshape;
 orbshp: charshape;
 orbshpfile: file of charshape;
 mstr: menustrings;
 temp: array[1..2] of charshape;
 temp2: array[1..2] of shape;
 move,joy,up,quit,quit2: boolean;
 valer: integer;
 high: highscores;
 highfile: file of highscores;
 tr: array[1..37] of byte;
 g: gridmap;
 ch: char;
 dw: dungeonwalls;
 cshp: array[1..16] of byte;
 joyb,joyb2: array[1..4] of boolean;
 mis: byte;
 under: array[1..16] of byte;
 underm: array[1..16] of byte;

procedure wrt(x,y: byte; what: string);
var
 i,j: byte;
 ch: char;
 ch2: string[1];
begin
 x:=x-1;
 if length(what)<>0 then begin
  for i:=1 to length(what) do begin
   ch2:=copy(what,i,1);
   ch:=ch2[1];
   j:=ord(ch);
   x:=x+1;
   if x>40 then begin
    x:=1;
    y:=y+1;
   end;
   if j<32 then j:=32;
   if j>127 then j:=32;
   ptext((x-1),(y-1)*2,f[j]);
  end;
 end;
end;

procedure wrt2(x,y: byte; what: string);
var
 i,j: byte;
 ch: char;
 ch2: string[1];
begin
 x:=x-1;
 if length(what)<>0 then begin
  for i:=1 to length(what) do begin
   ch2:=copy(what,i,1);
   ch:=ch2[1];
   j:=ord(ch);
   x:=x+1;
   if x>40 then begin
    x:=1;
    y:=y+1;
   end;
   if j<32 then j:=32;
   if j>127 then j:=32;
   saveptext((x-1),(y-1)*2,f[j],temp[1],temp[2]);
  end;
 end;
end;

procedure rd(x,y,maxchar: byte; var what: string);
var
 loop: integer;
 ch: char;
begin
 loop:=0;
 what:='';
 repeat
  loop:=loop+1;
  ptext((x-2+loop),(y-1)*2,f[127]);
  repeat
   repeat
   until keypressed;
   ch:=readkey;
  until (ch=chr(13)) or (ch=chr(8)) and (loop>1) or (ord(ch)>31) and (ord(ch)<127);
  if (ch<>chr(13)) and (ch<>chr(8)) and (loop<maxchar+1) then begin
   what:=what+ch;
   ptext((x-2+loop),(y-1)*2,f[ord(ch)]);
  end;
  if ch=chr(8) then begin
   what:=copy(what,1,length(what)-1);
   ptext((x-2+loop),(y-1)*2,f[32]);
   loop:=loop-2;
  end;
  if (loop=maxchar+1) and (ch<>chr(13)) then loop:=loop-1;
 until ch=chr(13);
 if ch=chr(13) then ptext((x-2+loop),(y-1)*2,f[32]);
end;

procedure block(x,y,len: byte);
var
 i: byte;
begin
 for i:=1 to len do begin
  ptext((x-2+i),(y-1)*2,border);
 end;
end;

procedure menu(x,y: byte; var mr: byte);
var
 maxm,i: byte;
 quit: boolean;
 ch: char;
begin
 maxm:=0;
 repeat
  maxm:=maxm+1;
 until mstr[maxm]='';
 maxm:=maxm-1;
 if maxm>0 then begin
  for i:=1 to maxm do begin
   wrt(x,y+(i-1)*2,mstr[i]);
  end;
  i:=mr;
  quit:=false;
  repeat
   wrt(x,y+(i-1)*2,mstr[i]);
   block(x,y+(mr-1)*2,length(mstr[mr]));
   wrt2(x,y+(mr-1)*2,mstr[mr]);
   i:=mr;
   repeat
   until keypressed;
   ch:=readkey;
   if (ch=#0) and (keypressed) then begin
    ch:=readkey;
    case ch of
     'H': mr:=mr-1;
     'P': mr:=mr+1;
     'K': mr:=mr-1;
     'M': mr:=mr+1;
    end;
    if mr<1 then mr:=maxm;
    if mr>maxm then mr:=1;
   end
   else begin
    if ch=#13 then quit:=true;
   end;
  until quit;
 end;
end;

procedure right;
begin
 for i:=2 to 25 do begin
  wrt(26,i,'               ');
 end;
end;

procedure setupgrid(x,y: byte);
var
 i,j: integer;
 z: byte;
begin
 for j:=y-5 to y+5 do begin
  for i:=x-5 to x+5 do begin
   if (i<1) or (i>32) or (j<1) or (j>32) then z:=46
   else begin
    if (d.l[i,j]<0) or ((i=d.sx) and (j=d.sy)) then z:=0
    else z:=tr[d.l[i,j]]-1;
   end;
   g[i-(x-5)+1+(j-(y-5))*11]:=z;
  end;
 end;
 newdrawgrid(screen^,g,t);
 {if up then drawgridup(g,t) else drawgridright(g,t);}
 for j:=y-5 to y+5 do begin
  for i:=x-5 to x+5 do begin
   if (i>0) and (i<33) and (j>0) and (j<33) then begin
    if d.l[i,j]<0 then newsavedraw(screen^,(i-(x-5))*2,(j-(y-5))*4,m[d.g[abs(d.l[i,j])].t].shp[25],temp2[1],temp2[2]);
                       {savedraw((i-(x-5))*2,(j-(y-5))*4,m[d.g[abs(d.l[i,j])].t].shp[25],temp2[1],temp2[2]);}
    if ((i=d.sx) and (j=d.sy)) then newsavedraw(screen^,(i-(x-5))*2,(j-(y-5))*4,c[1].shp[5],temp2[1],temp2[2]);
                                    {savedraw((i-(x-5))*2,(j-(y-5))*4,c[1].shp[5],temp2[1],temp2[2]);}
   end;
  end;
 end;
 newsavedraw(screen^,10,20,t[33],temp2[1],temp2[2]);
 {savedraw(10,20,t[33],temp2[1],temp2[2]);}
 show(screen^);
end;

procedure drawtrue;
var
 i: byte;
begin
 for i:=1 to 8 do begin
  str(i,pstr);
  wrt(26,4+(i-1)*2,pstr);
  draw(27,(3+(i-1)*2)*2-1,m[i].shp[25]);
 end;
 wrt(26,22,'] Objects');
 wrt(26,25,'Level:');
 str(level,pstr);
 wrt(33,25,pstr);
end;

procedure drawfalse;
var
 i,j: byte;
begin
 for i:=1 to 9 do begin
  str(i,pstr);
  wrt(26,4+(i-1)*2,pstr);
  case i of
   1: j:=1;
   2: j:=2;
   3: j:=19;
   4: j:=24;
   5: j:=27;
   6: j:=28;
   7: j:=29;
   8: j:=30;
   9: j:=31;
  end;
  draw(27,(3+(i-1)*2)*2-1,t[j]);
  if i<>9 then begin
   pstr:='F'+pstr;
   wrt(33,4+(i-1)*2,pstr);
   case i of
    1: j:=32;
    2: j:=35;
    3: j:=37;
    4: j:=38;
    5: j:=41;
    6: j:=44;
    7: j:=34;
    8: j:=0;
   end;
   if j<>0 then draw(35,(3+(i-1)*2)*2-1,t[j])
   else draw(35,(3+(i-1)*2)*2-1,c[1].shp[5]);
  end;
 end;
 wrt(26,22,'] Creatures');
 wrt(26,25,'Level:');
 str(level,pstr);
 wrt(33,25,pstr);
end;

procedure erasegenerator(x,y: byte);
var
 i,j: byte;
begin
 i:=0;
 repeat
  i:=i+1;
 until (d.g[i].x=x) and (d.g[i].y=y);
 d.g[i].x:=0;
end;

procedure edit(level: byte);
var
 quit,cpage: boolean;
 x,y,i,j,z: byte;
 ch: char;
begin
 cpage:=false;
 drawfalse;
 quit:=false;
 x:=16;
 y:=16;
 setupgrid(x,y);
 repeat
  repeat
  until keypressed;
  ch:=readkey;
  if (ch=#0) and (keypressed) then begin
   ch:=readkey;
   case ch of
    'G': begin x:=x-1; y:=y-1; up:=false; end;
    'H': begin y:=y-1; up:=true; end;
    'I': begin x:=x+1; y:=y-1; up:=false; end;
    'K': begin x:=x-1; up:=false; end;
    'M': begin x:=x+1; up:=false; end;
    'O': begin x:=x-1; y:=y+1; up:=false; end;
    'P': begin y:=y+1; up:=true; end;
    'Q': begin x:=x+1; y:=y+1; up:=false; end;
    ';','<','=','>','?','@','A','B':
         begin
          if d.l[x,y]<0 then erasegenerator(x,y);
          if (d.l[x,y]<>31) and (d.l[x,y]<>37) and ((x<>d.sx) or (y<>d.sy)) then begin
           case ch of
            ';': i:=30;
            '<': i:=32;
            '=': i:=34;
            '>': i:=35;
            '?': i:=36;
            '@': begin
                  if level=100 then i:=37
                  else i:=0;
                 end;
            'A': i:=31;
            'B': i:=1;
           end;
           if (i=0) or (i=37) then d.l[x,y]:=1 else d.l[x,y]:=i;
           if i=1 then begin
            d.sx:=x;
            d.sy:=y;
           end;
           if i=31 then begin
            d.l[d.ex,d.ey]:=1;
            d.ex:=x;
            d.ey:=y;
           end;
           if i=37 then begin
            for j:=1 to 32 do begin
             for z:=1 to 32 do begin
              if d.l[z,j]=37 then d.l[z,j]:=1;
             end;
            end;
            d.l[x,y]:=37;
           end;
          end;
         end;
   end;
   if x<2 then x:=31;
   if x>31 then x:=2;
   if y<2 then y:=31;
   if y>31 then y:=2;
   setupgrid(x,y);
  end
  else begin
   case ch of
    ']': begin
          cpage:=(not cpage);
          right;
          if cpage then begin
           drawtrue;
          end
          else begin
           drawfalse;
          end;
         end;
    '1','2','3','4','5','6','7','8','9':
         begin
          if cpage then begin
           if ch<>'9' then begin
            if d.l[x,y]<0 then erasegenerator(x,y);
            if (d.l[x,y]<>31) and (d.l[x,y]<>37) and ((x<>d.sx) or (y<>d.sy)) then begin
             i:=0;
             repeat
              i:=i+1;
             until (i=16) or (d.g[i].x=0);
             if d.g[i].x=0 then begin
              d.g[i].x:=x;
              d.g[i].y:=y;
              d.g[i].h:=m[ord(ch)-48].h;
              d.g[i].t:=ord(ch)-48;
              d.l[x,y]:=-i;
              setupgrid(x,y);
             end;
            end;
           end;
          end
          else begin
           if d.l[x,y]<0 then erasegenerator(x,y);
           if (d.l[x,y]<>31) and (d.l[x,y]<>37) and ((x<>d.sx) or (y<>d.sy)) then begin
            case ch of
             '1': i:=1;
             '2': i:=2;
             '3': i:=19;
             '4': i:=24;
             '5': i:=25;
             '6': i:=26;
             '7': i:=27;
             '8': i:=28;
             '9': i:=29;
            end;
            d.l[x,y]:=i;
            setupgrid(x,y);
           end;
          end;
         end;
   end;
   if ch=#27 then begin
    quit:=true;
    str(level,pstr);
    pstr:='LEVEL'+pstr;
    assign(dfile,pstr);
    rewrite(dfile);
    write(dfile,d);
    close(dfile);
   end;
  end;
 until quit;
end;

procedure findlevel(var level: byte);
var
 i,j,i2,pr1,pr2: byte;
 dir: array[1..4] of byte;
 quit: boolean;
begin
 level:=level-1;
 quit:=false;
 repeat
  level:=level+1;
  if level>100 then level:=1;
  str(level,pstr);
  pstr:='LEVEL'+pstr;
  assign(dfile,pstr);
  {$i-}
  reset(dfile);
  {$i+}
  if ioresult=0 then begin
   read(dfile,d);
   close(dfile);
   for j:=1 to 32 do begin
    for i:=1 to 32 do begin
     dw[i,j]:=false;
     for i2:=1 to 4 do dir[i2]:=0;
     if (d.l[i,j]=2) or (d.l[i,j]=32) then begin
      if i>1 then begin
       case d.l[i-1,j] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,32: dir[4]:=1;
       end;
      end;
      if i<32 then begin
       case d.l[i+1,j] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,32: dir[2]:=1;
       end;
      end;
      if j>1 then begin
       case d.l[i,j-1] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,32: dir[1]:=1;
       end;
      end;
      if j<32 then begin
       case d.l[i,j+1] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,32: dir[3]:=1;
       end;
      end;
      if d.l[i,j]=32 then dw[i,j]:=true;
      if (dir[1]=0) and (dir[2]=0) and (dir[3]=0) and (dir[4]=0) then d.l[i,j]:=3;
      if (dir[1]=0) and (dir[2]=0) and (dir[3]=1) and (dir[4]=0) then d.l[i,j]:=4;
      if (dir[1]=1) and (dir[2]=0) and (dir[3]=1) and (dir[4]=0) then d.l[i,j]:=5;
      if (dir[1]=1) and (dir[2]=0) and (dir[3]=0) and (dir[4]=0) then d.l[i,j]:=6;
      if (dir[1]=0) and (dir[2]=1) and (dir[3]=0) and (dir[4]=0) then d.l[i,j]:=7;
      if (dir[1]=0) and (dir[2]=1) and (dir[3]=0) and (dir[4]=1) then d.l[i,j]:=8;
      if (dir[1]=0) and (dir[2]=0) and (dir[3]=0) and (dir[4]=1) then d.l[i,j]:=9;
      if (dir[1]=0) and (dir[2]=1) and (dir[3]=1) and (dir[4]=0) then d.l[i,j]:=10;
      if (dir[1]=0) and (dir[2]=1) and (dir[3]=1) and (dir[4]=1) then d.l[i,j]:=11;
      if (dir[1]=0) and (dir[2]=0) and (dir[3]=1) and (dir[4]=1) then d.l[i,j]:=12;
      if (dir[1]=1) and (dir[2]=1) and (dir[3]=1) and (dir[4]=0) then d.l[i,j]:=13;
      if (dir[1]=1) and (dir[2]=1) and (dir[3]=1) and (dir[4]=1) then d.l[i,j]:=14;
      if (dir[1]=1) and (dir[2]=0) and (dir[3]=1) and (dir[4]=1) then d.l[i,j]:=15;
      if (dir[1]=1) and (dir[2]=1) and (dir[3]=0) and (dir[4]=0) then d.l[i,j]:=16;
      if (dir[1]=1) and (dir[2]=1) and (dir[3]=0) and (dir[4]=1) then d.l[i,j]:=17;
      if (dir[1]=1) and (dir[2]=0) and (dir[3]=0) and (dir[4]=1) then d.l[i,j]:=18;
     end;
     if d.l[i,j]=19 then begin
      for i2:=1 to 4 do dir[i2]:=0;
      if i>1 then begin
       case d.l[i-1,j] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,32: dir[4]:=2;
        20,21: dir[4]:=1;
       end;
      end;
      if i<32 then begin
       case d.l[i+1,j] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,32: dir[2]:=2;
        20,21: dir[2]:=1;
       end;
      end;
      if j>1 then begin
       case d.l[i,j-1] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,32: dir[1]:=2;
        20,21: dir[1]:=1;
       end;
      end;
      if j<32 then begin
       case d.l[i,j+1] of
        2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,32: dir[3]:=2;
        20,21: dir[3]:=1;
       end;
      end;
      pr1:=dir[1]+dir[3];
      pr2:=dir[2]+dir[4];
      if pr1>=pr2 then d.l[i,j]:=20 else d.l[i,j]:=21;
     end;
    end;
   end;
   quit:=true;
  end;
 until quit;
end;

procedure update(x,y,cl,cs: byte);
var
 i,j: integer;
begin
 for j:=y-5 to y+5 do begin
  for i:=x-5 to x+5 do begin
   if (i>0) and (i<33) and (j>0) and (j<33) then begin
    case d.l[i,j] of
     24,35,36,37: begin
                   draw((i-(x-5))*2,(j-(y-5))*4,t[tr[d.l[i,j]]]);
                   if (i=x) and (j=y) then
                    savedraw(10,20,c[cl].shp[cs],temp2[1],temp2[2]);
                  end;
    end;
   end;
  end;
 end;
end;

procedure setupgrid2(x,y,cl,cs: byte);
var
 i,j: integer;
 z: byte;
 ch: char;
begin
 for j:=y-5 to y+5 do begin
  for i:=x-5 to x+5 do begin
   if (i<1) or (i>32) or (j<1) or (j>32) then z:=46
   else begin
    if d.l[i,j]<0 then begin
     if d.l[i,j]<-16 then z:=tr[under[-(d.l[i,j]+16)]]-1
     else z:=0;
    end
    else z:=tr[d.l[i,j]]-1;
   end;
   g[i-(x-5)+1+(j-(y-5))*11]:=z;
  end;
 end;
 newdrawgrid(screen^,g,t);
 {if up then drawgridup(g,t) else drawgridright(g,t);}
 newsavedraw(screen^,10,20,c[cl].shp[cs],temp2[1],temp2[2]);
 {savedraw(10,20,c[cl].shp[cs],temp2[1],temp2[2]);}
 for j:=y-5 to y+5 do begin
  for i:=x-5 to x+5 do begin
   if (i>0) and (i<33) and (j>0) and (j<33) then begin
    if (d.l[i,j]<0) and (d.l[i,j]>-17) then begin
     if d.g[-d.l[i,j]].h>0 then
      newsavedraw(screen^,(i-(x-5))*2,(j-(y-5))*4,m[d.g[-(d.l[i,j])].t].shp[25],temp2[1],temp2[2])
      {savedraw((i-(x-5))*2,(j-(y-5))*4,m[d.g[-(d.l[i,j])].t].shp[25],temp2[1],temp2[2])}
     else
      newsavedraw(screen^,(i-(x-5))*2,(j-(y-5))*4,m[d.g[-(d.l[i,j])].t].shp[30-d.g[-d.l[i,j]].x],temp2[1],temp2[2]);
      {savedraw((i-(x-5))*2,(j-(y-5))*4,m[d.g[-(d.l[i,j])].t].shp[30-d.g[-d.l[i,j]].x],temp2[1],temp2[2]);}
    end;
    if (d.l[i,j]<-16) then begin
     z:=-(d.l[i,j]+16);
     newsavedraw(screen^,(i-(x-5))*2,(j-(y-5))*4,m[d.m[z].t].shp[cshp[z]],temp2[1],temp2[2]);
     {savedraw((i-(x-5))*2,(j-(y-5))*4,m[d.m[z].t].shp[cshp[z]],temp2[1],temp2[2]);}
    end;
   end;
  end;
 end;
 show(screen^);
end;

procedure printhealth(health: integer);
begin
 wrt(35,4,'    ');
 str(health,pstr);
 wrt(35,4,pstr);
end;

procedure printamulets(amulets: byte);
begin
 wrt(35,8,'   ');
 str(amulets,pstr);
 wrt(35,8,pstr);
end;

procedure printkeys(keys: byte);
begin
 wrt(35,6,'   ');
 str(keys,pstr);
 wrt(35,6,pstr);
end;

procedure printscore(score: longint);
begin
 wrt(35,10,'      ');
 str(score,pstr);
 wrt(35,10,pstr);
end;

function within(x,y,x2,y2: byte):boolean;
begin
 if (abs(x-x2)<6) and (abs(y-y2)<6) then within:=true
 else within:=false;
end;

procedure shootplay;
begin
 sound(40);
 delay(2);
 sound(50);
 delay(1);
 sound(10);
 delay(1);
 sound(20);
 delay(2);
 nosound;
end;

procedure hitplay;
begin
 sound(10);
 delay(2);
 sound(80);
 delay(1);
 sound(50);
 delay(2);
 sound(30);
 delay(1);
 nosound;
end;

procedure generateplay;
begin
 sound(220);
 delay(1);
 sound(230);
 delay(1);
 sound(210);
 delay(1);
 sound(215);
 delay(1);
 nosound;
end;

procedure getplay;
begin
 sound(950);
 delay(3);
 sound(1000);
 delay(2);
 sound(1050);
 delay(1);
 nosound;
end;

procedure downplay;
begin
 sound(800);
 delay(15);
 sound(700);
 delay(13);
 sound(500);
 delay(11);
 sound(100);
 delay(13);
 sound(10);
 delay(15);
 nosound;
end;

procedure doorplay;
begin
 sound(200);
 delay(10);
 sound(600);
 delay(8);
 sound(800);
 delay(6);
 sound(900);
 delay(4);
 sound(950);
 delay(2);
 nosound;
end;

procedure winplay;
begin
 sound(523);
 delay(100);
 sound(659);
 delay(100);
 sound(784);
 delay(100);
 sound(1047);
 delay(350);
 nosound;
 delay(50);
 sound(784);
 delay(100);
 sound(1047);
 delay(500);
 nosound;
end;

procedure forcefieldplay;
begin
 sound(850);
 delay(4);
 sound(750);
 delay(1);
 sound(775);
 delay(2);
 sound(820);
 delay(3);
 sound(815);
 delay(1);
 nosound;
end;

procedure attackplay;
begin
 sound(50);
 delay(1);
 sound(40);
 sound(10);
 delay(1);
 sound(70);
 sound(20);
 nosound;
end;

procedure joymove(var r: registers);
begin
 r.ah:=132;
 r.dx:=1;
 intr(21,r);
end;

procedure joybutton(var r: registers);
begin
 r.ah:=132;
 r.dx:=0;
 intr(21,r);
end;

procedure play(level: byte);
type
 you= record
       c,h,a,ml,m,s,ms: integer;
       mx,my,mdir,shpdir,x,y,cs,cd: byte;
      end;

var
 y: you;
 mr,cbutton: byte;
 i,j,speed,x2,y2,cs2,cd2,keys,amulets,ability,abno,startlevel: integer;
 turns,score: longint;
 quit,old,change,drawn,win,orbgot: boolean;
 ch: char;
 dirx,diry: array[1..8] of shortint;
 lm,lg: array[1..8] of longint;

begin
 if joy then begin
             joybutton(z);
             joyb2[1]:=odd(trunc(z.al/8));
             joyb2[2]:=odd(trunc(z.al/16));
             joyb2[3]:=odd(trunc(z.al/32));
             joyb2[4]:=odd(trunc(z.al/64));
 end;
 case button of
  1: cbutton:=1;
  2: cbutton:=2;
  4: cbutton:=3;
  8: cbutton:=4;
 end;
 quit:=false;
 wrt(26,14,'Level:');
 str(level,pstr);
 wrt(33,14,pstr);
 dirx[1]:=0; dirx[2]:=1; dirx[3]:=1; dirx[4]:=1; dirx[5]:=0; dirx[6]:=-1; dirx[7]:=-1; dirx[8]:=-1;
 diry[1]:=-1; diry[2]:=-1; diry[3]:=0; diry[4]:=1; diry[5]:=1; diry[6]:=1; diry[7]:=0; diry[8]:=-1;
 mr:=1;
 for i:=1 to 4 do begin
  mstr[i]:=c[i].name;
  draw(33,(3+(i-1)*2)*2-1,c[i].shp[5]);
 end;
 mstr[5]:='';
 menu(26,4,mr);
 startlevel:=level;
 y.c:=mr;
 y.h:=c[mr].h; y.a:=c[mr].a; y.ml:=c[mr].ml; y.m:=c[mr].m; y.s:=c[mr].s;
 y.ms:=c[mr].ms;
 for i:=1 to 8 do begin
  lm[i]:=0; lg[i]:=0;
 end;
 ability:=0;
 keys:=0;
 amulets:=0;
 abno:=0;
 score:=0;
 speed:=0;
 turns:=0;
 win:=false;
 orbgot:=false;
 findlevel(level);
 y.x:=d.sx; y.y:=d.sy; y.cs:=1; y.cd:=1; y.mdir:=0;
 setupgrid2(y.x,y.y,y.c,y.cs);
 right;
 wrt(26,4,'Health:');
 printhealth(y.h);
 wrt(26,6,'Keys:');
 printkeys(keys);
 wrt(26,8,'Amulets:');
 printamulets(amulets);
 wrt(26,10,'Score:');
 printscore(score);
 wrt(26,14,'Level:');
 str(level,pstr);
 wrt(33,14,pstr);
 for i:=1 to 16 do under[i]:=1;
 repeat
  if abno>0 then begin
   abno:=abno-1;
   if abno=0 then begin
    case ability of
     1: y.a:=y.a-1;
     2: begin y.ml:=y.ml-1; y.m:=y.m-1; end;
     3: y.s:=y.s+1;
    end;
    ability:=0;
   end;
  end;
  speed:=speed+1;
  if speed>10 then speed:=1;
  turns:=turns+1;
  change:=false;
  if turns>10000 then turns:=1;
  if (turns/5)=round(turns/5) then begin
   tr[24]:=tr[24]+1;
   if tr[24]>26 then tr[24]:=24;
   tr[35]:=tr[35]+1;
   if tr[35]>40 then tr[35]:=38;
   tr[36]:=tr[36]+1;
   if tr[36]>43 then tr[36]:=41;
   tr[37]:=tr[37]+1;
   if tr[37]>46 then tr[37]:=44;
   update(y.x,y.y,y.c,y.cs);
   if d.l[y.x,y.y]=35 then begin
    forcefieldplay;
    case tr[35] of
     38: y.h:=y.h-10;
     39: y.h:=y.h-50;
     40: y.h:=y.h-100;
    end;
    if y.h<=0 then begin
     y.h:=0;
     quit:=true;
    end;
    printhealth(y.h);
   end;
  end;
  x2:=y.x; y2:=y.y; cs2:=y.cs; cd2:=y.cd;
  up:=true;

  if y.s<=speed then begin

  i:=-1;
  if (not joy) then begin
   repeat
    i:=i+1;
   until (i=delaynumber) or (keypressed);
   if (i=delaynumber) then move:=false else move:=true;
  end
  else begin
   repeat
    i:=i+1;
    joymove(r);
    joybutton(z);
   until (i=delaynumber) or (keypressed) or (abs(r.ax-centerx)>50) or
    (abs(r.bx-centery)>50) or (joyb2[cbutton]<>odd(trunc(z.al/(button*8))));
   if (i=delaynumber) then move:=false else move:=true;
  end;
  if (move) then begin
   if keypressed then begin
   ch:=readkey;
   if (ch=#0) and (keypressed) then begin
    ch:=readkey;
    case ch of
     'G': begin y.x:=y.x-1; y.y:=y.y-1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=8;
          end;
     'H': begin y.y:=y.y-1;
           if (y.cs=1) then y.cs:=2
           else y.cs:=1;
           up:=true;
           y.cd:=1;
          end;
     'I': begin y.x:=y.x+1; y.y:=y.y-1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=2;
          end;
     'K': begin y.x:=y.x-1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=7;
          end;
     'M': begin y.x:=y.x+1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=3;
          end;
     'O': begin y.x:=y.x-1; y.y:=y.y+1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=6;
          end;
     'P': begin y.y:=y.y+1;
           if (y.cs=5) then y.cs:=6
           else y.cs:=5;
           up:=true;
           y.cd:=5;
          end;
     'Q': begin y.x:=y.x+1; y.y:=y.y+1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=4;
          end;
    end;
   end
   else begin
    if ch=#27 then quit:=true;
    case ch of
     'a','A': begin
               if amulets>0 then begin
                amulets:=amulets-1;
                printamulets(amulets);
                for i:=1 to 16 do begin
                 if (within(d.m[i].x,d.m[i].y,y.x,y.y)) and (d.m[i].h>0) then begin
                  hitplay;
                  lm[d.m[i].t]:=lm[d.m[i].t]+1;
                  if lm[d.m[i].t]>9999 then lm[d.m[i].t]:=9999;
                  d.m[i].h:=-d.m[i].x;
                  j:=d.m[i].x;
                  d.m[i].x:=4;
                  draw((j-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,t[tr[under[i]]]);
                  savedraw((j-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,m[d.m[i].t].shp[21],temp2[1],temp2[2]);
                  cshp[i]:=21;
                 end;
                end;
               end;
              end;
     'f','F': begin
               if y.mdir=0 then begin
                shootplay;
                y.mdir:=y.cd;
                y.shpdir:=y.mdir;
                y.mx:=y.x+dirx[y.mdir];
                y.my:=y.y+diry[y.mdir];
                mis:=d.l[y.mx,y.my];
                y.cs:=8+trunc((y.cs+1)/2);
                draw(10,20,t[tr[d.l[y.x,y.y]]]);
                savedraw(10,20,c[y.c].shp[y.cs],temp2[1],temp2[2]);
                y.cs:=(y.cs-8)*2;
                savedraw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,c[y.c].shp[12+y.mdir],temp2[1],temp2[2]);
               end;
              end;
{     'w': begin
           str(d.l[y.x,y.y-1],pstr);
           wrt(38,2,pstr);
           i:=-(d.l[y.x,y.y-1]+16);
           str(d.m[i].h,pstr);
           wrt(38,3,pstr);
           str(d.m[i].x,pstr);
           wrt(38,4,pstr);
           str(d.m[i].y,pstr);
           wrt(38,5,pstr);
           str(d.m[i].t,pstr);
           wrt(38,6,pstr);
          end;}
    end;
   end;
   end
   else begin
              for i:=1 to 4 do joyb[i]:=false;
              if joyb2[cbutton]<>odd(trunc(z.al/(button*8))) then begin
               if y.mdir=0 then begin
                shootplay;
                y.mdir:=y.cd;
                y.shpdir:=y.mdir;
                y.mx:=y.x+dirx[y.mdir];
                y.my:=y.y+diry[y.mdir];
                mis:=d.l[y.mx,y.my];
                y.cs:=8+trunc((y.cs+1)/2);
                draw(10,20,t[tr[d.l[y.x,y.y]]]);
                savedraw(10,20,c[y.c].shp[y.cs],temp2[1],temp2[2]);
                y.cs:=(y.cs-8)*2;
                savedraw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,c[y.c].shp[12+y.mdir],temp2[1],temp2[2]);
               end;
              end;
     if (r.ax-centerx<-50) then joyb[1]:=true;
     if (r.ax-centerx>50) then joyb[2]:=true;
     if (r.bx-centery<-50) then joyb[3]:=true;
     if (r.bx-centery>50) then joyb[4]:=true;
     if (joyb[1]) and (joyb[3]) then begin y.x:=y.x-1; y.y:=y.y-1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=8;
          end;
     if (joyb[3]) and (not joyb[1]) and (not joyb[2]) then begin y.y:=y.y-1;
           if (y.cs=1) then y.cs:=2
           else y.cs:=1;
           up:=true;
           y.cd:=1;
          end;
     if (joyb[2]) and (joyb[3]) then begin y.x:=y.x+1; y.y:=y.y-1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=2;
          end;
     if (joyb[1]) and (not joyb[3]) and (not joyb[4]) then begin y.x:=y.x-1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=7;
          end;
     if (joyb[2]) and (not joyb[3]) and (not joyb[4]) then begin y.x:=y.x+1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=3;
          end;
     if (joyb[1]) and (joyb[4]) then begin y.x:=y.x-1; y.y:=y.y+1;
           if (y.cs=7) then y.cs:=8
           else y.cs:=7;
           up:=false;
           y.cd:=6;
          end;
     if (joyb[4]) and (not joyb[1]) and (not joyb[2]) then begin y.y:=y.y+1;
           if (y.cs=5) then y.cs:=6
           else y.cs:=5;
           up:=true;
           y.cd:=5;
          end;
     if (joyb[2]) and (joyb[4]) then begin y.x:=y.x+1; y.y:=y.y+1;
           if (y.cs=3) then y.cs:=4
           else y.cs:=3;
           up:=false;
           y.cd:=4;
          end;
   end;
   old:=false;
   case d.l[y.x,y.y] of
    3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,32,33: old:=true;
    20,21: begin
            if keys>0 then begin
             keys:=keys-1;
             doorplay;
             printkeys(keys);
             if d.l[y.x,y.y]=20 then d.l[y.x,y.y]:=22
             else d.l[y.x,y.y]:=23;
            end
            else old:=true;
           end;
    24: begin
         getplay;
         y.h:=y.h+50;
         if y.h>9999 then y.h:=9999;
         d.l[y.x,y.y]:=1;
         printhealth(y.h);
        end;
    25: begin
         getplay;
         y.h:=y.h+100;
         if y.h>9999 then y.h:=9999;
         d.l[y.x,y.y]:=1;
         printhealth(y.h);
        end;
    26: begin
         getplay;
         case ability of
          1: y.a:=y.a-1;
          2: begin y.ml:=y.ml-1; y.m:=y.m-1; end;
          3: y.s:=y.s+1;
         end;
         y.a:=y.a+1;
         ability:=1;
         abno:=500;
         d.l[y.x,y.y]:=1;
        end;
    27: begin
         getplay;
         case ability of
          1: y.a:=y.a-1;
          2: begin y.ml:=y.ml-1; y.m:=y.m-1; end;
          3: y.s:=y.s+1;
         end;
         y.ml:=y.ml+1; y.m:=y.m+1;
         ability:=2;
         abno:=500;
         d.l[y.x,y.y]:=1;
        end;
    28: begin
         getplay;
         case ability of
          1: y.a:=y.a-1;
          2: begin y.ml:=y.ml-1; y.m:=y.m-1; end;
          3: y.s:=y.s+1;
         end;
         y.s:=y.s-1;
         ability:=3;
         abno:=500;
         d.l[y.x,y.y]:=1;
        end;
    29: begin
         if amulets<255 then begin
          getplay;
          amulets:=amulets+1;
          printamulets(amulets);
          d.l[y.x,y.y]:=1;
         end;
        end;
    30: begin
         if keys<255 then begin
          getplay;
          keys:=keys+1;
          printkeys(keys);
          d.l[y.x,y.y]:=1;
         end;
        end;
    31: begin
         downplay;
         level:=level+1;
         if level>100 then level:=1;
         findlevel(level);
         speed:=0;
         turns:=0;
         win:=false;
         y.x:=d.sx; y.y:=d.sy; y.cs:=1; y.cd:=1; y.mdir:=0;
         setupgrid2(y.x,y.y,y.c,y.cs);
         right;
         score:=score+1000;
         if score>999999 then score:=999999;
         wrt(26,14,'Level:');
         str(level,pstr);
         wrt(33,14,pstr);
         wrt(26,4,'Health:');
         printhealth(y.h);
         wrt(26,6,'Keys:');
         printkeys(keys);
         wrt(26,8,'Amulets:');
         printamulets(amulets);
         wrt(26,10,'Score:');
         printscore(score);
         for i:=1 to 16 do under[i]:=0;
        end;
    34: begin
         getplay;
         score:=score+50;
         if score>999999 then score:=999999;
         d.l[y.x,y.y]:=1;
         printscore(score);
        end;
    35: begin
         forcefieldplay;
         case tr[35] of
          38: y.h:=y.h-10;
          39: y.h:=y.h-50;
          40: y.h:=y.h-100;
         end;
         if y.h<=0 then begin
          y.h:=0;
          quit:=true;
         end;
         printhealth(y.h);
        end;
    36: begin
         getplay;
         score:=score+100;
         if score>999999 then score:=999999;
         d.l[y.x,y.y]:=1;
         printscore(score);
        end;
    37: begin
         winplay;
         win:=true;
         quit:=true;
         if startlevel=1 then orbgot:=true;
         d.l[y.x,y.y]:=1;
        end;
   end;
   i:=d.l[y.x,y.y];
   if i<0 then begin
    y.x:=x2; y.y:=y2;
    y.cs:=8+trunc((y.cs+1)/2);
    draw(10,20,t[tr[d.l[y.x,y.y]]]);
    savedraw(10,20,c[y.c].shp[y.cs],temp2[1],temp2[2]);
    y.cs:=(y.cs-8)*2;
    if i<-16 then begin
     if d.m[-(i+16)].h>0 then begin
      hitplay;
      d.m[-(i+16)].h:=d.m[-(i+16)].h-y.ml;
      if d.m[-(i+16)].h<=0 then begin
       lm[d.m[-(i+16)].t]:=lm[d.m[-(i+16)].t]+1;
       if lm[d.m[-(i+16)].t]>9999 then lm[d.m[-(i+16)].t]:=9999;
       score:=score+m[d.m[-(i+16)].t].h;
       if score>999999 then score:=999999;
       printscore(score);
       d.m[-(i+16)].h:=-d.m[-(i+16)].x;
       j:=d.m[-(i+16)].x;
       d.m[-(i+16)].x:=4;
       if within(j,d.m[-(i+16)].y,y.x,y.y) then begin
        draw((j-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,t[tr[under[-(i+16)]]]);
        savedraw((j-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,m[d.m[-(i+16)].t].shp[21],temp2[1],temp2[2]);
       end;
       cshp[-(i+16)]:=21;
      end;
     end;
    end
    else begin
     if d.g[-i].h>0 then begin
      hitplay;
      d.g[-i].h:=d.g[-i].h-y.ml;
      if d.g[-i].h<=0 then begin
       lg[d.g[-i].t]:=lg[d.g[-i].t]+1;
       if lg[d.g[-i].t]>9999 then lg[d.g[-i].t]:=9999;
       score:=score+m[d.g[-i].t].h;
       if score>999999 then score:=999999;
       printscore(score);
       d.g[-i].h:=-d.g[-i].x;
       j:=d.g[-i].x;
       d.g[-i].x:=4;
       if within(j,d.g[-i].y,y.x,y.y) then begin
        draw((j-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,t[1]);
        savedraw((j-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,m[d.g[-i].t].shp[26],temp2[1],temp2[2]);
       end;
      end;
     end;
    end;
   end;
   if old then begin
    y.x:=x2; y.y:=y2;
    draw(10,20,t[tr[d.l[y.x,y.y]]]);
    savedraw(10,20,c[y.c].shp[y.cs],temp2[1],temp2[2]);
   end;
   if (y.x<>x2) or (y.y<>y2) then change:=true;
  end;

  end;

 for i:=1 to 16 do begin
  if d.m[i].h>0 then begin

   if m[d.m[i].t].s<=speed then begin

   x2:=d.m[i].x; y2:=d.m[i].y; cs2:=cshp[i]; j:=0;

   if (m[d.m[i].t].m>0) and (random(100)+1<26) and (d.m[i].mdir=0) and
    (within(d.m[i].x,d.m[i].y,y.x,y.y)) then begin
    if (d.m[i].y=y.y) or (d.m[i].x=y.x) or (abs(d.m[i].x-y.x)=abs(d.m[i].y-y.y)) then begin
     if d.m[i].y=y.y then begin
      if d.m[i].x<y.x then d.m[i].mdir:=3 else d.m[i].mdir:=7;
     end
     else begin
      if d.m[i].x=y.x then begin
       if d.m[i].y<y.y then d.m[i].mdir:=5 else d.m[i].mdir:=1;
      end
      else begin
       if d.m[i].x-y.x<1 then begin
        if d.m[i].y-y.y<1 then begin
         d.m[i].mdir:=4;
        end
        else begin
         d.m[i].mdir:=2;
        end;
       end
       else begin
        if d.m[i].y-y.y<1 then begin
         d.m[i].mdir:=6;
        end
        else begin
         d.m[i].mdir:=8;
        end;
       end;
      end;
     end;
     d.m[i].mx:=d.m[i].x+dirx[d.m[i].mdir];
     d.m[i].my:=d.m[i].y+diry[d.m[i].mdir];
     underm[i]:=d.l[d.m[i].mx,d.m[i].my];
     case d.m[i].mdir of
      1: cshp[i]:=9;
      2,3,4: cshp[i]:=10;
      5: cshp[i]:=11;
      6,7,8: cshp[i]:=12;
     end;
     attackplay;
     draw((d.m[i].x-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,t[tr[under[i]]]);
     savedraw((d.m[i].x-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,m[d.m[i].t].shp[cshp[i]],temp2[1],temp2[2]);
     cshp[i]:=(cshp[i]-8)*2;
     savedraw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,m[d.m[i].t].shp[12+d.m[i].mdir],temp2[1],temp2[2]);
    end;
   end
   else begin

   d.l[x2,y2]:=under[i];
   if d.m[i].y<y.y then begin
    d.m[i].y:=d.m[i].y+1;
    j:=5;
   end;
   if d.m[i].y>y.y then begin
    d.m[i].y:=d.m[i].y-1;
    j:=1;
   end;
   if d.m[i].x<y.x then begin
    d.m[i].x:=d.m[i].x+1;
    j:=3;
   end;
   if d.m[i].x>y.x then begin
    d.m[i].x:=d.m[i].x-1;
    j:=7;
   end;
   case j of
    1: if cshp[i]=1 then cshp[i]:=2 else cshp[i]:=1;
    5: if cshp[i]=5 then cshp[i]:=6 else cshp[i]:=5;
    3: if cshp[i]=3 then cshp[i]:=4 else cshp[i]:=3;
    7: if cshp[i]=7 then cshp[i]:=8 else cshp[i]:=7;
   end;
   j:=d.l[d.m[i].x,d.m[i].y];
   if (j<>1) and (j<>22) and (j<>23)
    and ((d.m[i].x<>y.x) or (d.m[i].y<>y.y)) then begin
    d.m[i].x:=x2; d.m[i].y:=y2; cshp[i]:=cs2;
   end
   else begin
    if (d.m[i].x=y.x) and (d.m[i].y=y.y) then begin
     attackplay;
     if (m[d.m[i].t].ml-y.a)<1 then y.h:=y.h-1
     else y.h:=y.h+y.a-m[d.m[i].t].ml;
     if y.h<1 then begin
      y.h:=0;
      quit:=true;
     end;
     printhealth(y.h);
     d.m[i].x:=x2; d.m[i].y:=y2;
     cshp[i]:=8+trunc((cshp[i]+1)/2);
    end;
    j:=under[i];
    under[i]:=d.l[d.m[i].x,d.m[i].y];
    if not change then begin
     if within(x2,y2,y.x,y.y) then draw((x2+5-y.x)*2,(y2+5-y.y)*4,t[tr[j]]);
     if within(d.m[i].x,d.m[i].y,y.x,y.y) then
      savedraw((d.m[i].x+5-y.x)*2,(d.m[i].y+5-y.y)*4,m[d.m[i].t].shp[cshp[i]],temp2[1],temp2[2]);
    end;
   end;
   d.l[d.m[i].x,d.m[i].y]:=-16-i;

   end;

   end;

  end
  else begin
   if d.m[i].x<>0 then begin
    d.m[i].x:=d.m[i].x-1;
    if (not change) or (d.m[i].x=0) then begin
     if within(-(d.m[i].h),d.m[i].y,y.x,y.y) then begin
      draw(((-d.m[i].h)-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,t[tr[under[i]]]);
      if d.m[i].x<>0 then
       savedraw(((-d.m[i].h)-(y.x-5))*2,(d.m[i].y-(y.y-5))*4,m[d.m[i].t].shp[25-d.m[i].x],temp2[1],temp2[2]);
     end;
     if d.m[i].x=0 then begin
      if d.m[i].mdir<>0 then begin
       if within(d.m[i].mx,d.m[i].my,y.x,y.y) then
        draw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,t[tr[underm[i]]]);
       d.m[i].mdir:=0;
      end;
      d.l[-(d.m[i].h),d.m[i].y]:=under[i];
      d.m[i].x:=0;
      d.m[i].h:=0;
      cshp[i]:=0;
     end;
    end;
    cshp[i]:=25-d.m[i].x;
   end;
  end;
 end;
 for i:=1 to 16 do begin
  if d.g[i].h>0 then begin
   if (turns/(m[d.g[i].t].s*10))=(round(turns/(m[d.g[i].t].s*10))) then begin
    j:=random(4)+1;
    x2:=d.g[i].x; y2:=d.g[i].y;
    case j of
     1: y2:=y2-1;
     2: x2:=x2+1;
     3: y2:=y2+1;
     4: x2:=x2-1;
    end;
    if (d.l[x2,y2]=1) and ((x2<>y.x) or (y2<>y.y)) then begin
     j:=0;
     repeat
      j:=j+1;
     until ((d.m[j].h=0) and (d.m[j].x=0)) or (j=16);
     if (d.m[j].h=0) and (d.m[j].x=0) then begin
      generateplay;
      d.m[j].t:=d.g[i].t;
      d.m[j].h:=m[d.m[j].t].h;
      d.m[j].x:=x2;
      d.m[j].y:=y2;
      cshp[j]:=1;
      under[j]:=1;
      d.l[x2,y2]:=-(j+16);
      if (not change) and (within(d.m[j].x,d.m[j].y,y.x,y.y))
       then savedraw((d.m[j].x+5-y.x)*2,(d.m[j].y+5-y.y)*4,m[d.m[j].t].shp[cshp[j]],temp2[1],temp2[2]);
     end;
    end;
   end;
  end
  else begin
   if d.g[i].x<>0 then begin
    d.g[i].x:=d.g[i].x-1;
    if (not change) or (d.g[i].x=0) then begin
     if within(-(d.g[i].h),d.g[i].y,y.x,y.y) then begin
      draw(((-d.g[i].h)-(y.x-5))*2,(d.g[i].y-(y.y-5))*4,t[1]);
      if d.g[i].x<>0 then
       savedraw(((-d.g[i].h)-(y.x-5))*2,(d.g[i].y-(y.y-5))*4,m[d.g[i].t].shp[30-d.g[i].x],temp2[1],temp2[2]);
     end;
     if d.g[i].x=0 then begin
      d.l[-(d.g[i].h),d.g[i].y]:=1;
      d.g[i].x:=0;
      d.g[i].h:=0;
     end;
    end;
   end;
  end;
 end;
 if y.mdir<>0 then begin
  drawn:=false;
  if within(y.mx,y.my,y.x,y.y) then begin
   j:=d.l[y.mx,y.my];
   mis:=j;
   if (j=1) or (j=35) or (j=22) or (j=23) then begin

    if y.ms<=speed then begin

    draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[tr[mis]]);
    y.mx:=y.mx+dirx[y.mdir];
    y.my:=y.my+diry[y.mdir];
    mis:=d.l[y.mx,y.my];
    if c[y.c].rt then y.shpdir:=y.shpdir+1;
    if y.shpdir>8 then y.shpdir:=1;
    if within(y.mx,y.my,y.x,y.y) then
     savedraw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,c[y.c].shp[12+y.shpdir],temp2[1],temp2[2]);

    end;

   end;
   if within(y.mx,y.my,y.x,y.y) then begin
    old:=true;
    case d.l[y.mx,y.my] of
     24,25,26,27,28,29: old:=false;
    end;
    if old=false then begin
     y.mdir:=0;
     d.l[y.mx,y.my]:=1;
     draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[1]);
    end;
    if (old) and ((d.l[y.mx,y.my]<>1) and (d.l[y.mx,y.my]<>35)
     and (d.l[y.mx,y.my]<>22) and (d.l[y.mx,y.my]<>23)) then begin
     if d.l[y.mx,y.my]<0 then begin
      y.mdir:=0;
      i:=d.l[y.mx,y.my];
      if i<-16 then begin
       if d.m[-(i+16)].h>0 then begin
        hitplay;
        d.m[-(i+16)].h:=d.m[-(i+16)].h-y.m;
        if d.m[-(i+16)].h<=0 then begin
         lm[d.m[-(i+16)].t]:=lm[d.m[-(i+16)].t]+1;
         if lm[d.m[-(i+16)].t]>9999 then lm[d.m[-(i+16)].t]:=9999;
         score:=score+m[d.m[-(i+16)].t].h;
         if score>999999 then score:=999999;
         printscore(score);
         d.m[-(i+16)].h:=-d.m[-(i+16)].x;
         j:=d.m[-(i+16)].x;
         d.m[-(i+16)].x:=4;
         draw((j-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,t[tr[under[-(i+16)]]]);
         savedraw((j-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,m[d.m[-(i+16)].t].shp[21],temp2[1],temp2[2]);
         cshp[-(i+16)]:=21;
        end
        else begin
         draw((d.m[-(i+16)].x-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,t[tr[under[-(i+16)]]]);
         savedraw((d.m[-(i+16)].x-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,
          m[d.m[-(i+16)].t].shp[cshp[-(i+16)]],temp2[1],temp2[2]);
        end;
       end
       else begin
        draw(((-d.m[-(i+16)].h)-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,t[tr[under[-(i+16)]]]);
        savedraw(((-d.m[-(i+16)].h)-(y.x-5))*2,(d.m[-(i+16)].y-(y.y-5))*4,
         m[d.m[-(i+16)].t].shp[25-d.m[-(i+16)].x],temp2[1],temp2[2]);
       end;
      end
      else begin
       if d.g[-i].h>0 then begin
        hitplay;
        d.g[-i].h:=d.g[-i].h-y.m;
        if d.g[-i].h<=0 then begin
         lg[d.g[-i].t]:=lg[d.g[-i].t]+1;
         if lg[d.g[-i].t]>9999 then lg[d.g[-i].t]:=9999;
         score:=score+m[d.g[-i].t].h;
         if score>999999 then score:=999999;
         printscore(score);
         d.g[-i].h:=-d.g[-i].x;
         j:=d.g[-i].x;
         d.g[-i].x:=4;
         draw((j-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,t[1]);
         savedraw((j-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,m[d.g[-i].t].shp[26],temp2[1],temp2[2]);
        end
        else begin
         draw((d.g[-i].x-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,t[1]);
         savedraw((d.g[-i].x-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,
          m[d.g[-i].t].shp[25],temp2[1],temp2[2]);
        end;
       end
       else begin
        draw(((-d.g[-i].h)-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,t[1]);
        savedraw(((-d.g[-i].h)-(y.x-5))*2,(d.g[-i].y-(y.y-5))*4,
         m[d.g[-i].t].shp[30-d.g[-i].x],temp2[1],temp2[2]);
       end;
      end;
     end
     else begin
      if d.l[y.mx,y.my]=33 then begin
       d.l[y.mx,y.my]:=1;
       draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[1]);
       drawn:=true;
      end;
      if d.l[y.mx,y.my]=32 then begin
       d.l[y.mx,y.my]:=33;
       draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[36]);
       drawn:=true;
      end;
      if dw[y.mx,y.my] then begin
       dw[y.mx,y.my]:=false;
       d.l[y.mx,y.my]:=32;
       draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[35]);
       drawn:=true;
      end;
      y.mdir:=0;
      if (not drawn) then
       draw((y.mx-(y.x-5))*2,(y.my-(y.y-5))*4,t[tr[d.l[y.mx,y.my]]]);
     end;
    end;
   end
   else y.mdir:=0;
  end
  else y.mdir:=0;
 end;
 for i:=1 to 16 do begin
 if d.m[i].mdir<>0 then begin
  if within(d.m[i].mx,d.m[i].my,y.x,y.y) then begin
   j:=d.l[d.m[i].mx,d.m[i].my];
   if ((j=1) or (j=35) or (j=22) or (j=23))
    and ((d.m[i].mx<>y.x) or (d.m[i].my<>y.y)) then begin

    if m[d.m[i].t].ms<=speed then begin

    draw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,t[tr[j]]);
    d.m[i].mx:=d.m[i].mx+dirx[d.m[i].mdir];
    d.m[i].my:=d.m[i].my+diry[d.m[i].mdir];
    underm[i]:=d.l[d.m[i].mx,d.m[i].my];
    if within(d.m[i].mx,d.m[i].my,y.x,y.y) then
     savedraw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,m[d.m[i].t].shp[12+d.m[i].mdir],temp2[1],temp2[2]);

    end;

   end;
   if within(d.m[i].mx,d.m[i].my,y.x,y.y) then begin
    if (d.m[i].mx=y.x) and (d.m[i].my=y.y) then begin
     if (m[d.m[i].t].m-y.a)<1 then y.h:=y.h-1
     else y.h:=y.h+y.a-m[d.m[i].t].m;
     if y.h<1 then begin
      y.h:=0;
      quit:=true;
     end;
     printhealth(y.h);
     d.m[i].mdir:=0;
     draw(10,20,t[tr[d.l[y.x,y.y]]]);
     savedraw(10,20,c[y.c].shp[y.cs],temp2[1],temp2[2]);
    end
    else begin
     j:=d.l[d.m[i].mx,d.m[i].my];
     if (j<>1) and (j<>22) and (j<>23) and (j<>35) then begin
      d.m[i].mdir:=0;
      if j<0 then begin
       if j<-16 then begin
        draw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,t[tr[under[-(j+16)]]]);
        savedraw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,
         m[d.m[-(j+16)].t].shp[cshp[-(j+16)]],temp2[1],temp2[2]);
       end
       else begin
        draw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,t[1]);
        if d.g[-j].h>0 then begin
         savedraw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,
          m[d.g[-j].t].shp[25],temp2[1],temp2[2]);
        end
        else begin
         savedraw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,
          m[d.g[-j].t].shp[30-d.g[-j].x],temp2[1],temp2[2]);
        end;
       end;
      end
      else draw((d.m[i].mx-(y.x-5))*2,(d.m[i].my-(y.y-5))*4,t[tr[j]]);
     end;
    end;
   end
   else d.m[i].mdir:=0;
  end
  else d.m[i].mdir:=0;
 end;
 end;
  if change then setupgrid2(y.x,y.y,y.c,y.cs);
 until quit;
 delay(500);
 while keypressed do ch:=readkey;
 if (not win) then begin
  for i:=21 to 24 do begin
   draw(10,20,t[tr[d.l[y.x,y.y]]]);
   savedraw(10,20,c[y.c].shp[i],temp2[1],temp2[2]);
   delay(200);
  end;
  draw(10,20,t[tr[d.l[y.x,y.y]]]);
 end;
 if win then begin
  for i:=1 to 121 do g[i]:=46;
  for i:=1 to 9 do begin
   g[5+(i-1)*11]:=37;
   g[7+(i-1)*11]:=37;
   g[6+(i-1)*11]:=0;
  end;
  g[115]:=15;
  g[116]:=7;
  g[117]:=17;
  g[104]:=3;
  g[106]:=3;
  drawgridup(g,t);
  savedraw(10,36,c[3].shp[1],temp2[1],temp2[2]);
  savedraw(10,0,c[y.c].shp[5],temp2[1],temp2[2]);
  delay(500);
  for i:=1 to 7 do begin
   draw(10,(i-1)*4,t[1]);
   savedraw(10,i*4,c[y.c].shp[5+i mod 2],temp2[1],temp2[2]);
   for j:=0 to 8 do begin
    draw(8,j*4,t[38+i mod 3]);
    draw(12,j*4,t[38+i mod 3]);
   end;
   delay(500);
  end;
  draw(10,32,t[44]);
  winplay;
  for i:=1 to 100 do begin
   draw(10,32,t[44+i mod 3]);
   for j:=0 to 8 do begin
    draw(8,j*4,t[38+i mod 3]);
    draw(12,j*4,t[38+i mod 3]);
   end;
   delay(100);
  end;
  if orbgot then begin
   score:=score+100000;
   if score>999999 then score:=999999;
   printscore(score);
  end;
 end;
 i:=11;
 repeat
  i:=i-1;
 until (i=0) or (high[i].score>score);
 i:=i+1;
 if i<11 then begin
  if i<10 then begin
   for j:=9 downto i do begin
    high[j+1]:=high[j];
   end;
  end;
  right;
  high[i].score:=score;
  high[i].winner:=win;
  high[i].class:=y.c;
  high[i].name:='';
  for j:=1 to 10 do begin
   str(j,pstr);
   wrt(26,4+(j-1)*2,pstr);
   wrt(29,4+(j-1)*2,high[j].name);
   wrt(27,5+(j-1)*2,c[high[j].class].name);
   str(high[j].score,pstr);
   wrt(35,5+(j-1)*2,pstr);
   if high[j].winner then ptext(39,(3+(j-1)*2)*2,orbshp);
  end;
  rd(29,4+(i-1)*2,10,pstr);
  high[i].name:=pstr;
  assign(highfile,'ORB.HSC');
  rewrite(highfile);
  write(highfile,high);
  close(highfile);
 end;
 right;
 delay(500);
 while keypressed do ch:=readkey;
 for i:=1 to 8 do begin
  draw(25,5+(i-1)*4,m[i].shp[5]);
  draw(33,5+(i-1)*4,m[i].shp[25]);
  str(lm[i],pstr);
  wrt(29,4+(i-1)*2,pstr);
  str(lg[i],pstr);
  wrt(37,4+(i-1)*2,pstr);
 end;
 wrt(26,21,'Press A Key');
 repeat
 until keypressed;
 ch:=readkey;
end;

begin
 checkbreak:=false;
 randomize;
 for i:=1 to 24 do tr[i]:=i;
 for i:=25 to 30 do tr[i]:=i+2;
 for i:=31 to 35 do tr[i]:=i+3;
 tr[36]:=41;
 tr[37]:=44;
 assign(delayfile,'ORB.DAT');
 reset(delayfile);
 read(delayfile,delaynumber);
 read(delayfile,joysticknumber);
 read(delayfile,centerx);
 read(delayfile,centery);
 read(delayfile,button);
 close(delayfile);
 if joysticknumber>0 then joy:=true else joy:=false;
 assign(orbshpfile,'EGAORB.ORB');
 reset(orbshpfile);
 read(orbshpfile,orbshp);
 close(orbshpfile);
 assign(ffile,'EGAORB.FNT');
 reset(ffile);
 for i:=32 to 127 do read(ffile,f[i]);
 close(ffile);
 assign(mfile,'EGAORB.MNS');
 reset(mfile);
 read(mfile,m);
 close(mfile);
 assign(cfile,'EGAORB.CLS');
 reset(cfile);
 read(cfile,c);
 close(cfile);
 c[3].rt:=false;
 assign(tfile,'EGAORB.TRN');
 reset(tfile);
 read(tfile,t);
 close(tfile);
 assign(highfile,'ORB.HSC');
 reset(highfile);
 read(highfile,high);
 close(highfile);
 r.ah:=0;
 r.al:=13;
 intr(16,r);
 quit:=false;
 for i:=1 to 32 do border[i]:=0;
 for i:=1 to 8 do border[i]:=255;
 for i:=17 to 24 do border[i]:=255;
 for i:=0 to 24 do ptext(23,i*2,border);
 wrt(26,1,'The Black Orb');
 wrt(26,18,'Level:');
 level:=1;
 wrt(33,18,'1');
 mr:=1;
 repeat
  mstr[1]:='Play Level';
  mstr[2]:='Change Level';
  mstr[3]:='Edit Level';
  mstr[4]:='High Scores';
  mstr[5]:='Setup';
  mstr[6]:='Exit';
  mstr[7]:='';
  menu(26,4,mr);
  case mr of
   1: begin
       right;
       play(level);
       right;
       wrt(26,18,'Level:');
       str(level,pstr);
       wrt(33,18,pstr);
      end;
   2: begin
       wrt(33,18,'   ');
       rd(33,18,3,pstr);
       val(pstr,level,valer);
       if level<1 then level:=1;
       if level>100 then level:=100;
       wrt(33,18,'   ');
       str(level,pstr);
       wrt(33,18,pstr);
      end;
   3: begin
       right;
       str(level,pstr);
       pstr:='LEVEL'+pstr;
       assign(dfile,pstr);
       {$i-}
       reset(dfile);
       {$i+}
       if ioresult=0 then begin
        read(dfile,d);
        close(dfile);
       end
       else begin
        assign(dfile,'LEVEL0');
        reset(dfile);
        read(dfile,d);
        close(dfile);
       end;
       edit(level);
       right;
       wrt(26,18,'Level:');
       str(level,pstr);
       wrt(33,18,pstr);
      end;
   4: begin
       right;
       for i:=1 to 10 do begin
        str(i,pstr);
        wrt(26,4+(i-1)*2,pstr);
        wrt(29,4+(i-1)*2,high[i].name);
        wrt(27,5+(i-1)*2,c[high[i].class].name);
        str(high[i].score,pstr);
        wrt(35,5+(i-1)*2,pstr);
        if high[i].winner then ptext(39,(3+(i-1)*2)*2,orbshp);
       end;
       wrt(26,25,'Press A Key');
       repeat until keypressed;
       ch:=readkey;
       right;
       wrt(26,18,'Level:');
       str(level,pstr);
       wrt(33,18,pstr);
      end;
   5: begin
       right;
       mr2:=1;
       quit2:=false;
       if joysticknumber=1 then joy:=true else joy:=false;
       repeat
        mstr[1]:='Delay';
        if joy then mstr[2]:='Joystick Off'
        else mstr[2]:='Joystick On ';
        mstr[3]:='Center Joystick';
        mstr[4]:='Exit';
        mstr[5]:='';
        wrt(26,14,'Delay: ');
        str(delaynumber,pstr);
        wrt(33,14,pstr);
        menu(26,4,mr2);
        case mr2 of
         1: begin
             wrt(33,14,'      ');
             rd(33,14,6,pstr);
             val(pstr,delaynumber,valer);
             if delaynumber<1 then delaynumber:=1;
             if delaynumber>999999 then delaynumber:=999999;
            end;
         2: if joy then joy:=false else joy:=true;
         3: if joy then begin
             right;
             wrt(26,4,'Center Joystick');
             wrt(26,6,'Press Button');
             wrt(26,10,'Press A Key');
             wrt(26,12,'To Stop');
             joybutton(z);
             joyb[1]:=odd(trunc(z.al/8));
             joyb[2]:=odd(trunc(z.al/16));
             joyb[3]:=odd(trunc(z.al/32));
             joyb[4]:=odd(trunc(z.al/64));
             repeat
              joymove(r);
              joybutton(z);
             until (keypressed) or (odd(trunc(z.al/8))<>joyb[1]) or
              (odd(trunc(z.al/16))<>joyb[2]) or (odd(trunc(z.al/32))<>joyb[3])
              or (odd(trunc(z.al/64))<>joyb[4]);
             if (not keypressed) then begin
              centerx:=r.ax;
              centery:=r.bx;
              if (odd(trunc(z.al/8))<>joyb[1]) then button:=1;
              if (odd(trunc(z.al/16))<>joyb[2]) then button:=2;
              if (odd(trunc(z.al/32))<>joyb[3]) then button:=4;
              if (odd(trunc(z.al/64))<>joyb[4]) then button:=8;
             end
             else ch:=readkey;
             right;
            end;
         4: quit2:=true;
        end;
       until quit2;
       if joy then joysticknumber:=1 else joysticknumber:=0;
       assign(delayfile,'ORB.DAT');
       rewrite(delayfile);
       write(delayfile,delaynumber);
       write(delayfile,joysticknumber);
       write(delayfile,centerx);
       write(delayfile,centery);
       write(delayfile,button);
       close(delayfile);
       right;
       wrt(26,18,'Level:');
       str(level,pstr);
       wrt(33,18,pstr);
      end;
   6: quit:=true;
  end;
 until quit;
 textmode(c80);
end.