(*--------------------------- I/O Module --------------------------*)
(* (C) 1985 Copyright A.I.SOFTWARE                                 *)


(*----------------- Keyboard input -----------------*)

PROCEDURE PUTCHR(CH:CHAR); FORWARD;
PROCEDURE CLEAR_CORNER_WINDOW; FORWARD;



PROCEDURE GETCHR2(VAR CH:CHAR);
VAR
(* Uses direct io *)
  R:REGISTERS;
BEGIN

  R.AX   := $0600;
  R.DX   := $00FF;
  MSDOS(R);
  IF (R.FLAGS AND $0040) = 0 THEN CH := UPCASE(CHR(LO(R.AX)))
  ELSE CH := '@';

END; (* GETCHR2 *)


PROCEDURE BEEP;
BEGIN

  IF BEEPON THEN PUTCHR(CHR(7));

END; (* BEEP *)


PROCEDURE BACK_SPACE(VAR CH_NUM:BYTE);
BEGIN

  IF CH_NUM > 1 THEN BEGIN

    PUTCHR(' ');
    GOTOXY(WHEREX-2,WHEREY);
    PUTCHR(' ');
    GOTOXY(WHEREX-1,WHEREY);
    CH_NUM := CH_NUM - 1;

  END;

END; (* BACK_SPACE *)


PROCEDURE READER(N:BYTE; VAR CH:CHAR);
BEGIN

  CASE N OF

    1:REPEAT GETCHR2(CH); UNTIL CH IN ['Y','N'];
    2:REPEAT GETCHR2(CH); UNTIL CH IN ['S','D','T','I','Q'];
    3:REPEAT GETCHR2(CH); UNTIL CH IN ['1'..'5','I','Q'];
    4:REPEAT GETCHR2(CH); UNTIL CH IN ['Y','N','Q'];
    5:REPEAT GETCHR2(CH); UNTIL CH IN ['N','R','H','I','Q'];
    6:REPEAT GETCHR2(CH); UNTIL CH IN ['2','4','6','Q','I'];
    7:REPEAT GETCHR2(CH); UNTIL CH IN ['Y','N',CHR(RET)];
    8:REPEAT GETCHR2(CH); UNTIL CH IN ['0'..'9',CHR(RET),CHR(BKS)];
    9:REPEAT GETCHR2(CH); UNTIL CH IN ['G','I','Q'];

  END;

END; (* READER *)


PROCEDURE WRITEL(S:MSGS); FORWARD;


PROCEDURE READCHR(VAR CH:CHAR);
VAR

  COUNT,X,Y :INTEGER;

BEGIN

  X     := WHEREX;
  Y     := WHEREY;
  COUNT := 0;
  PUTCHR('?');
  GOTOXY(WHEREX-1,5);
  REPEAT

    COUNT := COUNT + 1;
    IF COUNT = MAXINT THEN  BEGIN

      IF NUM_PLAYERS = 0 THEN BEGIN

       GOTOXY(2,2);WRITEL('I''m waiting..');PUTCHR('.');
       DELAY(2000);
       GOTOXY(2,2);WRITEL('             '); PUTCHR(' ');
       COUNT := 0;
       GOTOXY(X,Y);

      END;

    END
    ELSE GETCHR2(CH);

  UNTIL CH IN ['A'..'F','0'..'9',
               'N','H','Q','S','U','M','T','O',
                CHR(BKS),CHR(RET)            ];


END; (* READCHR *)

PROCEDURE BLANKS; FORWARD;


PROCEDURE GET_FILE_NAME;
VAR

  CH :CHAR;
  I,J:BYTE;

BEGIN

  I := 1;
  REPEAT

    GETCHR2(CH);
    IF ((I = 1)AND(CH IN ['A'..'Z']))
    OR ((I > 1)AND(CH IN ['A'..'Z','0'..'9',':','.']))
    THEN BEGIN

      SAVED_GAME[I] := CH;
      I             := I + 1;
      PUTCHR(CH);

    END
    ELSE IF ORD(CH) = BKS THEN BACK_SPACE(I);

  UNTIL (ORD(CH) = RET)OR(I > 8);
  FOR J := I TO 11 DO SAVED_GAME[J] := ' ';

END; (* GET_FILE_NAME *)


PROCEDURE READNUM(VAR NUM:BYTE);
VAR

  IP    :BYTE;
  INT   :PACKED ARRAY[0..2] OF CHAR;
  NUMCH :CHAR;

BEGIN

  IP    := 0;
  NUM   := 0;
  INT[0]:='0';
  INT[1]:='0';
  INT[2]:='0';
  REPEAT

    READER(8,NUMCH);
    IF NUMCH IN ['0'..'9'] THEN BEGIN

      IP := IP + 1;
      GOTOXY(13+IP,3);
      INT[IP] := NUMCH;
      PUTCHR(NUMCH);

    END
    ELSE IF NUMCH = CHR(BKS) THEN BACK_SPACE(IP);

  UNTIL (NUMCH = CHR(RET))OR (IP = 2);
  IF IP > 0 THEN NUM := (ORD(INT[IP-1])-48) * 10 + (ORD(INT[IP])-48);
  GOTOXY(2,3);BLANKS;

END; (* READNUM *)


(*------------------- screen output ----------------*)


PROCEDURE CIRCLE(X,Y,CLR:INTEGER; N:CODE_NAME); FORWARD;


PROCEDURE PUTCHR;
VAR

  R :REGISTERS;

BEGIN

  R.AX   := $0200;
  R.DX := ORD(CH);
  MSDOS(R);

END; (* PUTCHR *)


PROCEDURE BLANKS;
VAR
  I :BYTE;
BEGIN

  FOR I:=1 TO 14 DO PUTCHR(' ');

END; (* BLANKS *)

PROCEDURE WRITEL;
VAR

  I :BYTE;

BEGIN

  FOR I:= 1 TO 13 DO PUTCHR(S[I]);

END; (* WRITEL *)


PROCEDURE WRITEINT(NUM:BYTE);
VAR
  X :BYTE;
  N :ARRAY [1..5] OF BYTE;
  NP:BYTE;
  I :BYTE;
BEGIN

  NP   := 0;
  REPEAT

    X    := NUM MOD 10;
    NP   := NP + 1;
    N[NP]:= X;
    NUM  := (NUM - X) DIV 10;

  UNTIL NUM = 0;
  FOR I:= NP DOWNTO 1 DO PUTCHR(CHR(N[I]+48));

END; (* WRITEINT *)


PROCEDURE MODE_AND_COLOR(N:BYTE);
BEGIN

  CASE N OF

    1:BEGIN

        TEXTCOLOR(YELLOW);
        TEXTBACKGROUND(BLACK);

      END;
    2:BEGIN

        TEXTMODE(C80);
        TEXTCOLOR(BLUE);
        TEXTBACKGROUND(BLACK);

      END;
    3:TEXTCOLOR(WHITE);
    4:BEGIN

        GRAPHCOLORMODE;
        PALETTE(PL);

      END;
    5:BEGIN

        TEXTCOLOR(BLACK);
        TEXTBACKGROUND(WHITE);

      END;
    6:BEGIN

        GRAPHBACKGROUND(BG);
        PALETTE(PL);

      END;
  END;

END; (* MODE_AND_COLOR *)


PROCEDURE CHANGE_COLORS;
BEGIN

  IF BG < 15 THEN BG := BG + 1
  ELSE BEGIN

    BG := 0;
    PL := (PL + 1) MOD 4;

  END;
  MODE_AND_COLOR(6);

END;(* CHANGE_COLORS *)


PROCEDURE CLEAR_CORNER_WINDOW;
VAR

  I :BYTE;

BEGIN

  FOR I := 2 TO 5 DO BEGIN

    GOTOXY(2,I);BLANKS;

  END;

END; (* CLEAR_CORNER_WINDOW *)



PROCEDURE REPORT_HINT(ND,ST,LCT:BYTE);
BEGIN

  CLEAR_CORNER_WINDOW;
  GOTOXY(2,3);PUTCHR('T');PUTCHR('r');PUTCHR('y');
  PUTCHR(' ');PUTCHR(BOARD[PLAYERS[ST][LCT]].NAME[1]);
  PUTCHR(BOARD[PLAYERS[ST][LCT]].NAME[2]);
  PUTCHR(' ');PUTCHR('t');PUTCHR('o');
  PUTCHR(' ');PUTCHR(BOARD[ND].NAME[1]);
  PUTCHR(BOARD[ND].NAME[2]);
  DELAY(3000);

END; (* REPORT_HINT *)


PROCEDURE WRITECHR(CH:CHAR);
BEGIN

  IF CH IN ['A'..'F','0'..'9']
  THEN PUTCHR(CH);

END; (* WRITECHR *)


PROCEDURE FLASH_SCREEN(N:BYTE);
VAR

  J :BYTE;

BEGIN

  FOR J := 0 TO N DO BEGIN

    PALETTE(J);
    DELAY(140);

  END;
  PALETTE(PL);

END; (* FLASH_SCREEN *)


PROCEDURE CLEAR1_WINDOW;
VAR

  I :BYTE;

BEGIN

  MODE_AND_COLOR(1);
  FOR I:= 1 TO 8 DO BEGIN

    GOTOXY(13,13 + I);WRITE('                                                       ');

  END;

END;(* CLEAR1_WINDOW *)


PROCEDURE SING_DISPLAY(CH_FROM_ND,CH_TO_ND,OP_FROM_ND,OP_TO_ND:BYTE);
BEGIN

(* displays last moves and number of turns for Chester - Human game *)

  GOTOXY(26,3);WRITEL('Last moves:  ');
  IF CH_FROM_ND <> 0 THEN BEGIN

    GOTOXY(27,4);
    PUTCHR('I');PUTCHR(' ');PUTCHR(' ');PUTCHR(':');PUTCHR(' ');
    PUTCHR(BOARD[CH_FROM_ND].NAME[1]);
    PUTCHR(BOARD[CH_FROM_ND].NAME[2]);
    PUTCHR(' ');PUTCHR('t');PUTCHR('o');PUTCHR(' ');
    PUTCHR(BOARD[CH_TO_ND].NAME[1]);
    PUTCHR(BOARD[CH_TO_ND].NAME[2]);

  END;
  IF OP_FROM_ND <> 0 THEN BEGIN

    GOTOXY(27,5);
    PUTCHR('Y');PUTCHR('o');PUTCHR('u');PUTCHR(':');PUTCHR(' ');
    PUTCHR(BOARD[OP_FROM_ND].NAME[1]);
    PUTCHR(BOARD[OP_FROM_ND].NAME[2]);
    PUTCHR(' ');PUTCHR('t');PUTCHR('o');PUTCHR(' ');
    PUTCHR(BOARD[OP_TO_ND].NAME[1]);
    PUTCHR(BOARD[OP_TO_ND].NAME[2]);
  END;
  GOTOXY(2,3);BLANKS;
  GOTOXY(26,2);WRITEL('# of moves:  ');PUTCHR(' ');
  GOTOXY(37,2);WRITEINT(NUM_MOVES);

END; (* SING_DISPLAY *)


PROCEDURE MULT_DISPLAY(FROM_ND,TO_ND,LAST_FROM,LAST_TO ,MODE:BYTE);
BEGIN

(* displays last moves and number of turns for Human - Human game *)
  IF FROM_ND <> 0 THEN BEGIN

    GOTOXY(26,3);WRITEL('Last moves:  ');
    GOTOXY(27,4);
    PUTCHR('P');PUTCHR('r');PUTCHR(' ');
    PUTCHR(CHR(MODE + 48));
    PUTCHR(':');
    PUTCHR(BOARD[FROM_ND].NAME[1]);
    PUTCHR(BOARD[FROM_ND].NAME[2]);
    PUTCHR(' ');PUTCHR('t');PUTCHR('o');PUTCHR(' ');
    PUTCHR(BOARD[TO_ND].NAME[1]);PUTCHR(BOARD[TO_ND].NAME[2]);

  END
  ELSE BEGIN

    GOTOXY(26,3);BLANKS;
    GOTOXY(26,4);BLANKS;

  END;
  IF LAST_FROM <> 0 THEN BEGIN


    GOTOXY(27,5);
    PUTCHR('P');PUTCHR('r');PUTCHR(' ');
    CASE MODE OF
      1        :PUTCHR(CHR(NUM_PLAYERS + 48));
      2,3,4,5,6:PUTCHR(CHR(MODE        + 47));
    END;
    PUTCHR(':');
    PUTCHR(BOARD[LAST_FROM].NAME[1]);
    PUTCHR(BOARD[LAST_FROM].NAME[2]);
    PUTCHR(' ');PUTCHR('t');PUTCHR('o');PUTCHR(' ');
    PUTCHR(BOARD[LAST_TO].NAME[1]);
    PUTCHR(BOARD[LAST_TO].NAME[2]);

  END
  ELSE BEGIN

    GOTOXY(26,5);BLANKS;

  END;
  IF NUM_MOVES <> 0 THEN BEGIN

    GOTOXY(26,2);WRITEL('# of moves:  ');PUTCHR(' ');
    GOTOXY(37,2);WRITEINT(NUM_MOVES);

  END
  ELSE BEGIN

    GOTOXY(26,2);BLANKS;

  END;

END; (* MULT_DISPLAY *)


PROCEDURE PROMPT(N:BYTE); FORWARD;



OVERLAY PROCEDURE MAIN_SCREEN;
BEGIN

  MODE_AND_COLOR(2);
  GOTOXY(1 ,1 );WRITE('');
  GOTOXY(1 ,2 );WRITE('۲                                               ۲');
  GOTOXY(1 ,3 );WRITE('۲          ۲');
  GOTOXY(1 ,4 );WRITE('۲                                  ۲');
  GOTOXY(1 ,5 );WRITE('۲           ۲');
  GOTOXY(1 ,6 );WRITE('۲                                    ۲');
  GOTOXY(1 ,7 );WRITE('۲۲');
  GOTOXY(1 ,8 );WRITE('۲                                          ۲');
  GOTOXY(1 ,9 );WRITE('۲۲');
  GOTOXY(1 ,10);WRITE('۲                            ۲');
  GOTOXY(1 ,11);WRITE('۲۲');
  GOTOXY(1 ,12);WRITE('۲Ĳ');
  GOTOXY(1 ,13);WRITE('۲۲');
  GOTOXY(1 ,14);WRITE('۲                                                       ۲');
  GOTOXY(1 ,15);WRITE('۲                                                       ۲');
  GOTOXY(1 ,16);WRITE('۲                                                       ۲');
  GOTOXY(1 ,17);WRITE('۲                                                       ۲');
  GOTOXY(1 ,18);WRITE('۲                                                       ۲');
  GOTOXY(1 ,19);WRITE('۲                                                       ۲');
  GOTOXY(1 ,20);WRITE('۲                                                       ۲');
  GOTOXY(1 ,21);WRITE('۲                                                       ۲');
  GOTOXY(1 ,22);WRITE('۲۲');
  GOTOXY(1 ,23);WRITE('۲                                                       ۲');
  GOTOXY(1 ,24);WRITE('');
  MODE_AND_COLOR(3);
  GOTOXY(21,8);WRITE('The Intelligent Chinese Checkers Program');
  GOTOXY(27,10);WRITE('(C) copyright A.I.SOFTWARE');

END; (* MAIN_SCREEN *)


OVERLAY PROCEDURE REMARK(M,N:BYTE);
BEGIN


  CLEAR_CORNER_WINDOW;
  BEEP;
  IF M = 1 THEN CASE N OF


    8 :IF BEFORE[2].C = 1 THEN BEGIN

       GOTOXY(2,3);WRITEL('Got you again');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('Got you now !');
         BEFORE[2].C := 1;

       END;
    10:IF BEFORE[3].C = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I told you to');
         GOTOXY(2,4);WRITEL('watch out... ');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('watch out now');
         BEFORE[3].C := 1;

       END;
    12:IF BEFORE[4].C = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I don''t mean ');
         GOTOXY(2,4);WRITEL('to annoy you ');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('annoying ?   ');
         BEFORE[4].C := 1;

       END;
    14:IF BEFORE[5].C = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I warned you!');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('You will lose');
         GOTOXY(2,4);WRITEL('this way...  ');
         BEFORE[5].C := 1;

       END;
    16:IF BEFORE[6].C = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I told you,  ');
         GOTOXY(2,4);WRITEL('you''re doomed');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('you''re doomed');
         BEFORE[6].C := 1;

       END;

  END
  ELSE CASE N OF


    8 :IF BEFORE[2].O = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('Got me again ');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('Got me there ');
         BEFORE[2].O := 1;

       END;
    10:IF BEFORE[3].O = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('You are very ');
         GOTOXY(2,4);WRITEL('good at this ');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('I''d better   ');
         GOTOXY(2,4);WRITEL('watch out... ');
         BEFORE[3].O := 1;

       END;
    12:IF BEFORE[4].O = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I''m changing ');
         GOTOXY(2,4);WRITEL('my strategy..');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('smashing !   ');
         BEFORE[4].O := 1;

       END;
    14:IF BEFORE[5].O = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('you''re going ');
         GOTOXY(2,4);WRITEL('to get to me ');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('overwhelming!');
         BEFORE[5].O := 1;

       END;

    16:IF BEFORE[6].O = 1 THEN BEGIN

         GOTOXY(2,3);WRITEL('I am doomed..');

       END
       ELSE BEGIN

         GOTOXY(2,3);WRITEL('I''m going to ');
         GOTOXY(2,4);WRITEL('lose this way');
         BEFORE[6].O := 1;

       END;

  END;

  DELAY(2000);

END; (* REMARK *)


OVERLAY PROCEDURE MESSAGE(N :BYTE);
VAR

  I,K :BYTE;
  NM  :CODE_NAME;

BEGIN

  CASE N OF

   1:BEGIN

       CLEAR1_WINDOW;
       GOTOXY(14,16);WRITE('Do you want to start over ?');
       GOTOXY(35,18);WRITE('Y : Yes');
       GOTOXY(35,19);WRITE('N : No ');
       GOTOXY(1,1);

     END;
   4:BEGIN

       NM[1] := '@';
       NM[2] := '@';
       GOTOXY(2,10);
       PUTCHR('Y');PUTCHR('o');PUTCHR('u');PUTCHR('r');PUTCHR('s');
       FOR K := 1 TO NUM_SETS DO
                CIRCLE(28,90+K*14-14,PLAY_SETS[K].OP,NM);
       GOTOXY(35,10);
       PUTCHR('M');PUTCHR('i');PUTCHR('n');PUTCHR('e');
       FOR K := 1 TO NUM_SETS DO
                CIRCLE(290,90+K*14-14,PLAY_SETS[K].CT,NM);
     END;
   5:BEGIN

       NM[1] := '@';
       NM[2] := '@';
       K     := 1;
       WHILE K <= NUM_SETS DO BEGIN

         GOTOXY(2,7+K*3);
         PUTCHR('P');PUTCHR('y');PUTCHR('r');PUTCHR(' ');
         PUTCHR(CHR(2*K+47));
         CIRCLE(28,(8+K*3)*8,PLAY_SETS[K].CT,NM);

         GOTOXY(35,7+K*3);
         PUTCHR('P');PUTCHR('y');PUTCHR('r');PUTCHR(' ');
         PUTCHR(CHR(2*K+48));
         CIRCLE(290,(8+K*3)*8,PLAY_SETS[K].OP,NM);
         K := K + 1;

       END;
     END;
   6:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,3);        WRITEL('Sorry, you   ');
       GOTOXY(2,4);        WRITEL('don''t have   ');
       GOTOXY(2,5);        WRITEL('any long move');
       DELAY(3000);

     END;
   7:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,3);WRITEL('Backing up...');

     END;
   8:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,3);WRITEL('Trading sides');
       DELAY(500);

     END;
   9:BEGIN

       GOTOXY(2 ,21);WRITEL('-- Options --');
       GOTOXY(2 ,22);WRITEL('H :Hint move ');
       GOTOXY(2 ,23);WRITEL('Q :Quit game ');
       GOTOXY(2 ,24);WRITEL('S :Save game ');
       GOTOXY(26,21);WRITEL('O :Beep on/of');PUTCHR('f');
       GOTOXY(26,22);WRITEL('U :Undo moves');
       GOTOXY(26,23);WRITEL('N :New colors');
       IF NUM_PLAYERS = 0 THEN BEGIN

         GOTOXY(26,24);WRITEL('T :Trade side');
         PUTCHR('s');

       END;

     END;
  11:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,2);WRITEL('Game over.   ');

     END;
  12,13:BEGIN

       FLASH_SCREEN(7);
       GOTOXY(2,3);
       FOR I := 1 TO 3 DO BEEP;
       CASE N OF
         12:WRITEL('I won !!!!   ');
         13:WRITEL('You win...   ');
       END;
       DELAY(2000);

     END;
  14:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,2);WRITEL('Good bye...  ');

     END;

   15,16,17,18,19,20
     :BEGIN

        GOTOXY(2,3);
        FLASH_SCREEN(6);
        FOR I := 1 TO 3 DO BEEP;
        CASE N OF

          15:WRITEL('Player 1 wins');
          16:WRITEL('Player 2 wins');
          17:WRITEL('Player 3 wins');
          18:WRITEL('Player 4 wins');
          19:WRITEL('Player 5 wins');
          20:WRITEL('Player 6 wins');

        END;
        DELAY(2000);

      END;
   21:BEGIN

        CLEAR1_WINDOW;
        GOTOXY(20,15);WRITE('Would you like  to');
        GOTOXY(20,17);WRITE('          G : see a sample game ?  ');
        GOTOXY(20,18);WRITE('          I : read instructions ?  ');
        GOTOXY(20,19);WRITE('          Q : Quit / restart    ?  ');
        GOTOXY(1,1);

      END;
   24:BEGIN

        BEEP;
        GOTOXY(30,24);WRITE('Sorry, that was all.');
        DELAY(1000);

      END;
   25:BEGIN

       GOTOXY(30,24);WRITE('--- More  (y/n) ? ---');
       GOTOXY(1,1);

     END;
   26:BEGIN

        GOTOXY(2 ,21);WRITEL('The goal is t');PUTCHR('o');
        GOTOXY(2 ,22);WRITEL('place all you');PUTCHR('r');
        GOTOXY(2 ,23);WRITEL('marbles on th');PUTCHR('e');
        GOTOXY(2 ,24);WRITEL('opposite side');
        GOTOXY(26,21);WRITEL('before your  ');
        GOTOXY(26,22);WRITEL('opponent puts');
        GOTOXY(26,23);WRITEL('all of his on');
        GOTOXY(26,24);WRITEL('yours.       ');

      END;
   27:BEGIN

        GOTOXY(2 ,21);WRITEL('A single jump');PUTCHR(' ');
        GOTOXY(2 ,22);WRITEL('can be made  ');PUTCHR(' ');
        GOTOXY(2 ,23);WRITEL('to any free  ');PUTCHR(' ');
        GOTOXY(2 ,24);WRITEL('adjacent hole');
        GOTOXY(26,21);WRITEL('Long jumps   ');
        GOTOXY(26,22);WRITEL('are made by  ');
        GOTOXY(26,23);WRITEL('jumping over ');
        GOTOXY(26,24);WRITEL('any marble   ');
        PUTCHR(' ');

      END;
   28:BEGIN

        GOTOXY(2 ,21);WRITEL('The strategy ');
        GOTOXY(2 ,22);WRITEL('to play well ');
        GOTOXY(2 ,23);WRITEL('involves plan');PUTCHR('s');
        GOTOXY(2 ,24);WRITEL('for long jump');PUTCHR('s');
        GOTOXY(26,21);WRITEL('discovering  ');
        GOTOXY(26,22);WRITEL('and blocking ');
        GOTOXY(26,23);WRITEL('the opponent''');PUTCHR('s');
        GOTOXY(26,24);WRITEL('plans, and   ');

      END;
   29:BEGIN

        GOTOXY(2 ,21);WRITEL('in general   ');
        GOTOXY(2 ,22);WRITEL('finding good ');
        GOTOXY(2 ,23);WRITEL('sequences of ');PUTCHR(' ');
        GOTOXY(2 ,24);WRITEL('moves that   ');PUTCHR(' ');
        GOTOXY(26,21);WRITEL('lead you to  ');
        GOTOXY(26,22);WRITEL('the goal fast');
        GOTOXY(26,23);WRITEL('and before   ');PUTCHR(' ');
        GOTOXY(26,24);WRITEL('your opponent');

      END;
   30:BEGIN

        GOTOXY(2 ,21);WRITEL('This sample  ');
        GOTOXY(2 ,22);WRITEL('uses a simple');
        GOTOXY(2 ,23);WRITEL('strategy to  ');
        GOTOXY(2 ,24);WRITEL('show the idea');
        GOTOXY(26,21);WRITEL('examine each ');
        GOTOXY(26,22);WRITEL('move being   ');
        GOTOXY(26,23);WRITEL('made. Stop if');
        GOTOXY(26,24);WRITEL('ready to play');

      END;

  31:BEGIN

        GOTOXY(2 ,2);WRITEL('Taking a few ');
        GOTOXY(2 ,3);WRITEL('minutes now, ');
        GOTOXY(2 ,4);WRITEL('but will play');
        GOTOXY(2 ,5);WRITEL('faster later ');

      END;

  32:BEGIN

        GOTOXY(2 ,2);WRITEL('Sorry, you   ');
        GOTOXY(2 ,3);WRITEL('maynot undo  ');
        GOTOXY(2 ,4);WRITEL('moves at this');
        GOTOXY(2 ,5);WRITEL('point in game');
        DELAY(2000);

      END;
   33:BEGIN

        GOTOXY(2 ,2);WRITEL('Sorry, maynot');
        GOTOXY(2 ,3);WRITEL('trade sides  ');
        GOTOXY(2 ,4);WRITEL('at this point');
        GOTOXY(2 ,5);WRITEL('in the game  ');
        DELAY(2000);

      END;

  END;

END; (* MESSAGE *)


OVERLAY PROCEDURE ERROR(N:BYTE);
BEGIN

  BEEP;
  IF N IN [1,2,3,8] THEN BEGIN

    CLEAR1_WINDOW;
    MODE_AND_COLOR(1);

  END;
  CASE N OF

   1:BEGIN

       GOTOXY(30,16);
       WRITE('Can''t find Chester''s data file "CHESTER.DAT" ');

     END;
   2:BEGIN

       GOTOXY(25,16);
       WRITE('Can''t find your game...');

     END;
   3,11:BEGIN

       GOTOXY(25,16);
       IF N = 3 THEN WRITE('Can''t get all of your game...')
       ELSE          WRITE('The given file name is invalid');

     END;
   4,5,6,7,10:
      BEGIN

        CLEAR_CORNER_WINDOW;
        GOTOXY(2,3);
        CASE N OF

          4:WRITEL('Typing error,');
          5:WRITEL('Illegal move,');
          6:WRITEL('Not yours,   ');
          7:WRITEL('Disk is full ');
         10:WRITEL('Invalid name ');

        END;
        GOTOXY(2,4);
        IF N IN [4,5,6] THEN WRITEL('try again    ');

     END;
   8:BEGIN

       CLEAR1_WINDOW;
       GOTOXY(25,16);
       WRITE('Can''t find help file');
       CLEAR1_WINDOW;

     END;
   9:BEGIN

       GOTOXY(25,16);
       WRITE('Can''t find sample game file "CHESTER.SMP"');

     END;

  END;
  DELAY(2000);

END; (* ERROR *)


(*----------------- board graphics -------------------*)


PROCEDURE PAINT(X,Y,C:INTEGER);
VAR
  C1,C2,I,J:INTEGER;
BEGIN

  CASE C OF
    0:BEGIN C1:=0;C2:=0;END;
    1:BEGIN C1:=1;C2:=1;END;
    2:BEGIN C1:=2;C2:=3;END;
    3:BEGIN C1:=1;C2:=3;END;
    4:BEGIN C1:=2;C2:=2;END;
    5:BEGIN C1:=1;C2:=2;END;
    6:BEGIN C1:=3;C2:=3;END;
  END;

  FOR I:= 1 TO 9 DO IF (ODD(I))OR(I<1)   THEN PLOT(X-4+I,Y-6,C1)
                                   ELSE PLOT(X-4+I,Y-6,C2);
  FOR I:= 2 TO 12 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-6+I,Y-5,C1)
                                   ELSE PLOT(X-6+I,Y-5,C2);
  FOR I:= 1 TO 13 DO IF (ODD(I))OR(I<1)  THEN PLOT(X-6+I,Y-4,C1)
                                   ELSE PLOT(X-6+I,Y-4,C2);
  FOR I:= 2 TO 16 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-8+I,Y-3,C1)
                                   ELSE PLOT(X-8+I,Y-3,C2);
  FOR I:= 1 TO 15 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-7+I,Y-2,C1)
                                   ELSE PLOT(X-7+I,Y-2,C2);
  FOR I:= 2 TO 16 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-8+I,Y-1,C1)
                                   ELSE PLOT(X-8+I,Y-1,C2);
  FOR I:= 1 TO 15 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-7+I,Y  ,C1)
                                   ELSE PLOT(X-7+I,Y  ,C2);
  FOR I:= 2 TO 16 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-8+I,Y+1,C1)
                                   ELSE PLOT(X-8+I,Y+1,C2);
  FOR I:= 1 TO 13 DO IF (ODD(I))OR(I<1)  THEN PLOT(X-6+I,Y+2,C1)
                                   ELSE PLOT(X-6+I,Y+2,C2);
  FOR I:= 2 TO 12 DO IF (NOT ODD(I))OR(I<1)  THEN PLOT(X-6+I,Y+3,C1)
                                   ELSE PLOT(X-6+I,Y+3,C2);
  FOR I:= 1 TO 9 DO IF (ODD(I))OR(I<1)   THEN PLOT(X-4+I,Y+4,C1)
                                   ELSE PLOT(X-4+I,Y+4,C2);

END; (* PAINT *)


PROCEDURE CIRCLE;
VAR

  I,J,K,CL:INTEGER;

  PROCEDURE WRITE_A(X1,Y1:INTEGER);
  BEGIN
    PLOT(X1 + 1,Y1,CLR);
    PLOT(X1 + 2,Y1,CLR);
    FOR I:=1 TO 6 DO BEGIN
      PLOT(X1, Y1 + I,CLR);
      PLOT(X1+3, Y1 + I,CLR);
    END;
    PLOT(X1 + 1, Y1 + 3, CLR);
    PLOT(X1 + 2, Y1 + 3, CLR);
  END; (* WRITE_A *)

  PROCEDURE WRITE_B(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 6 DO PLOT(X1,Y1+I,CLR);
    FOR I:=1 TO 2 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+3,CLR);
      PLOT(X1+I,Y1+6,CLR);
      PLOT(X1+3,Y1+I,CLR);
      PLOT(X1+3,Y1+I+3,CLR);
    END;
  END;(* WRITE_B *)

  PROCEDURE WRITE_C(X1,Y1:INTEGER);
  BEGIN
    FOR I:=1 TO 5 DO PLOT(X1,Y1+I,CLR);
    FOR I:=1 TO 2 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+6,CLR);
    END;
    PLOT(X1+3,Y1+1,CLR);
    PLOT(X1+3,Y1+5,CLR);
  END;(* WRITE_C *)

  PROCEDURE WRITE_D(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 6 DO PLOT(X1+1,Y1+I,CLR);
    FOR I:=1 TO 5 DO PLOT(X1+4,Y1+I,CLR);
    FOR I:=2 TO 3 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+6,CLR);
    END;
    PLOT(X1,Y1,CLR);
    PLOT(X1,Y1+6,CLR);
  END;(* WRITE_D *)

  PROCEDURE WRITE_E_F(X1,Y1:INTEGER; WHICH:CHAR);
  BEGIN
    FOR I:=0 TO 6 DO PLOT(X1,Y1+I,CLR);
    FOR I:=1 TO 3 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+3,CLR);
      IF WHICH = 'E' THEN PLOT(X1+I,Y1+6,CLR);
    END;
  END;(* WRITE_E_F *)

  PROCEDURE WRITE_1(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 6 DO PLOT(X1+2,Y1+I,CLR);
    PLOT(X1+1,Y1,CLR);
    PLOT(X1,Y1+1,CLR);
  END;(* WRITE_1 *)

  PROCEDURE WRITE_2(X1,Y1:INTEGER);
  BEGIN
    PLOT(X1,Y1+1,CLR);
    FOR I:=0 TO 3 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+6,CLR);
      IF I > 1 THEN PLOT(X1+I,Y1+3,CLR);
    END;
    FOR I:=1 TO 2 DO PLOT(X1+3,Y1+I,CLR);
    PLOT(X1,Y1+5,CLR);
    PLOT(X1+1,Y1+4,CLR);
  END;(* WRITE_2 *)

  PROCEDURE WRITE_3(X1,Y1:INTEGER);
  BEGIN
    FOR I:=1 TO 2 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1+I,Y1+6,CLR);
      PLOT(X1+3,Y1+I,CLR);
      PLOT(X1+3,Y1+I+3,CLR);
    END;
    PLOT(X1,Y1+1,CLR);
    PLOT(X1,Y1+5,CLR);
    PLOT(X1+2,Y1+3,CLR);
  END;(* WRITE_3 *)

  PROCEDURE WRITE_4(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 6 DO PLOT(X1+3,Y1+I,CLR);
    FOR I:=0 TO 3 DO PLOT(X1,Y1+I,CLR);
    FOR I:=1 TO 2 DO PLOT(X1+I,Y1+3,CLR);
  END; (* WRITE_4 *)

  PROCEDURE WRITE_5(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 3 DO BEGIN
      PLOT(X1+I,Y1,CLR);
      PLOT(X1,Y1+I,CLR);
    END;
    FOR I:=0 TO 2 DO BEGIN
      PLOT(X1+I,Y1+3,CLR);
      PLOT(X1+I,Y1+6,CLR);
    END;
    PLOT(X1+3,Y1+4,CLR);
    PLOT(X1+3,Y1+5,CLR);
  END;(* WRITE_5 *)

  PROCEDURE WRITE_6(X1,Y1:INTEGER);
  BEGIN
    FOR I:=2 TO 5 DO PLOT(X1,Y1+I,CLR);
    PLOT(X1+1,Y1+6,CLR);
    PLOT(X1+2,Y1+6,CLR);
    PLOT(X1+3,Y1+5,CLR);
    PLOT(X1+3,Y1+4,CLR);
    PLOT(X1+2,Y1+3,CLR);
    PLOT(X1+1,Y1+4,CLR);
    PLOT(X1+1,Y1+1,CLR);
    PLOT(X1+2,Y1  ,CLR);
  END;(* WRITE_6 *)

  PROCEDURE WRITE_7(X1,Y1:INTEGER);
  BEGIN
    FOR I:=0 TO 3 DO PLOT(X1+I,Y1,CLR);
    PLOT(X1,Y1+1,CLR);
    FOR I:=1 TO 2 DO PLOT(X1+3,Y1+I,CLR);
    PLOT(X1+2,Y1+3,CLR);
    FOR I:=4 TO 6 DO PLOT(X1+1,Y1+I,CLR);
  END; (* WRITE_7 *)

  PROCEDURE WRITE_8_9_0(X1,Y1,WHICH:INTEGER);
  BEGIN
    CASE WHICH OF
      0:BEGIN
          FOR I:=1 TO 5 DO BEGIN
            PLOT(X1  ,Y1+I,CLR);
            PLOT(X1+3,Y1+I,CLR);
          END;
          FOR I:=1 TO 2 DO  BEGIN
            PLOT(X1+I,Y1  ,CLR);
            PLOT(X1+I,Y1+6,CLR);
          END;
        END;
    8,9:BEGIN
          FOR I:=0 TO 6 DO PLOT(X1+3,Y1+I,CLR);
          FOR I:=0 TO 2 DO BEGIN
            PLOT(X1+I,Y1,CLR);
            IF (WHICH=8)OR(WHICH=9) THEN PLOT(X1+I,Y1+3,CLR);
          END;
          FOR I:=1 TO 2 DO PLOT(X1,Y1+I,CLR);
          IF WHICH=8 THEN BEGIN
            FOR I:=3 TO 6 DO PLOT(X1,Y1+I,CLR);
            FOR I:=1 TO 2 DO PLOT(X1+I,Y1+6,CLR);
          END;
        END;
    END;
  END;(* WRITE_8_9_0 *)

 BEGIN

 IF CLR = 7 THEN BEGIN
(* clears marble *)

  CL := 1;
  FOR J:=0 TO 3 DO PLOT(X-J,Y-6,CL);
  FOR J:=1 TO 4 DO PLOT(X+J,Y-6,CL);
  FOR J:=0 TO 3 DO PLOT(X-J,Y+4,CL);
  FOR J:=1 TO 4 DO PLOT(X+J,Y+4,CL);
  FOR J:=1 TO 3 DO PLOT(X-6,Y-J,CL);
  FOR J:=1 TO 3 DO PLOT(X+7,Y-J,CL);
  FOR J:=0 TO 1 DO PLOT(X-6,Y+J,CL);
  FOR J:=0 TO 1 DO PLOT(X+7,Y+J,CL);
  PLOT(X-4,Y-5,CL);
  PLOT(X-5,Y-4,CL);
  PLOT(X+5,Y-5,CL);
  PLOT(X+6,Y-4,CL);
  PLOT(X-5,Y+2,CL);
  PLOT(X-4,Y+3,CL);
  PLOT(X+6,Y+2,CL);
  PLOT(X+5,Y+3,CL);

 END
 ELSE PAINT(X,Y,CLR);

 IF CLR = 7 THEN CLR := 3 ELSE CLR:=0;

 FOR K:= 1 TO 2 DO
 CASE N[K] OF  (* N[K] if the name of the marble *)

    '0':WRITE_8_9_0(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4,0);
    '1':WRITE_1(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '2':WRITE_2(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '3':WRITE_3(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '4':WRITE_4(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '5':WRITE_5(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '6':WRITE_6(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '7':WRITE_7(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    '8':WRITE_8_9_0(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4,8);
    '9':WRITE_8_9_0(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4,9);
    'A':WRITE_A(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    'B':WRITE_B(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    'C':WRITE_C(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    'D':WRITE_D(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4);
    'E':WRITE_E_F(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4,'E');
    'F':WRITE_E_F(X - (4 * (2 - K)) + (2 * (K - 1)),Y - 4,'F');

  END;

END; (* CIRCLE *)


PROCEDURE MOVEIT(FROM_ND,TO_ND,ST:BYTE);
VAR

  I,J      :BYTE;

BEGIN

  BEEP;
  GET_PATH(ST,FROM_ND,TO_ND);
  FOR I := PATH_LENGTH DOWNTO 2 DO BEGIN

    FOR J := 1 TO 5 DO BEGIN

      PAINT(BOARD[MOVE_PATH[I-1]].XCOORD,BOARD[MOVE_PATH[I-1]].YCOORD,0);
      PAINT(BOARD[MOVE_PATH[I  ]].XCOORD,BOARD[MOVE_PATH[I  ]].YCOORD,0);
      CIRCLE(BOARD[MOVE_PATH[I - 1]].XCOORD,BOARD[MOVE_PATH[I - 1]].YCOORD,
             BOARD[FROM_ND         ].COLOR, BOARD[MOVE_PATH[I - 1]].NAME);
      CIRCLE(BOARD[MOVE_PATH[I    ]].XCOORD,BOARD[MOVE_PATH[I    ]].YCOORD,
             BOARD[MOVE_PATH[I - 1]].COLOR, BOARD[MOVE_PATH[I    ]].NAME);
    END;

  END;

  IF ((BOARD[FROM_ND].DIST[ST] - BOARD[TO_ND].DIST[ST]) > 6) AND
     (* in order not to do this during the sample game *)
     (OP_LAST_F <> 0)
  THEN BEGIN

    FLASH_SCREEN(BOARD[FROM_ND].DIST[ST] - BOARD[TO_ND].DIST[ST]);
    IF NUM_PLAYERS = 0
    THEN REMARK(MODE,BOARD[FROM_ND].DIST[ST] - BOARD[TO_ND].DIST[ST]);

  END;
  BOARD[TO_ND].COLOR   := BOARD[FROM_ND].COLOR;
  BOARD[FROM_ND].COLOR := 7;

END; (* MOVEIT *)


OVERLAY PROCEDURE DRAWBOARD;
VAR

  NM :CODE_NAME;
  I  :INTEGER;

BEGIN

  FOR I:=121 DOWNTO 1 DO BEGIN

    IF BOARD[I].COLOR = 7 THEN PAINT(BOARD[I].XCOORD,BOARD[I].YCOORD,0);
    CIRCLE(BOARD[I].XCOORD,BOARD[I].YCOORD,BOARD[I].COLOR,BOARD[I].NAME);

  END;
  DRAW(0  ,0  ,319,0  ,3);
  DRAW(319,0  ,319,199,3);
  DRAW(319,199,0  ,199,3);
  DRAW(0  ,199,0  ,0  ,3);
  DRAW(5  ,43 ,126,43 ,3);
  DRAW(126,43 ,126,5  ,3);
  DRAW(195,5  ,195,43 ,3);
  DRAW(195,43 ,314,43 ,3);
  DRAW(5  ,42 ,125,42 ,2);
  DRAW(125,42 ,125,5  ,2);
  DRAW(196,5  ,196,42 ,2);
  DRAW(196,42 ,314,42 ,2);
  DRAW(5  ,156,126,156,3);
  DRAW(126,156,126,195,3);
  DRAW(195,156,195,195,3);
  DRAW(195,156,314,156,3);
  DRAW(5  ,157,125,157,2);
  DRAW(125,157,125,195,2);
  DRAW(196,157,314,157,2);
  DRAW(196,157,196,195,2);
  DRAW(4  ,4  ,315,4  ,3);
  DRAW(315,4  ,315,195,3);
  DRAW(315,195,4  ,195,3);
  DRAW(4  ,195,4  ,4  ,3);
  DRAW(50 ,155,50 ,44 ,2);
  DRAW(51 ,155,51 ,44 ,3);
  DRAW(270,155,270,44 ,2);
  DRAW(269,155,269,44 ,3);

  FOR I:= 2 TO 317 DO IF ODD(I) THEN PLOT(I,2,2);
  FOR I:= 2 TO 317 DO IF ODD(I) THEN PLOT(I,197,2);
  FOR I:= 2 TO 197 DO IF ODD(I) THEN PLOT(2,I,2) ;
  FOR I:= 2 TO 197 DO IF ODD(I) THEN PLOT(317,I,2);

END; (* DRAWBOARD *)



(*--------------------------- File I/O Module --------------------------*)
(* (C) 1985 Copyright A.I.SOFTWARE                                      *)



OVERLAY PROCEDURE SAVE_THE_GAME;
VAR

  OK        :BOOLEAN;
  BUFFER    :ARRAY[1..128,1..308] OF BYTE ABSOLUTE GUARD;

BEGIN

  PROMPT(24);
  {$I-}
  ASSIGN(SAVED_FILE,SAVED_GAME);
  OK := (IORESULT = 0);
  IF NOT OK THEN ERROR(1)
  ELSE BEGIN

    REWRITE(SAVED_FILE);
    OK := (IORESULT = 0);
    IF NOT OK THEN ERROR(7)
    ELSE BEGIN

      GUARD := 255;
      BLOCKWRITE(SAVED_FILE,BUFFER,308);
      OK := (IORESULT = 0);
      IF NOT OK THEN ERROR(7)
      ELSE BEGIN

        CLOSE(SAVED_FILE);
        {$I+}
        OK := (IORESULT = 0);
        IF NOT OK THEN ERROR(7);

      END;

    END;

  END;

END; (* SAVE_THE_GAME *)


OVERLAY PROCEDURE WHERE_IS_THE_GAME(VAR OK :BOOLEAN);
VAR

  BUFFER    :ARRAY[1..128,1..308] OF BYTE ABSOLUTE GUARD;

BEGIN

 {$I-}
  REPEAT

    PROMPT(6);
    GET_FILE_NAME;
    ASSIGN(SAVED_FILE,SAVED_GAME);
    OK:= (IORESULT = 0);
    IF NOT OK THEN ERROR(11)
    ELSE BEGIN

      RESET(SAVED_FILE);
      OK:= (IORESULT = 0);
      IF OK THEN BEGIN

        BLOCKREAD(SAVED_FILE,BUFFER,1);
        OK := (GUARD = 255)AND(IORESULT = 0);
        {$I+}

      END;
      IF NOT OK AND (SAVED_GAME[1] <> ' ') THEN ERROR(2);

    END;

  UNTIL OK OR (SAVED_GAME[1] = ' ') ;

END; (*  WHERE_IS_THE_GAME *)


OVERLAY PROCEDURE GET_GAME(VAR OK :BOOLEAN);
VAR

  BUFFER    :ARRAY[1..128,1..308] OF BYTE ABSOLUTE GUARD;
  RECSREAD  :INTEGER;

BEGIN

  PROMPT(25);
  {$I-}
  RESET(SAVED_FILE);
  OK := (IORESULT = 0);
  IF OK THEN BEGIN

    BLOCKREAD(SAVED_FILE,BUFFER,308,RECSREAD);
    OK := (RECSREAD = 308 ) AND (IORESULT = 0);

  END;
  {$I+}
  IF NOT OK THEN  ERROR(3);
  CLOSE(SAVED_FILE);

END; (* GET_GAME *)


OVERLAY PROCEDURE INIT_BOARD;
VAR

  INFILE :FILE OF NODE;
  I,J    :BYTE;
  OK     :BOOLEAN;

BEGIN

{$I-}
  ASSIGN(INFILE,'CHESTER.DAT');
  OK:= (IORESULT = 0);
  RESET(INFILE);
  OK := (IORESULT = 0);
{$I+}
  IF NOT OK THEN ERROR(1)
  ELSE BEGIN
    {$I-}
    FOR I := 0 TO 122 DO BEGIN

      READ(INFILE,BOARD[I]);OK := (IORESULT = 0);

    END;
    {$I+}

  END;
  TERMINATE := NOT OK;
  CLOSE(INFILE);

END; (* INIT_BOARD *)


OVERLAY PROCEDURE READ_INSTRUCTIONS;
VAR

  OK        :BOOLEAN;
  HELP_FILE :TEXT;
  CH        :CHAR;
  NUM_LINES :INTEGER;
  LINE      :STRING[80];

BEGIN

  {$I-}
  ASSIGN(HELP_FILE,'CHESTER.HLP');
  OK:= (IORESULT = 0);
  RESET(HELP_FILE);
  CH  := 'Y';
  OK  := (IORESULT = 0);
  {$I+}
  IF NOT OK THEN ERROR(8);
  WHILE OK AND (CH IN ['Y','y']) AND ( NOT EOF(HELP_FILE)) DO BEGIN

    CLRSCR;
    GOTOXY(1,1);
    NUM_LINES := 0;
    WHILE (NOT EOF(HELP_FILE)) AND (NUM_LINES < 22) DO BEGIN

      READLN(HELP_FILE,LINE);
      WRITELN(LINE);
      NUM_LINES := NUM_LINES + 1;

    END;
    MESSAGE(25);
    READER(1,CH);
    IF EOF(HELP_FILE) AND (CH IN ['Y','y']) THEN MESSAGE(24);

  END;
  CLOSE(HELP_FILE);

END; (* Read instructions *)



OVERLAY PROCEDURE GET_SAMPLE_GAME(VAR OK :BOOLEAN;
                                  VAR SG :SAMPLE_GAME);
VAR

  I          :BYTE;
  SAMPLE     :FILE OF SAMPLE_MOVE;

BEGIN

  {$I-}
  ASSIGN(SAMPLE,'CHESTER.SMP');
  OK:= (IORESULT = 0);
  RESET(SAMPLE);
  OK := (IORESULT = 0);
  {$I+}
  IF NOT OK THEN ERROR(9)
  ELSE FOR I:= 1 TO 67 DO READ(SAMPLE,SG[I]);
  CLOSE(SAMPLE);

END; (* OVERLAY GET_SAMPLE_GAME *)


(*------------------------------ Help module --------------------------*)
(****** watch for screen i/o here *******)


PROCEDURE START_OVER; FORWARD;



PROCEDURE INIT; FORWARD;


OVERLAY PROCEDURE DPROMPT(N:BYTE);
BEGIN

  IF N IN [1..7] THEN BEGIN

    CLEAR1_WINDOW;
    MODE_AND_COLOR(1);

  END;
  CASE N OF

   0:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,2);WRITEL('   My turn   ');
       GOTOXY(2,3);WRITEL(' Thinking... ');

     END;
   1:BEGIN

       GOTOXY(14,14);WRITE('Do you want to  ');
       GOTOXY(28,16);WRITE(' N : start a new game ? ');
       GOTOXY(28,17);WRITE(' R : Reassume a saved game ? ');
       GOTOXY(28,18);WRITE(' H : play against another human ? ');
       GOTOXY(28,19);WRITE(' I : see instructions ? ');
       GOTOXY(28,20);WRITE(' Q : Quit/restart ? ');
       GOTOXY(1,1);

     END;

   3:BEGIN

       GOTOXY(14,14);WRITE('Would you like to play ');
       GOTOXY(31,16);WRITE(' S: Singles ?      ');
       GOTOXY(31,17);WRITE(' D: Doubles ?      ');
       GOTOXY(31,18);WRITE(' T: Triples ?      ');
       GOTOXY(31,19);WRITE(' I: Instructions ? ');
       GOTOXY(31,20);WRITE(' Q: Quit/restart ? ');
       GOTOXY(1,1);

     END;
   4:BEGIN

       GOTOXY(14,14);WRITE('Select skill level  ');
       GOTOXY(31,15);WRITE(' 1: novice          ');
       GOTOXY(31,16);WRITE(' 2: average         ');
       GOTOXY(31,17);WRITE(' 3: advanced        ');
       GOTOXY(31,18);WRITE(' 4: junior champion ');
       GOTOXY(31,19);WRITE(' 5: grand champion  ');
       GOTOXY(31,20);WRITE(' I: instructions    ');
       GOTOXY(31,21);WRITE(' Q: Quit/restart    ');
       GOTOXY(1,1);

     END;
   5:BEGIN

       GOTOXY(14,15);WRITE('Do you want me to make the first move ?');
       GOTOXY(31,17);WRITE('  Y : Yes ');
       GOTOXY(31,18);WRITE('  N : No  ');
       GOTOXY(31,19);WRITE('  Q : Quit/restart ');
       GOTOXY(1,1);

     END;
   6:BEGIN

       GOTOXY(13,23);WRITE('   -- Just press RETURN if you changed your mind --    ');
       GOTOXY(15,15);WRITE('File where game was saved = ');

     END;
   7:BEGIN

       GOTOXY(14,14);WRITE('How many players     ');
       GOTOXY(31,16);WRITE('    2 : two          ');
       GOTOXY(31,17);WRITE('    4 : four         ');
       GOTOXY(31,18);WRITE('    6 : six          ');
       GOTOXY(31,19);WRITE('    I : instructions ');
       GOTOXY(31,20);WRITE('    Q : Quit/restart ');
       GOTOXY(1,1);

    END;
 9,10:
    BEGIN

      CLEAR_CORNER_WINDOW;
      GOTOXY(2,2);
      CASE N OF
        9:IF NUM_PLAYERS = 0 THEN WRITEL('  Your turn  ')
          ELSE BEGIN

            WRITEL('Up:Player #  ');
            GOTOXY(14,2);
            WRITEINT(MODE);

          END;
       10:WRITEL('M:change mind');
      END;
      GOTOXY(2,3);
      CASE N OF
        9:WRITEL('# of marble  ');
       10:WRITEL('# of final   ');
      END;
      GOTOXY(2,4);
      CASE N OF
        9:WRITEL('to be moved  ');
       10:WRITEL('landing hole ');
      END;
      GOTOXY(2,5);BLANKS;

    END;
  11,12,13,14,23:
    BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,3);
       CASE N OF
         11:BEGIN WRITEL('File=        ');GOTOXY(7,3);END;
         12:WRITEL('Sure ? Y/N   ');
         13:WRITEL('# of moves ? ');
         14:WRITEL('Restart y/n ?');
         23:WRITEL('Now moving...');
       END;

     END;

  22:BEGIN

       GOTOXY(13,23);WRITE('      Press indicated letter to select option         ');
       GOTOXY(1,1);

     END;
  25:BEGIN

       CLEAR1_WINDOW;
       GOTOXY(14,16);WRITE('               Reading your game...');
       GOTOXY(13,23);WRITE('                                                      ');
       GOTOXY(1,1);

     END;
  24:BEGIN

       CLEAR_CORNER_WINDOW;
       GOTOXY(2,3);WRITEL('Saving game..');PUTCHR('.');

     END;

  END;
  IF NOT (N IN [5,21,22]) THEN BEEP;

END; (* OVERLAY PROMPT *)


OVERLAY PROCEDURE HELP;
VAR

  CH        :CHAR;
  OK,DONE   :BOOLEAN;
  MOVE_NUM,
  S,F,T,LOC :BYTE;
  SG        :SAMPLE_GAME;

  PROCEDURE RESTORE_SCREEN;
  BEGIN

    MAIN_SCREEN;
    MESSAGE(3);
    MODE_AND_COLOR(1);

  END;

BEGIN

  MESSAGE(21);
  READER(9,CH);
  CASE CH OF

  'G','g':BEGIN (* See sample game *)

        DONE     := FALSE;
        MOVE_NUM := 1;
        PL       := 1;
        S        := 1;
        INIT;
        MODE_AND_COLOR(4);
        DRAWBOARD;
        MESSAGE(26);
        NUM_SETS        := 1;
        PLAY_SETS[1].CT := 1;
        PLAY_SETS[1].OP := 4;
        OPPONENT_SET    := 4;
        CHESTER_SET     := 1;
        MESSAGE(4);
        GET_SAMPLE_GAME(OK,SG);

        IF OK THEN WHILE NOT DONE  DO BEGIN

          F := SG[MOVE_NUM].FN;
          T := SG[MOVE_NUM].TN;
          CASE S OF

            1:BEGIN

                CLEAR_CORNER_WINDOW;
                GOTOXY(2,2);WRITEL('I move       ');

              END;
            4:BEGIN

                GOTOXY(2,4);WRITEL('You could mov');PUTCHR('e');

              END;

          END;
          CASE S OF
            1:GOTOXY(4,3);
            4:GOTOXY(4,5);
          END;
          PUTCHR(BOARD[F].NAME[1]);
          PUTCHR(BOARD[F].NAME[2]);
          PUTCHR(' ');PUTCHR('t');
          PUTCHR('o');PUTCHR(' ');
          PUTCHR(BOARD[T].NAME[1]);
          PUTCHR(BOARD[T].NAME[2]);
          LOC := 1;
          WHILE PLAYERS[S][LOC] <> F DO LOC := LOC + 1;
          PLAYERS[S][LOC] := T;
          MOVEIT(F,T,S);
          IF S = 4 THEN BEGIN

            GOTOXY(26,3);WRITEL('More  y / n ?');
            READER(1,CH);
            IF CH IN ['N','n'] THEN DONE := TRUE
            ELSE IF MOVE_NUM < 9 THEN MESSAGE(26 + MOVE_NUM DIV 2);
            GOTOXY(26,3);BLANKS;

          END;
          IF MOVE_NUM < 67 THEN  MOVE_NUM := MOVE_NUM + 1
          ELSE BEGIN

             DONE := TRUE;
             GOTOXY(2,4);WRITEL('and win this ');
             GOTOXY(2,5);WRITEL('sample game  ');
             DELAY(500);

          END;
          IF S = 1 THEN S := 4 ELSE S := 1;

        END;
        INIT_BOARD;
        RESTORE_SCREEN;
    END;

  'I','i':BEGIN

            READ_INSTRUCTIONS;
            RESTORE_SCREEN;

          END;
  'Q','q':START_OVER;

  END; (* CASE *)

END; (* OVERLAY HELP *)


PROCEDURE PROMPT;
BEGIN

  DPROMPT(N);

END; (* PROMPT *)



