' GUESS.BAS -- This module handles the user's guesses and the guess box
' $INCLUDE: 'J.INC'

DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol

FUNCTION GuessAWord$
	ShowMessage ("Enter a 5-letter word. <TAB> to change box. <ESC> to end")
	HighlightBox (GuessBox)
	Guess$ = ""
	Row = TopRow + 3
	Col = LftCol + 4
	LOCATE Row, Col, 0
	COLOR Dark, Background, Background
	PRINT "-----";
	DO
		COLOR Dark, Background, Background
		LOCATE Row, Col + LEN(Guess$), 1, 0, 7
		DO
			Char$ = UCASE$(INKEY$)
		LOOP UNTIL LEN(Char$)
		IF Char$ = CHR$(9) THEN                   'TAB
			PushMsg
			NormalBox (GuessBox)
			ChangeKnownList
			HighlightBox (GuessBox)
			PopMsg
		ELSEIF Char$ = CHR$(27) THEN              'ESC
			NormalBox (GuessBox)
			HighlightBox (MessageBox)
			PushMsg
			ShowMessage ("Do you really want to stop?")
			DO
				Ch$ = UCASE$(INPUT$(1))
			LOOP UNTIL INSTR("YN", Ch$)
			IF Ch$ = "N" THEN
				NormalBox (MessageBox)
				HighlightBox (GuessBox)
				PopMsg
			ELSE
				GuessAWord$ = ""
				EXIT FUNCTION
			END IF
		ELSEIF Char$ = CHR$(8) AND LEN(Guess$) > 0 THEN   'Backspace
			Guess$ = MID$(Guess$, 1, LEN(Guess$) - 1)
			LOCATE Row, Col + LEN(Guess$), 1, 0, 7
			PRINT "-";
		ELSEIF Char$ = CHR$(13) AND LEN(Guess$) = 5 THEN  'Enter
			IF WordExists(Guess$) THEN
				LOCATE Row, Col, 0
				GuessAWord$ = Guess$
				EXIT FUNCTION
			ELSE
				PushMsg
				ShowMessage (CHR$(7) + "Unknown word.  Add it to the dictionary?")
				IF YesNo = "Y" THEN
					PopMsg
					AddWord (Guess$)
					LOCATE Row, Col, 0
					GuessAWord$ = Guess$
					EXIT FUNCTION
				ELSE
					PopMsg
					LOCATE Row, Col, 0
					COLOR Dark, Background, Background
					PRINT "-----";
					Guess$ = ""
				END IF
			END IF
		ELSEIF Char$ >= "A" AND Char$ <= "Z" AND LEN(Guess$) < 5 THEN
			Guess$ = Guess$ + Char$
			COLOR Normal, Background, Background
			PRINT Char$;
		END IF
	LOOP
END FUNCTION

SUB InitGuess
	CALL BoxCoords(GuessBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol
	NormalBox (GuessBox)
	COLOR Normal, Background, Background
	LOCATE TopRow + 1, LftCol + 2, 0
	PRINT "Your Guess";
	COLOR Dark, Background, Background
	LOCATE TopRow + 3, LftCol + 4, 0
	PRINT "-----";
END SUB

