' INSTRUCT.BAS -- Instructions for Jots
' $INCLUDE: 'J.INC'

DECLARE FUNCTION InstStop% ()

FUNCTION InstStop%
	Locate 25, 15, 1, 0, 7
	Print "Press any key to continue or ESC to stop ==> ";
	DO
		Char$ = INKEY$
	LOOP UNTIL LEN(Char$)
	IF Char$ = CHR$(27) THEN
		InstStop = TRUE
	ELSE
		InstStop = FALSE
	END IF
	Locate 1,1,0
END FUNCTION
		
SUB Instructions
	Color Normal, Background, Background
	CLS
	Print
	Print "                Welcome to The Game of Jots!"
	Print
	Print "     Your aim in this game is to guess a secret word that the computer"
	Print "   has selected.  The word will be 5 letters long."
	Print
	Print "     Each time you make a guess, the computer will tell you how many"
	Print "   letters are in both your word and the secret word.  With a little"
	Print "   logic and a well-stocked vocabulary, you should be able to figure"
	Print "   out the letters in the secret word and then guess the secret word"
	Print "   itself.
	Print   
	Print "      There are a lot of boxes on the screen.  Let's take a look at"
	Print "   how each of them works.  Look at the next screen carefully, and"
	Print "   then we'll describe each box in detail."
	IF InstStop Then Exit Sub
	
	CLS
	InitScore
	InitGuess
	InitGuessList
	InitUsedList
	InitPossList
	InitKnownList
	InitNotes
	InitMessage
	ShowMessage("Press any key to continue")
	Pause

	CLS
	InitGuess
	HighlightBox(GuessBox)
	Color Normal, Background, Background
	Locate 7,1,0
	Print "      You'll spend most of your time in the 'Your Guess' box, entering"
	Print "   the words you want to guess.  Simply type a 5-letter word.  The"
	Print "   computer won't let you type numbers or punctuation."
	print
	Print "      If you want to stop the game or if you give up, press ESC while"
	Print "   you are in the 'Your Guess' box."
	Print
	Print "      If you want to move to another box, press the TAB key while you"
	Print "   are in the 'Your Guess' box."
	IF InstStop then exit sub

	CLS
	Initguess
	InitKnownList
	HighlightBox(KnownBox)
	Color Normal, Background, Background
	Locate 7, 1, 0
	Print "      You will also use the 'Known Letters' box fairly often.  Whenever"
	Print "   you think you know a letter in the secret word, move here and type in"
	Print "   the letter.  The letters here will be shown in a special color in"
	Print "   other boxes on the screen."
	IF InstStop then Exit Sub

	NormalBox(KnownBox)
	InitScore
	HighlightBox(ScoreBox)
	Color Normal, Background, Background
	Locate 12, 1, 0
	Print "      The computer keeps track of your score in the 'Score' box.  You"
	Print "   can't move to this box nor directly change the information in it."
	IF InstStop then Exit Sub

	NormalBox(ScoreBox)
	HighlightBox(KnownBox)
	Color Normal, Background, Background
	Locate 15, 1, 0
	Print "      When you are in the 'Known Letter' box, you can press ENTER or"
	Print "   RETURN to go back to the 'Your Guess' box.  If you press TAB, you"
	Print "   will move to a new box
	IF InstStop then Exit Sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	HighlightBox(PossListBox)
	Color Normal, Background, Background
	Locate 12, 1, 0
	Print "      You will use the 'Possible Letters' box to cross off letters that"
	Print "   you are sure are NOT in the secret word.  Once you move to this box,"
	Print "   simply type the letters that you want to cross off.  If you make a "
	Print "   mistake, type the letter again, and it will turn back to a possible"
	Print "   letter."
	Print
	IF InstStop then Exit Sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	InitUsedList
	HighlightBox(UsedBox)
	Color Normal, Background, Background
	Locate 17, 1, 0
	Print "      The computer keeps this box up to date for you.  It will always"
	Print "   show you what letters you haven't yet tried."
	If InstStop then Exit Sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	InitGuessList
	HighlightBox(GuessListBox)
	Color Normal, Background, Background
	Locate 12, 17, 0
	Print "   The large box on the side is used to record your guesses."
	Locate 13, 17, 0
	Print "It will show you what words you have guessed, how many letters"
	Locate 14, 17, 0
	Print "in each word are also in the secret word, which letters have"
	Locate 15, 17, 0
	Print "been crossed off in each word, and which letters you know for"
	Locate 16, 17, 0
	Print "sure are included in each word."  
	Locate 18, 17, 0
	Print "   The information in this box is your key to figuring out the"
	Locate 19, 17, 0
	Print "secret word.  Study it carefully while you are playing!  The"
	Locate 20, 17, 0
	Print "dark numbers in the box show you how many points you will earn"
	Locate 21, 17, 0
	Print "when you guess the secret word."
	IF Inststop then exit sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	HighlightBox(PossListBox)
	Color Normal, Background, Background
	Locate 12, 1, 0
	Print "      When you are ready to leave the 'Possible Letters' box, press"
	Print "   RETURN or ENTER to go back to the 'Your Guess' box, or TAB to "
	Print "   move on to the next box.
	IF InstStop then exit sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	InitUsedList
	InitNotes
	HighlightBox(NoteBox)
	Color Normal, Background, Background
	Locate 11,1,0
	Print "    If you want"
	Print " want to make"
	Print " notes to your-"
	Print " self, or try"
	Print " spelling a word"
	Print " different ways,"
	Print " move to this"
	Print " box.  It has"
	Print " a very simple"
	Print " word processor"
	Print " for you to use."
	IF InstStop then exit sub

	CLS
	InitGuess
	InitKnownList
	InitScore
	InitPossList
	InitUsedList
	InitNotes
	InitMessage
	HighlightBox(MessageBox)
	Color Normal, Background, Background
	Locate 16,1,0
	Print "    The box at"
	Print " the bottom of"
	Print " the screen will"
	Print " have questions"
	Print " for you or give"
	Print " you information"
	IF InstStop then exit sub

	CLS
	Print
	Print "      The computer has a large list of 5-letter words that it can"
	print "   choose from.  Every time you make a guess, it looks to see if"
	print "   your word is in its list.  If you use a word the computer doesn't"
	print "   know, it will stop the game and ask you if it can add the word"
	print "   to its list.  If you say yes, it will accept your guess.  If you"
	print "   say no, it will assume you made a typing error and erase your"
	print "   guess for you.  Remember, the words you add to the list may show"
	print "   up as secret words some day, so don't add words like VWXYZ."
	print
	Print "      One warning.  The computer does not know very many plurals (words"
	Print "   that end with an 's').  If you want you use plurals as guesses,"
	Print "   the computer will probably ask you if each one is a genuine word."
	Print
	Print "      You can select 'Maintain Word List' from the main menu to"
	print "   see a list of the words the computer knows, add words to the"
	print "   list, or delete words from the list, if you want."
	Print
	Print "      Now it is time to start the game. Press any key."
	while inkey$ = "" : wend
end sub

