' NOTE.BAS -- This module maintains the note pad
' $INCLUDE: 'J.INC'

DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol
DIM SHARED NoteRow, NoteCol

SUB InitNotes
	CALL BoxCoords(NoteBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol
	NoteRow = TopRow + 2
	NoteCol = LftCol + 1

	NormalBox (NoteBox)
	COLOR Normal, Background, Background
	LOCATE TopRow + 1, LftCol + 1, 0
	PRINT "Notes:";
END SUB

SUB MakeNotes
ShowMessage ("Move with arrows, erase with backspace, <TAB> or <ESC> to leave")
HighlightBox(NoteBox)
DO
	COLOR Dark, 1, 1
	LOCATE NoteRow, NoteCol, 1, 0, 7
	DO
		char$ = INKEY$
	LOOP UNTIL LEN(char$)
	COLOR Normal, 1, 1
	IF char$ = CHR$(9) OR char$ = CHR$(27) THEN
		NormalBox(NoteBox)
		EXIT SUB
	END IF
	IF LEN(char$) = 1 THEN
		IF char$ >= " " AND NoteCol < RtCol THEN
			PRINT char$;
			NoteCol = NoteCol + 1
		ELSEIF char$ = CHR$(13) THEN
			NoteCol = LftCol + 1
			IF NoteRow < BotRow - 1 THEN
				NoteRow = NoteRow + 1
			END IF
		ELSEIF char$ = CHR$(8) AND NoteCol > LftCol + 1 THEN
			NoteCol = NoteCol - 1
			LOCATE NoteRow, NoteCol, 0
			PRINT " ";
		END IF
	ELSE
		SELECT CASE MID$(char$, 2, 1)
			CASE CHR$(&H4B)                     'left arrow
				IF NoteCol > LftCol + 1 THEN
					NoteCol = NoteCol - 1
				END IF
			CASE CHR$(&H4D)                     'right arrow
				IF NoteCol < RtCol - 1 THEN
					NoteCol = NoteCol + 1
				END IF
			CASE CHR$(&H48)                     'up arrow
				IF NoteRow > TopRow + 1 THEN
					NoteRow = NoteRow - 1
				END IF
			CASE CHR$(&H50)                     'Down arrow
				IF NoteRow < BotRow - 1 THEN
					NoteRow = NoteRow + 1
				END IF
			CASE ELSE
		END SELECT
	END IF
LOOP
END SUB
	
