program Morpion ;

{*****************************************************************************}
{                                                                             }
{           Programme crit en TURBO-PASCAL Version 4.0                       }
{           par    Jean-Paul MICHEL                                           }
{                  8 , Chemin Louis Chirpaz     69130 - ECULLY                }
{           d'aprs une mthode expose par Frdric NEUVILLE                 }
{           dans  SCIENCE & VIE MICRO  de Mars 1987 .                         }
{                                                                             }
{           Ce programme est libre  l'utilisation et la copie .              }
{                                                                             }
{*****************************************************************************}

Uses  Crt ;

  const valeur : array[-4..5] of integer =  (1000,30,10,3,1,3,10,40,5000,5) ;
               { valeur donne aux diffrents tats possibles d'un alignement }
        faible     =   7 ;     { attributs vido }
        fort       =  15 ;
        inverse    = 112 ;
        sousligne  =   9 ;
        clignotant = 143 ;
        marque_joueur     = 'X' ;
        marque_ordinateur = 'O' ;
        vide = ' ' ;


  type  cases = Record
                      marque : char ;        { 'X' , 'O' ou ' ' }
                      effectif : byte ;
                                   { nombre d'alignements passant par la case }
                                   { ce nombre est infrieur ou gal  20     }
                      numero : array[1..20] of integer ;
                                   { numro de ces alignements }
                end ;

  var   position : array[1..25,1..40] of cases ;
        alignement : array[1..3252] of integer ;
                   { tat dans lequel se trouvent chacun des 3252 alignements }
        Joueur_gagne , Ordinateur_gagne : boolean ;
        alignement_gagnant : integer ;
        ligne,colonne : integer ;
        lettre,code : char ;



  Procedure Numerotage_des_alignements ; { dtermination , pour chaque case , }
                                         { des alignements passant par elle   }
     var  i,j,k,num : integer ;
     begin
          for i := 1 to 25 do
              for j := 1 to 40 do position[i,j].effectif := 0 ;
          num := 1 ;
          for i := 1 to 25 do
              for j := 1 to 36 do
                  begin
                       for k := 0 to 4 do
                           with position[i,j+k] do
                                begin
                                     inc(effectif) ;
                                     numero[effectif] := num ;
                                end ;
                       inc(num) ;
                  end ;
          for j := 1 to 40 do
              for i := 1 to 21 do
                  begin
                       for k := 0 to 4 do
                           with position[i+k,j] do
                                begin
                                     inc(effectif) ;
                                     numero[effectif] := num ;
                                end ;
                       inc(num) ;
                  end ;
          for i := 1 to 21 do
              for j := 1 to 36 do
                  begin
                       for k := 0 to 4 do
                           with position[i+k,j+k] do
                                begin
                                     inc(effectif) ;
                                     numero[effectif] := num ;
                                end ;
                       inc(num) ;
                  end ;
          for i := 1 to 21 do
              for j := 5 to 40 do
                  begin
                       for k := 0 to 4 do
                           with position[i+k,j-k] do
                                begin
                                     inc(effectif) ;
                                     numero[effectif] := num ;
                                end ;
                       inc(num) ;
                  end ;
     end ;


  Procedure Sortie ;
     begin
          gotoXY(80,25) ;
          TextAttr := faible ;
          writeln ;
          halt ;
     end ;


  Procedure Clavier ;
     begin
          lettre := Upcase(ReadKey) ;
          code := #0 ;
          if lettre = #0  then code := ReadKey ;
          if (lettre = 'Q') or (lettre = #27) then Sortie ;
     end ;


  Function Confirmation : boolean ;
     begin
          repeat
                Clavier ;
          until lettre in ['O','N'] ;
          Confirmation := (lettre = 'O') ;
     end ;


  Procedure Entree ;
     begin
          DirectVideo := true ;
          CheckBreak := false ;
          TextAttr := faible ;
          ClrScr ;
          gotoXY(1,2) ;
          writeln('                            ') ;
          writeln('                                        ') ;
          writeln('                                  ') ;
          writeln('                                             ') ;
          writeln('                                      ') ;
          writeln ;
          write('ͻ') ;
          write('    Programme  crit par  Jean-Paul MICHEL  , d''aprs une mthode expose     ') ;
          write('       par Frdric NEUVILLE  dans  SCIENCE & VIE MICRO  de Mars 1987         ') ;
          write('ͼ') ;
          writeln ;
          write(' Le but du jeu consiste  faire ');
          TextAttr := sousligne ;
          write('le premier') ;
          TextAttr := faible ;
          writeln(' un alignement de 5 cases , dans ') ;
          writeln('    n''importe quelle direction ( horizontale , verticale ou incline ) .') ;
          writeln ;
          writeln('                     Vous jouez contre l''ordinateur . ') ;
          writeln ;
          write(' Les cases de l''ordinateur sont marques par "',marque_ordinateur,'" ,') ;
          writeln(' les vtres par "',marque_joueur,'" .') ;
          writeln ;
          writeln(' Vous vous dplacerez dans le tableau grce aux touches du curseur , et vous ') ;
          writeln('   validerez la case que vous aurez choisie avec la touche ENTREE  ( < ) .') ;
          writeln ;
          writeln(' Vous pouvez quitter le jeu pendant la partie en appuyant sur "Q" ou sur ESC .');
          Numerotage_des_alignements ;
          gotoXY(23,25) ;
          TextAttr := inverse ;
          write('   Appuyez sur une touche   ') ;
          Clavier ;
     end ;


  Procedure Debut_du_jeu;
     var  i,j : integer ;
          joueur_commence : boolean ;
     begin
          for i:=1 to 3252 do alignement[i] := 0 ;
                    { au dbut d'une partie , les alignements sont tous vides }
          for i:=1 to 25 do
              for j:=1 to 40 do position[i,j].marque := vide ;
          Joueur_gagne := false ;
          Ordinateur_gagne := false ;
          TextAttr := fort ;
          ClrScr ;
          for i:=1 to 999 do write(' ') ;
          write('') ;
          gotoXY(23,23) ;
          write('Ŀ') ;
          gotoXY(23,24) ;
          write(' Voulez-vous commencer ? (O/N)  ') ;
          gotoXY(23,25) ;
          write('') ;
          gotoXY(54,24) ;
          joueur_commence := Confirmation ;
          gotoXY(23,23) ;
          write('                 ') ;
          gotoXY(23,24) ;
          write('                 ') ;
          gotoXY(23,25) ;
          write('                 ') ;
          ligne := 13 ;
          colonne := 20 ;
          if not(joueur_commence) then
             begin
                  gotoXY((colonne shl 1) -1,ligne) ;
                  write(marque_ordinateur,#8) ;
                  with position[ligne,colonne] do  { mise  jour des tableaux }
                       begin
                            marque := marque_ordinateur ;
                            for i := 1 to effectif do
                                alignement[numero[i]] := 1 ;
                       end ;
             end ;
     end ;


  Procedure Joueur ;
     var  i,n : integer ;
     begin
          repeat                             { choix de la case par le joueur }
                gotoXY((colonne shl 1) -1,ligne) ;
                Clavier ;
                Case code of
                  #72 : if ligne >  1 then ligne := ligne - 1 ;
                  #80 : if ligne < 25 then ligne := ligne + 1 ;
                  #75 : if colonne >  1 then colonne := colonne - 1 ;
                  #77 : if colonne < 40 then colonne := colonne + 1 ;
                  #71 : colonne := 1 ;
                  #79 : colonne := 40 ;
                  #73,#119 : ligne := 1 ;
                  #81,#117 : ligne := 25 ;
                end ;
          until (lettre = #13) and (position[ligne,colonne].marque = vide ) ;
          write(marque_joueur,#8) ;
          with position[ligne,colonne] do          { mise  jour des tableaux }
               begin
                    marque := marque_joueur ;
                    for i := 1 to effectif do
                        begin
                             n := numero[i] ;
                             Case alignement[n] of
                               0,-1,-2,-3 : dec(alignement[n]) ; { un de plus }
                               1,2,3,4    : alignement[n] := 5 ; { neutralis }
                              -4 : begin
                                        Joueur_gagne := true ;
                                        alignement_gagnant := n ;
                                   end ;
                             end ;
                        end ;
               end ;
     end ;


  Procedure Ordinateur ;
     var  i,j,k,n,
          gain,gain_max : integer ;
     begin
          gain_max := 0 ;                    { recherche de la meilleure case }
          for i := 1 to 25 do
            for j := 1 to 40 do
               if position[i,j].marque = vide then
                  with position[i,j] do
                       begin
                            gain := 0 ;
                            for k := 1 to effectif do
                                gain := gain + valeur[alignement[numero[k]]] ;
                            if gain > gain_max then
                               begin
                                    gain_max := gain ;
                                    ligne := i ;
                                    colonne := j ;
                               end ;
                       end ;
          gotoXY((colonne shl 1) -1,ligne) ;
          write(marque_ordinateur,#8) ;
          with position[ligne,colonne] do          { mise  jour des tableaux }
               begin
                    marque := marque_ordinateur ;
                    for i := 1 to effectif do
                        begin
                             n := numero[i] ;
                             Case alignement[n] of
                              -1,-2,-3,-4 : alignement[n] := 5 ; { neutralis }
                               0,1,2,3    : inc(alignement[n]) ; { un de plus }
                               4 : begin
                                        Ordinateur_gagne := true ;
                                        alignement_gagnant := n ;
                                   end ;
                             end ;
                        end ;
               end ;
     end ;


  Procedure Montre_combinaison_gagnante ;
     var  k,n,sens : integer ;
          marque : char ;
     begin
          n := alignement_gagnant ;
          Case n of
                1..900 : begin
                              sens := 1 ;
                              colonne := ((n-1) mod 36 ) + 1 ;
                              ligne   := ((n-1) div 36 ) + 1 ;
                         end ;
             901..1740 : begin
                              sens := 2 ;
                              colonne := ((n-901) div 21 ) + 1 ;
                              ligne   := ((n-901) mod 21 ) + 1 ;
                         end ;
            1741..2496 : begin
                              sens := 3 ;
                              colonne := ((n-1741) mod 36 ) + 1 ;
                              ligne   := ((n-1741) div 36 ) + 1 ;
                         end ;
            2497..3252 :begin
                              sens := 4 ;
                              colonne := ((n-2497) mod 36 ) + 5 ;
                              ligne   := ((n-2497) div 36 ) + 1 ;
                         end ;
          end ;
          TextAttr := clignotant ;
          if Joueur_gagne then marque := marque_joueur
                          else marque := marque_ordinateur ;
          for k := 0 to 4 do
              begin
                   gotoXY((colonne shl 1) -1,ligne) ;
                   write(marque) ;
                   Case sens of
                     1 : colonne := colonne + 1 ;
                     2 : ligne := ligne + 1 ;
                     3 : begin
                              colonne := colonne + 1 ;
                              ligne := ligne + 1 ;
                         end ;
                     4 : begin
                              colonne := colonne - 1 ;
                              ligne := ligne + 1 ;
                         end ;
                   end ;
              end ;
     end ;


  Function Fin : boolean ;
     begin
          if ligne < 22 then ligne := 22
                        else ligne :=  2 ;
          TextAttr := fort ;
          gotoXY(24,ligne) ;
          write('Ŀ') ;
          gotoXY(24,ligne +1) ;
          if ordinateur_gagne
             then write('       J ''ai gagn !       ')
             else write('     Vous avez gagn !     ') ;
          gotoXY(24,ligne +2) ;
          write(' Une autre partie ? (O/N)  ') ;
          gotoXY(24,ligne +3) ;
          write('') ;
          gotoXY(50,ligne +2) ;
          Fin := not(Confirmation) ;
     end ;


  begin          { corps principal du programme }
       Entree ;
       repeat
             Debut_du_jeu ;
             repeat
                   Joueur ;
                   if not(Joueur_gagne) then Ordinateur ;
             until Joueur_gagne or Ordinateur_gagne ;
             Montre_combinaison_gagnante ;
       until Fin ;
       Sortie ;
  end .

