{
                                               
               N E D R A G . P A S             
                                               

                                               
 Copyright 1988 by Markt & Technik Verlag      
                                               
 Sprache : Turbo Pascal Version 3              
                                               
 Autor   : Toan Phan-Huy                       
                                               

                                               
 NEDRAG ist ein >>AMIDAR<<-hnliches Geschick- 
 lichkeitsspiel. Es untersttzt mehrere Level  
 und ist auf CGA und EGA lauffhig.            
                                               

                                               
         Anmerkungen zum Listing:              
                       
  Leerzeichen in Strings sind als          
   dargestellt.                                
  Zur besseren Unterscheidung haben wir       
   das kleine l unterstrichen.               
  Die Zeilennummern und das |-Zeichen       
   drfen Sie nicht mit eingeben.              
  Zum Compilieren mssen Sie die Dateien      
   GRAPH.P und GRAPH.BIN bereitstellen.        
                                               
}

{$C-}
Program Nedrag;
 {$I Graph.P}

 Type Ar7By =Array[0..7] of Byte;
      Ar38By=Array[1..38] of Byte;
      A4    =Array[1..4] of Integer;
      A5    =Array[1..5] of Integer;
      A6    =Array[1..6] of Integer;
      A2532 =Array[0..25,0..32] of Byte;
      A46   =Array[1..4,1..6] of Byte;
      A56   =Array[1..5] of A6;
      Ori   =(Stop,Left,Right,Up,Down);
      Two   =Array[1..10] of
              Record
               Score:Real;
               Name:String[3];
              End;

 Const Pat :Array[1..5] of Ar7By=
            ((248,248,253,255,251,137,112,  0),
             (231, 60,189, 90, 60, 24, 90,102),
             (126, 70, 82, 82, 70, 60,216,252),
             ( 30, 63, 31,  2,249,255,249,  0),
             (  0, 24, 36, 66, 66, 36, 24,  0));

       Numb:Array['0'..'9'] of Ar7By=
            (( 60,126,102,102,102,126, 60,0),
             ( 24, 24, 24, 24, 28, 28, 24,0),
             (124,126,  2,126, 64,126, 62,0),
             ( 60,126, 64,126, 64,126, 60,0),
             ( 48, 48,124,126, 54,  6,  6,0),
             ( 62,126, 64,126,  2,126,124,0),
             ( 60,126,102, 62,  6, 38, 28,0),
             ( 14, 28, 56,112, 96,126, 62,0),
             ( 60,126,102, 60,102,126, 60,0),
             ( 60,126, 96,124,102,126, 60,0));

       Laby:Array[1..12,2..4] of Integer=
             (( 6,14,21),(8,13,20),(7,11,19),
              (10,13,16),(5,17,22),(4,12,18),
              ( 5,13,20),(9,16,18),(7,11,17),
              ( 8,15,21),(6, 9,19),(3,10,13));

       DirX:A4 = (-1,1,0,0);
       DirY:A4 = (0,0,-1,1);
       Psx :A5 = (16,1,31,1,31);
       Psy :A5 = (12,1,1,24,24);
       Dif :Array[1..2] of String[8]=
            (' Novice ',' Expert ');

       All =288;
       Ms  =50;

 (*--------------------------------------------
    Graphikvariablen
   --------------------------------------------*)

 Var Fill:Array[1..134] of Byte;
     Player,Rabbit,WaCan,Anti,
     Space,Bye,Fence,Part:Ar38By;
     Num:Array['0'..'9'] of Ar38By;

 (*--------------------------------------------
    High-Score Variablen
   --------------------------------------------*)

 Var HiSco:Two;
     HiScoFil:File of Two;
     FileError:Boolean;

 (*--------------------------------------------
    Sonstige Variablen
   --------------------------------------------*)

 Var X,Y:A5;
     Dirc,Last:Array[1..5] of Ori;
     P:Array[1..2] of A2532;
     Min:Array[1..2] of A46;
     SqX:Array[1..2] of A6;
     SqY:Array[1..2] of A56;
     Un,Ob,Neb:Array[1..24] of Integer;
     Points:Array[1..2] of Real;
     Piez,Bonus,Power:Array[1..2] of Integer;
     Life,Level,Time:Array[1..2] of Byte;
     Thru:Array[1..2] of Boolean;
     Evry,Pl,Sk,Inc,
     Ac,D,Fl,G:Integer;
     Chase,SoundOn:Boolean;
     Pstr:String[6];
     Ch:Char;

 (*--------------------------------------------
    Definition der Shapes
   --------------------------------------------*)

 Procedure Shaping (Var Shape:Ar38By;
                        Pat:Ar7By;
                        C:Integer);
  Begin
   GraphMode;
   Pattern (Pat);
   FillPattern (1,1,8,8,C);
   GetPic (Shape,1,1,8,8);
  End;

  Procedure StoreShapes;
   Var L:Integer;
       S:'0'..'9';
   Begin
    GraphMode;
    GetPic (Space,1,1,8,8);
    For L:=1 to 8 Do Draw (1,L,32,L,3);
    GetPic (Fill,1,1,32,8);
    GetPic (Part,1,1,32,2);
    Shaping (WaCan,Pat[1],1);
    Shaping (Rabbit,Pat[2],2);
    Shaping (Anti,Pat[3],1);
    Shaping (Bye,Pat[4],1);
    Shaping (Fence,Pat[5],3);
    For S:='0' to '9' Do
     Shaping (Num[S],Numb[S],1);
    GraphMode;
   End;

 (*--------------------------------------------
    Zeichnen eines Rechteckes
   --------------------------------------------*)

 Procedure Box (Dx1,Dy1,
                Dx2,Dy2:Integer);
  Begin
   Draw (Dx1,Dy1,Dx2,Dy1,1);
   Draw (Dx2,Dy1,Dx2,Dy2,1);
   Draw (Dx2,Dy2,Dx1,Dy2,1);
   Draw (Dx1,Dy2,Dx1,Dy1,1);
  End;

 (*--------------------------------------------
    High-Score-Datei wird geladen
   --------------------------------------------*)

 Procedure OpenFile;
  Var L:Integer;
  Begin
   Assign (HiScoFil,'HiScore.Fil');
   {$I-}
   Reset (HiScoFil);
   {$I+}
   FileError:=(IOResult<>0);
   If FileError then
    For L:=1 to 10 Do
     With HiSco[L] Do Begin
      Score:=0;
      Name:='Bou';
     End
   else Begin
    Read (HiScoFil,HiSco);
    Close (HiscoFil);
   End;
  End;

 (*--------------------------------------------
    Speichern der aktuallen High-Score-Liste
   --------------------------------------------*)

 Procedure StoreScore;
  Var L1,L2,L3:Integer;
      Ready:Boolean;
  Begin
   For L1:=1 to Pl Do Begin
    L2:=0;Ready:=False;
    Repeat
     L2:=L2+1;
     If Points[L1] > HiSco[L2].Score then Begin
      For L3:=9 downto L2 Do
       HiSco[L3+1]:=HiSco[L3];
      ClearScreen;
      GotoXY (16, 7); Write ('Yippie !');
      GotoXY (13, 8); Write ('Ihr Name bitte');
      GotoXY (15, 9); Write ('Spieler ',L1);
      GotoXY (18,12); Write ('---');
      GotoXY (18,11);
      Buflen:=3;
      With HiSco[L2] Do Begin
       Read (Name);
       Score:=Points[L1];
      End;
      Ready:=True;
      If Not FileError then Begin
       Reset (HiScoFil);
       Write (HiScoFil,HiSco);
       Close (HiscoFil);
      End;
     End;
    Until Ready or (L2=10);
   End;
  End;

 (*--------------------------------------------
    Titelbild und Ausgabe des High-Score's
   --------------------------------------------*)

 Procedure DisplayPic;
  Var L1,L2,L3:Integer;
  Begin
   GraphMode;

   L2:=0;
   For L1:=0 to 5 Do Begin
    Draw (0,79+L2,319,79+L2,1);
    L2:=L2+L1*8;
   End;

   L2:=0; L3:=0;
   For L1:=0 to 9 Do Begin
    Draw (159+L2,79,159+L3,199,1);
    Draw (159-L2,79,159-L3,199,1);
    L2:=L2+16; L3:=L3+24;
   End;

   GraphWindow (15,19,127,131);
   ClearScreen;
   GraphWindow (0,0,319,199);
   Box (15,27,119,131);
   Draw (15,27,23,19,1);
   Draw (23,19,127,19,1);
   Draw (127,19,127,123,1);
   Draw (127,123,119,131,1);
   FillShape (23,23,1,1);
   Draw (119,27,127,19,0);

   GraphWindow (207,31,295,119);
   ClearScreen;
   GraphWindow (0,0,319,199);
   Box (215,39,295,119);
   Draw (295,39,287,31,1);
   Draw (287,31,207,31,1);
   Draw (207,31,207,111,1);
   Draw (207,111,215,119,1);
   FillShape (211,35,1,1);
   Draw (215,39,207,31,0);

   GraphWindow (47,151,271,191);
   ClearScreen;
   GraphWindow (0,0,319,199);
   Box (47,159,271,191);
   Draw (47,159,63,151,1);
   Draw (63,151,255,151,1);
   Draw (255,151,271,159,1);
   FillShape (159,155,1,1);

   GotoXY ( 5, 5); Write ('HighScore');
   GotoXY ( 8,22); Write ('S=Spielstufe');
   GotoXY (22,22); Write ('Return=Start');
   GotoXY ( 8,23); Write ('P=SpielerZahl');
   GotoXY (22,23); Write ('Ctrl-Q=Ende ');

   For L1:=1 to 10 Do Begin
    Str (HiSco[L1].Score:6:0,Pstr);
    For L2:=1 to 6 Do
     If Pstr[L2]=' ' then
      PutPic (Num['0'],L2*8+15,L1*8+47)
     else
      PutPic (Num[Pstr[L2]],L2*8+15,L1*8+47);
    GotoXY (12,6+L1); Write (HiSco[L1].Name);
   End;
   GotoXY (29, 7); Write (' Nedrag ');
   GotoXY (29, 8); Write ('   By   ');
   GotoXY (29, 9); Write ('Phan-Huy');
   GotoXY (29,10); Write ('  Toan  ');
 End;

 (*--------------------------------------------
    Lschen des Tastaturpuffers
   --------------------------------------------*)

 Procedure ClearBuf;
  Var Buf:Char;
  Begin
   While KeyPressed Do Read (Kbd,Buf);
  End;

 (*--------------------------------------------
    Wahl der Optionen
   --------------------------------------------*)

 Procedure Newrite (Cx,Cy:Integer);
  Begin
   GotoXY (Cx,Cy+2); Write (Dif[Sk]);
   GotoXY (Cx,Cy+4); Write (Pl,' Player');
  End;

 Procedure Option;
  Var Ch:Char;
  Begin
   ClearBuf;
   Sk:=1;Pl:=1;
   Newrite (29,10);
   Repeat
    Read (Kbd,Ch);
    Case UpCase (Ch) of
         'S':If Sk=2 then Sk:=1 else Sk:=2;
         'P':If Pl=2 then Pl:=1 else Pl:=2;
         #17:Begin TextMode(Bw80); Halt End;
    End;
    Newrite (29,10);
   Until Ch=#13;
  End;

 (*--------------------------------------------
    Bildschirmanzeige je nach Spielmodus
   --------------------------------------------*)

 Procedure Border;
  Var L1,L2:Integer;
  Begin
   GraphMode;
   Newrite (33,1);
   For L1:=1 to Pl Do Begin
    GotoXY (33,L1*8  ); Write ('********');
    GotoXY (34,L1*8+2); Write (L1,'UP');
    GotoXY (34,L1*8+5); Write ('LEV');
    PutPic (WaCan,271,L1*64+54);
    For L2:= 1 to 7 Do
     PutPic (Num['0'],264+L2*8,L1*64+24);
    For L2:= 1 to 2 Do
     PutPic (Num['0'],296+L2*8,L1*64+40);
    PutPic (Num['3'],288,L1*64+54);
   End;
  End;

 (*--------------------------------------------
    Variableninitialisierung vor Spielbeginn
   --------------------------------------------*)

 Procedure Info;
  Begin
   FillChar(Life,SizeOf(Life),3);
   FillChar(Level,SizeOf(Level),0);
   FillChar(Points,SizeOf(Points),0);
   FillChar(Thru,SizeOf(Thru),True);
   FillChar(Time,SizeOf(Time),Ms);
  End;

 (*--------------------------------------------
    Weiter bei Tastendruck
   --------------------------------------------*)

 Procedure Pause;
  Begin
   Repeat Until KeyPressed;
  End;

 (*--------------------------------------------
    Hauptprozedur
   --------------------------------------------*)

 Procedure Game  (Var P:A2532;
                  Var Min:A46;
                  Var SqY:A56;
                  Var SqX:A6;
                  Var Piez,Power,Bonus:Integer;
                  Var Thru:Boolean);

   Var Out,MusOn1,MusOn2:Boolean;

 (*--------------------------------------------
    Verschiedene 'Melodien'
   --------------------------------------------*)

   Procedure Melody1;
    Const Notes:A4=(523,587,659,523);
          C    :Integer=0;
    Begin
     If Thru or Out then C:=0
     else Begin
      C:=C+1;
      If SoundOn then Sound (Notes[C]);
      If C=4 then Begin
       NoSound;
       C:=0;
       MusOn1:=False;
      End;
     End;
    End;

   Procedure Melody2;
    Const C:Integer=0;
    Begin
     If Thru or Out then C:=0
     else Begin
      C:=C+1;
      If SoundOn then
       If Odd(C) then Sound (348)
       else Sound (440);
      If C=6 then Begin
       NoSound;
       C:=0;
       MusOn2:=False;
      End;
     End;
    End;

   Procedure Melody3;
    Const Notes:A4=(392,440,492,520);
    Var L1,L2:Integer;
    Begin
     If SoundOn then Begin
      For L1:=1 to 2 Do
       For L2:=2 downto 1 Do Begin
        Sound (Notes[L2]);
        Delay (200);
       End;
      For L1:=3 downto 1 Do Begin
       Sound (Notes[L1]);
       Delay (200);
      End;
      NoSound;
      For L1:=1 to 3 Do Begin
       Sound (Notes[L1]);
       Delay (200);
      End;
      Sound (Notes[4]);Delay (50);
      NoSound;
     End
     else Delay (1000);
    End;

   Procedure Melody4;
    Var L1,L2:Integer;
    Begin
     If SoundOn then
      For L1:=1 to 20 Do
       For L2:=1 to 100 Do Begin
        Sound (L1*L2);
        Delay (1);
       End
     else Delay(1000);
     NoSound;
    End;

 (*--------------------------------------------
    Zeichnen des Spielfeldes
   --------------------------------------------*)

   Procedure DrawBoard;
    Var L1,L2,L3,L4:Integer;
        F1,F2,T1,T2:Integer;
    Begin
     ClearScreen;
     For L1:=1 to 4 Do
      For L2:=1 to 6 Do Begin
       F1:=SqX[L2]+1;
       F2:=SqY[L1,L2]+1;
       T1:=SqX[L2]+4;
       T2:=SqY[L1+1,L2]-1;
       For L3:=F1 to T1 Do
        For L4:=F2 to T2 Do
         P[L4,L3]:=2;
       Box (F1*8-7,F2*8-7,T1*8,T2*8);
      End;
      Box (0,0,249,193);
    End;

 (*--------------------------------------------
    Wahl eines Spielfeldes
   --------------------------------------------*)

  Procedure NewLaby;
   Var R,L1,L2:Integer;
   Begin
    For L1:=1 to 6 Do Begin
     SqX[L1]:=L1*5-4;
     SqY[1,L1]:=1;
     SqY[5,L1]:=24;
     R:=Random(12)+1;
     For L2:=2 to 4 Do
      SqY[L2,L1]:=Laby[R,L2];
    End;
    For L1:=1 to 4 Do
     For L2:=1 to 6 Do
      Min[L1,L2]:=
       12+2*(SqY[L1+1,L2]-SqY[L1,L2]-1);
   End;

 (*--------------------------------------------
    Initialisierung bei neuer Spielrunde
   --------------------------------------------*)

   Procedure NewInit;
    Var L:Integer;
    Begin
     FillChar (P,SizeOf(P),0);
     For L:=0 to 32 Do Begin
      P[0,L]:=2; P[25,L]:=2 End;
     For L:=0 to 25 Do Begin
      P[L,0]:=2; P[L,32]:=2 End;
     If Level[G]<99 then
      Level[G]:=Level[G]+1;
     If Life[G]<9 then
      If Level[G] Mod 5=0 then
       Life[G]:=Life[G]+1;
     If Time[G]>10 then Time[G]:=Time[G]-1;
     Piez:=0;
     Power:=0;
     Bonus:=0;
     Chase:=False;
     NewLaby;
    End;

 (*--------------------------------------------
    Hier wird ein Kaninchen gefangen
   --------------------------------------------*)

   Procedure Caught;
    Var F,L,R,T:Integer;
        Co:A4;
    Begin
     Bonus:=Bonus+5;
     P[Y[1],X[1]]:=P[Y[1],X[1]]-3;
     PutPic (Anti,X[1]*8-7,Y[1]*8);
     F:=0;
     For L:=2 to 5 Do Begin
      If (Y[L]=Y[1]) and (X[L]=X[1]) then T:=L;
      If ((Y[1]<>Psy[L]) or (X[1]<>Psx[L])) and
         (P[Psy[L],Psx[L]]<2) then
        Begin F:=F+1; Co[F]:=L End;
     End;
     If F>0 then Begin
      R:=Random(F)+1;
      R:=Co[R];
      X[T]:=Psx[R];
      Y[T]:=Psy[R];
     End
     else Begin
      X[T]:=16;
      Y[T]:=12;
     End;
     P[Y[T],X[T]]:=P[Y[T],X[T]]+3;
     PutPic (Rabbit,X[T]*8-7,Y[T]*8);
     MusOn1:=True;
    End;

 (*--------------------------------------------
    Ausgabe der Punktzahl
   --------------------------------------------*)

   Procedure PrintPoints;
    Var L:Integer;
    Begin
     Str (Points[G]:6:0,Pstr);
     For L:= 1 to 6 Do
      If Pstr[L]<>' ' then
       PutPic (Num[Pstr[L]],264+L*8,G*64+24);
    End;

 (*--------------------------------------------
    Ausgabe der Anzahl der Restleben
   --------------------------------------------*)

   Procedure PrintLife;
    Begin
     Str (Life[G]:1,Pstr);
     PutPic (Num[Pstr[1]],288,G*64+54);
    End;

 (*--------------------------------------------
    Ausfllen eines bzw. mehrerer Rechtecke
   --------------------------------------------*)

   Procedure Filling;
    Var L1,L2:Integer;
    Begin
     If SoundOn then
      If Not (MusOn1 or MusOn2) or Out or Thru
       then Sound (500-Ob[1]*10);
     For L1:=1 to Evry Do Begin
      PutPic (Part,Neb[L1],Un[L1]*2);
      Un[L1]:=Un[L1]-1;
      Ob[L1]:=Ob[L1]-1;
     End;
     L1:=0;
     Repeat
      L1:=L1+1;
      While (Ob[L1]=0) and (L1<=Evry) Do Begin
       For L2:=L1 to Evry-1 Do Begin
        Ob[L2]:=Ob[L2+1];
        Un[L2]:=Un[L2+1];
        Neb[L2]:=Neb[L2+1];
       End;
       Evry:=Evry-1;
      End;
     Until L1>=Evry;
     If Evry=0 then NoSound;
    End;

 (*--------------------------------------------
    Abfrage,ob ein Rechteck ganz umrandet ist
   --------------------------------------------*)

   Procedure Test (Ly,Lx:Integer);
    Var L:Integer;
    Begin
     If Min[Ly,Lx]=0 then Begin
      Evry:=Evry+1;
      Ob[Evry]:=(SqY[Ly+1,Lx]-SqY[Ly,Lx]-1)*4;
      Un[Evry]:=(SqY[Ly+1,Lx]-1)*4;
      Neb[Evry]:=(SqX[Lx]+1)*8-7;
      Bonus:=Bonus+1;
      If ((Lx=1) or (Lx=6)) and
         ((Ly=1) or (Ly=4)) then
       Power:=Power+1;
      If Power=4 then Begin
       MusOn2:=True;
       Player:=Anti;
       Chase:=True;
       Ac:=100;
       Power:=0;
       Fl:=0;D:=0;
      End;
     End;
    End;

   Procedure Surround;
    Var Mid,Dr,Dl:Boolean;
        Wx,WyR,WyL,S:Integer;
    Begin
     If P[Y[1],X[1]]=0 then Begin
      P[Y[1],X[1]]:=1;
      Wx:=(X[1]+4) Div 5;
      If (X[1]+4) Mod 5<>0 then
       Mid:=True else Mid:=False;
      WyR:=0; WyL:=0;
      Dr:=False; Dl:=False;

      For S:=1 to 4 Do Begin
       If Wx<7 then
        If (Y[1] > SqY[S,Wx]) and
           (Y[1] < SqY[S+1,Wx]) Then WyR:=S;
       If Not Mid then If Wx>1 then
        If (Y[1] > SqY[S,Wx-1]) and
           (Y[1] < SqY[S+1,Wx-1]) Then WyL:=S;
      End;

      For S:=1 to 5 Do Begin
       If Wx<7 then
        If Y[1]=SqY[S,Wx] then Begin
         WyR:=S; Dr:=True End;
       If Wx>1 then
        If Y[1]=SqY[S,Wx-1] then Begin
         WyL:=S; Dl:=True End;
      End;

      If Mid and (WyR<5) then Begin
       Min[WyR,Wx]:=Min[WyR,Wx]-1;
       Test (WyR,Wx);
      End;

      If Mid and (WyR>1) then Begin
       Min[WyR-1,Wx]:=Min[WyR-1,Wx]-1;
       Test (WyR-1,Wx);
      End;

      If Not Mid then Begin
       If (WyR<5) and (Wx<7) then Begin
        Min[WyR,Wx]:=Min[WyR,Wx]-1;
        Test (WyR,Wx);
       End;

       If (WyL<5) and (Wx>1) then Begin
        Min[WyL,Wx-1]:=Min[WyL,Wx-1]-1;
        Test (WyL,Wx-1);
       End;

       If Dr and (WyR>1) and (Wx<7) then Begin
        Min[WyR-1,Wx]:=Min[WyR-1,Wx]-1;
        Test (WyR-1,Wx);
       End;

       If Dl and (WyL>1) and (Wx>1) then Begin
        Min[WyL-1,Wx-1]:=Min[WyL-1,Wx-1]-1;
        Test (WyL-1,Wx-1);
       End;
      End;

      Piez:=Piez+1;
      Points[G]:=Points[G]+1;
      If Piez=All then Thru:=True;
      PrintPoints;
     End;
    End;

 (*--------------------------------------------
    Positionierung der einzelnen Figuren
   --------------------------------------------*)

   Procedure Putting(N,I:Integer);
    Begin
     If N>1 then P[Y[N],X[N]]:=P[Y[N],X[N]]-3;
     If (N=1) or (P[Y[N],X[N]]=1) then
      PutPic (Fence,X[N]*8-7,Y[N]*8)
     else If P[Y[N],X[N]]=0 then
      PutPic (Space,X[N]*8-7,Y[N]*8);
     X[N]:=X[N]+DirX[I];
     Y[N]:=Y[N]+DirY[I];
     If N>1 then Begin
      PutPic (Rabbit,X[N]*8-7,Y[N]*8);
      P[Y[N],X[N]]:=P[Y[N],X[N]]+3;
     End
     else PutPic (Player,X[N]*8-7,Y[N]*8);
     If P[Y[1],X[1]] in [3,4] then
      Case Chase of
                 False:Out:=True;
                 True :Caught;
      End;
      If N=1 then Surround;
    End;

 (*--------------------------------------------
    Bewegung der einzelnen Figuren
   --------------------------------------------*)

   Procedure Moving (N,I:Integer);
    Var V,W:Integer;
    Begin
     V:=P[Y[N]+DirY[I],X[N]+DirX[I]];
     W:=P[Y[N]+DirY[Ord(Last[N])],
                    X[N]+DirX[Ord(Last[N])]];
     If (N=1) and (V<>2) or
        (N>1) and Not (V in [2,3,4]) then
      Begin
       Putting (N,I);
       Last[N]:=Dirc[N];
      End
     else
      If (N=1) and (W<>2) or
         (N>1) and Not (W in [2,3,4]) then
       If Last[N]<>Stop then
        Putting (N,Ord(Last[N]));
    End;

 (*--------------------------------------------
    Verfolgungsalgorhytmus der Kaninchen
   --------------------------------------------*)

   Procedure InsMove (Var Nx,Ny:Integer;
                      Var Dirc,Last:Ori);
    Var R:Integer;

    Procedure Invers (Var Dl:Ori);
     Begin
      If Dl=Left  then Dl:=Right;
      If Dl=Right then Dl:=Left;
      If Dl=Up    then Dl:=Down;
      If Dl=Down  then Dl:=Up;
     End;

    Procedure MoveX;
     Begin
      If X[1]<Nx then Dirc:=Left;
      If X[1]>Nx then Dirc:=Right;
     End;

    Procedure MoveY;
     Begin
      If Y[1]=Ny then
       If Odd(R) then Dirc:=Up
       else Dirc:=Down;
      If Y[1]<Ny then Dirc:=Up;
      If Y[1]>Ny then Dirc:=Down;
     End;

     Begin
      R:=Random(10)+1;
      Case R of
             1,2,3,4:MoveY;
             5,6    :MoveX;
             7,8    :Begin MoveX;MoveY End;
             9,10   :Begin MoveY;MoveX End;
      End;
      If Chase then Begin
       Fl:=Fl+1;
       If Fl Mod 25=0 then D:=D+1;
       If Odd (D) then Begin
        Invers (Dirc);
        Invers (Last);
       End;
      End;
     End;

 (*--------------------------------------------
    Spielsteuerung
   --------------------------------------------*)

   Procedure Control;
    Var Q:Integer;
    Begin
     Delay (Time[G]);
     Inc:=Inc+1;
     If Chase then Begin
      Ac:=Ac-1;
      If Ac=6 then MusOn2:=True;
      If Ac=0 then Begin
       Player:=WaCan;
       Chase:=False;
      End;
     End;
     If Keypressed then Begin
      Read (Kbd,Ch);
      If (Ch=#27) and Keypressed then Begin
       Read (Kbd,Ch);
       Case Ch of
               #75:Dirc[1]:=Left;
               #77:Dirc[1]:=Right;
               #72:Dirc[1]:=Up;
               #80:Dirc[1]:=Down;
       End;
      End
      else Case UpCase(Ch) of
                   #27:Begin
                        NoSound;
                        Pause;
                       End;
                   'S':Begin
                        NoSound;
                        SoundOn:=Not SoundOn;
                       End;
           End;
     End;

     For Q:=2 to 5 Do
      InsMove (X[Q],Y[Q],Dirc[Q],Last[Q]);

     If Dirc[1]<>Stop then
      Moving(1,Ord(Dirc[1]));
     For Q:=2 to 5 Do
      If ((Odd(Inc)) or (Sk=2) or (Level[G]>80))
       and Not Out then
        Moving(Q,Ord(Dirc[Q]));

     If Evry>0 then Filling;
     If MusOn2 then Melody2
      else If MusOn1 then Melody1;
    End;

 (*--------------------------------------------
    Variableninitialisierung
   --------------------------------------------*)

   Procedure Init;
    Var L1,L2,L3:Integer;
    Begin
     Str (Level[G]:2,Pstr);
     For L1:=1 to 2 Do
      If Pstr[L1]=' ' then
       PutPic (Num['0'],296+L1*8,G*64+40) else
       PutPic (Num[Pstr[L1]],296+L1*8,G*64+40);
     PrintLife;

     GraphWindow (0,0,255,199);
     ClearScreen;
     GotoXY (13,12); Write ('Spieler ',G);
     Delay (1000);
     DrawBoard;

     For L1:=1 to 4 Do
      For L2:=1 to 6 Do
       If Min[L1,L2]=0 then
        For L3:=SqY[L1,L2]+1 to SqY[L1+1,L2]-1 Do
         PutPic (Fill,(SqX[L2]+1)*8-7,L3*8);

     For L1:=1 to 24 Do
      For L2:=1 to 31 Do Begin
       If P[L1,L2]>2 then P[L1,L2]:=P[L1,L2]-3;
       If P[L1,L2]=1 then
        PutPic(Fence,L2*8-7,L1*8);
     End;

     For L1:=1 to 5 Do Begin
      Dirc[L1]:=Stop;
      Last[L1]:=Stop;
      X[L1]:=Psx[L1];Y[L1]:=Psy[L1];
      If L1=1 then
       PutPic(WaCan,X[L1]*8-7,Y[L1]*8)
      else Begin
       P[Psy[L1],Psx[L1]]:=P[Psy[L1],Psx[L1]]+3;
       PutPic(Rabbit,X[L1]*8-7,Y[L1]*8)
      End;
     End;

     FillChar(Ob,SizeOf(Ob),0);
     FillChar(Un,SizeOf(Un),0);
     Player:=WaCan;
     Thru:=False;
     Out:=False;
     MusOn1:=False;
     MusOn2:=False;
     Evry:=0;
     Surround;
     ClearBuf;
     Pause;
     GraphWindow (0,0,320,199);
    End;

 (*--------------------------------------------
    Addieren des Bonus pro Spielrunde
   --------------------------------------------*)

   Procedure PlusBonus;
    Var L:Integer;
    Begin
     For L:=1 to Bonus Do Begin
      Points[G]:=Points[G]+100;
      PrintPoints;
      If SoundOn then Begin
       Sound (L*100);
       Delay (1);
       Nosound;
      End;
     End;
     Bonus:=0;
    End;

 (*--------------------------------------------
    Hauptteil der Hauptprozedur
   --------------------------------------------*)

   Begin
    Repeat
     If Thru then NewInit;
     Init;
     Repeat
      Control;
     Until Out Or Thru;
     If Out then
      PutPic(Bye,X[1]*8-7,Y[1]*8);
     While Evry>0 Do Begin
      Filling;
      Delay (10);
     End;
     If Thru then Begin
      Melody3;
      PlusBonus;
     End;
     If Out then Melody4;
    Until Out;
    Life[G]:=Life[G]-1;
    PrintLife;
   End;

 (*--------------------------------------------
    Hauptprogramm
   --------------------------------------------*)

  Begin
   SoundOn:=True;
   StoreShapes;
   OpenFile;
   Repeat
    Info;
    DisplayPic;
    Option;
    Border;
    Repeat
     For G:=1 to Pl Do
      If Life[G]>0 then
       Game (P[G],Min[G],SqY[G],SqX[G],
             Piez[G],Power[G],Bonus[G],Thru[G]);
    Until (Life[1]=0) and (Life[Pl]=0) ;
    ClearBuf;
    StoreScore;
   Until True=False;
  End.