10 REM    ===START OF FILE===
20 REM ***************************
30 REM *          LEM           *
40 REM ***************************
50 REM
55 REM MODIFIED FOR JOY STICK   1/29/84
56 REM
60 SCREEN 1
70 COLOR 4,0
80 CLS
90 KEY OFF
100 LOCATE 2,7
110 PRINT "* * *  OUT ON A LEM  * * *"
120 LOCATE 5,1
130 PRINT "A challenging game of skill ..."
140 LOCATE 8,1
150 PRINT "Use your joy stick to run your"
160 PRINT "horizontal and vertal thrusters."
170 PRINT "You are to land the lunar excursion"
180 PRINT "module (LEM) as gently and accurately"
190 PRINT "as possible."
200 PRINT
210 PRINT
220 PRINT "WATCH YOUR FUEL SUPPLY!"
230 PRINT
240 PRINT
250 PRINT "If you have fuel left, the onboard"
260 PRINT "computer will -attempt- to return"
270 PRINT "you to earth..."
280 REM
290 LOCATE 25,9
300 PRINT "PRESS ANY KEY TO BEGIN";
310 REM
320 REM  STARTING POINT FOR EACH LANDING ATTEMPT
330 IF LEN(INKEY$) THEN 330
340 ON STRIG(0) GOSUB 390
350 STRIG(0) ON
360 K$ = INKEY$
370 IF K$ = "" THEN 360
380 REM
390 COLOR 0,1
400 CLS
410 REM  A DIFFERENT GAME EACH SECOND OF THE HOUR
420 T$ = MID$(TIME$ ,4,2) + MID$(TIME$ ,7)
430 RANDOMIZE VAL(T$)
440 REM
450 REM   BUILD THE SPACE SHIP IMAGE
460 LINE (3,1) - (5,5),2,BF
470 LINE (2,2) - (6,4),2,BF
480 LINE (1,7) - (2,6),3
490 LINE (6,6) - (7,7),3
500 DIM SHIP(7)
510 GET (0,0) - (8,8),SHIP
520 REM
530 REM   BUILD VERTICAL EXHAUST IMAGE
540 LINE (9,1) - (11,1)
550 DIM EXHAUSTX(1)
560 GET (9,1) - (11,1),EXHAUSTX
570 REM
580 REM   BUILD HORIZONTAL EXHAUST IMAGE
590 LINE (1,9) - (1,12)
600 DIM EXHAUSTY(1)
610 GET (1,9) - (1,12),EXHAUSTY
620 REM
630 REM      SPRINKLE A FEW STARS AROUND
640 CLS
650 FOR I = 1 TO 300
660   PSET(320 * RND ,200 * RND)
670 NEXT I
680 REM
690 REM   DRAW THE EARTH
700 CIRCLE (277,63),25,1
710 PAINT (277,63),1
720 DRAW "c3bm272,42r7d1r4l13d1l4r22d1l24g1r23l3d1l20"
730 DRAW "r3d1r14l4d1l8c2l3u1l1d2r18e3l1g1l2f1l5d2r4"
740 DRAW "l16d1r14d1l15d1r14g1l13d1r13g1l13"
750 DRAW "d1r13f2l1h3l3g1l8d1r6g1l4f1r3f1l3f1r6u2l1d1l1"
760 DRAW "d2l3r5d1r1g1r13l2u1l7e1r3d3r7l15f1r15f1l16"
770 DRAW "g1r21d1l21f1r20g1l18f1r17g1l15"
780 DRAW "f1r13d1l13d1r11d1l11d1r9g1l7g1r6g1l4d1r2l5"
790 DRAW "bm273,54c1u1e1r1f2"
800 DRAW "c3bd2l2bl2bu1l2h1l1bd4l3h1l3h1l2h1l1"
810 DRAW "bg5r1f2r1f1r5u1l3"
820 DRAW "bm273,79r1f1d1l3h1l1h2u2e3r2e1r9l3h1l4"
830 DRAW "bh2e1r4e1r7l3e2r1"
840 REM
850 REM  CHOOSE SITE FOR LANDING PAD
860 XL = 140 + 50 * RND
870 YL = 180 - 10 * RND
880 REM
890 REM   CREATE TOPOGRAPHICAL FEATURES OF MOON
900 M1 = M2
910 M2 = M1 + 37 * RND
920 IF M2 > 319 THEN M2 = 319
930 H1 = H2
940 H2 = 190 - 70 * RND
950 IF H1 = 0 THEN 930
960 IF M2 < XL - 39 THEN 990
970 IF M2 > XL + 39 THEN 990
980 H2 = YL
990 LINE (M1,H1) - (M2,H2),1
1000 IF M2 < 319 THEN 900
1010 PAINT (0,199),3,1
1020 REM
1030 REM   DRAW THE LANDING PAD
1040 LINE (XL - 3,YL) - (XL + 3,YL + 2),1,BF
1050 REM
1060 REM   SLIGHTLY RANDOM STARTING LOCATION FOR SHIP
1070 SHIPX = 50 * RND
1080 SHIPY = 20 * RND
1090 REM
1100 REM    SLIGHTLY RANDOM STARTING VELOCITY FOR SHIP
1110 VELX = 7 + RND * 3
1120 VELY = 1 + RND
1130 REM
1140 REM  STARTING CONDITIONS
1150 PUT (SHIPX,SHIPY),SHIP, XOR
1160 FACTOR = .1
1170 FUEL = 999
1180 THRUSTUP = 3
1190 REM
1200 REM  MAIN FLIGHT LOOP STARTS HERE
1210 REM
1220 REM  SAMPLE JOY STICK
1230 REM
1240 HORZ = STICK(0)
1241 VERT = STICK(1)
1250 IF FLAG.F1 = 0 AND HORZ > 150 THEN GOSUB 2000 : FLAG.F1 = 1
1260 IF FLAG.F1 = 1 AND HORZ > 25 AND HORZ < 150 THEN GOSUB 2000 : FLAG.F1 = 0
1270 IF FLAG.F2 = 0 AND HORZ < 25 THEN GOSUB 2040 : FLAG.F2 = 1
1280 IF FLAG.F2 = 1 AND HORZ > 25 AND HORZ < 150 THEN GOSUB 2040 : FLAG.F2 = 0
1285 IF FLAG.F3 = 1 AND FUEL = 0 THEN GOSUB 2080 : FLAG.F3 = 0 : ELSE IF FLAG.F3 = 0 AND FUEL = 0 THEN 1310
1290 IF FLAG.F3 = 0 AND VERT < 25 THEN GOSUB 2080 : FLAG.F3 = 1
1300 IF FLAG.F3 = 1 AND VERT > 25 AND VERT < 150 THEN GOSUB 2080 : FLAG.F3 = 0
1310 PULSE = PULSE MOD 7 + 1
1320 IF PULSE = 1 THEN SOUND 1200 - FUEL / 5,1
1330 IF THRUSTUP < 0 THEN FUEL = FUEL - 9.7
1340 IF THRUSTSIDE THEN FUEL = FUEL - 5.3
1350 IF FUEL < 0 THEN FUEL = 0 : STRIG(0) OFF
1360 IF FUEL > 99 THEN 1460
1370 SOUND 99,0
1380 IF FUEL > 0 THEN SOUND 400,1
1390 IF FUEL > 0 THEN 1460
1400 REM
1410 REM   NO MORE FUEL LEFT, DISENGAGE ENGINES
1420 SOUND 2000,1
1430 THRUSTSIDE = 0
1440 REM
1450 REM   COMPUTE NEW VELOCITIES AND POSITIONS
1460 VELX = VELX + FACTOR * THRUSTSIDE * 3
1470 OLDX = SHIPX
1480 SHIPX = SHIPX + FACTOR * VELX * 3
1490 VELY = VELY + FACTOR * THRUSTUP
1500 OLDY = SHIPY
1510 SHIPY = SHIPY + FACTOR * VELY
1520 REM
1530 REM  PUT EXHAUST IMAGES IN VIEW IF NECESSARY
1540 IF THRUSTSIDE < 0 THEN PUT (SHIPX + 7,SHIPY + 3),EXHAUSTX, XOR : FLGL = 1
1550 IF THRUSTSIDE > 0 THEN PUT (SHIPX - 2,SHIPY + 3),EXHAUSTX, XOR : FLGR = 1
1560 IF THRUSTUP < 0 THEN PUT (SHIPX + 4,SHIPY + 7),EXHAUSTY, XOR : FLGU = 1
1570 REM
1580 REM   HAVE WE DRIFTED OFF SCREEN ?
1590 IF SHIPY < 0 THEN 1910
1600 IF SHIPX < 2 THEN 1910
1610 IF SHIPX > 308 THEN 1910
1620 REM
1630 REM   ERASE OLD SHIP IMAGE VIA XOR TO PRESERVE BACKGROUND
1640 PUT (OLDX,OLDY),SHIP, XOR
1650 REM
1660 REM    DRAW NEW SHIP IMAGE, XOR ONTO BACKGROUND
1670 PUT (SHIPX,SHIPY),SHIP, XOR
1680 REM
1690 REM   ERASE THE EXHAUST IMAGES IF NECESSARY
1700 IF FLGL THEN PUT (SHIPX + 7,SHIPY + 3),EXHAUSTX, XOR : FLGL = 0
1710 IF FLGR THEN PUT (SHIPX - 2,SHIPY + 3),EXHAUSTX, XOR : FLGR = 0
1720 IF FLGU THEN PUT (SHIPX + 4,SHIPY + 7),EXHAUSTY, XOR : FLGU = 0
1730 REM
1740 REM    SKIP LANDING CHECK FOR AWHILE IF RETURNING TO EARTH
1750 IF LAND < = 0 THEN 1800
1760 LAND = LAND - .07
1770 GOTO 1840
1780 REM
1790 REM   ARE LANDING PADS TOUCHING THE MOON (AND NOT THE EARTH)?
1800 IF POINT(SHIPX,SHIPY + 8) = 1 AND SHIPY > 85 THEN 2120
1810 IF POINT(SHIPX + 8,SHIPY + 8) = 1 AND SHIPY > 85 THEN 2120
1820 REM
1830 REM   UPDATE THE FUEL SUPPLY
1840 LOCATE 25,16
1850 PRINT USING "FUEL ###";FUEL;
1860 REM
1870 REM   KEEP ON FLYING
1880 GOTO 1240
1890 REM
1900 REM   WE JUST DRIFTED OFF SCREEN
1910 COLOR 4,1
1920 LOCATE 12,4
1930 IF LAND = 0 THEN PRINT "MISSION ABORTED, RETURN TO EARTH"
1940 IF LAND < > 0 THEN PRINT "       WELCOME HOME HERO!"
1950 FOR A = 1 TO 1000
1960 NEXT
1970 RUN 330
1980 REM
1990 REM    SUBROUTINE ... LEFT ENGINE CONTROL
2000 THRUSTSIDE = - (THRUSTSIDE < > 1)
2010 RETURN
2020 REM
2030 REM   SUBROUTINE ... RIGHT ENGINE CONTROL
2040 THRUSTSIDE = (THRUSTSIDE < > - 1)
2050 RETURN
2060 REM
2070 REM    SUBROUTINE ... VERTICAL ENGINE CONTROL
2080 THRUSTUP = 7 * (THRUSTUP = 3) - 3 * (THRUSTUP = - 7)
2090 RETURN
2100 REM
2110 REM   WE LANDED... BUT HOW DID WE FARE?
2120 LOCATE 1,1
2130 VEL = ABS(VELX) + ABS(VELY)
2140 IF VEL < 4 THEN 2350
2150 REM
2160 PRESET(SHIPX + 4,SHIPY + 8)
2170 FOR I = 1 TO VEL * .7
2180   DELX = 9 * VEL * RND(- .5)
2190   DELY = 7 * VEL * (- RND)
2200   DRAW "C2 NM+=DELX;,=DELY;"
2210 NEXT I
2220 REM
2230 REM   FAST ENOUGH TO DIG NEW CRATER?
2240 IF VEL < 8 THEN 2300
2250 PRT$ = "NEW CRATER IS #### METERS WIDE..."
2260 PRINT USING PRT$;VEL * VEL / 7
2270 GOTO 2770
2280 REM
2290 REM    LANDING WAS TOO ROUGH, SORRY
2300 PRINT "DAMAGED BEYOND REPAIR ...                        "
2310 PRINT "ENJOY YOUR STAY !!!         ";
2320 GOTO 2770
2330 REM
2340 REM   LANDED OK, JUST HOW WELL DID YOU DO?
2350 IF VEL < 3 THEN 2390
2360 PRINT "FAIRLY SOFT LANDING ... "
2370 GOTO 2570
2380 REM
2390 IF VEL < 2 THEN 2420
2400 PRINT "NICE JOB !!  ";
2410 GOTO 2570
2420 REM
2430 IF VEL < 1 THEN 2460
2440 PRINT "EXCELLENT SOFT LANDING !!!!!";
2450 GOTO 2570
2460 REM
2470 IF SHIPX - XL + 4 < 3 THEN 2510
2480 PRINT "SUPERIOR LANDING JOB !!!!!!!!!";
2490 GOTO 2570
2500 REM
2510 PRINT "THE PRESIDENT CALLS WITH HIS";
2520 LOCATE 2,1
2530 PRINT "CONGRATULATIONS ON A SUPERB LANDING!";
2540 GOTO 2730
2550 REM
2560 REM  OKAY, SO HOW CLOSE TO THE LANDING PAD ARE YOU?
2570 DIS = ABS(SHIPX - XL + 4) + ABS(SHIPY - YL + 8)
2580 LOCATE 2,1
2590 IF DIS < 50 THEN 2630
2600 PRINT "BUT YOU ARE WAY OUT IN THE BOONIES !";
2610 GOTO 2730
2620 REM
2630 IF DIS < 10 THEN 2670
2640 PRINT "BUT YOU MISSED THE LANDING SITE!";
2650 GOTO 2730
2660 REM
2670 IF DIS < 3 THEN 2710
2680 PRINT USING "BUT YOU MISSED THE SPOT BY ## METERS.";DIS
2690 GOTO 2730
2700 REM
2710 PRINT "AND YOU LANDED RIGHT ON TARGET!!";
2720 REM
2730 FOR A = 1 TO 4000
2740 NEXT
2750 GOTO 2810
2760 REM
2770 FOR A = 1 TO 1000
2780 NEXT
2790 REM
2800 REM   SHALL WE RETURN TO EARTH
2810 IF (FUEL < > 0) AND (VEL < 4) THEN 2820 ELSE RUN 330
2820 LOCATE 1,1
2830 PRINT "EARTH CALLING --- RETURN HOME                    ";
2840 LOCATE 2,1
2850 PRINT "                                                 ";
2860 VELX = 0
2870 VELY = - 1
2880 LAND = 1
2890 THRUSTUP = - 7
2900 THRUSTSIDE = 0
2910 FOR Z = 1 TO 2000
2920 NEXT Z
2930 LOCATE 1,1
2940 PRINT "LEM COMPUTER ENGAGED - RETURNING HOME            ";
2950 IF LEN(INKEY$) THEN 2950
2960 GOTO 1240
2970 REM   ===END OF FILE===
