 : SOUND TUTOR E : Copyright (C) 1984 Stan W. Merrill -- All Rights Reserved 2 : -------------------------------------------------------------------- < : -- Declare Global Constants P   AZ Z  NO              :  YES            :  MENU.ENTRIES     Dd YELLOW          :  WHITE         :  BLACK            n CYAN             :  FKEY.ROW       :  FKEY.COL       " x SPEAKER.PORT  a  :  SPEAKER.ON     :  SPEAKER.OFF     TIMER.PORT    B  :  TIMER.ON       :  LOWER.CASE       I ESC$  ()    :  NOTE.COUNT     :   NOTE$( ), FREQ( )   : ------------------------------------------------------------------  : -- Main Control Section        : -- reset function keys   P       : -- set screen width '  ,,   : -- set text mode 5  , BLACK ;  \        : -- Menu title |        : -- Show menu   (YES)       : -- Get choice (FKEY)    WHITE, BLACK    FKEY     j   : -- Highlight Key Top ""   FKEY         : -- Beep L,   FKEY         : -- Clicks }6   FKEY      *   : -- Computer Talk @   FKEY      0   : -- Alarm J   FKEY         : -- Phasor T   FKEY      r   : -- Parakeet (^   FKEY         : -- PC Piano Rh   FKEY      
   : -- Buzzer r   FKEY      ^   : -- Lowest Note |   FKEY  .   :     : -- Beep    FKEY  /   :    : -- Clicks    FKEY  0   :  *z  : -- Computer Talk I   FKEY  1   :  0  : -- Alarm {   FKEY  2   :  h  : -- Phasors    FKEY  3   :  r&  : -- Parakeet    FKEY  4   :  
  : -- PC Piano    FKEY  5   :  
T  : -- Buzzer H   FKEY  6   :  ^  : -- Lowest Note \   CYAN, BLACK    FKEY     j   : -- Return Key Top to Normal   : ------------------------------------------------------------------ : -- Subroutine: MENU TITLE K: -- Requires: (nothing)         Returns: (nothing) &TITLE$      "> > >    BOOTSTRAPS: SOUND EFFECTS    < < <" 0AUTHOR$  "Copyright (C) 1984 by Stan W. Merrill -- All Rights Reserved" :MSG1$  "Press a Function Key to Hear Sound Effect" UDMSG2$  "Press the <ALT> Key Plus a Function Key to View Program" NMSG3$  "Type RUN and Press "()()()" to Restart Program After Viewing" X YELLOW, BLACK b ,((  ((TITLE$))),   :   TITLE$; !l ,((  ((AUTHOR$)))  :   AUTHOR$; Mv , ((  ((MSG1$)))  :   MSG1$; y , ((  ((MSG2$)))  :   MSG2$;  , ((  ((MSG3$)))  :   MSG3$;  : ------------------------------------------------------------------ !: -- Subroutine: DRAW A SET OF FKEYS e: -- Requires:   FKEY.ROW, FKEY.COL        Returns: (nothing) o  LEFT.OF.BOX  FKEY.COL FKEY    TOP.OF.BOX  FKEY.ROW  (FKEY.ROW  )      CYAN, BLACK      : -- Draw box   FKEY  FKEY   3   j  : -- Label the box H   WHITE, BLACK ]    EXPLANATION$ *   TOP.OF.BOX  , (FKEY.COL  (EXPLANATION$)  ) 4   EXPLANATION$; > :TOP.OF.BOX   H: RLEFT.OF.BOX  FKEY.COL   \FKEY   )f TOP.OF.BOX  FKEY.ROW  (FKEY.ROW  )   =p   CYAN, BLACK Zz     : -- Draw box p  FKEY  FKEY      j  : -- Label the Fkey    WHITE, BLACK    EXPLANATION$    TOP.OF.BOX  , LEFT.OF.BOX      EXPLANATION$;   :TOP.OF.BOX    FKEY   ' : k  "Beep", "Computer Talk", "Phasors", "PC Piano", "Lowest Note"   "Clicks", "Alarm", "Parakeet", "Buzzer", "QUIT to SYSTEM"    : ------------------------------------------------------------------ !: -- Subroutine: DRAW A BOX d!: -- Requires:   TOP.OF.BOX, LEFT.OF.BOX     Returns: (nothing) !$ TOP.OF.BOX, LEFT.OF.BOX !. "͸"; !8 TOP.OF.BOX  , LEFT.OF.BOX !B "    "; !L TOP.OF.BOX  , LEFT.OF.BOX !V ""; !` G"j: ------------------------------------------------------------------ m"t: -- Subroutine: LABEL THE FKEY "~: -- Requires:   FKEY               Returns: (nothing) ": -- Determine Key Top Location #ODD.EVEN  ((FKEY  )  ) : -- 1 if even, 0 if odd E#TOP.OF.BOX  FKEY.ROW  ((FKEY    ODD.EVEN)  ) `#LEFT.OF.BOX  FKEY.COL # (ODD.EVEN  )  LEFT.OF.BOX  FKEY.COL   # TOP.OF.BOX  , LEFT.OF.BOX   #: -- Label Key Top # (FKEY  
)   "F"; (FKEY  0); $ (FKEY  
)   "F10"; $ i$: ------------------------------------------------------------------ $ : -- Subroutine: GET USER'S CHOICE (using Function keys) $
: -- Requires: (nothing)         Returns: FKEY % SEG:  , () :-- Clear keyboard buffer O%( SEG:  j,              :-- Clear BASIC's buffer b%2VALID.KEY  NO r%<CHOICE$   %F (((CHOICE$)  )  (VALID.KEY  NO)) %P  CHOICE$   %Z   ((CHOICE$)  ) %d    CHOICE$  (CHOICE$,) 2&n    FKEY  (CHOICE$)  :     : -- See BASIC manual, App. G q&x     (FKEY    FKEY  MENU.ENTRIES)  VALID.KEY  YES &     (FKEY  .  FKEY  (MENU.ENTRIES-))  VALID.KEY  YES &   &   FKEY  
   :  & & 0': ------------------------------------------------------------------ U': -- Subroutine: FUNCTION KEYS ': -- Requires: (nothing)         Returns: (nothing) '               : -- turn off function key menu ' FKEY    
   : -- reset function keys so they ;(   FKEY,""        : --   can be used as regular keys u( :FKEY           ' --   (See BASIC manual, App. G) {( (: ------------------------------------------------------------------ (: -- Subroutine: PHASOR  (stepped loop technique) 8)": -- Requires: (nothing)         Returns: (nothing) z)6 TIME                         : -- Three quick warbles )@   FREQ    ,   d )J     FREQ, L} )T   :FREQ )^ :TIME )h *r: ------------------------------------------------------------------ Y*|: -- Subroutine: PARAKEET  (stepped loop technique) *: -- Requires: (nothing)         Returns: (nothing) * K                         : -- Chirp twice *   J     *     I  (
    2 +       I, ~ +     :I ++   :J o+  DELAYLENGTH  ,  :    : -- Separate chirps with delay z+ :K +DELAYLENGTH    :      : -- Separate chirps from warble + J                         : -- Warble 4 times ,   I    T  2 ',     I, L} 3,  :I >, :J D,& ,0: ------------------------------------------------------------------ ,:: -- Subroutine: ALARM   (stepped loop technique) -D: -- Requires: (nothing)         Returns: (nothing) D-X TIME                     : -- Repeat alarm three times b-b   FREQ    x   x-l     FREQ, 333 -v   :FREQ - :TIME - -: ------------------------------------------------------------------ !.: -- Subroutine: CLICKS  (immediate data technique) [.: -- Requires: (nothing)         Returns: (nothing) . TIME       : -- Click 6 times .   0u,     : -- Make a sound higher than human ear can hear .  DELAYLENGTH    :     : -- Delay / :TIME / Y/: ------------------------------------------------------------------ u/: -- Subroutine: BEEP /: -- Requires: (nothing)         Returns: (nothing) / /  0*: ------------------------------------------------------------------ G04: -- Subroutine: COMPUTER TALK  (generated data technique) 0>: -- Requires: (nothing)         Returns: (nothing) 0R TIME    # 0\  FREQ  ()    < 0f   FREQ,  0p :TIME 0z &1: ------------------------------------------------------------------ b1: -- Subroutine: PC PIANO  (DATA statement technique) 1: -- Requires: (nothing)         Returns: (nothing) 1: -- Define Constants 1DUR    :  ROW    :  COL   2: -- Fill arrays with keyboard and frequency data Y2: --   The NOTE$ array holds the key that, when pressed, will  2: --   make the sound whose frequency is in the FREQ array. 2 
 2 NOTE    NOTE.COUNT 2   NOTE$(NOTE)  :   FREQ(NOTE) 2 :NOTE 3	: -- Tell user how to use PC Piano #3	 53	 CYAN, BLACK |3$	 ,  :  "   Press these keys to play the PCpiano   "; 3.	 YELLOW, BLACK 38	 ,  :  "1  2  3  4     7  8  9  0"; 3B	 ,  :  "q  w  e  r     u  i  o  p"; 4L	 ,  :  "a  s  d  f     j  k  l  ;"; H4V	 ,  :  "z  x  c  v     m  ,  .  /"; Z4`	 CYAN, BLACK 4j	 ,  :  "Press <ESC> to Return to Main Menu"; 4t	 WHITE, BLACK 4~	: -- Wait for a key to be pressed, then play its note 4	K$  " " 5	 (K$  ESC$) -5	  : -- Get a keystroke from the user  f5	   SEG:  , ()  : Clear keyboard buffer 5	   SEG :  j,              : Clear BASIC's buffer 5	  K$    :   K$  ""  	 5	  : -- Change input to lower case 6	   (K$  ESC$)  K$  ((K$)  LOWER.CASE) d6	  : -- Locate note in note$ array using binary search technique 6	  FOUND  NO  :  TOP  NOTE.COUNT  : BOTTOM   6	  NOTE  (NOTE.COUNT) 6	   ((BOTTOM  TOP)  (FOUND  NO)) 7 
    NOTE  (BOTTOM  ((TOP  BOTTOM))) =7

     (K$  NOTE$(NOTE))  TOP  NOTE   n7
     (K$  NOTE$(NOTE))  BOTTOM  NOTE   7
     (K$  NOTE$(NOTE))  FOUND  YES :  FREQ(NOTE), DUR 7(
   72
  : -- Erase old note from screen and print new one 8<
   ROW, COL  :   "              "; 78F
  ROW  (	FREQ(NOTE)) ]8P
   (FOUND  YES)  COL  COL   x8Z
   COL  F  COL   8d
   (FOUND  YES)   ROW, COL,  8n
   (FOUND  YES)   ();FREQ(NOTE);"hz ";(); 8x
 8
   !9
: -- NOTE$ data occur in ASCII collating sequence  l9
: -- Change NOTE.COUNT constant to reflect number of notes in array. 9
 ",", 220!,   ".", 246.94,   "/", 261.63,   0, 2093!,     1, 1046.5 9
 2, 1174.7,     3, 1318.5,    4, 1396.9,    7, 1568!,     8, 1760! F:
 9, 1975.5,     ;, 523.25,    a, 261.63,    c, 164.81,    d, 329.63 :
 e, 659.26,     f, 349.23,    i, 880!,      j, 392!,      k, 440! :
 l, 493.88,     m, 196!,      o, 987.77,    p, 1046.5,    q, 523.25 ;
 r, 698.46,     s, 293.66,    u, 783.99,    v, 174.61,    w, 587.33 >;
 x, 146.83,     z, 130.81 ;
: ------------------------------------------------------------------ ;
: -- Subroutine: BUZZER  (use CPU to generate sound) ;
: -- Requires: (nothing)         Returns: (nothing) $<SPEAKER.STATUS  (SPEAKER.PORT) 8< TIME    < k<"  SPEAKER.STATUS  SPEAKER.STATUS  SPEAKER.ON <,   SPEAKER.PORT, SPEAKER.STATUS <6  SPEAKER.STATUS  SPEAKER.STATUS  SPEAKER.OFF <@   SPEAKER.PORT, SPEAKER.STATUS <J :TIME <T H=^: ------------------------------------------------------------------ =h: -- Subroutine: LOWEST NOTE  (use timer to generate sound) =r: -- Requires: (nothing)         Returns: (nothing) =: -- send divisor to timer > TIMER.PORT,     : -- low order byte B> TIMER.PORT,     : -- high order byte t>: -- turn on the bits that activate speaker >SPEAKER.STATUS  (SPEAKER.PORT) >SPEAKER.STATUS  SPEAKER.STATUS  TIMER.ON > SPEAKER.PORT, SPEAKER.STATUS ?: -- wait for the user to press a key R? ,   :   "Press a key to stop the sound . . ."; e?   ""   ? ,   :   "                                   "; ?: -- turn off the speaker ?SPEAKER.STATUS  SPEAKER.STATUS  SPEAKER.OFF @ SPEAKER.PORT, SPEAKER.STATUS @ e@: ------------------------------------------------------------------ @&: -- Subroutine: LOOP DELAY @0: -- Requires: (nothing)         Returns: (nothing) @D DELAY    DELAYLENGTH @N :DELAY @X   