REM *******************  QWIKFALL.BAS  ************************
REM A modernization of pitfall.bas by B. Bednarz, using all new
REM source code and QuickBasic vers. 4.0.  This file is being
REM released with the .exe file and the pitfall source file,
REM both to play as a game and as a lesson in moving from
REM basica to QuickBasic.                                                   


REM QB4 will automatically DECLARE subroutines with notified of
REM the programmer's intentions (under the edit menu).
DECLARE SUB gapcalc (lev%, pg%, lft%, ga%)    'Calculate pit gap size.
DECLARE SUB description ()                    'Describe game.
DECLARE SUB doagain (kch$)                    'Play another game?           
DECLARE SUB showrules ()                      'Rules of game.
DECLARE SUB startmenu (userspeed%, userdiff%) 'Initial menu.
DECLARE SUB inspeed (userinput%, diffinput%)  'Get game speed for machine.          
DECLARE SUB hiscore (newhs!)                  'Check high scores.
DECLARE SUB getname (nn$)                     'Get name for high scores.              
DECLARE SUB quitter (p%, s!, h%, ekt%)        'Quit game prematurely.
DECLARE SUB newship (sh%)                     'New (extra) ship bonus.
DECLARE SUB fanfare (p%)                      'Congrats for making a pit.
     'pitset sets the attributes of the pit.
DECLARE SUB pitset (p%, pg%, pt%, pp%, sp%, df%)
DECLARE SUB move (r%, c%)                     'Surprise move to new spot.
DECLARE SUB knocked (mh%)                     'Hit by monster.
DECLARE SUB hurt (max%, r%, c%)               'Hit pit wall.
DECLARE SUB cprint (char%, color1%, color2%)  'Print in color.
DECLARE SUB newlevel (le%, ga%)               'Print new level.
DECLARE SUB items (le%, ga%, pi%)             'Put out monsters, etc.
DECLARE SUB uplf (r%, c%)                     'The next few are curser
DECLARE SUB up (r%, c%)                       ' keys for the ship to
DECLARE SUB uprt (r%, c%)                     ' move (including
DECLARE SUB lf (r%, c%)                       ' diagonally).
DECLARE SUB rt (r%, c%)                       '
DECLARE SUB lfdn (r%, c%)                     '
DECLARE SUB dn (r%, c%)                       '
DECLARE SUB dnrt (r%, c%)                     '
DECLARE SUB eaten (zap%)                      'Eaten by monster.
DECLARE SUB bonus (sc!)                       'Bonus to score.
DECLARE SUB update (lev%, scr!, max%, ship%)  'Update score, etc.

DEFINT A-Z
CLS
REM Basic's random number generator is not very random, so we
REM try to help it out by RANDOMIZing at random moments.
RANDOMIZE TIMER
COLOR 7, 0, 0

REM startmenu gives the menu of initial choices, and finds out
REM matters such as how fast the game should run.  This is
REM equivalent to lines 1-3, 82-93 in pitfall.bas.  Additional
REM choices how been added for information about the game,
REM the rules of the games, etc.
startmenu pcspeed, pcdiff


REM This is the start of the game proper.  At the completion of
REM a game, a GOTO can easily start the entire game over.  In this
REM case, a GOTO and label ("beginning:") are more efficient and
REM easier to read than attempting a vary large DO loop.
beginning:                 
CLS                          'The next few lines are general preparation,
PLAY "MBT120N0"              'such as pitfall lines 10-13.
pit = 1                      'Start with pit number one.
REM score! is your score, maxhits is your tolerance for getting zapped.
REM dead is to escape from the game loop (usually from dying), etc.
score! = 0: maxhits = 10: dead = 0: ships = 1

REM Two reward variables are used to increment rewarding success.
ireward! = 3000: reward! = ireward!


REM startpit is to start a new pit.  Success brings increasingly
REM more difficult pits.  In this case, a DO loop would work as well,
REM but would be less readable.
startpit:
level = 1                    'Depth into pit.
REM These are variables for the current & previous location of the
REM ship, and the left margin of the pit.  Then pitset calculations
REM current conditions within the pit, such as width, speed, etc.
row = 10: col = 40: rold = row: cold = col: left = 32
pitset pit, pitgap, pittime, pitprob, pcspeed, pcdiff

REM This is the main loop to collect moves.
k$ = CHR$(0)
DO
REM Update the score, etc. at the bottom of the screen.  This
REM is the same as pitfall lines 15-18.
   update level, score!, maxhits, ships
   LOCATE rold, cold: cprint 249, 14, 7
   LOCATE row, col: cprint 157, 1, 7
   rold = row - 1: cold = col
   score! = score! + (row \ 2)         'Score for going this deep.
REM This is the reward system for certain achievements.  It could
REM be made into a routine.  The variable ireward! is used to
REM increment the reward level.
   IF score! > reward! THEN
      maxhits = maxhits + 5
      reward! = reward! + ireward!
      IF reward! = 24000 THEN
         ships = ships + 1             'Bonus of an extra ship.
         PLAY "MFT120L16CCDDEECCFFDDBBABCDEFG"
      ELSEIF reward! = 42000 THEN
         ships = ships + 1
         PLAY "MFT120L16CCDDEECCFFDDBBABCDEFG"
      ELSE
         PLAY "MBT120L8CEG"
      END IF
      update level, score!, maxhits, ships
   END IF
REM Next we calculate the pit gap width & location.  This is a much
REM better method than used in pitfall.bas lines 30 & on.
   gapcalc level, pitgap, left, gap
   newlevel left, gap                  'Print new level of pit.
REM items puts monsters & others in pit at this level.
   items left, gap, pitprob
   k$ = INKEY$               'Get move instead of ON KEY in pitfall,
                             'lines 6-9, 48-59.
11 IF INKEY$ <> "" THEN 11   'Eliminate extra key presses.
   IF LEN(k$) = 2 THEN       'Cursor movement is extended code.
      choice = ASC(RIGHT$(k$, 1))
      SELECT CASE choice     'Use the cursor pad.
         CASE 71
            uplf row, col
         CASE 72
            up row, col
         CASE 73
            uprt row, col
         CASE 75
            lf row, col
         CASE 77
            rt row, col
         CASE 79
            level = level + 1
            lfdn row, col
         CASE 80
            level = level + 1
            dn row, col
         CASE 81
            level = level + 1
            dnrt row, col
         CASE ELSE
      END SELECT
   ELSEIF LEN(k$) = 1 THEN       'These are regular key commands.
      choice = ASC(k$)
      score! = score! - 100      'Penalty for double moves.
      SELECT CASE choice
         CASE 52                 'Shift-keypad moves double distance.
            lf row, col
            lf row, col
         CASE 54
            rt row, col
            rt row, col
         CASE 55
            uplf row, col
            lf row, col
         CASE 57
            uprt row, col
            rt row, col
         CASE 49
            lfdn row, col
            lf row, col
         CASE 51
            dnrt row, col
            rt row, col
         CASE 80, 112        'Remaining choices for pausing & quitting.
            score! = score! + 100      'No penalty.
pause:      kpause$ = INKEY$
            IF kpause$ <> "P" AND kpause$ <> "p" THEN GOTO pause
         CASE 27                       'Escape is used as a quit key.
            dead = 5
            score! = score! + 100
            EXIT DO
         CASE ELSE
            score! = score! + 100      'Not recognizable move.
      END SELECT
   END IF

   level = level + 1
   xtest = SCREEN(row, col)  'Test for monster, etc. at ship location.
   SELECT CASE xtest         'Like pitfall.bas lines 21-23.
      CASE 177                         'Hit the pit wall.
         hurt maxhits, row, col
      CASE 1                           'Hit weak monster.
         knocked maxhits
      CASE 2                           'Hit strong monster.
         eaten dead
      CASE 15                          'Hit bonus.
         bonus score!
      CASE 248                         'Hit surprise.
         move row, col
      CASE ELSE
   END SELECT
   IF maxhits <= 0 THEN dead = 1       'Hit too much kills ship.
REM Following loop controls game speed.
   FOR kkk! = 1 TO pittime: NEXT kkk!
LOOP WHILE dead = 0 AND level < 500
REM dead <> 0 means either really dead, or quit, or ....  Pits are
REM only 500 levels deep.


REM Check to see how escaped move loop.  Different values of
REM variable "dead" is used to mark ways to escape.
SELECT CASE dead
   CASE 0                    'Finished pit.
      fanfare pit
      maxhits = maxhits + 5 + 5 * pit
      score! = score! + (pit * 500)
      pit = pit + 1
      GOTO startpit
   CASE 1
      PLAY "MBT240L32BAGFEDCBAGFEDCBAGFEDCBAGFEDCBAGFEDCBAGFEDCBAGFEDC"
      LOCATE rold, cold
      PRINT CHR$(254);
   CASE 2
      PLAY "MBO0T120L16CDCDEDEFEFGFGAGABABCBCDCDCO4"
      LOCATE rold, cold
      PRINT " ";
      LOCATE row, col
      PRINT CHR$(2);
   CASE 5                    'Prematurely quit.  Check to play again.
      PLAY "MBT120L32O4ACBDGEFP48O2FEGDBCAP48O3ACBDGEF"
      quitter pit, score!, maxhits, keycheck
      IF keycheck = 0 THEN
         CLS
         END
      END IF
REM   For restarting entire game, it's easier to read and program
REM   using GOTO rather than a DO loop.
      GOTO beginning
   CASE ELSE
END SELECT

update level, score!, maxhits, ships
DO                           'Give player time to regroup.
   endcnt = PLAY(1)
LOOP WHILE endcnt > 1
IF ships > 1 THEN            'Killed with more ships continues to play.
   newship ships
   maxhits = 10 + 5 * pit
   ships = ships - 1
   dead = 0
   GOTO startpit
END IF

REM Now finish up game.  Start by checking high scores.
hiscore score!
doagain keych$                         'Want to play again?
IF keych$ = "Y" THEN GOTO beginning
LOCATE 24, 38
PRINT "Good Day!";
END

REM bonus is a simple routine for awarding going deeper into pit.
SUB bonus (sc!)
   RANDOMIZE TIMER
   sc! = sc! + 200
   PLAY "MBT120L32N55N57N55"
END SUB

REM This is used to print a character in a different "color."
SUB cprint (char, color1, color2)
   COLOR color1, 0, 0
   PRINT CHR$(char);
   COLOR color2, 0, 0
END SUB

REM This is a description of the game, how it came to be written, etc.
REM It is called from the initial menu.
SUB description
   CLS
   PRINT "This game is Qwikfall, an adaption of a much older game, Pitfall.  There are"
   PRINT "various enhancements to the same basic theme as in  Pitfall.   These include"
   PRINT "better cursor control, allowance for machine speed, added monsters & bonuses"
   PRINT "and a permanent top ten record.  More importantly, it is being released with"
   PRINT "the carefully documented source code.   This is a part of a set of files  --"
   PRINT "including the code for Pitfall   --   as an example of making the transition"
   PRINT "from GW-Basic (Basica) to QuickBasic Vs.4.0.  It exemplifies the use of line"
   PRINT "labels (as opposed to line numbers), modularity through routines, and effic-"
   PRINT "ient use of both the do while loops and GOTOs.  A second advantage to having"
   PRINT "the annotated source code is so that you may modify (if you have QuickBasic)"
   PRINT "the program, creating changes to suit your own taste.  A beginner wishing to"
   PRINT "write his own game might start by rewriting this Qwikfall.  Note to prospec-"
   PRINT "tive game designers:    There are certain features included in Qwikfall that"
   PRINT "should be included in all games as common curtesy.   These include the pause"
   PRINT "(press  P during the game), the escape (press Escape), a rulebook, allowance"
   PRINT "for different speeds of machines  -- this is important, because there are so"
   PRINT "many different  computers out in use  --  storing high scores,  an easy quit"
   PRINT "to DOS, and allowing to quit a current game and immediately play another.  I"
   PRINT "could go on,  but the point is to make the game convenient,  so that players"
   PRINT "may concentrate on enjoying the game itself.   A final point:  This game and"
   PRINT "the inculded set of files are copyright 1988 by B.Bednarz. If you modify the"
   PRINT "program, you must choose  another name and identify it as modified.   If you"
   PRINT "redistribute any portion of this you must include all files unchanged. There"
   PRINT "is no charge for Quikfall, but donations or picture postcards may be sent to";
   LOCATE 25, 1
   PRINT "B.Bednarz, c/o 567 High St. SE, Salem, Ore. 97301.  (Press any key to go on)";
descwait:
   kdesc$ = INKEY$: IF kdesc$ = "" THEN GOTO descwait
END SUB

'Move down a level.
SUB dn (r, c)
   IF r < 23 THEN r = r + 1
END SUB

'Move down & right.
SUB dnrt (r, c)
   IF r < 23 THEN r = r + 1
   IF c < 80 THEN c = c + 1
END SUB

REM Check to see if wants to play again or quit for the day.
SUB doagain (kch$)
   LOCATE 20, 28
   PRINT "Do you wish to play again? (Y/N) ";
   DO
      kch$ = INKEY$
      kch$ = UCASE$(kch$)
   LOOP WHILE (kch$ <> "N") AND (kch$ <> "Y")
   PRINT kch$;
END SUB

'Strong alien will eat (zap) ship.
SUB eaten (zap)
   zap = 2
END SUB

'Hooray! for having completed a pit.  Called after main move loop.
SUB fanfare (p)
   PLAY "L8MBT120CDECEDFFAGBBDACDABBDACBBAFGGGCDCBAA"
pitclear:
   kpit$ = INKEY$: IF kpit$ <> "" THEN GOTO pitclear
   CLS
   LOCATE 10, 27
   PRINT "CONGRATULATIONS COMMANDER!!";
   LOCATE 12, 19
   PRINT "You have successfully navigated pit number ";
   PRINT USING "#"; p;
   PRINT ".";
   LOCATE 13, 19
   PRINT "So now prepare to traverse an even worse pit!";
   DO
      notecnt = PLAY(1)
   LOOP WHILE notecnt > 1
   LOCATE 14, 19
   PRINT "Press any key to continue."
pitwait: kpit$ = INKEY$: IF kpit$ = "" THEN GOTO pitwait
   CLS
END SUB

REM This calculates the pit gap width & location.  The formula is
REM to that used in pitfall.bas, but has better control and side-to
REM side (sinusiodal) movement.
SUB gapcalc (lev, pg, lft, ga)
   sinarg! = lev * (lev / 10000!) + lev / 5
REM The sinusoidal term in midgap! causes wiggling from side-to-
REM side of the screen.
   midgap! = 40 + (5 + lev * .003) * SIN(sinarg!)
   thin! = 12 / (1 + LOG(lev))
REM pg corresponds to pit number player is traversing.  The sin part
REM causes a sinusoidal fluctuation in width.  The "thin" part makes
REM pit generally get thinner as you get deeper.
   ga = 6 + pg + INT(SIN(RND * 6.28) * 4) + 2 * INT(thin!)
REM Calculate the distance from the left margin.
   lft = INT(midgap!) - (ga / 2)
   IF lft < 1 THEN lft = 1
   IF lft + ga > 79 THEN lft = 79 - ga
END SUB

'Called at end of game.
SUB getname (nn$)
   CLS
   PRINT "You have qualified for the hall of fame."
   INPUT ; "What is your name"; nn$
END SUB

REM This gets the high score file, or creates one if need be.  It
REM prints the top so many on the screen.
SUB hiscore (newhs!)
REM These two arrays keep track of the players' names & scores.
   DIM hsname$(11), hisco!(11)
   OPEN "qwikfall.sco" FOR INPUT AS #1 'The high score file.
   hsflag = 0                          'Used to see if file is changed.
   FOR kkhs = 1 TO 10                  'Keep track of top ten.
      IF EOF(1) = -1 THEN              'If end of file, must blank name.
         hsname$(kkhs) = "          "
         hisco!(kkhs) = 0
      ELSE
         INPUT #1, hsname$(kkhs), hisco!(kkhs)
      END IF
      IF hisco!(kkhs) < newhs! THEN   'Compare score to determine place.
         getname newname$             'Congratulations, you qualified.
         hisco!(kkhs + 1) = hisco!(kkhs)
         hisco!(kkhs) = newhs!
         hsname$(kkhs + 1) = hsname$(kkhs)
         hsname$(kkhs) = newname$
         kkhs = kkhs + 1
         newhs! = -100                 'Just read in rest of names.
         hsflag = 1
      END IF
   NEXT kkhs
   CLOSE #1
   IF hsflag = 1 THEN                  'We have a new high score.
      OPEN "qwikfall.sco" FOR OUTPUT AS #1
REM High score file is "qwikfall.sco", and has ten records with
REM a structure of two fields: name, score.
      FOR kkhs = 1 TO 10
         WRITE #1, hsname$(kkhs), hisco!(kkhs)
      NEXT kkhs
      CLOSE #1
   END IF

REM Now print out the high score on the screen.
   CLS
   LOCATE 5, 37: PRINT "SCORE";
   LOCATE 5, 45: PRINT "NAME";
   FOR kkhs = 1 TO 10
      LOCATE kkhs + 7, 33: PRINT USING "##"; kkhs;
      PRINT ". "; hisco!(kkhs);
      LOCATE kkhs + 7, 45: PRINT hsname$(kkhs);
   NEXT kkhs

REM Let player have time to look.
   LOCATE 20, 30: PRINT "Press any key to continue..."
hswait:
   khs$ = INKEY$: IF khs$ = "" THEN GOTO hswait
END SUB

'Weak monster can hurt.
SUB hurt (max, r, c)
   max = max - 1
   SOUND 60, 3
   LOCATE r, c: PRINT CHR$(32);
END SUB

REM Called from initial menu to adjust game speed for different
REM machines.
SUB inspeed (userinput, userdiff)
   CLS
   LOCATE 10, 30
   PRINT "You  may adjust  the  speed";
   LOCATE 11, 30
   PRINT "of this  game to  allow for";
   LOCATE 12, 30
   PRINT "the speed of your computer.";
   LOCATE 13, 30
   PRINT "Choose an integer 0  to  9.";
   LOCATE 14, 30
   PRINT "Where  0  is for slow (PC),";
   LOCATE 15, 30
   PRINT "and 9  is for fast (80386).";
   LOCATE 16, 30
   PRINT "Please choose now: ";
speedloop:
   kspeed$ = INKEY$
   SELECT CASE kspeed$
      CASE "0"
         userinput = 0
         userdiff = 0
      CASE "1"
         userinput = 30
         userdiff = 5
      CASE "2"
         userinput = 60
         userdiff = 10
      CASE "3"
         userinput = 100
         userdiff = 15
      CASE "4"
         userinput = 150
         userdiff = 25
      CASE "5"
         userinput = 200
         userdiff = 35
      CASE "6"
         userinput = 300
         userdiff = 50
      CASE "7"
         userinput = 500
         userdiff = 100
      CASE "8"
         userinput = 700
         userdiff = 150
      CASE "9"
         userinput = 1000
         userdiff = 200
      CASE CHR$(27)
         CLS
         PRINT "Have a nice day! "; CHR$(1);
         END
      CASE ELSE
         GOTO speedloop
   END SELECT
   PRINT kspeed$;
END SUB

REM Put in monsters and other interesting creatures.  Must calculate
REM location and probability of item.
SUB items (le, ga, pi)

REM First, randomly calculate how many monsters appear on the line.
   monstnum = 0
   monstprb = INT(RND * 1000!) + 1
   IF monstprb > 925 - pi THEN monstnum = monstnum + 1
   IF monstprb > 990 - (pi \ 4) THEN monstnum = monstnum + 1
   IF monstprb > 998 - (pi \ 10) THEN monstnum = monstnum + 1
REM Next randomly place the monsters.
   sgap! = ga - 1
   FOR kk = 1 TO monstnum
      monstloc = INT(RND * sgap!) + 1
      LOCATE 23, le + monstloc + 1
      killprob = INT(RND * 1000!) + 1  'Probability of appearing.
      IF killprob > 670 THEN
         COLOR 23, 0, 0
         PRINT CHR$(2);
         COLOR 7, 0, 0
      ELSE
         PRINT CHR$(1);
      END IF
   NEXT kk

REM Now follow the same procedure for bonus stars.
   bonusnum = 0
   bonusprb = INT(RND * 1000!) + 1
   IF bonusprb > 850 THEN bonusnum = bonusnum + 1
   IF bonusprb > 950 THEN bonusnum = bonusnum + 1
   IF bonusprb > 990 THEN bonusnum = bonusnum + 1
   FOR kk = 1 TO bonusnum
      bonusloc = INT(RND * sgap!) + 1
      LOCATE 23, le + bonusloc
      PRINT CHR$(15);
   NEXT kk

REM Now follow the same procedure for random movers.
   movenum = 0
   moveprb = INT(RND * 1000!) + 1
   IF moveprb > 980 - (pi \ 2) THEN movenum = movenum + 1
   IF moveprb > 994 - (pi \ 5) THEN movenum = movenum + 1
   IF moveprb > 998 - (pi \ 8) THEN movenum = movenum + 1
   sgap! = ga - 1
   FOR kk = 1 TO movenum
      moveloc = INT(RND * sgap!) + 1
      LOCATE 23, le + moveloc + 1
      PRINT CHR$(248);
   NEXT kk
END SUB

'Be careful!!
SUB knocked (mh)
   mh = mh - 10
   PLAY "MBT120GFE"
END SUB

'Move left.
SUB lf (r, c)
   IF c > 1 THEN c = c - 1
END SUB

'Move left & down.
SUB lfdn (r, c)
   IF c > 1 THEN c = c - 1
   IF r < 23 THEN r = r + 1
END SUB

REM Surprise move to random new location.
SUB move (r, c)
   RANDOMIZE TIMER
   PLAY "MBT240L64AGBFCEDECFBGA"
   rownew = INT(RND * 21!) + 2         'Randomly move to a new row.
   prevtype = 177                      'Wall material.
   FOR kkkk = 1 TO 80                  'Find boundaries of pit.
      sqtype = SCREEN(rownew, kkkk)
      IF sqtype <> 177 AND prevtype = 177 THEN
         starts! = kkkk + 4
      ELSEIF sqtype = 177 AND prevtype <> 177 THEN
         ends! = kkkk - 4
      END IF
      IF ends! < starts! THEN ends! = starts!
      prevtype = sqtype
   NEXT kkkk
   tempnew! = (ends! - starts!) * RND  'Random placement within the pit.
   colnew = INT(tempnew!) + 1
   r = rownew
   c = colnew + starts!
   REM
   PLAY "MBT120N0"
END SUB

'Print new level on bottom of screen.
SUB newlevel (le, ga)
   COLOR 5, 0, 0
   LOCATE 24, 1
   PRINT STRING$(le, 177);             'Wall material.
   PRINT STRING$(ga, 32);              'Blank (pit space).
   ri = 80 - le - ga
   PRINT STRING$(ri, 177)
   COLOR 7, 0, 0
END SUB

REM Get replacement ship when you are zapped.
SUB newship (sh)
   CLS
   LOCATE 12, 21
   PRINT "You have lost your ship!";
onewait: shipk$ = INKEY$: IF shipk$ <> "" THEN GOTO onewait
   LOCATE 13, 21
   PRINT "Fortunately, you were rescued by your backup.";
   LOCATE 14, 21
   PRINT "Prepare to attempt this pit again.";
   LOCATE 15, 21
   PRINT "Press any key to meet your maker...";
twowait:   kship$ = INKEY$: IF kship$ = "" THEN GOTO twowait
   CLS
END SUB

REM This is pit number, pitgap, and other pit factors.
REM These factors were found by experimenting to optimize
REM the game.  pg is related to calculating pitgap size &
REM location, pp is related to probability of objects
REM showing up in the pit, pt is for pit time, related
REM to the speed of the game.
SUB pitset (p, pg, pt, pp, sp, df)
   pg = 15 - (p * 3)
   pp = 17 * (p - 1)
   pt = sp - (p * df)
   IF pt <= 0 THEN pt = 1
   IF pg < 0 THEN pg = 0
END SUB

REM For quitting in the middle of the game.
SUB quitter (p, s!, h, kt)
   CLS
quitkey:
   qkey$ = INKEY$: IF qkey$ <> "" THEN GOTO quitkey
   LOCATE 10, 10
   PRINT "You were in pit number ";
   PRINT USING "#"; p;
   LOCATE 11, 19
   PRINT "with a score of ";
   PRINT USING "####"; s!;
   LOCATE 12, 19
   PRINT "and with ";
   PRINT USING "###"; h;
   PRINT " hits left."
   LOCATE 14, 10
   PRINT "However, you cannot be considered for any";
   LOCATE 15, 10
   PRINT "awards because there is no honor in quitting.";
   LOCATE 20, 10
   PRINT "Press escape again to leave game, any other key to play again."
query:
   ktest$ = INKEY$: IF ktest$ = "" THEN GOTO query
   IF ktest$ = CHR$(27) THEN
      kt = 0
   ELSE
      kt = 1
   END IF
END SUB

'Move right.
SUB rt (r, c)
   IF c < 80 THEN c = c + 1
END SUB

REM Called from the initial menu.
SUB showrules
   CLS
   PRINT "The object of the game is to travel";
   LOCATE 2, 1: PRINT "down the perilous pits of planet PC.";
   LOCATE 5, 2: PRINT "Use the cursor pad to move:";
   LOCATE 6, 2: PRINT "          \7   ^8   /9           ";
   LOCATE 7, 2: PRINT "          <4   (5)  >6           ";
   LOCATE 8, 2: PRINT "          /1   v2   \3           ";
   LOCATE 10, 2: PRINT "Note:  Because you are constantly";
   LOCATE 11, 2: PRINT "dropping down the pit, the upward";
   LOCATE 12, 2: PRINT "moving keys  (7, 8, 9)  only keep";
   LOCATE 13, 2: PRINT "you stationary on a given line.  "
   LOCATE 14, 2: PRINT "If you press the left/right arrow";
   LOCATE 15, 2: PRINT "keys (4, 6) you will still drop a";
   LOCATE 16, 2: PRINT "row,  and if you press a downward";
   LOCATE 17, 2: PRINT "key (1,2,3), you will drop 2 rows";
   LOCATE 19, 2: PRINT "Special:   Holding down the shift";
   LOCATE 20, 2: PRINT "key while pressing the cursor key";
   LOCATE 21, 2: PRINT "will move you twice the distance.";
   LOCATE 22, 2: PRINT "(At a cost of 100 pts each time.)";
   LOCATE 5, 45: PRINT "Objects of concern (friend & foe):";
   LOCATE 6, 45: PRINT "----------------------------------";
   LOCATE 7, 47: PRINT CHR$(177); " |     Pit Walls    | Weakens  ";
   LOCATE 8, 47: PRINT CHR$(1); " | Alien scout ship | Damages   ";
   LOCATE 9, 47: PRINT CHR$(2); " |   Alien cruiser  | Kills     ";
   LOCATE 10, 47: PRINT CHR$(248); " |    Black Hole    | Transports";
   LOCATE 11, 47: PRINT CHR$(15); " |    Power Geods   | Energizes ";
   LOCATE 12, 47: PRINT CHR$(250); " |    Ship trail    | Tracks  ";
   LOCATE 13, 47: PRINT CHR$(157); " |     Your ship    | Flies  ";
   LOCATE 15, 45: PRINT "Bonuses:                          ";
   LOCATE 16, 46: PRINT "Bonus points for completing a pit.";
   LOCATE 17, 46: PRINT "Bonus ships for high scores.      ";
   LOCATE 19, 45: PRINT "Other points of interest:   ";
   LOCATE 20, 46: PRINT "Hit the ESCape to quit game.";
   LOCATE 21, 46: PRINT "Hit the P key to Pause game.";
   LOCATE 25, 26: PRINT "Press any key to continue...";
ruleswait:
   krules$ = INKEY$: IF krules$ = "" THEN GOTO ruleswait
END SUB

REM The initial move when game is first started.
SUB startmenu (userspeed, userdiff)
   userspeed = 100
   DO                                  'Loop until start game.
      CLS
      LOCATE 6, 25
      PRINT "QWIKFALL, an update of Pitfall."
      LOCATE 7, 25
      PRINT "Copyright 1988 by B. F. Bednarz"
      LOCATE 10, 35
      PRINT "Choose one:";
      LOCATE 11, 35
      PRINT " Start game";
      LOCATE 12, 35
      PRINT " P.C. speed";
      LOCATE 13, 35
      PRINT " Game Rules";
      LOCATE 14, 35
      PRINT " About game";
      LOCATE 15, 35
      PRINT " Quit  game";
      DO                               'Loop until legal keypress.
         kmenu$ = INKEY$
         kmenu$ = LCASE$(kmenu$)
         SELECT CASE kmenu$
            CASE "s"                   'Need this to be a legal keypress.
            CASE "p"
               inspeed userspeed, userdiff
            CASE "g"
               showrules
            CASE "a"
               description
            CASE "q"
               CLS
               LOCATE 12, 36
               PRINT "Goodbye!"
               END
            CASE ELSE
               kmenu$ = " "            'Use space to mark illegal entry.
         END SELECT
      LOOP WHILE kmenu$ = " "
   LOOP WHILE kmenu$ <> "s"
END SUB

'Move up.
SUB up (r, c)
   IF r > 2 THEN r = r - 1
END SUB

REM Called whenever score, etc. is changed (at new level).
SUB update (lev, sco!, max, ship)
   COLOR 15, 0, 0
   LOCATE 25, 5
   FOR kk = 1 TO (ship - 1)
      PRINT CHR$(157);
   NEXT kk
   LOCATE 25, 20: PRINT "level"; lev;
   LOCATE 25, 40: PRINT "SCORE"; : PRINT USING "#######"; sco!;
   LOCATE 25, 60: PRINT "strength"; max;
   COLOR 7, 0, 0
END SUB

'Move up & left.
SUB uplf (r, c)
   IF r > 2 THEN r = r - 1
   IF c > 1 THEN c = c - 1
END SUB

'Move up and right.
SUB uprt (r, c)
   IF r > 2 THEN r = r - 1
   IF c < 80 THEN c = c + 1
END SUB

