/********** The Son of Tetris Project ************/

/***************** HIGH SCORES ********************/

#include <ctype.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sot.h"

#define MARK_CHAR '' /* detect unused table */
#define SPACE_STRING "                    "

struct scre
{
  char name[20];
  long scre_val;
} /* scre */;

static char embed_str[] = "High_score_table:"; /* Table marker in .EXE file */
static char score_space[TABLE_LEN * sizeof(struct scre)] = { MARK_CHAR };

static FILE *prog_file;
static int   rec_no;
const struct scre *score = (void *)&score_space;

void  error(int error_no)
{
  static char *msg[] = {"Insufficient memory for program. Sorry!",
                        "Disk error here, giving up. Sorry!",
		       };
  puts(msg[error_no]);
  exit(error_no);
}     /* error */


void  write_exe_file(void)
{
  fseek(prog_file, rec_no, SEEK_SET);
  fwrite(score, sizeof(struct scre), TABLE_LEN,prog_file);
  fflush(prog_file);
}     /* write_exe_file */



void  init_score(char *prog_name)
{
  void *buf_ptr;
  char *srch_ptr;
  unsigned f_l;
  int handle;
  int i;

  prog_file = fopen(prog_name,"r+b");
  handle = fileno(prog_file);
  f_l = (unsigned)filelength(handle);
  buf_ptr = malloc(f_l);

  if (buf_ptr == NULL)
    error(1);

  if (f_l != read(handle, buf_ptr, f_l))
    error(2);

  for (rec_no = 0, srch_ptr = buf_ptr;
       strcmp(srch_ptr,embed_str);
       rec_no++, srch_ptr++);
  free(buf_ptr);
  srch_ptr += sizeof(embed_str);
  rec_no += sizeof(embed_str);

  if (score_space[0] == MARK_CHAR)  /* unused score table */
  {
    for (i = 0; i < TABLE_LEN; i++)
    {
      strcpy((score + i)->name,SPACE_STRING);
      (score + i)->scre_val = 0;
    } /* for each table entry */
    write_exe_file();
  } /* score table need initialising */
}     /* init_score */


void end_score(void)
{
  fclose(prog_file);
} /*  end_score */


void champ_val(char *name, long *score_val, int rank)
{
  strcpy(name,(score + (--rank)) -> name);
  *score_val = (score + rank) ->scre_val;
} /* champ_val */


void  update_score_table(char *name,long new_score)
{
  int rank;

  while (isspace(*name))   /* kill off non-entered names */
    name++;
  if (! (*name))
    return;
  for (rank = TABLE_LEN - 2; rank >= -1; rank--)
  {
    /* if new score exceeds current rank */
    if (((score + rank)->scre_val < new_score) && (rank >= 0))
    {
      (score + rank + 1)->scre_val = (score + rank)->scre_val;
      strcpy((score + rank + 1) -> name,(score + rank) -> name);
    } /* new_score execeeds current rank */

    else  /* copy new data into rank below */
    {
      (score + rank + 1)->scre_val = new_score;
      strcpy((score + rank + 1) -> name, name);
      break; /* all done */
    }
  } /* for */
  write_exe_file();
} /* update_score_table */
