
/* 
     Geodesic Publications, P.O.Box 7, Willow Creek, CA. 95573
     This  program demonstrates the use of fuctions,

     gline( x1, y1, x2, y2, color )    and    polyfill( xypairs ).

     	The  program  first  fills  the  screen  with  540 lines, then
     generates  regular  polygons  of   random   sides,   sizes,   and
     colors.  Lines and  areas  are  draw  in  the  medium  resolution
     graphics  mode  for  the  standard IBM PC  color  graphics  card.
     The  two  routines,  "polyfill",  and  "gline"  are  the  fastest
     possible implementations of their graphic functions.

     	The routine "polyfill" fills in any polygon you define and can
     even put a border of a different color around it.  The fill color
     is  two pixels meshed to give you ten possible colors rather that
     just four.
                 polyfill( xypairs ) - xypairs points to integer stack:

                 high byte         low byte           xypairs>color
             _ _ _ _ _ _ _ _   _ _ _ _ _ _ _ _                count
   color  = |_|_|_|_|_|_|_|_| |_|_|_|_|_|_|_|_|               x1 -----  
             |       | | | |       | | ^ ^ ^ ^ fill color     y1   |    
             |       | | | |       ^ ^ border color           x2   |    
             |       | | | ^ transparency off/on              y2 count=4
             |       | | ^ shade off/on                       x3   |    
             |       | ^ fill   off/on                        y3   |    
             |       ^ border  off/on                         x4   |    
             ^ polygon  off/on                                y4 -----  
                                                              
     (x,y) pairs are offset by (xcent,ycent) center point.    
*/

#include <stdio.h>
#define PON 	0x8000			/*  flags in colour word   */
#define BORD	0x0800
#define FILL	0x0400 
#define SHADE	0x0200
#define TRANS	0x0100
#define TWO_PIE	   256		/* for  cosi()  and  sini()    */

int seed, es, xmin, xmax, ymin, ymax, xcent, ycent;  /* Used outside 0.c */

int xy[40][2], x, y, i, radius, delta, angle, sides, color;

main(argc, argv) 
int argc;
char *argv[];
{
	set_option(stdin , get_option( stdin ) & ~3);
	set_option(stdout, get_option( stdout) & ~3);
	video_io(4,0,0,0);
	es = 0xb800;
	draw_lines(); 
	xmin=  9;
	ymin=  8;
	xmax=310;
	ymax=190;
	color = 0;
	while( !char_waiting( stdin ) ){
		xcent  = rando() % 320;
		ycent  = rando() % 200;
		radius = rando() %  50 + 20;
		sides  = rando() %   8 +  3;
		angle  = rando() %  85;
		delta  = TWO_PIE / sides;
		xy[ 0 ][ 0 ] = color--;
		xy[ 0 ][ 1 ] = sides;
		for( i = 1;   i <= sides; i++, angle += delta ) {
			xy[ i ][ 0 ] = mult(  radius, cosi( angle ) );
			xy[ i ][ 1 ] = mult(  radius, sini( angle ) );
		}

		polyfill( xy[0] );

	}
	getchar();
/*
	video_io(2,0,0,0);
*/
}

video_io(av, bv, cv, dv)
unsigned av, bv, cv, dv;
{
	asm(" mov ax ,14[bp] ");
	asm(" mov bx ,16[bp] ");
	asm(" mov cx ,18[bp] ");
	asm(" mov dx ,20[bp] ");
	asm(" int 10h        ");
}

draw_lines() 
{
	xmin=  0;
	ymin=  0;
	xmax=319;
	ymax=199;
	for( x = -5, y=-5; x<325; x++ )	gline( x, y, 319-x, 199-y, color++);
	for( x = -5, y=-5; y<206; y++ ) gline( x, y, 319-x, 199-y, color++);
}
