{
                                 

  DISPLAY.CH  include module for CHESS.PAS
     Last modified:  10/29/85

  This module contains many of the screen and input definitions
  and procedures.

                                 
}

{ Colors,  Black = 0, White = 15 }
type  TextColorType = record
                         Background,Color : 0..15;
                      end;

const
   NormalColor :   TextColorType =
      (Background : Brown;   Color : 15);
   BorderColor :   TextColorType =
       (Background : Blue;    Color : Yellow);
   LibColor : TextColorType =
       (Background : red; Color : yellow);
   LightColor : TextColorType =
       (Background : Brown; Color : 15);     { HIghlighting }
   BoardColor :    array[ColorType] of TextColorType =
       ((Background : Green;       Color : Green),
        (Background : Red;         Color : Red));
   PieceColor :    array[ColorType] of TextColorType =
       ((Background : LightGray;   Color : 0),
        (Background : 0;           Color : LightGray));

procedure SetColor(ScreenColor : TextColorType);
begin
   TextBackground(ScreenColor.Background);
   TextColor(ScreenColor.Color);
end;

{ Screen coordinates and colors for the Screen picture }
type  ScreenPosType = record
                         x, y :              byte;
                         Background,Color : 0..15;
                      end;

const HeadingPos :  ScreenPosType =   { Heading }
         (x : 54;   y :  1;
          Background : Red;         Color : 15);

      PlayerPos : ScreenPosType = { Current Player Indicator }
         (x : 54; y : 2;
          Background : LightGray; Color : 0);
      LevelPos : ScreenPosType =    { Current Level Indicator }
         ( x : 54;
           y : 3;
           Background : Blue; Color : Yellow );
      ClockPos :    ScreenPosType =   { The two chess clocks }
         (x : 54;   y :  4;
          Background : Green;       Color : Yellow);
      MovePos :     ScreenPosType =   { The two Last moves }
         (x : 70;   y :  4;
          Background : Blue;        Color : LightGray);
      DepthPos :    ScreenPosType =   { Search Depth, analysed Move }
         (x : 54;   y :  7;
          Background : Red;         Color : Yellow);
      ValuePos :    ScreenPosType =   { Evaluation }
         (x : 54;   y :  8;
          Background : LightGray;   Color : Blue);
      MainLinePos : ScreenPosType =   { Main Line }
         (x : 54;   y :  9;
          Background : Blue;        Color : LightGray);
      NodePos :     ScreenPosType =   { Nodes }
         (x : 54;   y : 11;
          Background : Brown;       Color : LightGreen);
      TimePos :     ScreenPosType =   { Nodes per Second }
         (x : 68;   y : 11;
          Background : Brown;       Color : LightGreen);
      MenuPos :     ScreenPosType =   { Command Menu }
         (x : 54;   y : 13;
          Background : Brown;       Color : 0);
      SearchPos :   ScreenPosType =   { The searched moves }
         (x : 54;   y : 20;
          Background : Brown;       Color : 0);
      CommandPos :  ScreenPosType =   { Command Line }
         (x : 54;   y : 21;
          Background : Green;       Color : 15);
      MessagePos :  ScreenPosType =   { Message Line }
         (x : 54;   y : 23;
          Background : Red;       Color : 15);

procedure GoToPos(ScreenPos : ScreenPosType; x1, y1 : byte);
{ Go to a screen position and set color }
begin
   with ScreenPos do
   begin
      GoToXY(x + x1,y + y1);
      TextBackground(Background);
      TextColor(Color);
   end;
end;

procedure Beep;
begin
   Sound(220);
   Delay(250);
   NoSound;
end;

procedure ClearEOL;
begin
   SetColor(NormalColor);
   ClrEOL;
end;

procedure ClearScr;
begin
  SetColor(NormalColor);
  ClrScr;
end;

procedure ClearEvaluInfo;
begin
  Window(54, 4, 80, 11);
  ClearScr;
  Window(1, 1, 80, 25);
end; { ClearEvaluInfo }

procedure ClearEvaluation;
begin
  Window(54, 5, 80, 11);
  ClearScr;
  Window(1, 1, 80, 25);
end; { ClearEvaluation }

procedure OpeningLibMsg;
begin
  Window(54, 5, 80, 11);
  SetColor(NormalColor);
  ClrScr;
  GotoXY(2,6);
  SetColor(LibColor);
  Write(' Using opening library ');
  Window(1, 1, 80, 25);
end; { OpeningLibMsg }

type  str80 = string[80];
procedure Message(AskStr : str80);
{ Prints various information }
begin
   GoToPos(MessagePos,0,0);
   Write(AskStr);
end;

procedure Error(AskStr : str80);
{ Prints Error information }
begin
   Beep;
   Message(AskStr);
   ClearEOL;
   Delay(1200);
end; { Error }

procedure ClearErrMsg;
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  Message('');
  ClearEol;
  GotoXY(StartX, StartY);
end; { ClearErrMsg }

const CommandLength = 10;
type  CommandString = string[CommandLength];
var   Command : CommandString;
      AskLen :  byte;

procedure Ask(AskStr : str80);
{ Ask a question }
begin
  GoToPos(CommandPos,0,0);
  Write(AskStr);
  ClearEOL;
  AskLen := Length(AskStr);
end; { Ask }

procedure ReturnCursor;
begin
   GoToPos(CommandPos,AskLen,0);
end;

var { Is set if the Board is Turned upside Down }
      Turned : boolean;
procedure GoToSquare(Square : SquareType; x1,y1 : integer);
begin
 if Turned then Square := Square xor $77;
 GoToXY((Square MOD 8) * 6 + 3 + x1, (7 - Square DIV 16) * 3 + 2 + y1);
end;

{ =====================  Display routines ==================== }
type   str6 = string[6];
       PictureType = array[0..2] of
                       record
                          x : integer;
                          s : str6
                       end;

procedure PrintLine(Square : SquareType;
                     x1,y1 : byte;
                         s : str6);
begin
   GoToSquare(Square, x1, y1);
   Write(s);
end;

procedure ClearSquare(Square : SquareType);
var   y : byte;
begin
   if odd(Square MOD 8 + Square DIV 16) then
   begin
      SetColor(BoardColor[White]);
      for y := 0 to 2 do
        PrintLine(Square,0,y,'');
   end
   else
   begin
      SetColor(BoardColor[Black]);
      for y := 0 to 2 do
        PrintLine(Square,0,y,'      ');
   end;
   SetColor(NormalColor);
end;

procedure PrintPiece(Square : SquareType;
                     Piece : PieceType;   Color : ColorType);

const PiecePicture : array[King..Pawn] of PictureType =

        (((x : 1;   s :  '++++'),
          (x : 1;   s :  ' K'),
          (x : 1;   s :  '')),

         ((x : 1;   s :  ''),
          (x : 1;   s :  'ε'),
          (x : 1;   s :  ' Q')),

         ((x : 1;   s :  'ҿ'),
          (x : 1;   s :  ' R'),
          (x : 1;   s :  '  ')),

         ((x : 2;   s :   ''),
          (x : 2;   s :   ' '),
          (x : 2;   s :   'B')),

         ((x : 1;   s :  'Ŀ'),
          (x : 1;   s :  'Կ'''),
          (x : 2;   s :   'N')),

         ((x : 0;   s : ''     ),
          (x : 3;   s :    'P' ),
          (x : 2;   s :   '')));

var   y : byte;
begin
   SetColor(PieceColor[Color]);
   for y := 0 to 2 do
     with PiecePicture[Piece][y] do
        PrintLine(Square,x,y,s);
   SetColor(NormalColor);
end;

type  BoardIdType = array[SquareType] of
                      record
                         Piece : PieceType;
                         Color : ColorType;
                      end;

var   Display : BoardIdType;

procedure LightFirst(S : Str80; CurPos : ScreenPosType);
{ This procedure highlights the First letter of a Menu option }
var
  i : byte;
begin
  with CurPos do
  begin
    SetColor(LightColor);
    Write(S[1]);
    TextColor(Color);
    for i := 2 to Length(S) do
      Write(S[i]);
  end;
end; { LightFirst }

{ Level Types and variables moved here for Display procedures }
type  LevelType = (Normal,FullGameTime,DemoGame,
                   Infinite,PlySearch,MateSearch);
var
  Level       : LevelType;     { LevelType }
  MaxLevel    : byte;          { Maximum Search Depth }
  AverageTime : real;

procedure PrintCurLevel;
{ Displays the current Level indicator }
begin
  GoToPos(LevelPos,0,0);
  ClearEOL;
  Write('LEVEL: ');
  case Level of
         Normal       : Write(AverageTime : 1 : 0, ' sec / move');
         FullGameTime : Write(AverageTime : 2 : 2,' min / Game');
         DemoGame     : Write('Demo');
         Infinite     : Write('Infinite');
         PlySearch    : Write('Ply-Depth = ', MaxLevel);
         MateSearch   : Write('MateSearch');
  end;
end;

procedure ClearMenu;
{ Clears the menu area }
begin
  with MenuPos do
    Window(x, y, 79, 23);
  ClearScr;
  Window(1, 1, 80, 25);
end; { ClearMenu }

procedure ClearMessage;
{ Clears help message on bottom of edit menu }
begin
  With CommandPos do
    Window(x, y + 3, 79, y + 4);
  ClearScr;
  Window(1,1,80,25);
end; { ClearMessage }

procedure DispLevelMenu;
{ Prints the Level Selection Menu }
begin
  ClearMenu;
  ClearMessage;
  GoToPos(MenuPos,0,0);
  LightFirst('Normal     Seconds / move',MenuPos);
  GoToPos(MenuPos,0,1);
  LightFirst('FullTime   Minutes / game',MenuPos);
  GoToPos(MenuPos,0,2);
  LightFirst('Demo       Your pace',MenuPos);
  GoToPos(MenuPos,0,3);
  LightFirst('Infinite   Until interrupt',MenuPos);
  GoToPos(MenuPos,0,4);
  LightFirst('PlySearch  Search-depth',MenuPos);
  GoToPos(MenuPos,0,5);
  LightFirst('Mate       Mate puzzles',MenuPos);
  GoToPos(MenuPos,0,6);
  LightFirst('Quit       Main menu',MenuPos);
  PrintCurLevel;
end; { DisplayLevelMenu }

procedure MoveMessage;
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,0,3);
  Write(' Type move (PE4 E2E4 E4) ');
  GoToPos(CommandPos,0,4);
  Write(' or use the arrow keys   ');
  GotoXY(StartX, StartY);
end; { MoveMessage }

procedure PieceArrowMsg;
{ Helps with using arrows to mark piece to move }
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,0,3);
  Write(' Point at PIECE and mark ');
  GoToPos(CommandPos,0,4);
  Write('  by typing <SPACE BAR>  ');
  GotoXY(StartX, StartY);
end; { PieceArrowMsg }

procedure DestArrowMsg;
{ Helps with using arrows to mark destination of move }
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,2,3);
  Write(' Point to DESTINATION ');
  GoToPos(CommandPos,2,4);
  Write(' and hit <SPACE BAR>  ');
  GotoXY(StartX, StartY);
end; { DestArrowMsg }

procedure EdArrowMsg;
{ Help for using arrows to mark square to edit }
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,0,3);
  Write(' Point at square to edit ');
  GoToPos(CommandPos,0,4);
  Write(' and hit <SPACE BAR>     ');
  GotoXY(StartX, StartY);
end; { EdArrowMsg }

procedure SquareMessage;
{ Help message flashed when arrows are allowed in edit }
var
  StartX, StartY : byte;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,0,3);
  Write('Enter Square (E4, A1, H2)');
  GoToPos(CommandPos,0,4);
  Write('or use the arrow keys    ');
  GotoXY(StartX, StartY);
end; { SquareMessage }

procedure PieceMessage;
{ Help Message for adding Pieces in Edit }
var
  StartX, StartY : integer;
begin
  StartX := WhereX;
  StartY := WhereY;
  ClearMessage;
  GoToPos(CommandPos,0,3);
  Write('Chess Pieces:  P,N,B,R,Q,K');
  GoToPos(CommandPos,0,4);
  Write('or <SPACE> to clear square');
  GoToXY(StartX, StartY);   { restore previous cursor position }
end; { PieceMessage }

procedure PrintMenu;
{ Prints the Main Command Menu and help lines }
begin
  ClearMenu;
  ClearMessage;
  GoToPos(MenuPos,8,1);
  Write('Main Menu');
  GoToPos(MenuPos,0,3);
  LightFirst('NewGame  ',MenuPos);
  LightFirst('Level  ',MenuPos);
  LightFirst('Play  ',MenuPos);
  LightFirst('Turn',MenuPos);
  GoToPos(MenuPos,3,4);
  LightFirst('Multi   ',MenuPos);
  LightFirst('Auto   ',MenuPos);
  LightFirst('Single',MenuPos);
  GoToPos(MenuPos,3,5);
  LightFirst('Value   ',MenuPos);
  LightFirst('Back   ',MenuPos);
  LightFirst('Forward',MenuPos);
  GoToPos(MenuPos,3,6);
  LightFirst('Hint    ',MenuPos);
  LightFirst('Edit   ',MenuPos);
  LightFirst('Quit',MenuPos);
  PrintCurLevel;
end; { PrintMenu }

procedure DispEditMenu;
begin
  ClearMenu;
  ClearMessage;
  GoToPos(MenuPos,6,2);
  Write('Edit Options');
  GoToPos(MenuPos,0,4);
  Write('To Edit: <Piece> <Square>');
  GoToPos(MenuPos,2,5);
  LightFirst('White    ',MenuPos);
  LightFirst('Black    ',MenuPos);
  LightFirst('Clear',MenuPos);
  GoToPos(MenuPos,0,6);
  LightFirst('LoadBoard  ',MenuPos);
  LightFirst('SaveBoard  ',MenuPos);
  LightFirst('Quit',MenuPos);
  PieceMessage;
end; { DispEditMenu }

procedure ColorToPlay(Color : ColorType);
{ Prints current Color to play }
begin
  GoToPos(PlayerPos, 0, 0);
  if Color = White then Write(' White')
  else Write(' Black');
  Write(' to Move ');
end; { ColorToPlay }

procedure SetBorder;
{ Sets up the color and proper characters (rank and file) }
var
  i : byte;
begin
  SetColor(BorderColor);
  for i := 0 to 7 do
  begin
    if not Turned then GoToSquare($70 + i,0,- 1)
    else GoToSquare(i,0,- 1);
      Write('   ',Chr(ord('A') + i),'  ');
  end;
  for i := 1 to 25 do
  begin
    GoToXY(1,i);
    Write('  ');
    GoToXY(51,i);
    Write('  ');
  end;
  for i := 0 to 7 do
  begin
    if not Turned then GoToSquare(i * $10,- 2,1)
    else GoToSquare(i * $10 + 7,- 2,1);
      Write(1 + i,' ');
  end;
end; { SetBorder }

procedure SetUpScreen(var FirstCall : boolean);
{ Prints the Screen picture }
var   Sq :  SquareType;
      No :  byte;

const PrintNo : array[0..63] of SquareType =
   (0,$10,$20,$30,$40,$50,$60,$70,
      $71,$72,$73,$74,$75,$76,$77,
      $67,$57,$47,$37,$27,$17,  7,
        6,  5,  4,  3,  2,  1,
      $11,$21,$31,$41,$51,$61,
          $62,$63,$64,$65,$66,
          $56,$46,$36,$26,$16,
          $15,$14,$13,$12,
          $22,$32,$42,$52,
              $53,$54,$55,
              $45,$35,$25,
              $24,$23,
              $33,$43,
                  $44,
                  $34);
begin
  SetColor(NormalColor);
  if FirstCall then
  begin
    FirstCall := false;
    ClearScr;
    GoToPos(HeadingPos,0,0);
    Write('T U R B O - C H E S S');
    ColorToPlay(White);
    SetBorder;
    PrintMenu;
  end; { if }
  ClearEvaluInfo;
  for No := 0 to 63 do
    ClearSquare(PrintNo[No]);
  for Sq := 0 to $77 do
    Display[Sq].Piece := Empty;
end; { SetUpScreen }

procedure PrintBoard;
{ Prints the Board On the Screen }
var   Square : SquareType;
begin
  for Square := 0 to $77 do if (Square and $88) = 0 then
    with Board[Square] do
      if (Piece <> Display[Square].Piece) or
         (Piece <> Empty) and
         (Color <> Display[Square].Color) then
         begin
           if Display[Square].Piece <> Empty then
             ClearSquare(Square);
           Display[Square].Piece := Piece;
           Display[Square].Color := Color;
           if Piece <> Empty then
             PrintPiece(Square,Piece,Color);
         end;
  GoToPos(CommandPos,0,0);
end; { PrintBoard }

const PieceLetter : array[Empty..Pawn] of char = ' KQRBNP';
function MoveStr(Move : MoveType) : str6;
{ Converts a Move to a string }
begin
   MoveStr :='      ';
   with Move do
      if MovPiece <> Empty then
         if Spe and (MovPiece = King) then
            { Castling }
            if New1 > Old then MoveStr :='O-O   '
            else MoveStr :='O-O-O '
         else
         begin
            MoveStr[1] := PieceLetter[MovPiece];
            MoveStr[2] := Chr(ord('a') + Old MOD 16);
            MoveStr[3] := Chr(ord('1') + Old DIV 16);
            if Content = Empty then
               MoveStr[4] :='-'
            else
               MoveStr[4] :='x';
            MoveStr[5] := Chr(ord('a') + New1 MOD 16);
            MoveStr[6] := Chr(ord('1') + New1 DIV 16);
         end;
end; { MoveStr }

procedure PrintValue(Square : SquareType;   Value : integer);
{ Prints Piece-Value table }
begin
   GoToSquare(Square,1,1);
   SetColor(NormalColor);
   Write(Value : 4);
end; { PrintValue }

procedure PrintTime(Color : ColorType;   Time : real);
{ Prints the chess clocks }
var   Minutes : integer;
      SecStr :  string[4];
begin
   GoToPos(ClockPos,0,ord(Color));
   case Color of
      White : Write('White:');
      Black : Write('Black:');
   end;
   Minutes := Trunc(Time / 60.0);
   Str(Time - Minutes * 60.0 : 4 : 1,SecStr);
   if SecStr[1] =' ' then SecStr[1] :='0';
   Write(Minutes : 4,':',SecStr);
end; { PrintTime }

procedure PrintMove(MoveNo : integer;   ProgramColor : ColorType;
                    Move : MoveType);
{ Prints movenumber and Last Move }
begin
   GoToPos(MovePos,0,ord(ProgramColor));
   Write(MoveNo DIV 2 + 1 : 3,'. ',MoveStr(Move));
end; { PrintMove }

procedure PrintBestMove(MainLine : LineType; MainEvalu : MaxType);
{ Print MainLine On Screen }
var   Dep : DepthType;
begin
   GoToPos(MainLinePos,0,0);
   ClearEOL;
   GoToPos(MainLinePos,0,1);
   ClearEOL;
   GoToPos(MainLinePos,0,0);
   Dep := 0;
   while (Dep < 7) and (MainLine[Dep].MovPiece <> Empty) do
   begin
      if Dep MOD 4 <> 0 then Write(' ');
      Write(MoveStr(MainLine[Dep]));
      Dep := Dep + 1;
      if Dep = 4 then GoToPos(MainLinePos,0,1);
   end;
   GoToPos(ValuePos, 0, 0);
   Write('Value:', MainEvalu / 256 : 7 : 2);
   ReturnCursor;
end; { PrintBestMove }
