Program FLEET;

{This module will allow the player to select the fleets from his
navy. Fleets will be posted in the theaters given in the game
data file.  Up to four theaters may be used.
Repeat
.  Read map and display
.  Clear all fleet assignments
.  Do until all fleets OK
.  .  Display navy to right of map
.  .  Initialize all fleets
.  .  Set to first fleet
.  .  Do until all fleets selected
.  .  .  Show selected ship status on demend
.  .  .  Clear map fleet area
.  .  .  If cursor at ships in port
.  .  .  .   Move cursor to select ship
.  .  .  .   Select ship on CR
.  .  .  .   Move ship from port to fleet
.  .  .  Else
.  .  .  .   Restore fleet ships to ships in port
.  .  .  End
.  .  End
.  End
.
.  Decrement damage of all Allied ships in port
.  Randomly select Axis fleets
.  Decrement damage of all Axis ships in port (if any)
.
.  Engage in combat
.  Clear all Work1 (shots taken)
.  Set round to 0
.  For each theater
.  .   Increment the round
.  .   Repeat until all surface ships on one side eliminated
.  .   .   Randomly select Axis Combat followed by Allied Combat or vice versa
.  .   End
.  End
.
.  Calculate victory points
.
until victory point delta is five or as selected from input data set
Display winner}

{$ICOMMON.PAS}
{$IPUTPIC.PAS}
{$ICURSOR.PAS}
{$IBORDER.PAS}
{$IWIND.PAS}
{$IBEEP.PAS}

VAR list:array[1..20] of integer;
    Allied_Total,Axis_Total,
    Allied_Ship_Cnt,Axis_Ship_Cnt,
    Allied_Sub_Cnt,Axis_Sub_Cnt,
    Allied_Ship_No,Axis_Ship_No:integer;
    Round:integer;
    Sub_Shots,key,scnt,acnt,xcnt:integer;
    Temp_Name:string[10];
    Theamax:array[1..8] of integer;
    init_no:real;
    Cur_Ctl,Max_Ships,Assg_Ships,Turn:integer;

Procedure Ships_in_Port;                           {Display ships not assigned}
Begin                                              {to a theater}
  Gotoxy(66,1);
  FastWrite('Ships in Port',7,0,1);
  For i:=1 to Ships do
    Begin
      Gotoxy(67,i+2);
      With Allied_Navy[i] do
        If (Status<>9) and (Fleet=0) then
           begin
             If Theater=0 then FastWrite(' ',7,0,1)
             else Fastwrite('*',7,0,1);
             FastWrite(ID,7,0,1);
           end
        Else
           FastWrite('           ',7,0,1);
    end;
end;

Procedure Pick_Fleets;

begin

gotoxy(24,24);
Fastwrite('Enter ? for help',7,0,1);
theano:=1;                                              {Display first theater}
cmax:=Theater[1].max;
ixloc:='p';                                      {Set location pointer to port}
portix:=1;                                       {Set to first ship}
theaix:=1;
For i:=1 to theacnt do                           {Clear fleet assignments}
  begin
    For j:=1 to 20 do
       begin
          Allied_Fleet[i,j]:=0;
          Axis_Fleet[i,j]:=0;
       end;
  end;

for i:= 1 to 20 do
 begin
   Allied_Navy[i].Fleet:=0;
   Axis_Navy[i].Fleet:=0;
 end;

Ships_in_Port;

TheaWind(theano);
repeat

  begin
    cx:=66;                                        {Set cursor select position}
    cy:=portix+2;
    if ixloc='t' then
      with Theater[theano] do
        begin
           cx:=x+1;
           cy:=theaix+1+y;
           cmax:=max;
        end;
    gotoxy(cx,cy);
    Fastwrite(chr(26),15,0,3);
    Uncursor;

    l:=cursor;                                     {Read character}
    case l of
     32: begin                                              {Advance theater}
            Restore;
            theano:=theano+1;
            if theano>theacnt then theano:=1;
            TheaWind(theano);
            theaix:=1;
            cmax:=theater[theano].max;
          end;
     4:  begin                                              {Advance cursor}
           if ixloc='p' then
             begin
               Cur_Ctl:=portix;
               repeat
                 portix:=portix+1;
                 if portix>Ships then portix:=1;
               until ((Allied_Navy[portix].fleet=0) and
                     (Allied_Navy[portix].status<>9)) or (portix=Cur_Ctl);
             end
           else
             with theater[theano] do
               begin
                  Cur_Ctl:=theaix;
                  repeat
                     theaix:=theaix+1;
                     if theaix>max then theaix:=1;
                  until (Allied_Fleet[theano,theaix]>0) or (theaix=Cur_Ctl);
               end;
           end;
     3:  begin                                              {Decrement cursor}
           if ixloc='p' then
             begin
               Cur_Ctl:=portix;
               repeat
                 portix:=portix-1;
                 if portix<1 then portix:=Ships;
               until ((Allied_Navy[portix].fleet=0) and
                      (Allied_Navy[portix].status<>9)) or
                     (portix=Cur_Ctl);
             end
           else
             with theater[theano] do
               begin
                 Cur_Ctl:=theaix;
                 repeat
                   theaix:=theaix-1;
                   if theaix<1 then theaix:=max;
                 until (Allied_Fleet[theano,theaix]<>0) or
                       (theaix=Cur_Ctl);
               end;

         end;
     1:  ixloc:='t';                            {switch to theater}
     2:  ixloc:='p';                            {switch to port}
     13: begin
           if (ixloc='p') then                  {switch ship from port to}
             begin                              {theater}
                with Allied_Navy[portix] do
                if (Fleet=0) and (Status<>9) and
                   ((Theater=0) or (Theater=theano)) then
                  begin
                    theaix:=0;
                    repeat
                      theaix:=theaix+1;
                    until (theaix>cmax) or (Allied_Fleet[theano,theaix]=0);
                    if theaix<=cmax then
                       begin
                         Fleet:=theano;
                         Allied_Fleet[theano,theaix]:=portix;
                       end
                    else
                       theaix:=cmax;
                    end;
                  end
                else
                  begin
                    i:=Allied_Fleet[theano,theaix];  {switch ship from theater}
                    if i>0 then                      {to port}
                       begin
                         Allied_Navy[i].Fleet:=0;
                         Allied_Fleet[theano,theaix]:=0;
                       end;
                  end;
                  TheaWind(theano);
                  Ships_in_Port;
         end;
     115,
     83: begin                                       {Display status}
           if (ixloc='p') and (Allied_Navy[portix].Fleet=0) and
              (Allied_Navy[portix].Status<>9) then
           DispStatus(portix);
           if ixloc='t' then
             begin
               i:=Allied_Fleet[theano,theaix];
               if i<>0 then
                 DispStatus(i);
             end;
          end;
     63:  begin
           Restore;
           Windx:=16;                                  {Setup window}
           Windy:=8;
           Winddx:=33;
           Winddy:=11;
           Border(Windx,windy,winddx,winddy,1,15,0);
           Window(Windx+1,Windy+1,Windx+Winddx-2,Windy+winddy-2);
           ClrScr;
           Gotoxy(5,9);                                {Display static data}
           FastWrite('PRESS ANY KEY TO CONTINUE',7,0,1);
           Gotoxy(1,1);
           FastWrite(' Up/Down cursors select ship',7,0,1);
           Gotoxy(1,2);
           FastWrite(' Left/Right switch theater/port',7,0,1);
           Gotoxy(1,3);
           FastWrite(' ENTER moves ship',7,0,1);
           Gotoxy(1,4);
           FastWrite(' END completes selection',7,0,1);
           Gotoxy(1,5);
           FastWrite(' S or s displays ship status',7,0,1);
           Gotoxy(1,6);
           FastWrite(' Space advances theater',7,0,1);
           Gotoxy(1,7);
           FastWrite(' Q or q terminates game ',7,0,1);
           Window(1,1,80,25);
           uncursor;
           Kbdrd;
           Restore;
           TheaWind(theano);
         end;

    end; {case}
    if l<>32 then                                 {Clear cursor unless theater}
      begin                                       {changed}
         Gotoxy(cx,cy);                           {Clear cursor}
         Fastwrite(' ',7,0,3);
      end;
  end;
until (l=5) or (quitsw=1);                                        {End inputted}

For i:=1 to ships do
  begin
    with Allied_Navy[i] do
      if (Fleet=0) and (Status<>9) and (Damage>0) then
      Damage:=Damage-1;
  end;

For i:=1 to 20 do                                      {Shuffle list index}
  list[i]:=i;

For i:=1 to 50 do
  begin
    j:=random(20)+1;
    k:=random(20)+1;
    l:=list[j];
    list[j]:=list[k];
    list[k]:=l;
  end;

Max_Ships:=0;
For i:=1 to theacnt do                                {Clear fleet counts}
  begin                                               {and set max fleet cnt}
    Axis_Fleet_Count[i]:=1;                           {allowed}
    Theamax[i]:=Theater[i].max;
    Max_Ships:=Max_Ships+Theamax[i];
  end;

Assg_Ships:=0;
For n:=1 to 20 do                                     {Move fixed theater ships}
  with Axis_navy[n] do                                {to theater}
   begin
    if Max_Ships>Assg_Ships then
    begin
      if (Theater<>0) and (status<>9) and
         (Axis_Fleet_Count[Theater]<=Theamax[Theater]) then
        begin
          Fleet:=Theater;
          Axis_Fleet[theater,Axis_Fleet_Count[Theater]]:=n;
          Axis_Fleet_Count[Theater]:=Axis_Fleet_Count[Theater]+1;
          Assg_Ships:=Assg_Ships+1;
        end;
    end;
   end;

n:=0;                                                 {Randomly select rest of}
For i:=1 to 20 do                                     {axis fleets}
  begin
     with Axis_Navy[list[i]] do                       {pick ship}
       begin
         if Max_Ships>Assg_Ships then
           begin
             if (fleet=0) and (status<>9) and (damage<(defense/2)) then
                begin
                  repeat
                    n:=n+1;                             {select theater}
                    if n>theacnt then n:=1;
                   {gotoxy(1,1);write(max_Ships,' ',assg_Ships);read(kbd,c);}
                  until Axis_Fleet_Count[n]<=Theamax[n];
                  Fleet:=n;
                  Axis_Fleet[n,Axis_Fleet_Count[n]]:=list[i];
                  Axis_Fleet_Count[n]:=Axis_Fleet_Count[n]+1;
                  Assg_Ships:=Assg_Ships+1;
                end;
           end;
       end;
  end;

For i:=1 to 20 do
  begin
    with Axis_Navy[i] do
      if (Fleet=0) and (Status<>9) and (Damage>0) then
      Damage:=Damage-1;
  end;

if quitsw<>1 then
 begin
    For m:=1 to theacnt do
      TheaWind(m);

    gotoxy(20,24);
    Fastwrite('PRESS ANY KEY TO CONTINUE',15,0,1);
    uncursor;
    Kbdrd;
    gotoxy(1,1);
 end;
end;


Procedure Up_Axis_Cnt(n:integer);   {Increment Axis ship/sub counters}
begin
  If Axis_Navy[n].Model='S' then Axis_Sub_Cnt:=Axis_Sub_Cnt+1
  else Axis_Ship_Cnt:=Axis_Ship_Cnt+1;
end;

Procedure Up_Allied_Cnt(n:integer);   {Increment Allied ship/sub counters}
begin
  If Allied_Navy[n].Model='S' then Allied_Sub_Cnt:=Allied_Sub_Cnt+1
  else Allied_Ship_Cnt:=Allied_Ship_Cnt+1;
end;

Procedure ReCalc(tn:integer);                       {Rearrange and reorder}
begin                                               {ships in theater to}
                                                    {eliminate blank spots}
Allied_Ship_Cnt:=0;
Allied_Sub_Cnt:=0;
For i:=1 to Theater[tn].max do
  begin
    if Allied_Fleet[tn,i]=0 then
      begin
        for j:=(i+1) to Theater[tn].max do
          begin
            if Allied_Fleet[tn,j]<>0 then
              begin
                Allied_Fleet[tn,i]:=Allied_Fleet[tn,j];
                Allied_Fleet[tn,j]:=0;
                Up_Allied_Cnt(Allied_Fleet[tn,i]);
                j:=Theater[tn].max;
              end;
          end;
      end
    else
      Up_Allied_Cnt(Allied_Fleet[tn,i]);
  end;
Allied_Total:=Allied_Ship_Cnt+Allied_Sub_Cnt;
Axis_Ship_Cnt:=0;
Axis_Sub_Cnt:=0;
For i:=1 to Theater[tn].max do
  begin
    if Axis_Fleet[tn,i]=0 then
      begin
        for j:=(i+1) to Theater[tn].max do
          begin
            if Axis_Fleet[tn,j]<>0 then
              begin
                Axis_Fleet[tn,i]:=Axis_Fleet[tn,j];
                Axis_Fleet[tn,j]:=0;
                Up_Axis_Cnt(Axis_Fleet[tn,i]);
                j:=Theater[tn].max;
              end;
          end;
      end
    else
      Up_Axis_Cnt(Axis_Fleet[tn,i]);
  end;
Axis_Total:=Axis_Ship_Cnt+Axis_Sub_Cnt;
TheaWind(tn);
Window(66,3,80,24);
gotoxy(1,21);
end;

Procedure HiLite(as,xs:integer);

begin
Allied_Ship_No:=Allied_Fleet[Theano,as];
Axis_Ship_No:=Axis_Fleet[Theano,xs];
with theater[theano] do
  begin
    Window(x+1,y+1,x+23,y+max+2);
    if as <> 0 then
      begin
        gotoxy(2,as+1);
        with Allied_Navy[Allied_Ship_No] do
          Fastwrite(ID,0,15,1);
      end;
    if xs <> 0 then
      begin
        gotoxy(13,xs+1);
        with Axis_Navy[Axis_ship_No] do
          Fastwrite(ID,0,15,1);
      end;
  end;
end;


Procedure Do_Return;
begin
if quitsw<>1 then
  begin
    Writeln;
    Writeln('PRESS ANY KEY');
    Writeln('TO CONTINUE.');
    Window(1,24,80,25);
    ClrScr;
    Gotoxy(15,1);
    FastWrite(Temp_Name+' Battle Phase',15,0,1);
    uncursor;
    Kbdrd;
    Window(66,1,80,25);
    ClrScr;
    Recalc(Theano);
    Theawind(Theano);
  end;
end;

Procedure Battle_Results;                {Calculate and display battle results}

begin
ReCalc(theano);
TheaWind(theano);
Window(66,3,80,24);
ClrScr;
Gotoxy(2,2);
Writeln('BATTLE RESULTS');
Writeln;
if ((Axis_Ship_Cnt>0) and (Allied_Sub_Cnt>0)) or
   ((Allied_Ship_Cnt>0) and (Axis_Sub_Cnt>0)) or
   (Allied_Ship_Cnt=Axis_Ship_Cnt) then             {I.E. Are both=0}
   begin
     writeln('  Battle is');
     writeln('   a draw');
   end
else
   begin
     if Allied_Ship_Cnt>0 then
        begin
          Victory_Points:=Victory_Points+1;
          for n:= 1 to Allied_Total do
            begin                                {See if Convoy survived}
              with Allied_Navy[Allied_Fleet[theano,n]] do
              begin
                if model='V' then
                  begin
                    Victory_Points:=Victory_Points+1; {increment VP}
                    Fleet:=0;                         {remove convoy}
                    Status:=9;
                    Allied_Fleet[theano,n]:=0;
                    Writeln('  Convoy VP');
                  end;
              end;
            end;
          Temp_name:=Allied_Name;
        end
     else
        begin
          Victory_Points:=Victory_Points-1;
          for n:= 1 to Axis_Total do
            begin                                {See if Convoy survived}
              with Axis_Navy[Axis_Fleet[theano,n]] do
              begin
                if model='V' then
                  begin
                    Victory_Points:=Victory_Points-1; {increment VP}
                    Fleet:=0;                         {remove convoy}
                    Status:=9;
                    Axis_Fleet[theano,n]:=0;
                    Writeln('  Convoy VP');
                  end;
              end;
            end;
          Temp_name:=Axis_Name;
        end;
     Writeln('   '+Temp_name);
     Writeln(' wins battle');
   end;
Writeln;
Writeln('   Turn  ',Turn);
Writeln('   VPs = ',abs(Victory_Points));
Writeln('     of ',Victory_Points_to_win);
Writeln(' needed to win');
Writeln;
Temp_Name:=Axis_Name;
if Victory_Points>0 then Temp_Name:=Allied_Name;
Writeln('   '+Temp_Name);
Writeln('   advantage');
Do_Return;
end;

Procedure Do_Attack(as,ts:integer);

var Target_Total,Attacker_Total,
    Target_Ship_Cnt,Attacker_Ship_Cnt,
    Target_Sub_Cnt,Attacker_Sub_Cnt:integer;
    Target_Fleet,Attacker_Fleet:Fleet_Kind;
    Target:Ship;
    Attacker:Ship;

begin
If Temp_Name=Axis_Name then
  begin
    Target_Total:=Allied_Total;
    Target_Ship_Cnt:=Allied_Ship_Cnt;
    Target_Sub_Cnt:=Allied_Sub_Cnt;
    Target:=Allied_Navy[Allied_Fleet[theano,ts]];
    Target_Fleet:=Allied_Fleet[theano];
    Attacker_Fleet:=Axis_Fleet[theano];
    Attacker:=Axis_Navy[Axis_Fleet[theano,as]];
    i:=as;
    j:=ts;
  end
else
  begin
    Target_Total:=Axis_Total;
    Target_Ship_Cnt:=Axis_Ship_Cnt;
    Target_Sub_Cnt:=Axis_Sub_Cnt;
    Target:=Axis_Navy[Axis_Fleet[theano,ts]];
    Target_Fleet:=Axis_Fleet[theano];
    Attacker_Fleet:=Allied_Fleet[theano];
    Attacker:=Allied_Navy[Allied_Fleet[theano,as]];
    i:=ts;
    j:=as;
  end;

if (Target_Total>0) and ((Attacker.Model<>'S') or
                        ((Attacker.Model='S') and (Round=1) and
                        ((Target.Model<>'S') and
                         (Target.Model<>'K') and
                         (Target.Model<>'P')))) then
  begin
    HiLite(j,i);
    Window(66,3,80,24);
    ClrScr;

    gotoxy(1,1);
    writeln(Temp_Name);
    writeln('ATTACK RESULTS');
    writeln;
    Writeln(Attacker.ID);
    Writeln('attacking');
    Writeln(Target.ID);
    Writeln;
    Writeln('Turn ',Turn);
    Writeln('Round ',Round);
    Writeln('Shot ',scnt,' of ',Attacker.attack);
    Writeln;
    j:=5;
    k:=Random(6)+1;
    if (Attacker.Model='D') and (Target.Model='S') then k:=6;
    if (Attacker.Model<>'D') and (Target.Model='S')then j:=6;
    if Attacker.Model='A' then j:=4;
    if attacker.Model='K' then j:=3;
    if k<j then
      begin
        Writeln('MISS');
        Writeln;
      end
    else
      begin
        if Attacker.Model='K' then
           begin                                           {remove kamikazi}
              Attacker.Fleet:=0;
              Attacker.Status:=9;
              Attacker_Fleet[as]:=0;
              If Temp_Name=Axis_Name then xcnt:=xcnt-1
              else acnt:=acnt-1;
              scnt:=Attacker.attack;
           end;
        if k=j then
          begin
            Writeln('DISABLED');
            Target.Fleet:=0;                               {move target yo port}
            Target_Fleet[ts]:=0;
            Writeln;
          end
        else
         begin
            Writeln('HIT!!!!');
            l:=random(3)+1;
            if attacker.model='K' then l:=random(8)+1;     {set heavy hit from kamikazi}
            if random(15)>=14 then l:=10;                  {randomly sink ship}
            writeln('Damage = ',l,' Pts');
            writeln;
            with Target do
              begin
                Damage:=Damage+l;
                If damage >= Defense then
                  begin
                    Status:=9;
                    Writeln(ID);
                    Writeln('has been sunk.');
                    writeln;
                    Fleet:=0;
                    Target_Fleet[ts]:=0;
                  end;
              end;
          end;
      end;
    If Temp_Name=Axis_Name then
      begin
        Allied_Navy[Allied_Fleet[theano,ts]]:=Target;
        Allied_Fleet[theano]:=Target_Fleet;
        Axis_Navy[Axis_Fleet[theano,as]]:=Attacker;
        Axis_Fleet[theano]:=Attacker_Fleet;
      end
    else
      begin
        Axis_Navy[Axis_Fleet[theano,ts]]:=Target;
        Axis_Fleet[theano]:=Target_Fleet;
        Allied_Navy[Allied_Fleet[theano,as]]:=Attacker;
        Allied_Fleet[theano]:=Attacker_Fleet;
      end;
    Do_Return;
  end;
end;


Procedure Axis_Combat;
begin
if (Axis_Total>0) and (Allied_Total>0) then
  begin
    Temp_Name:=Axis_Name;
    Sub_Shots:=Allied_Ship_Cnt;
    for xcnt:= 1 to Axis_Total do
      begin
        with Axis_Navy[Axis_Fleet[TheaNo,xcnt]] do
          begin
            if model = 'S' then attack:=Sub_Shots;
            scnt:=1;
            while (scnt<=attack) and (Allied_Total>0) and (quitsw<>1) do
               begin
                  acnt:=random(Allied_Total)+1;
                  Do_Attack(xcnt,acnt);
                  scnt:=scnt+1;
               end;
          end;
      end;
  end;
end;

Procedure Do_Battle;

begin
  with Allied_Navy[Allied_Fleet[theano,acnt]] do
    begin
      Window(1,24,80,25);
      ClrScr;
      Gotoxy(12,1);
      FastWrite('Attacker and target are highlighted. Enter ? for help.',15,0,1);
      HiLite(acnt,xcnt);
      uncursor;
      key:=cursor;
      case key of
         5 : scnt:=attack;                          {complete firing}
         4 : begin                                  {cursor down}
               xcnt:=xcnt+1;
               if xcnt>Axis_Total then xcnt:=1;
             end;
         3 : begin                                  {cursor up}
               xcnt:=xcnt-1;
               if xcnt<1 then xcnt:=Axis_Total;
             end;
    115,83 : DispStatus(Allied_Fleet[theano,acnt]);     {status}
        13 : begin
                Do_Attack(acnt,xcnt);                   {do attack}
                scnt:=scnt+1;                           {incr shot counter}
             end;
    119,87 : begin                                      {withdraw}
                scnt:=-1;                               {signal to get out}
                Fleet:=0;                               {of loop}
                Allied_Fleet[theano,acnt]:=0;
                acnt:=acnt-1;
                ReCalc(theano);
             end;
        63 : begin
               Window(1,1,80,25);
               Restore;
               Windx:=16;                         {help window}
               Windy:=8;
               Winddx:=33;
               Winddy:=11;
               Border(Windx,windy,winddx,winddy,1,15,0);
               Window(Windx+1,Windy+1,Windx+Winddx-2,Windy+winddy-2);
               ClrScr;
               Gotoxy(5,9);                  {Display static data}
               FastWrite('PRESS ANY KEY TO CONTINUE',7,0,1);
               Gotoxy(1,1);
               FastWrite(' Up/Down cursors select target',7,0,1);
               Gotoxy(1,2);
               FastWrite(' ENTER fires on target',7,0,1);
               Gotoxy(1,3);
               FastWrite(' W or w withdraws attacker',7,0,1);
               Gotoxy(1,4);
               FastWrite(' END completes firing',7,0,1);
               Gotoxy(1,5);
               FastWrite(' S or s displays ship status',7,0,1);
               Gotoxy(1,6);
               FastWrite(' Q or q terminates game',7,0,1);
               Window(1,1,80,25);
               uncursor;
               kbdrd;
               Restore;
               TheaWind(theano);
               HiLite(acnt,xcnt);
             end;
      end; {case}
      ReCalc(theano);
      TheaWind(theano);
      if xcnt>Axis_Total then xcnt:=Axis_Total;
    end;
end;

Procedure Allied_Combat;
begin
if (Allied_Total>0) and (Axis_Total>0) then
  begin
    ReCalc(theano);
    Sub_Shots:=Axis_Ship_Cnt;
    acnt:=1;
    xcnt:=1;
    repeat
      begin
        Temp_Name:=Allied_Name;
        with Allied_Navy[Allied_Fleet[TheaNo,acnt]] do
          begin
            if model = 'S' then attack := Sub_Shots;
            if (model<>'S') or ((model = 'S') and (Round < 2)) then
              begin
                scnt:=1;
                  begin
                    repeat
                      if Axis_Total>0 then Do_Battle;
                      {Note:scnt is incremented in Do_Battle when
                       key is 13. It is set to -1 when ship withdrawn}
                    until (key=5) or (key=119) or (key=87) or
                          (scnt>attack) or (scnt<1) or (Axis_Total=0) or
                          (Allied_Total=0) or (quitsw=1);
                  end;
              end;
          end;
      end;
      acnt:=acnt+1;
    until (acnt>Allied_Total) or (Allied_Total=0) or (Axis_Total=0) or
          (quitsw=1);
  end;
end;

Procedure Do_Combats;
begin

For TheaNo:=1 to TheaCnt do
  begin
    ReCalc(Theano);                                 {Recalculate and position}
    Round:=1;
    init_no:=Random;
    repeat
       begin
         TheaWind(TheaNo);                       {Display Theater}
         If (init_no < init_factor) then         {Randomly determine the}
           begin                                 {initative}
             if quitsw <> 1 then Axis_Combat;
             if quitsw <> 1 then Allied_Combat;
           end
         else
           begin
             if quitsw <> 1 then Allied_Combat;
             if quitsw <> 1 then Axis_Combat;
           end;
      end;
    Round:=Round+1;
    until (Allied_Ship_Cnt=0) or (Axis_Ship_Cnt=0) or (quitsw=1);
    if quitsw<>1 then
      begin
        Battle_Results;
        Window(1,1,80,25);
        Restore;
      end;
  end;
end;

begin

Randomize;
GetPic(PicName);                      {Load map}
Victory_Points:=0;                    {Initialize victory point count}
Turn:=1;
repeat
  Snapshot(3);
  if quitsw <> 1 then Pick_Fleets;    {Pick Allied and Axis fleets}
  if quitsw <> 1 then Snapshot(3);

  if quitsw <> 1 then Do_Combats;     {Do combat in each theater}
  turn:=turn+1;
until (abs(Victory_Points)>=Victory_Points_to_win) or (quitsw=1) or
      (turn>10);
if quitsw<>1 then
begin
  Window(1,1,80,25);
  ClrScr;
  for m:=2 to 9 do
    Border(m+10,m,59-(2*m),25-(2*m),1,7,0);
  Temp_Name:=Allied_Name;
  If Victory_Points<0 then Temp_Name:=Axis_Name;
  if turn<11 then
  begin
    Gotoxy(33,11);
    LowVideo;
    Writeln('WINNER OF THE');
  end;
  Gotoxy(34,12);
  Writeln('CAMPAIGN IS');
  NormVideo;
  Gotoxy(35,13);
  If (abs(Victory_Points)>=Victory_Points_to_win) then Writeln(Temp_Name)
  else Writeln(' A DRAW');
  Uncursor;
  Kbdrd;
end;
Clrscr;
end.