Program Zappo;
{$C-}
{$U-}

{      Zappo! Ver.1.0 by: Robert Keefe      }
{					    }
Type
 Str14		= String[14];
 Str50          = String[50];
 Str80		= String[80];
 GameArray	=Array[1..3,1..27] of Char;
 PlayerRec  	=Record
                  Name                : Str14;
		  Total,Amount,Final  : Real;
		  FreeSpin	      : integer;
	         End;
 PlayerArray = Array[1..4] of PlayerRec;

Var
 DiskFile			: Text;
 PlayerList			: PlayerArray;
 ColorOn,Game_Done,Turn_Done,
 Round_Done,Winner,Peek,
 TimeLimit,SoundOn		: Boolean;
 Problem			: Str80;
 Answer,Category		: Str50;
 Game_Board			: GameArray;
 Round,Lines,
 Players,Current_Player,
 Misses, i			: integer;
 Red1,Blue1,Green1,Cyan1,
 Magenta1,Yellow1,LightRed1,
 LightBlue1,LightGreen1,
 LightCyan1,LightMagenta1,
 Text80,Text40 : Integer;
 Used_Letters			: Array['A'..'Z'] of Boolean;
 Puzzle_Set			: Array[1..4] of Str80;
 TStr				: String[10];


Const
 F1	= $FF3B;
 F9	= $FF43;
 Give_Up = $FF88;
 CTRL_Q  = $11;
 CTRL_T  = $14;
 CTRL_S  = $13;
 On      = $0607;
 Off     = $1000;
             { Utillities for Screen  I/O }


{... Display String at x,y ...}
Procedure Show(x,y : Integer; InStr : Str80);
Begin GoToXY(x,y); Write(InStr); End; {Show}


{...Set Foreground/Background Colors ...}
Procedure Colors(FG,BG : Integer);
Begin TextColor(FG); TextBackGround(BG); End; {Colors}


{...Turn Cursor Off/On ...}
Procedure Cursor(Mode : Integer);
Var Result : Record AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS : Integer; End;


Begin
 Result.AX := $0100; Result.CX := Mode; Intr($10,Result);
 End;{Cursor}


{... Display Player List & Status ...}
Procedure Show_Status(Level : Integer);
Var
i : integer;
Kolors : Array[0..3] of Integer;


Begin
 Kolors[0] := Yellow1; Kolors[1] := Cyan1;
 Kolors[2] := Green1; Kolors[3] := Cyan1;
 Window(1,1,40,25); Colors(Kolors[Level],Black); Show(4,3,'Totals...');
 Case Level of
  0	: Show(17,3,'   Game');
  1,3   : Show(17,3,'  Round');
  2	: Show(17,3,'Session');
End;
For i := 1 to Players do
 With PlayerList[i]  do
  Begin
   Colors(White,Black); Show(1,i+3,Name);
   Colors(kolors[Level],Black); GoToXy(16,i+3);
   Case Level of
    0     : Write(Total:8:2);
    1,3   : Write(Amount:8:2);
    2     : Write(Final:8:2);
   End;
  End;
 Colors(LightBlue,Black);
 If SoundOn Then Show(1,25,#13+#14) Else Show(1,25,' ');
 If TimeLimit Then Show(39,25,#18) Else Show(39,25,' ');
End; {Show_Status}


{...Draw Double Bar Box ...}

Procedure Box(x,y,x1,y1:integer);
Var
 i : Integer;


Begin
 For i := x+1 to x1-1 Do  Begin Show(i,y,#205); Show(i,y1,#205); End;
 For i := y+1 to y1-1 Do  Begin Show(x,i,#186); Show(x1,i,#186); End;
 Show(x,y,#201); Show(x,y1,#200); Show(x1,y,#187); Show(x1,y1,#188);
End; {Box}


{..................... Sound Effects ............................}


{...}
Procedure Alarm;
Var
 i : Integer;
Begin
 If SoundOn Then
  For i := 1 to 10 do Begin Sound(1000); Delay(100); NoSound; Delay(100); End;
End;


{...}
Procedure Beep;
 Begin If SoundOn Then Sound(440); Delay(100); NoSound; End; {Beep}

{...}
Procedure Click;
Begin
 If SoundOn Then
  Begin
   Sound(3000); Delay(5); Sound(2000); Delay(10);
   Sound(1000); Delay(5); NoSound;
  End
  Else Begin
   Window(1,1,40,25);
   Colors(White,Black); Show(39,25,#15); Delay(200);
   Colors(LightBlue,BlacK); Show(39,25,#18);
  End;
End; {Click}


{...}
Procedure Blonk;
Begin
 If SoundOn Then
  Begin Sound(440); Delay(160); Sound(330); Delay(160); NoSound; End;
End; {Blonk}


{...}
Procedure Bleep;
Begin
 If SoundOn Then
  Begin Sound(1500); Delay(20); Sound(2000); Delay(20); Nosound; End;
End; {Bleep}


{...}
Procedure Bzoop;
Var
i : Integer;
Begin
 If SoundOn Then
  For i :=210 downto 21 do Begin Sound(10*i); Delay(10); End; NoSound;
End; {Bzoop}


{...}
Procedure Buzz;
Var
 i : Integer;
Begin
 If SoundOn Then
  For i := 1 to 800 do Begin Sound(3880); Delay(1); Sound(1660); End; NoSound; End;


{...................... General Purpose Routines ..................}

{...Display Time Out Message ...}
Procedure TimeOut_Message;
 Begin
  Blonk; Window(5,21,35,23); Colors(Yellow1+Blink,Blue1); ClrScr;
  Turn_Done := True;
  Show(4,2,'You took too much time!'); Delay(1000);
End; {TimeOut_Message}



{    Return Key Value and Value of Time Out Counter .....}
Function Get_Key(Var Count : Integer):Integer;
 Var
  Key : Char;
  i,Tick : Integer;
  Flip : Boolean;


Begin
 Tick := 0; i := 0; Flip := True;
  Repeat
   Tick := Succ(Tick) Mod 3500;
   If (Tick=0) And (Count <> 999) Then
   Begin
    If TimeLimit Then Begin Count := Pred(Count); If (Count <5) Then Click;End;
    If Flip Then Begin i :=Succ(i) Mod 4; Show_Status(i); End;
    Flip := Not Flip;
   End;
  Until KeyPressed Or (Count <0);
  If Count  >=0 Then
   Begin
    Read(KBD,Key);
    If (Key = #27) And KeyPressed
     Then Begin Read(KBD,Key); Get_Key := $FF00+Byte(Key); End
     Else Get_Key := $00+Byte(Key);
   End
   Else Get_Key := 0;
End; {Get_Key}



{... Gets (Y)es or (N)o Response ....}
Function Get_YN(Stat:Boolean):Char;
Var
 Key,CountDown : Integer;
 Ch : Char;
Begin
 Repeat
  If Stat Then CountDown := 888 Else CountDown := 999;
  Key := Get_Key(CountDown);
  Case Key of
   32..127 : Ch := UpCase(Char(Lo(Key)));
   Else Ch := #0;
  End;
  If Not (Ch in ['Y','N']) Then Beep
 Until Ch in ['Y','N'];
 Get_YN := Ch;
End; {Get_YN}



{... Sets Mode to Color/Mono ...}
Procedure Set_DisplayMode(Mode : Boolean);
Begin
 Case Mode of
  True   : Begin
            Text80 := C80;  Text40 := C40;
            Blue1        := Blue;	Green1		:= Green;
	    Red1	 := Red;	Yellow1		:= Yellow;
            Magenta1	 := Magenta;    Cyan1		:= Cyan;
            LightBlue1	 := LightBlue;  LightGreen1	:= LightGreen;
	    LightRed1    := LightRed;	LightMagenta1	:= LightMagenta;
	    LightCyan1	 := LightCyan;
    End;
False : Begin
            Text80 := BW80; Text40 := BW40;
            Blue1	 := LightGray	;    Green1		:= LightGray;
	    Red1	 := White;      Yellow1		:= White;
            Magenta1	 := LightGray;  Cyan1		:= White;
	    LightBlue1   := White;      LightGreen1     := LightGray;
            LightRed1    := LightGray;	LightMagenta1   := LightGray;
            LightCyan1   := LightGray;
           End;
   End;
 TextMode(Text80);
End; {Set_DisplayMode}


{Returns String in Upper Case & Strips Extra Spaces and Illegal Chars}
Function Clean_Str(Instr:Str80):Str50;
Var
 i      : Integer;
OutStr  : Str50;
Flag    : Boolean;
Const
 Alpha : Set of Char = ['A'.. 'Z','a'..'z','-',#39];


Begin
 i := 1; Flag := True; OutStr := '';
 While i <= Length(InStr) do
  Begin
   If (InStr[i] = ' ') and Not Flag Then OutStr := OutStr + ' ';
   If InStr[i] in Alpha Then
    Begin
     OutStr := OutStr + UpCase(InStr[i]);
     Flag := False;
    End
    Else If InStr[i] = ' ' Then Flag := True;
  i := Succ(i);
 End;
If Not (OutStr[Length(outStr)] in Alpha) Then Delete(OutStr,Length(outStr),1);
Clean_Str := OutStr;
End; {Clean_Str}

{... No File Found Routine ...}
Procedure ErrorExit;
Begin
 TextMode(Text80); ClrScr;
 Colors(Red1+Blink,Black); Show(38,12,'Error!');
 Colors(red1,Black); Show(23,14,'Can not find data file, (ZAPDAT.???)');
 Alarm; Cursor(On); Halt;
End; {ErrorExit}


{... Scrolls Wheel Window One Line ...}
Procedure Scroll(FG,BG:Integer);
 Var Result : Record AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS : Integer; End;
Begin
  With Result Do
   Begin
    AX := $0700;
    AX := AX + 1;
    BX := ((BG shl 4) + (FG)) SHL 8;
    CX := ((4-1) SHL 8) + 31-1;
    DX := ((16-1) SHL 8) + 39-1;
   End;
  Intr($10,Result);
End; {Scroll}


{.... Randomizes Order of Play ....}
Procedure Randomize_List(Var List : PlayerArray;
                         Index : Integer);

Var
 i,RndNum : Integer;
 Trec     : PlayerRec;
Begin
 For i := Index downto  1 do
  Begin
   RndNum := Random(i)+1;
   TRec := List[i]; List[i] := List[RndNum]; List[RndNum] := TRec;
  End;
End; {Randomize_List}


{......................... Start Up .........................}

{.... Sets Valus for Start of Game ....}
Procedure Initialize;
Begin
 TextMode(Text80); Window(1,1,80,25);
 Colors(Yellow1,Black); ClrScr;
 Randomize;
 FillChar(playerList,SizeOf(PlayerList),#0);
 Players := 0; Current_Player :=1; Round := 1;
 SoundOn := False; TimeLimit := False;
 Cursor(Off);
End; {Initialize}


{... Sets Value for start of New Round ....}
Procedure ReStart;
Var
 i  : Integer;
 Ch : Char;
Begin
 FillChar(Game_Board,SizeOf(Game_Board), ' ');
 FillChar(Used_Letters,SizeOf(Used_Letters),#0);
 Game_Done := False; Winner := False; Peek := False;
 Misses := 0; Lines := 0;
 For i := 1 to Players do
  With PlayerList[i] do Amount := 0.0;
 Current_Player := ((Round-1) Mod Players) + 1;
 While KeyPressed Read(KBD,CH);
End; {ReStart}


{... User Inputs Player Names ...}
Procedure Get_Player_Names(Var List : PlayerArray;
                           Var Index : Integer);

Var
 Name,Tstr : Str14;
 i,RndNum : Integer;

Begin
 Cursor(Off); Window(1,1,80,25); Colors(Yellow1,Black); ClrScr;
 Colors(Cyan1,Black); Box(2,3,59,11); Window(3,4,58,10); ClrScr;
 Show(3,1,'Enter Player Names...');
 Show(5,2,'1) Up  to  four  players  may  play,  at  a time.');
 Show(5,3,'2) Each  Name  may  be  as long as 14 characters.');
 Show(5,4,'3) Enter the Name of each player , one at a time.');
 Show(5,5,'4) Press  RETURN  when  the  entry  is  complete,');
 Show(5,6,'5) If there are no more names press ENTER, again.');
 Colors(Black,LightGray); Window(1,1,80,25);
 Box(34,15,76,20); Window(35,16,75,19);
 Index := 0; Cursor(On);
 Repeat
  ClrScr; Bleep;
  Show(1,1,'Enter Player Names...');
  Show(4,3,'Player Number '+Char(Index+49) + '?');
  Buflen := 14; GoToXY(22,3);
  Read(name); Name := Clean_Str(Name);
  If Name<>'' Then
   Begin
    Index := Succ(Index);
    List[Index].Name   := Name;
    List[Index].Amount := 0.0;
    List[Index].Total  := 0.0
   End;
 Until (Name = '') Or (Index = 4);
 If Index = 0 Then Begin Index :=1; List[Index].Name := 'No Name'; End;
 Window(1,1,80,25); Cursor(Off);
 Randomize_List(List,Index);
End; {Get_Player_Name}


{... User Inputs Sound Option (On/Off ?) and
     Timer Option (On/Off?) ...}
Procedure Intro_Screen;
Var
 i,j,Kolor : Integer;
Begin
Cursor(Off); Window(1,1,80,25);
Colors(Blue1,Black); ClrScr; Kolor := Blue1;
For j := 0 to 3 do
 For i := 1 to 25 do
  Begin
   If Text80=C80
    Then Begin Kolor := (Kolor Mod 6) +1; Colors(Kolor,Black); End
    Else Colors(White,Black);
   If Not Odd(j)
    Then Show(j*20+6,i,' ZAPPO! ')
    Else Show(j*20+6,26-i,' ZAPPO!');
   End;
Colors(cyan1,Blue1); Box(51,1,80,5);
Window(52,2,79,4); ClrScr;
 Show(1,1,'During the game...');
 Show(3,2,'CTRL_S toggles Sound   ');
 Show(3,3,'CTRL_T toggles Time Limit');
 Window(1,1,80,25); Colors(Black,LightGray);
 Window(6,8,46,9); ClrScr;
 Colors(Red1,LightGray); Show(1,1,'Sound effects are now ');
 Colors(Black,LightGray);
 If SoundOn Then Write('On ') Else Write('Off ');
 Colors(Red1,LightGray); Show(2,2,'Do you want Sound Effects? (Y/N)');
 Cursor(On); Bleep;
 If Get_YN(False) = 'Y' Then SoundOn := True Else SoundOn := False;
 Window(1,1,80,25); Colors(Cyan1,Blue1); Box(12,14,80,24);
 Window(13,15,79,23); ClrScr;
 Show(1,1,'If you choose to have a time limit.....');
 Show(4,3,'1) A player  has  only a limited  amount of  response  time.');
 Show(4,4,'2) A player  loses a turn if the  response time is exceeded.');
 Show(4,5,'3) About 15 seconds are allowed to choose to spin the wheel.');
 Show(4,6,'4) Only about  10  seconds are allowed  to  choose a letter.');
 Show(4,7,'5) The last  5 seconds are then marked with an audible tick.');
 Show(4,8,'6) There  is  no  time  limit  for  typing  trial  solution.');
 Colors(Black,LightGray); Window(6,8,46,9); ClrScr;
 Colors(LightBlue,LightGray); Show(1,1,'The Time Limit is now ');
 Colors(Red1,LightGray);
 If TimeLimit Then Write('On ') Else Write('Off');
 Colors(LightBlue1,LightGray); Show(2,2,'Do you want a Time Limit? (Y/N');
 Cursor(On); Bleep;
 If Get_YN(False) = 'Y' Then TimeLimit := True Else TimeLimit :=False;
End; {Intro_Screen}


{...Loads Four Puzzles (for one Round) ...}
Procedure Get_PuzzleSet;
Var
 Index,Size,RndNum,i,j : Integer;
 TStr                  : Str80;
 FileSet  : Array[0..9] of Str14;
 Name     : Str14;
 RndNumSet: Array[1..4] of Integer;
 BadNum   : Boolean;

Begin
 Index := 0;
 For i := 0 to 9 do
 Begin
  Name := 'ZapDat.00' + Char(i+48);
  Assign(DiskFile,Name);
  {$I-} Reset(DiskFile); {$I+}
  If IOResult = 0 Then
   Begin Close(DiskFile); FileSet[Index] := Name; Index := Succ(Index);End;
 End;
 If Index = 0
 Then ErrorExit
 Else
  Begin
   RndNum := Random(Index);
   Size := 0;
   Assign(diskFile,FileSet[RndNum]);
   Reset(DiskFile);
{ >>> Count Lines of Text in the File <<< }
    While Not EOF(DiskFile) do
      Begin Size := Succ(Size); ReadLn(DiskFile,TStr); End;
    Close(DiskFile);

{ >>> Now get four unique random numbers <<< }
    FillChar(RndNumSet,8,#0);
    For i := 1 to 4 do
     Begin
      Repeat
       BadNum := False;
       RndNum := Random(Size)+1;
       For j := 1 to i-1 Do If RndNum = RndNumSet[j] Then BadNum := True;
      Until Not BadNum;
      RndNumSet[i] := RndNum;
     End;


{ >>> Them locate a record (line of text) corresponding to each of these }
   For j := 1 to 4 do
    Begin
     Reset(DiskFile);
     For i := 1 to RndNumSet[j] do ReadLn(DiskFile,Puzzle_Set[j]);
     Close(DiskFile);
    End;
  End;
End; {Get_PuzzleSet}



{... Displays General Information .....}
Procedure Facts;
Var
 Num,i : Integer;

Begin
 Window(1,1,80,25); Colors(White,Black); ClrScr; Cursor(Off);
 Colors(White,Black); Box(1,1,31,3); Show(6,2,'Welcome to Zappo!'); Bleep;
 Colors(LightMagenta1,Black); Box(5,5,28,7);
 Show(7,6,'Four Rounds per Game'); Bleep;
 Colors(Yellow1,Black); Box(40,4,72,6);
 If Players=1
  Then Show(42,5,'Only one player this game.')
  Else Show(42,5,'Up to four players may play.');
 Bleep; Colors(Cyan1,Black); Box(9,8,70,10);
 If Players=1
  Then Show(12,9,'One player gets five turns in which to solve the puzzle.')
  Else Show(12,9,'Zappo! is a Super - Duper version of Hangman.');
  Bleep; colors(Green1,Black); Box(57,12,80,17);
  Show(60,13,'A   Point   Wheel');
  Show(60,14,'has  been   added');
  Show(60,15,'to  introduce  an');
  Show(60,16,'element of chance');
  Colors(LightBlue1,Black); Box(2,12,30,18);
  If Players=1
   Then Show(5,13,'On each of your turns,')
   Else Show(5,13,'When it is your turn,');
  Show(5,14,'you may choose to:');
  Show(7,15,'Spin the Point Wheel');
  Show(7,16,'Solve the puzzle');
  Show(7,17,'End the Game'); Bleep;
  Colors(Magenta1,Black); Box(34,14,52,18);
  Show(37,15,'Win Points');
  Show(37,16,'From 100');
  Show(37,17,'To 1000'); Bleep;
  Colors(Yellow1,Black); Box(31,19,80,22);
  Show(33,20,'You may....');
  Show(33,21,'Win a Free Turn -- Loose a Turn -- Zappo!'); Bleep;
  Colors(LightRed1,Black); Box(5,20,19,22);
  Show(8,21,'Good Luck!'); Bleep;
  Colors(White,Black); Box(21,23,56,25);
  Show(25,24,'*** Press Key to Continue ***'); Bleep;
  Repeat Num := Random(999); Until KeyPressed;
  Cursor(Off);
  Bleep; Window(1,1,80,25); Colors(White,Black); ClrScr;
  For i  := 1 to 25 do
   If Odd(i) Then
    Begin
     If Odd(i Div 2) Then Colors(LightBlue1,Black) Else Colors(White,Black);
     Show(1+(i*38) Div 25,i,'*** P A T I E N C E   P L E A S E ***');
   End;
End; {Facts}



{........ Routines Used While the Game is Running ...........}


{... Re-arrange current puzzle so that words can be placed symmetrically }
Procedure Get_Game_Board(Answer    : Str50;
                         Var Board : GameArray;
                         Var Line  : integer);
Var
 TLine, TStr          : Str50;
 i, Offset,Place,Index : Integer;


Begin
 Tstr := Answer; TLine := ''; Index := 1; Line := 0; Place := 0;
 Repeat
  If TStr[Index] = ' ' Then Place := Index;
  Index := Succ(Index);
  If (Index > 25) Or (Index >= Length(TStr)) Then
   Begin
    If (Place = 0) Or (Index >= Length(TStr))
    Then TLine := Tstr
    Else Begin
     Tline := Copy(TStr,1,Place-1);
     TStr  := Copy(TStr,Place+1,Length(TStr));
     Place := 0; Index := 1;
    End;
   Offset := (27-Length(tLine))Div 2;
   For i := 1 to Offset Do Tline := ' ' +TLine;
   Line := Succ(Line);
   Move(TLine[1],Board[Line],Length(TLine));
  End;
 Until Index >= Length(TStr);
End; {Get_Game_Board}


{... Display the Game Board ...}
Procedure Show_Board(Board : GameArray; Lines : Integer);
Var
 x,y : Integer;

Begin
 Colors(Cyan1,Blue1);
 For y := 10 to (Lines-1)*2+12 Do For x := 1 to 27 Do Show(x,y,'1');
 Box(1,9,28,(Lines -1)*2+13);
 For y := 1 to Lines Do
  Begin
   For x := 1 to 27 Do
    If Game_Board[y,x] <> ' ' Then
     If Game_Board[y,x] In ['-',#39]
     Then Begin Colors(Yellow1,Black); Show(x+1,2*(y-1)+11,Game_Board[y,x]); End
     Else Begin Colors(Blue1,Black); Show(x+1,2*(y-1)+11,'.'); End;
  End;
 Colors(White,Black); Show(1+(27-Length(Category)) Div 2,9,Category);
End; {Show_Board}



{...Draw the Point Wheel ...}
Procedure Make_Wheel;
Var
 Kolor,i : Integer;
Const
 Values : Array[1..13] of Integer =
           (700,200,400,700,600,200,350,1000,1000,500,250,100,300);

Begin
 Colors(LightCyan1,Black); Box(30,3,40,17);
 Colors(White,Black); Show(30,10,#16); Show(40,10,#17);
 Colors(LightBlue,Cyan1); Show(32,3,' Point '); Show(32,17,' Wheel ');
 Window(31,4,39,17); GoTOXy(1,1);
 For i := 1 to 13 Do
  Begin
   If Text80 = C80
    Then Kolor := ((Values[i] Div 100) Mod 6) +1
    Else Kolor := LightGray;
   Colors(Black,Kolor); Write(#177,#177);
   Colors(White,Kolor); Write(Values[i]:4,' ');
   Colors(Black,Kolor); Write(#177,#177);
  End;
 Colors(White,Black);    Show(1,4,'  Zappo!  ');
 Colors(Black,LightGray); Show(1,8,'Free Turn');
End; {Make_Wheel}



{... Display Playing Screen ... }
Procedure Show_Playing_Screen(Problem : Str80);
Var
 Place : Integer;
 Ch : Char;
Begin
 TextMode(Text40); Window(1,1,40,25); Colors(Yellow1,Black); ClrScr;
 Cursor(Off);
 Colors(Yellow1,Black); Show(17,1,'Zappo! ');
 Colors(LightBlue1,Black); Show(1,1,'Round'); Write(Round:3);
 Show_Status(1);
 Place     := Pos('/',Problem);
 Answer    := Copy(Problem,Place+1,Length(Problem));
 Answer    := Clean_Str(Answer);
 Category  := Copy(Problem,1,Place-1);
 Category  := Clean_Str(Category);
 Get_Game_Board(Answer,Game_Board,Lines);
 Show_Board(Game_Board,Lines);
 Colors(Blue1,Black);
 For Ch := 'A' to 'Z' Do  Show(7+Ord(Ch)-65,25,Ch);
 Make_Wheel;
End; {Show_Playing_Screen}



{... Guess a Letter in the Puzzle .... }
Procedure Get_Letter(Var Letter:Char;
                         Var Lose:Boolean);
Const
 CharSet : Set Of Char = ['A'..'Z'];
 CountDown : Integer = 10;
Begin
 Window(5,21,35,23); Colors(yellow1,Blue1);
 Letter := #0; CountDown := 10;
 Show(2,3,'Pick a Letter...');
 Colors(Yellow1+Blink,Blue1); Write('?');
 Repeat
  Letter := UpCase(Char(Lo(Get_key(CountDown))));
  If (CountDown <0) And TimeLimit
  Then Begin Lose := False; If Not (Letter in CharSet) Then Beep; End;
 Until (Letter in CharSet) Or Lose;
End; {Get_Letter}


{... See if Letter is in Puzzle ...}
Procedure Process_Letter(Ch : Char;
                         Var Winners : Integer);
Var
 x,y : Integer;

Begin
 Window(1,1,80,25);
 Winners := 0;
 If Used_Letters[Ch] Then Begin Beep; Exit End;
 Used_Letters[Ch] := True;
 Colors(White,Black); Show(7+Ord(Ch)-65,25,Ch);
 For y := 1 to Lines Do
   For x := 1 to 27  Do
   If Game_Board[y,x] = Ch Then
    Begin
     Winners := Succ(Winners); Game_Board[y,x] := #$FF;
     Colors(Yellow1,Black);  Show(x+1,2*(y-1)+11,Ch);
     Bleep; Delay(250);
    End;
End; {Process_Letter}


{ ... See if Puzzle is solved or only Vowels remain ...}


Function Whats_left : Integer;
Var
 x,y : Integer;
 AllVowels,NoLetters : Boolean;
Const
 Vowels : Set of Char = ['A','E','I','O','U'];
 Consonant : Set of Char = ['B'..'D','F'..'H','J'..'N','P'..'T','V'..'Z'];
Begin
 AllVowels := True; NoLetters := True;
 For y := 1 to Lines Do
   For x := 1 to 27 Do
    Begin
     If Game_Board[y,x] In Consonant Then AllVowels := False;
     If Game_Board[y,x] In Consonant + Vowels Then NoLetters := False;
    End;
 If AllVowels and Noletters
  Then Whats_Left := 2
  Else If AllVowels
   Then Whats_Left := 1
   Else Whats_Left := 0
End; {Whats_Left}


{...Make Wheel Spin and Get Result...}
Procedure Spin_Wheel(Var Prize : Integer);
Var
 RandNum,Target,i,j,Kolor : Integer;


Const
 Wheel : Array[0..24] of Integer = (700,200,400,-999,600,200,350,1000,-1,
			            500,250,100,300,0,200,300,100,800,0,
                                    400,100,300,150,-1,900);
Index : Integer = 0;

Begin
 Window(1,1,40,25); Colors(Yellow1+Blink,Black);
 Show(30,10,#16); Show(40,10,#17);
 Window(31,4,39,16); Colors(Red1,LightGray);
 RandNum := Random(25) +1;
 For i := RandNum+25 DownTo 1 Do
  Begin
   If i<21 Then Delay((21-i) * 6) Else Delay(5);
   Beep;
   Index := (Index+1) Mod 25; Target := (Index+19) Mod 25;
   Scroll(Red1,LightGray);
   GoToXy(1,1);
     Case Wheel[Index] of
      100..1000 : Begin
                   If Text80 = C80
                    Then Kolor := ((Wheel[Index] Div 100) Mod 6) +1
                    Else Kolor := LightGray;
                   Colors(Black,Kolor); Write(#177,#177);
                   Colors(White,Kolor); Write(Wheel[Index]:4,' ');
                   Colors(Black,Kolor); Write(#177,#177);
	          End;
      0         : Begin Colors(Black,LightGray); Write('Free Turn'); End;
      -1        : Begin Colors(Red1,LightGray); Write('Lose Turn'); End;
      -999      : Begin Colors(White,Black); Write('  Zappo!  '); End;
    End;
  End;
 Prize := Wheel[Target];
 Window(1,1,40,25); Colors(White,Black);
 Show(30,10,#16); Show(40,10,#17);
End; {Spin_Wheel}


{...Route Course of Program, Based on Result of Wheel Spin ...}
Procedure Process_Spin(Var Lose : Boolean);
Var
 Letter : Char;
 Hits,Kolor,Prize : Integer;
Const
 Vowels : Set of Char = ['A','E','I','O','U'];
 Free_Spin = 0;
 Lose_Turn = -1;
 Zappo     = -999;
Begin
 Spin_Wheel(Prize); Delay(1000);
 Window(5,21,35,23); Colors(Yellow1,Blue1); ClrScr;
 Case Prize of
  Free_Spin : Begin
               With PlayerList[Current_Player] Do FreeSpin := Succ(FreeSpin);
               Colors(Black+Blink,LightGray); Show(11,1,' Free Turn ');
               Bleep; Delay(1000);
             End;
 Zappo   :  With PlayerList[Current_Player] Do
             Begin
              Colors(White+Blink,Black); Show(11,1,' Zappo! ');
              Delay(250); Bzoop; Delay(1000); 
              Amount := 0.0; Lose := True;
              Show_Status(1);
             End;
  Lose_Turn : Begin
               Colors(Red1+Blink,LightGray); Show(11,1,' Lose Turn ');
               Delay(250); Bzoop; Delay(1000); Lose := True;
              End;
 100..1000 : Begin
              Show(9,1,'Points = ');
	      If Text80 = C80
              Then Kolor := ((Prize Div 100) Mod 6)+1
              Else Kolor := Black;
             Colors(White+Blink,Kolor); Write(#16);
	     Colors(White,Kolor); Write(Prize:4,' ');
             Colors(White+Blink,Kolor); Write(#17);
             Get_Letter(Letter,Lose);
	     Process_Letter(Letter,Hits);
	     If (Letter in Vowels) And (Hits>0) Then
              Begin
               Window(5,21,35,23); Colors(Yellow1,Blue); ClrScr;
               Bleep; Show(6,1,'No Points for Vowels');
               Delay(5000); Prize := 0;
             End;
           If Hits=0
            Then Lose := True
            Else With PLayerList[Current_Player] Do
              Begin
               Lose := False; Amount := Amount+Hits*Prize;
               Show_Status(1);
              End;
            End;
   End; {Case}
End; {Process_Spin}



{...Get Answer to Puzzle From the Player...}
Procedure Solve(Var Winner:Boolean);
Var
 TStr : Str50;


Begin
 Window(5,21,35,23); Colors(Yellow1,Blue1); ClrScr;
 Cursor(On); Show(1,1,'Enter Answer...');
 Colors(Black,LightGray);
 GoToXy(1,3); ClrEol; GoToXy(1,2); ClrEol;
 BufLen := 50; Read(TStr); TStr := Clean_Str(TStr);
 If TStr = Answer
  Then Winner := True
  Else 
   Begin 
    Winner := False;
    GoToXy(1,3); ClrEol; GoToXy(1,2); ClrEol;
    Show(1,2,TStr); Bzoop; Delay(4000);
   End;
 Cursor(Off);
End; {Solve}


{...Display Correct Answer...}
Procedure Show_Answer;
Var
 x,y : Integer;
Begin
Window(1,1,40,25);
 For y := 1 to Lines Do
  For x:= 1 to 27 Do
   If Not( Game_Board[y,x] in [' ',#$FF]) Then
    Begin Colors(Yellow1,Black); Show(x+1,2*(y-1)+111,Game_Board[y,x]); End
End; {Show_Answer}


{...End of Turn...}
Procedure Next_Player;
Var
 i : Integer;
Begin
 Window(5,21,35,23); Colors(Yellow1,Blue1); ClrScr;
 If SoundOn
  Then Buzz
  Else Begin Show(7,1,'Your Turn is Over'); Delay(1000); End;
If PlayerList[Current_Player].FreeSpin >0 Then
 Begin
  Show(1,3,'Use a Free Turn? (Y/N)...');
  If Get_YN(True) = 'Y' Then
  Begin
   Misses := Pred(Misses);
   Turn_Done := False;
   With PlayerList[Current_Player] Do FreeSpin := Pred(FreeSpin);
  End
  Else Current_Player := (Current_Player Mod Players) +1;
End
Else Current_Player := (Current_Player Mod Players) + 1;
Misses := Succ(Misses);
If (Misses >=5) And (Players = 1) Then
 Begin
  Bzoop; ClrScr;
  Show(2,1,'That is Five Misses, too Bad!');
  Show(6,3,'Better Luck Next Time');
  Round_Done := True; Turn_Done := True;
  Show_Answer; Delay(3000);
 End;
If Players = 1 Then
 Begin
  Window(1,1,40,25); Colors(White,Black); GoTOXY(30,1);
  For i := 1 to Misses Do Write(#251);
 End;
End; {Next_Player}


{...Display Message for Correct Answer...}
Procedure Announce_Winner;
Begin
 With PlayerList[Current_Player] Do
  Begin
   If Amount<200.0 Then Amount := 200.0;
   Total := Total+Amount; Final := + Amount;
   Show_Answer; Show_Status(0);
   Round_Done := True;
   Window(5,21,35,23); Colors(Yellow1+Blink,Red1); ClrScr;
   Show(13,1,'Correct!'); Colors(Yellow1,Red1);
   Show(9,2,'You are a Winner!');
   Alarm; Delay(3000);
  End;
End; {Announce_Winner}



{..Handle Activity Associated With a Player's Turn...}
Procedure Take_Turn(Var Winner:Boolean);
Var
 i,Key         : Integer;
Const
 CountDown     : Integer = 15;
 NotYet    = 0;
 AllVowels = 1;
 Solved    = 2;


Begin
 Turn_Done := False; CountDown := 15;
 Window(1,1,40,25);
 Colors(Cyan1,Blue1); Box(4,20,36,24);
 Repeat
  Window(1,1,40,25); Colors(White,Black);
  With PlayerList[Current_Player] Do
   Begin
    Show(4,19,'Player... '+Name+'  '); ClrEol;
    For i :=  1 to FreeSpin Do Write(#1);
   End;
  Window(5,21,35,23); Colors(Cyan1,Blue1); ClrScr;
  Case Whats_left of
   NotYet    : Begin
                Show(1,1,'Options...');
                Show(4,2,'F1 Spin'); Show(20,2,'F9 Solve');
                Show(10,3,'CTRL-Q Quit');
                If Not  TimeLimit Then CountDown := 15;
                Key := Get_Key(CountDown);
                If (CountDown <0) And TimeLimit Then TimeOut_Message
                 Else Case Key of
                  F1     : Begin Process_Spin(Turn_Done); CountDown :=15; End;
                  F9     : Begin Solve(Winner); Turn_Done := True; End;
            Give_Up: Begin
                      Show_Answer; Peek := True; Delay(1000); Round_Done := True
                    End;
            CTRL_Q : Begin 
                      Turn_Done := True; Round_Done := True;
                      Game_Done := True;
                    End;
            CTRL_T : Begin
                      TimeLimit := Not TimeLimit; Show_status(1); 
                     End;
            CTRL_S : Begin SoundOn := Not SoundOn; Show_Status(1); End;
            Else Beep;
         End; {Case}
      End; {Not_Yet}
AllVowels : Begin
             Alarm; Window(1,1,40,25);
             Colors(Red1,Blue1); Show(15,20,'Vowels only '); Delay(1000);
             Solve(Winner); Turn_Done := True;
           End;
 Solved   : Begin
             Colors(Yellow1,Blue1); Show(12,2,'That is it '); Delay(1000);
             Winner := True; Turn_Done := True;
            End;
 End; {Case What's Left}
Until Turn_Done or Peek
End; {Take_Turn}


{...Ask if Player wants to start another Game...}
Function Do_Again : Boolean;
Var
 i,Dly : Integer;
Begin
 Window(5,21,35,23); Colors(Yellow1,Blue1); ClrScr;
 Show(2,2,'Play another game? (Y/N)...');
 Colors(Yellow1+Blink,Blue1); Write('?');
 If Get_YN(true) = 'Y' Then
  Begin
   Window(5,21,35,23); Colors(Yellow1,Blue1);
   ClrScr; Show(4,1,'Do not go away,');
   Show(8,2,'I`ll be right back');
   Get_PuzzleSet; Do_Again := True;
   For i := 1 to Players Do PlayerList[i].Total := 0.0;
   Randomize_List(PlayerList,PLayers);
  End
  Else Do_Again := False;
  End; {Do_Again}



{...Randomize the Order of Play...}
Procedure ReOrder_List;
Var
 i       : Integer;
 Trec    : PlayerRec;
 Flipped : Boolean;
Begin
 Repeat
  Flipped := False;
  For i := 1 to Players-1 Do
    If PlayerList[i].Final <PlayerList[i+1].Final Then
     Begin
      TRec  := PlayerList[i]; PlayerList[i] := PlayerList[i+1];
      PlayerList[i+1] := Trec;
      Flipped := True;
    End;
 Until Not Flipped;
End; {ReOrder_List



{...Show Point Summary for Session...}
Procedure Show_Grand_Total;
Var
 i : Integer;
Begin
 ReOrder_List;
 Show(7,2,'Gand Totals This Session');
 Colors(Green1,Black); Show(6,4,'Name'); Show(22,4,'Points');
 Colors(LightRed1,Black);
  For i := 1 to Players Do
   Begin
    GoToXY(4,5+i); Write(PlayerList[i].Name);
    GoToXy(20,5+i); Write(PlayerList[i].Final:8:0);
   End;
  Delay(1000);
 End; {Show_Grand_Totals}



{***   ..........  ** Begin Main Program ** ............   *** }

Begin
 ColorOn:= True;                     {Default Display Mode}
 If ParamCount > 0 Then
  Begin                             {Check Command Line for}
   TStr := ParamStr(1);             {argument              }
   If UpCase(TStr[i])='M' Then ColorOn := False;
  End;
 Set_DisplayMode(ColorOn);
 Initialize;                         {Set values for start-up}
 Intro_Screen;                       {Sound On?   Time Limit?}
 Get_Player_Names(PlayerList,Players); {Get Names of Players}
 Facts;                                 {Display Intro Screen}
 Get_PuzzleSet;                         {Read 4 Puzzles from Disk}
 Restart;                               {Set Values for New Game}
 Repeat
  Problem := Puzzle_Set[Round];       {Get next Puzzle from Array}
  Show_Playing_Screen(Problem);       {Display Main Screen}
  Repeat
   Round_Done := False;
   Take_Turn(Winner);                 {Start next player's turn}
   If Not (Game_Done or Peek) Then    
    If Winner                         {That Turn is over. Was it}
     Then Announce_Winner             {a winner?                }
     Else Next_Player;                {If not go to next Player }
  Until Round_Done;                   
  Round := Succ(Round);
  Show_Status(1);                     {Show Round Totals        }
  If (Round > 4) And Not Game_Done    {See if user wants        }
       Then If Do_Again Then Round := 1;      {to play again    }
  If Not Game_Done Then Restart
 Until (Round > 4) or Game_Done;
 TextMode(Text40); Window(1,1,40,25); ClrScr; {The game is over}
 Colors(Yellow1,Black);                       {      so        }
 If Players >1 Then Show_Grand_Total;   {Show                  }
 Colors(White,Black);                   {        summary       }
 Show(4,2,'Thanks for Playing Zappo!   '); {              then    }
 Delay(1000);                           {                  exit}
 Show(7,20,'*** Press Key to exit ***'); { Gracefully....       }
 Repeat Until KeyPressed;
 TextMode(Text80); ClrScr;
 Cursor(On);
End.
