procedure RoomDescriptionsOne;
{written by W. Jeffrey Wilson & lynne ostergren,
            Department of Psychological Sciences,
            Indiana University - Purdue University at Fort Wayne,
            2101 Coliseum Boulevard East,
            Fort Wayne, IN  46805.
copyright, 1985 by Purdue Research Foundation, West Lafayette, Indiana 47907.
                    All Rights Reserved.  Unmodified copies of this program
                    may be freely distributed.  Each copy must contain this
                    notice.}

begin
case Loc of
LateralVentricle: begin
writeln('This cavernous space is filled with cerebrospinal fluid, flowing medially');
writeln('toward a small opening.  As you are carried by this flow, you notice a dorsal');
writeln('passage that looks promising.');
       end;
ThirdVentricle: begin
writeln('In this narrow fluid-filled chamber you are being carried rapidly in a');
writeln('caudal direction.  The thalamus looms large on either side of you, while');
writeln('ventrally you can make out nuclei of the hypothalamus.');
       end;
CerebralAqueduct: begin
writeln('This is a narrow passageway connecting the third and fourth ventricles.');
writeln('The flow of cerebrospinal fluid is carrying you caudally quite rapidly!');
writeln('You are surrounded by a gray region.');
       end;
FourthVentricle: begin
if PillWorking = 0 then begin
writeln('WARNING! WARNING! You are in the fourth ventricle! Do not proceed caudally');
writeln('without your anti-immune system pill.  Without it, you will be devoured by');
writeln('the phagocytes and white blood cells of the immune system!');
end;
writeln('This is a large space filled with cerebrospinal fluid.  The cerebellum towers');
writeln('above you, and several structures are apparent ventrally.');
       end;
Foramen: begin
if PillWorking = 0 then begin
writeln('DANGER! DANGER! You must take an anti-immune system pill NOW!');
end;
writeln('The cerebrospinal fluid is surging through this small opening into the');
writeln('subarachnoid space.  You will soon begin your journey back to the heart.');
       end;
SubArachnoid: begin
writeln('You are being swept forcefully toward an arachnoid villus, and a reunion');
writeln('with the blood supply.');
if PillWorking = 0 then begin
writeln('You failed to take an anti-immune system pill, and now time has run out!');
end;
       end;
CaudateHead: begin
writeln('This large forebrain structure is a major component of the extrapyramidal');
writeln('motor system and, with the putamen, makes up the corpus striatum.  You were');
writeln('able to enter the caudate by way of the nigrostriatal bundle because you were');
writeln('carrying dopamine. The structure narrows considerably in the caudal');
writeln('direction, but there appears to be an opening there.');
       end;
CaudateTail: begin
writeln('This narrow tail of the caudate is quite slippery, and the footing is very');
writeln('treacherous.  The tail curves laterally and ventrally out of view in a caudal');
writeln('direction.');
       end;
Amygdala: begin
writeln('This structure is often grouped with both the basal ganglia and the limbic');
writeln('system.  It probably subserves aggression or rage.  Passages lead caudally');
writeln('and medially.');
       end;
Putamen: begin
writeln('The putamen is a component of the corpus striatum and the lentiform nucleus.');
writeln('A large number of myelinated fibers make up the roof, and provide easy ');
writeln('handholds for an exit in that direction.  A soft white glow enters the');
writeln('room from the medial direction.');
       end;
Pallidum: begin
writeln('This extrapyramidal structure, together with the more lateral putamen, makes');
writeln('up the lentiform nucleus.  The lentiform nucleus and corpus striatum together');
writeln('make up the major telencephalic component of the basal ganglia.  The ceiling');
writeln('here is composed of large myelinated fibers, perfect for climbing.  A small,');
writeln('almost invisible passage leads in a medial direction.');
       end;
Nigra: begin
writeln('This darkly pigmented area produces much of the dopamine found in the brain.');
writeln('A long, twisting passageway leads in a rostral direction, and you can see a');
writeln('myelinated highway ventral to your current location.  A wet, gray region');
writeln('lies dorsal to you.');
       end;
InternalCapsule: begin
writeln('You are on a heavily myelinated highway that originates somewhere dorsal to');
writeln('your present position, and extends caudally as far as you can see.  Passages');
writeln('extend laterally and ventrally.');
       end;
CerebralPeduncle: begin
writeln('The heavily myelinated highway that you find yourself on extends both');
writeln('rostrally and caudally.  A dark cluster of cell bodies is apparent dorsally.');
       end;
NigroStriatalBundle: begin
writeln('This caudal-rostral pathway runs from the substantia nigra to the caudate');
writeln('nucleus, bringing dopaminergic fibers from the midbrain to the forebrain.');
       end;
Thalamus: begin
writeln('Welcome to a major relay station of your brain.  Afferent pathways on their');
writeln('way to the cortex synapse here, as do efferent fibers leaving the cortex.');
writeln('Passages extend away from you in all directions except dorsally and rostrally.');
       end;
Pons: begin
writeln('This mesencephalic landmark contains many groups of cell bodies, as well as');
writeln('fibers that extend to the cerebellum.  The corticospinal fibers that make up');
writeln('the cerebral peduncles rostrally continue through the pons and extend');
writeln('caudally.  A narrow bundle of fibers extends dorsally, and you can see a');
writeln('group of cells in the medial direction.');
       end;
Medulla: begin
writeln('This primitive part of the brain, in the myelencephalon, controls vegetative');
writeln('processes essential to life.  The sound of running water is quite strong');
writeln('dorsally, This region nears the end of a long rostral-caudal highway, and you');
writeln('can see some fibers decussating caudally.  A passage leads medially.');
       end;
Raphe: begin
writeln('This midline group of cell bodies forms the core of both the pons and the');
writeln('medulla.  For some reason, you feel quite drowsy.');
       end;
LateralLemniscus: begin
writeln('These myelinated fibers form part of the auditory pathway.  You hear sounds');
writeln('that seem to originate in a medial direction.  A small hill rises on the');
writeln('rostral horizon.  A narrow pathway leads caudally.');
       end;
VentralNoradBundle: begin
writeln('This caudal-rostral pathway consists of noradrenergic fibers that lead from');
writeln('the locus coeruleus in the pons to the forebrain.');
       end;
InferiorColliculus: begin
writeln('You are on a small hill in the auditory system.  This structure forms part');
writeln('of the tectum, the roof of the mesencephalon.  You can move rostrally,');
writeln('caudally, or ventrally.');
       end;
MedialGeniculate: begin
writeln('This auditory relay nucleus is located at the caudal end of the thalamus.');
writeln('A path radiates laterally from this point, and a small hill can be seen');
writeln('caudally in the distance.');
       end;
TrapezoidBody: begin
writeln('This brainstem nucleus is the most peripheral part of the auditory system');
writeln('that you can enter.  There is no obvious exit.');
       end;
PeriAqueductalGray: begin
writeln('This region surrounding the cerebral aqueduct plays a role in the modulation');
writeln('of pain.  Electrical stimulation of this area produces profound analgesia.');
writeln('A large hill rises rostrally, a small hill dorsally, a dark group of cells');
writeln('lies ventrally, and a path leads caudally.  You hear rapidly flowing fluid');
writeln('in the medial direction.');
       end;
AuditoryCx: begin
writeln('Whirr - TICKTOCK - Meeoowwww - TraLaLaLa - CRASH - "Fourscore and seven years"');
writeln('Voices, music, and every imaginable sound envelope you.  Words seem quite');
writeln('loud in both the dorsal and caudal direction, and a bundle of fibers');
writeln('extends medially.  The landscape is hazy in the rostral direction.');
       end;
SuprachiasmNuc: begin
writeln('This small structure is thought to be involved in the regulation of circadian');
writeln('rhythms.  You can see the optic chiasm ventrally.');
       end;
Pituitary: begin
writeln('Also known as the hypophysis, this endocrine organ is often called the');
writeln('"master gland" of the body.  Under the control of the hypothalamus, it ');
writeln('secretes a variety of hormones.  There is no obvious way out.');
       end;
Pyramids: begin
writeln('Here fibers of the corticospinal tract cross to opposite sides of the');
writeln('brainstem before descending to terminate in the spinal cord.  There is no');
writeln('obvious way out.');
       end;
CingulateGyrus: begin
writeln('This band of limbic cortex allows passage in all directions except medially');
writeln('and caudally.');
       end;
OpticTract: begin
writeln('This bundle of fibers carries visual infomation caudally to the lateral');
writeln('geniculate nucleus in the thalamus.  The fibers appear to decussate somewhat');
writeln('rostrally to here.  A large hill is barely visible in the ventral distance.');
       end;
OpticChiasm: begin
writeln('Optic nerve fibers from the nasal half of each retina cross here on their way');
writeln('to the lateral geniculate nucleus via the optic tracts.  A large bundle of');
writeln('fibers extends caudally, and a small path leads dorsally.');
       end;
LateralGeniculate: begin
writeln('Visual information is relayed caudally from this point to the occipital lobe');
writeln('of the cortex.  The optic tract enters from a rostral direction, and the rest');
writeln('of the thalamus lies medial to your current position.  A large hill is just');
writeln('apparent in a ventral direction.');
       end;
SuperiorColliculus: begin
writeln('This large hill, together with the inferior colliculus, forms the tectum, the');
writeln('roof of the mesencephalon.  The superior colliculus is involved in visual');
writeln('tracking and reflexive eye movements.  A steep path descends ventrally into');
writeln('a nondescript, gray region.  Other passages lead both dorsally and rostrally.');
       end;
OpticRadiation: begin
writeln('This pathway conveys visual information from the lateral geniculate nucleus');
writeln('to the visual cortex in the occipital lobe.');
       end;
VisualCx: begin
writeln('Lights, colors, forms, shapes and patterns of every conceivable shade, hue');
writeln('and brightness dance around you.  This is the cortical area concerned with');
writeln('visual information processing.  There is no obvious way out.');
       end;
Septum: begin
writeln('This limbic system structure seems to inhibit rage or emotionality, for');
writeln('lesioning it produces the "septal rage" phenomenon in rats.');
writeln('A tunnel leads laterally, and other paths lead dorsally and caudally.');
       end;
MammillaryBody: begin
writeln('This hypothalamic region is implicated in both emotionality and sexual');
writeln('behavior.  An intriguing road lies dorsally, and a narrow path rostrally.');
writeln('Moving medially causes intense hunger pangs.');
       end;
Hippocampus: begin
writeln('Memories well up within you in this structure that is thought to play a role');
writeln('in memory consolidation.  A myelinated pathway leads medially, and a small');
writeln('passageway leaves in a rostral direction.');
       end;
Fornix: begin
writeln('This band of fibers interconnects the hippocampus, septal area, and');
writeln('mammillary bodies of the hypothalamus.  The fibers extend ventrally,');
writeln('rostrally, and laterally.');
       end;
VMN: begin
writeln('You feel quite satiated within this hypothalamic nucleus, felt to play a role');
writeln('in the inhibition of food intake.  Moving laterally gives rise to feelings of');
writeln('hunger, while ventral movement gets your hormones flowing.');
       end;
LHA: begin
writeln('Severe hunger grips you here, but it seems to subside as you approach a');
writeln('medial passage.  A large structure looms above you, and a passageway leads');
writeln('caudally.');
       end;
SensoryStrip: begin
writeln('Shocks race through you, fingers caress you, pins prick at you, and feathers');
writeln('brush your skin here in the cortical area that mediates somatosensation.');
writeln('There is some movement rostrally, and the terrain slopes downward medially.');
writeln('In the caudal direction, things are somewhat hazy.');
       end;
MotorStrip: begin
writeln('Voluntary motor control resides here, exerting its influence via the bundle');
writeln('of fibers descending ventrally below you.  You can move in all directions');
writeln('except dorsally.');
       end;
FrontalLobe: begin
writeln('This region of the cortex is concerned primarily with motor control and');
writeln('planning, but is also implicated in various aspects of that nebulous feature');
writeln('of us all, our personality.  You can move both caudally and medially.');
       end;
Brocas: begin
writeln('This area of the frontal lobe plays an important role in speech production.');
writeln('Faint sounds originate ventrally, and you sense movement medially.  An');
writeln('important area seems to lie caudal to this, but its name escapes you.');
       end;
Wernickes: begin
writeln('You know what this place is, but you cannot find the words to name it.  It');
writeln('is involved in speech, you think.  Several passageways lead out of this area,');
writeln('but you cannot think of the names of the directions in which they lead.');
       end;
AssocCx: begin
writeln('Recollections dance around you here.  You hear music that reminds you of a');
writeln('place that you once visited.  You met someone there, and can see her face.');
writeln('The way out is none too clear, and your memories haunt you.');
       end;
Accumbens: begin
writeln('This region, poised between the limbic system and the basal ganglia, is');
writeln('thought to allow emotions to gain access to the motor system.  The only way');
writeln('out is laterally, the way you came in.');
       end;
Cerebellum: begin
writeln('This delicately structured "small brain" sits atop your brainstem, and');
writeln('controls coordinated movements.  It may also play a role in learning.  The');
writeln('sound of flowing liquid is quite loud ventrally.');
       end;
Assoc1: begin
writeln;
writeln('This is a different region of the association cortex.');
       end;
Assoc2: begin
writeln;
writeln('This part of the association cortex is different from the one you just left.');
       end;
Assoc3: begin
writeln;
writeln('Association cortex all looks alike, yet this looks different somehow.');
       end;
Assoc4: begin
writeln;
writeln('You seem to be free associating.');
       end;
Assoc5: begin
writeln;
writeln('You must like this part of your brain.');
       end
end;
end;