;Demonlord's Music Construction Set Interrupt handler version 1.05
;(demonlord@swipnet.se)
;
;Compile in TASM with /m5 parameter...

jumps
.model small
.code
start:

mov cs:pspseg,es

push cs
pop ds
lea dx,mess
mov ah,9
int 21h                      ;print message

mov ax,3516h
int 21h
mov word ptr oldint16,bx     ;save old int 16 handler
mov word ptr oldint16+2,es

mov es,cs:pspseg
mov bx,81h
checkparam:                  ;check for parameters
cmp byte ptr es:[bx],0dh
je noparam                   ;none found, hook INT 16
cmp byte ptr es:[bx],20h
jne paramfound               ;parameter found, skip INT 16 hook
inc bx
jmp checkparam               ;check more...

paramfound:                  ;this is lame... :)
jmp take13

noparam:
mov ax,2516h
lea dx,int16
push cs
pop ds
int 21h                      ;no parameter found, hook INT 16

lea dx,patchmess
mov ah,9
int 21h                      ;show Press Ctrl-X to quit message

take13:
mov ax,3513h
int 21h
mov word ptr oldint13,bx
mov word ptr oldint13+2,es   ;save old INT 13

mov ax,2513h
lea dx,int13
push cs
pop ds
int 21h                      ;hook INT 13, this always happens...

lea dx,entermess
mov ah,9
int 21h
lea dx,messmess
int 21h                      ;show measure computer speed message

db 0eah,0,1,0,0    ;jmp to new cs:100h, segment 0000 will be modified by MAKEEXE

mess      db 'Music Construction Set',13,10
          db 'Ripped to DOS by Demonlord 05/21/99',13,10,'$'
patchmess db 'Press Ctrl-X to quit when loaded...',13,10,'$'
messmess  db 'Measuring computer speed (this may take a while)...',13,10,'$'
entermess db 13,10,'$'

;------------------------------ INT 16 HANDLER -------------------------------

int16:
cmp ah,0
jne runorigint               ;check if correct function

pushf
call oldint16                ;call real INT 16 to get key pressed

push ax
mov al,20h
out 20h,al
out 0a0h,al
out 20h,al                   ;signal EOI
pop ax


cmp al,18h                   ;check for ctrl-x
je quit                      ;if so, prepare to quit
iret                         ;not, return

runorigint:                  ;not desired function, run original and return
db 0eah
oldint16 dd ?

quit:                        ;quitting time
mov ax,2516h
lds dx,cs:oldint16
int 21h                      ;restore orig INT 16
mov ax,2513h
lds dx,cs:oldint13
int 21h                      ;restore orig INT 13

push cs
pop ds

mov ax,3
int 10h                      ;set textmode
lea dx,mess
mov ah,9
int 21h                      ;show message again

mov ax,4c00h
int 21h                      ;DOS, freedom!

;------------------------------ INT 13 HANDLER -------------------------------


saveregs:                    ;save original registers without using stack
mov cs:origax,ax
mov cs:origbx,bx
mov cs:origcx,cx
mov cs:origdx,dx
mov cs:origbp,bp
mov cs:origsi,si
mov cs:origdi,di
mov cs:origds,ds
mov cs:origes,es
ret

restoreregs:                 ;restore original regs
mov ax,cs:origax
mov bx,cs:origbx
mov cx,cs:origcx
mov dx,cs:origdx
mov bp,cs:origbp
mov si,cs:origsi
mov di,cs:origdi
mov ds,cs:origds
mov es,cs:origes
ret

int13:                       ;INT 13, the main event
cmp dl,7fh
ja runorig13                 ;HD operation? run real deal...

cmp ah,5
je fakeformat                ;if format, set carry and exit
cmp ah,2
je ls                        ;trap read
cmp ah,3
je ls                        ;trap write
jmp runorig13                ;no function we're interested in, run real


fakeform2:
mov word ptr cs:curcmd,0     ;reset current command & filenames
mov word ptr cs:curfn,0
call restoreregs             ;restore registers

fakeformat:
mov ah,2                     ;set error and bail
stc
retf 2

ls:
call saveregs

mov si,67f9h                 ;ds:67f9 is where MCS stores entered command
push cs
pop es
lea di,loadstr
mov cx,4
rep cmpsb                    ;check if loading
jne checksave
mov cs:loadsave,1
jmp checkdone

checksave:
mov si,67f9h
lea di,savestr
mov cx,4
rep cmpsb                    ;check if saving
jne checkdir
mov cs:loadsave,2

checkdir:
mov si,67f9h
lea di,dirstr
mov cx,3
rep cmpsb                    ;check if DIR
je itsdir

mov si,67f9h
lea di,cattstr
mov cx,3
rep cmpsb                    ;check if CAT
je itsdir
jmp checkdone

itsdir:
mov cs:loadsave,3

checkdone:
cmp cs:loadsave,0            ;no recognized command, run real INT 13
je poprunorig

call restoreregs

cmp dh,1
je readfile                  ;side 1? must be a fileread
cmp cx,2
je fakefat                   ;reading FAT? fake one then...
cmp cx,6
je fakedir                   ;reading DIR sector 1, fix one up
cmp cx,8
je fakedir                   ;reading DIR sector 2, fix one up

readfile:                    ;no recognized sector requested, must be file
                             ;operation
cmp cs:loadsave,2
je savefile                  ;check if saving

push cs
pop es
lea di,curcmd                ;check if we're already doing this command
mov si,67f9h
mov ds,cs:origds
cmploop:
lodsb
cmp al,0
je cmpdone                   ;yep, same old, same old
cmp byte ptr es:[di],al
jne notsame                  ;nope, new command, init new read
inc di
jmp cmploop

notsame:                     ;new command, reset all vars, save filename...
mov si,67f9h
mov ds,cs:origds
push cs
pop es
lea di,curcmd                ;moves command to curcmd, since it's
                             ;always 4+space
movefnl:                     ;then filename ends up in curfn
lodsb
stosb
cmp al,0
jne movefnl

mov si,67feh
checkdot:                    ;check filename for .
lodsb
cmp al,'.'
je fndotfound                ;found a .
cmp al,':'
je fakeform2                 ;found driveletter, fake error and exit!
cmp al,0
je nodotfound                ;no dot found, fix extension
jmp checkdot

nodotfound:
dec di
mov ax,'M.'
stosw
mov ax,'*C'
stosw
mov al,0
stosb                        ;add .MC* to filename to search for
mov ah,4eh
xor cx,cx
lea dx,curfn
push cs
pop ds
int 21h                      ;search for filename
jc fakeform2                 ;not found, fake error
mov ds,cs:pspseg             ;file found
push cs
pop es
mov si,9eh
lea di,curfn
movefnnow:
lodsb
stosb
cmp al,0
jne movefnnow                ;move found filename to curfn


fndotfound:
                             ;open file curfn, start reading
mov cs:sectorsread,0         ;reset number of sectors already read, since it's
                             ;a new file...

cmpdone:                     ;same command/file as last time, continue moving...
push cs
pop ds
mov ax,3d02h
lea dx,curfn
int 21h                      ;open file
jc fakeform2                 ;error opening, fake error
xchg bx,ax

mov ah,3fh
mov cx,8192
lea dx,directory
int 21h                      ;read (hopefully) entire file

mov ah,3eh
int 21h                      ;close file

mov si,dx
mov ax,sectorsread
mov cl,9
shl ax,cl                    ;shift up number of sectors read to bytes
add si,ax                    ;place to continue reading from

mov ax,origax
xor ah,ah
add sectorsread,ax           ;increase sectorsread

mov cl,9
shl ax,cl                    ;shift up number of sectors to read to bytes.
mov cx,ax
mov es,origes
mov di,origbx
rep movsb                    ;move as many bytes requested from file

call restoreregs             ;success! restore registers
mov ah,0                     ;return successful read...
clc
retf 2


savefile:                    ;it's a save!
push cs
pop es
lea di,curcmd
mov si,67f9h
mov ds,cs:origds
cmploop2:                    ;check if same operation
lodsb
cmp al,0
je cmpdone2                  ;yep, must be
cmp byte ptr es:[di],al
jne notsame2                 ;nope, init new vars
inc di
jmp cmploop2

notsame2:                    ;new command, reset all vars, save filename...
mov si,67f9h
mov ds,cs:origds
push cs
pop es
lea di,curcmd                ;moves command to curcmd, since it's always
                             ;4+space
movefnl2:                    ;then filename ends up in curfn automatically!
lodsb
stosb
cmp al,0
jne movefnl2

mov si,67feh
checkdot2:                   ;check for extension
lodsb
cmp al,'.'
je fndotfound2               ;extension found, use it!
cmp al,':'
je fakeform2                 ;drive found, fake error and exit!
cmp al,0
je nodotfound2               ;no dot found, add extension
jmp checkdot2

nodotfound2:
dec di
mov ax,'M.'
stosw
mov ax,'SC'
stosw                        ;no extension found, add .MCS as default
mov al,0
stosb

fndotfound2:
mov cs:sectorsread,0         ;reset number of sectors written
push cs
pop ds
lea dx,curfn
mov ax,3c00h
xor cx,cx
int 21h                      ;create new file, or overwrite old with same name
jc fakeform2                 ;error creating, fake error and exit
xchg bx,ax
mov ah,3eh
int 21h                      ;close file again. now it exists for next routine
                             ;to open...


cmpdone2:                    ;same as last time, append to existing file!
push cs
pop ds
lea dx,curfn
mov ax,3d02h
int 21h                      ;open existing file
jc fakeform2
xchg bx,ax
mov ax,4202h
xor cx,cx
xor dx,dx
int 21h                      ;seek to eof

mov ax,cs:origax
xor ah,ah
mov cl,9
shl ax,cl                    ;shift sectors to write into bytes
mov cx,ax
mov ah,40h
mov dx,cs:origbx
mov ds,cs:origes
int 21h                      ;save data to file

mov ax,5701h
xor cx,cx
xor dx,dx
int 21h                      ;set zero file time & date

mov ah,3eh
int 21h                      ;close file

call restoreregs             ;it's a success! return no errors...
mov ah,0
clc
retf 2


fakefat:
cmp byte ptr cs:origax+1,3   ;check if write
je writefat                  ;if so, fake successful write
mov byte ptr es:[bx],0fdh    ;set fake fat ID
mov word ptr es:[bx+1],0ffffh
mov di,3

fillmore:
mov byte ptr es:[bx+di],0f7h ;fill FAT with EOF, doesn't matter
inc di                       ;but it prevents divide overflows in MCS code...
mov byte ptr es:[bx+di],07fh
inc di
mov byte ptr es:[bx+di],0ffh
inc di
cmp di,1fdh
jb fillmore

writefat:
call restoreregs             ;faked FAT done, return no error
mov ah,0
clc
retf 2


fakedir:
cmp byte ptr cs:origax+1,3    ;check if write
je writedir                   ;if so, fake write successful
findmcs:

push cs
pop es
push cs
pop ds
lea di,directory
mov cx,1024                  ;only use 2k directory, like original.
mov ax,0
rep stosw                    ;fill dir with 0, so we start with clear dir...

mov ah,4eh
mov cx,00100111b
lea dx,mcsstr
int 21h                      ;find first *.MCS file

mov cs:searched,0            ;first search
mov cs:filesfound,0          ;no files found yet

findmore:
jc findmcd                   ;no more files found, exit
inc cs:filesfound            ;increase files found
mov ds,cs:pspseg
push cs
pop es
mov si,9eh                   ;filename found in DS:SI
mov cl,5
mov ax,cs:filesfound
dec ax
shl ax,cl
lea di,directory
add di,ax                    ;add to proper place in faked dir

push di                      ;save offset for later

xor dx,dx
movename1:                   ;move filename into fake dir
lodsb
cmp al,'.'
je dotfound1                 ;dot found, move extension
cmp al,':'
je fakeform2                 ;driveletter found, fake error and exit
cmp al,0
je dotfound1                 ;filename done
stosb
inc dl                       ;increase filename length
jmp movename1

dotfound1:                   ;found extension
mov cx,8
sub cx,dx                    ;fill up filename to 8 chars with spaces
jcxz nofillspace             ;filename is already 8 chars, skip fill
mov al,' '
rep stosb

nofillspace:
mov cx,3                     ;move extension
rep movsb
mov al,20h
stosb                        ;add archive attribute

pop di                       ;restore filename start position
add di,26                    ;cluster offset in directory
mov ax,cs:filesfound
add ax,2
stosw                        ;save fake cluster nr
mov si,9ah
mov cx,2
rep movsw                    ;move real filesize

cmp cs:filesfound,63         ;no more than 63 files can be listed, last has
                             ;to be 0!
jae allfound                 ;no more can be listed...
mov ah,4fh
int 21h                      ;find next file
jmp findmore                 ;do it again...

findmcd:
inc cs:searched              ;all MCS found, go for MCD
cmp cs:searched,2
je allfound                  ;searched twice (MCS,MCD), all files found

push cs
pop ds
mov ah,4eh
mov cx,00100111b
lea dx,mcdstr
int 21h                      ;init search for *.MCD
jmp findmore

allfound:
call restoreregs

push cs
pop ds
mov di,bx

lea si,directory
cmp cx,6                  ;first directory sector (6)?
je domove
add si,1024               ;nope, second sector (8), skip first part of fake dir

domove:
mov cx,1024
rep movsb                 ;move two directory sectors to MCS area...

exitsuccess:
call restoreregs          ;it's done man! exit without error...
mov ah,0
clc
retf 2

writedir:                    ;write directory
push cs
pop ds
push cs
pop es
lea si,curfn
lea di,tempfn

xor dx,dx
movename3:                   ;move current filename into tempfn
lodsb
cmp al,'.'                   ;found dot, continue with extension
je dotfound3
cmp al,':'                   ;found driveletter, bail with error
je fakeform2
cmp al,0                     ;end of filename found
je dotfound3
stosb
inc dl                       ;save length
jmp movename3

dotfound3:
mov cx,8                     ;pad filename to 8 with spaces
sub cx,dx
jcxz nofillspace3            ;filename is already 8 chars, man!
mov al,' '
rep stosb

nofillspace3:
mov cx,3
rep movsb                    ;tempfn is now spacefilled curfn

call restoreregs

push cs
pop es
lea di,tempfn
mov si,bx                    ;ds:si is dir to write
add bx,400h                  ;ds:bx is where to stop looking for fn
                             ;need to find filename in directory, so we can
                             ;set correct length to the file being written!
                             ;so far it's only sectorbased size, and that
                             ;won't load back...

findfn:
push si
push di
xor dx,dx
findname:                    ;find current filename
lodsb
cmp al,byte ptr es:[di]
jne findnext                 ;not this one, try next
inc di
inc dx
cmp dx,11
jae filefound                ;yep, this is the one!
jmp findname

findnext:
pop di
pop si
add si,32                    ;skip to next file in directory
cmp si,bx
jb findfn                    ;are we too far?
jmp exitsuccess              ;filename not found in this sector, fake success
                             ;and hope it turns up in next sector :)

filefound:                   ;yes! filename found
pop di
pop si
add si,28
lodsw                        ;ax is the correct filesize!
mov cx,ax
push cs
pop ds
mov ax,3d02h
lea dx,curfn
int 21h                      ;open current file with write access
jc fakeform2                 ;error opening, fake error and leave
xchg bx,ax
mov ax,4200h
mov dx,cx
xor cx,cx
int 21h                      ;seek to correct filesize
mov ah,40h
mov cx,0
int 21h                      ;write 0 bytes to trunc file at correct size!
mov ax,5701h
xor cx,cx
xor dx,dx
int 21h                      ;set date & time to 0 (a la MCS) :)
mov ah,3eh
int 21h                      ;close file and we're done!
jmp exitsuccess

poprunorig:
call restoreregs

runorig13:                   ;run original INT 13
db 0eah
oldint13 dd ?

loadstr db 'LOAD'            ;LOAD command
savestr db 'SAVE'            ;SAVE command
dirstr db 'DIR'              ;DIRectory command
cattstr db 'CAT'             ;CATalog command
loadsave db 0                ;0=none, 1=load, 2=save, 3=dir/cat
curcmd db 5 dup(0)           ;current command including space (LOAD ,SAVE )
curfn db 13 dup(0)           ;current filename
tempfn db 13 dup(0)          ;temp filename var
mcsstr db '*.mcs',0          ;searchstring for MCS files
mcdstr db '*.mcd',0          ;searchstring for MCD files
pspseg dw ?                  ;PSP seg of program
filesfound dw 0              ;number of files found
searched db 0                ;how many times searched?
sectorsread dw ?             ;number of sectors read from/written to file

origax dw ?                  ;original registers
origbx dw ?
origcx dw ?
origdx dw ?
origbp dw ?
origsi dw ?
origdi dw ?
origds dw ?
origes dw ?

directory db 8192 dup(0)     ;directory/songfile data area, can be expanded
                             ;if necessary!

end start
