/* advcio.c - system dependant code for AdvCom */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#include <stdio.h>
#include <fcntl.h>

/* status values */
#define ST_OK	1
#define ST_ERR	0

/* external routines */
extern long lseek();

/* advinit - initialize */
/*
	This function parses the argument list and returns the
	input and output file names.
*/
advinit(banner,argc,argv,ifile,ofile)
  char *banner;	/* program banner text */
  int argc;	/* argc passed to main() */
  int *argv[];	/* argv passed to main() */
  char *ifile;	/* input file name (output) */
  char *ofile;	/* output file name (output) */
{
    /* print the banner text */
    printf("%s\n",banner);

    /* check the argument count */
    if (argc < 2)
	advfatal("usage: advcom <file> [ <ofile> ]");
    
    /* get the input file name (adventure source file) */
    strcpy(ifile,argv[1]); strcat(ifile,".adv");

    /* get the output file name (adventure data file) */
    strcpy(ofile,(argc < 3 ? argv[1] : argv[2])); strcat(ofile,".dat");
}

/* advcreate - create a binary data file */
/*
	This function *must* create the file in binary mode so that
	subsequent writes will also be in binary mode.  No character
	translations should be done during writes.  You probably
	won't need to modify this function unless your runtime
	library defaults to ASCII mode for files created with creat().
*/
int advcreate(name,pfd)
  char *name;	/* file name */
  int *pfd;	/* file descriptor (output) */
{
    /* create the file in ***BINARY*** mode */
    if ((*pfd = creat(name,0666)) < 0)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advclose - close a binary data file */
/*
	You probably won't need to modify this routine.  It was
	added as a hook to allow the use of non-UNIX style file
	I/O routines.
*/
int advclose(fd)
  int fd;
{
    /* close the binary file */
    if (close(fd) != 0)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advseek - seek to a position in a binary data file */
/*
	You probably won't need to modify this routine.  It was
	added as a hook to allow the use of non-UNIX style file
	I/O routines.
*/
int advseek(fd,pos)
  int fd; long pos;
{
    /* seek to the position */
    if (lseek(fd,pos,0) != pos)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advwrite - write to a binary data file */
/*
	This function must write data in binary mode.  No character
	translations should be done here.
*/
int advwrite(fd,buf,len)
  int fd; char *buf; int len;
{
    /* write the data */
    if (write(fd,buf,len) != len)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advfatal - print a fatal error message and exit */
/*
	You can probably leave this function as-is.  It was added
	to the machine/compiler dependant module to provide a hook
	for using alert boxes on machines like the Macintosh and
	the Atari-ST.
*/
advfatal(msg)
  char *msg;
{
    fprintf(stderr,msg);
    advpause();
    exit(1);
}

/* advpause - pause at the end of the adventure before returning to the OS */
/*
	This routine is provided as a hook for machines that clear the
	screen before returning to the OS.  It is called after each
	error message is printed.  It can also be used to prevent error
	messages from scrolling off the screen before they have been
	seen by the user.  This is especially useful on systems that
	don't support XON/XOFF flow control.
*/
advpause()
{
}

