/****************************************************************/
/*								*/
/* ibmutils							*/
/*								*/
/* These are routines that are specific to the PC. Mostly, this	*/
/* involves the screen addressing functions. The C86 compiler	*/
/* has a kind of trickey way to do direct video I/O, but if you	*/
/* do the writes into the adapter card yourself, then you get	*/
/* the traditional "PC flicker" that we all know.		*/
/*								*/
/****************************************************************/

#include	<stdio.h>
#include	"bkg.h"

struct	regval	{
		int	ax, bx, cx, dx, si, di, ds, es;
		};

/*P*/
/****************************************************************/
/*								*/
/* write_at							*/
/*								*/
/* This function puts "string" at row "x" column "y" on the PC	*/
/* display. On a color monitor, the text shows up in "color".	*/
/* The caller can put a special byte called CTEOL in the string	*/
/* to indicate "clear to end of line". This is used so that the	*/
/* PC looks like a real machine (the Kaypro).			*/
/*								*/
/****************************************************************/

write_at( x, y, string, color )

int	x, y;
char	string[];
int	color;

	{

	int		pos, other;
	unsigned	word;
	struct	regval	regs;

	for( pos = 0; string[ pos ]; pos++ )
		if ( string[ pos ] == CTEOL )
			{
			crt_srcp( x, y + pos, 0 );
			regs.ax = 0x0920;
			regs.bx = ( color & 0x00ff );
			regs.cx = ( 80 - ( y + pos ) );
			sysint( 0x10, &regs, &regs );
			y--; /* dec y to account for 1 character. */
			}
		else
			{
			crt_srcp( x, y + pos, 0 );
			regs.ax = 0x0900 | ( string[ pos ] & 0x00ff );
			regs.bx = ( color & 0x00ff );
			regs.cx = 1;
			sysint( 0x10, &regs, &regs );
			}

	} /* write_at */

/*P*/
/****************************************************************/
/*								*/
/* char_at							*/
/*								*/
/* This is just like "write_at" except it transmits bytes.	*/
/*								*/
/****************************************************************/

char_at( x, y, data, color )

int	x, y;
char	data;
int	color;

	{

	struct	regval	regs;

	crt_srcp( x, y, 0 );

	if ( data == CTEOL )
		{
		regs.ax = 0x0920;
		regs.bx = ( color & 0x00ff );
		regs.cx = ( 80 - y );
		sysint( 0x10, &regs, &regs );
		}
	else
		{
		regs.ax = 0x0900 | ( data & 0x00ff );
		regs.bx = ( color & 0x00ff );
		regs.cx = 1;
		sysint( 0x10, &regs, &regs );
		}

	} /* char_at */
/*P*/
/****************************************************************/
/*								*/
/* clear							*/
/*								*/
/* Should be self-apparent.					*/
/*								*/
/****************************************************************/

clear()
	{

	crt_cls();

	}

/*P*/
/****************************************************************/
/*								*/
/* cursor							*/
/*								*/
/* Turn off the cursor - the Kaypro can do it!			*/
/*								*/
/****************************************************************/

cursor( on_off )

int	on_off;

	{

	/* I don't know if this can be done on the PC	*/
	/* other than writing directly to the video	*/
	/* controller chip - the hardware reference	*/
	/* says that that's not a good idea.		*/

	} /* cursor */

/*P*/
/****************************************************************/
/*								*/
/* raw_kbhit, raw_keyboard					*/
/*								*/
/* This function checks for a keyboard character without	*/
/* reading it in. The other reads a byte from the keyboard w/o	*/
/* doing an echo to the terminal.				*/
/*								*/
/****************************************************************/

raw_kbhit()

	{

	return( ( key_scan() == -1 ) ? FALSE : TRUE );

	} /* my_kbhit */

raw_keyboard()

	{

	unsigned int	scan_n_char, cast;
	unsigned char	ch;

	scan_n_char = key_getc();
	ch = ( scan_n_char & 0x00ff );
	cast = ch;
	cast &= 0x00ff;	/* Make absolutely sure...	*/

	return( cast );

	}

/*P*/
/****************************************************************/
/*								*/
/* srand1							*/
/*								*/
/* On the Kaypro BDS C, which is not at all standard, this	*/
/* function is included in the RTL. Here, we display "str" and	*/
/* start counting. When a key is pressed, it's time to seed the	*/
/* random number generator.					*/
/*								*/
/****************************************************************/

srand1( str )

char	*str;

	{

	unsigned int	seed;

	printf( "%s", str );
	for( seed = 0; ! raw_kbhit(); seed++ );
	srand( seed );

	} /* srand1 */
