/*P*/
/****************************************************************/
/*								*/
/* utils.c							*/
/*								*/
/* These are the utility procedures in general use for a lot of	*/
/* software systems (e.g. sign software, framegen, etc.). The	*/
/* functions in this library are linked in as needed - use the	*/
/* "-L" option on the "L2" linker. Most of the functions are	*/
/* dependent on the Kaypro, and should be overridden with a	*/
/* different, machine-dependent library for special macines.	*/
/*								*/
/****************************************************************/

#include	<stdio.h>
#define		ESCAPE		0x1b
#define		SUPPORTED	TRUE
#define		TESTING		FALSE

/*P*/
/****************************************************************/
/*								*/
/* write_at							*/
/*								*/
/****************************************************************/

write_at( x, y, string )

int	x, y;
char	string[];

	{
	int	pos;

	#if	TESTING

		if ( ( x < 0  ) ||
		     ( x > 23 ) ||
		     ( y < 0  ) ||
		     ( y > 79 ) )
			{
			printf( "write_at: row=%d col=%d", x, y );
			exit();
			}

		#endif
 	
	bios( 4, ESCAPE );
	bios( 4, '=' );
	bios( 4, 32 + x );
	bios( 4, 32 + y );

	pos = 0;
	while( string[ pos ] )
		bios( 4, string[ pos++ ] );

	} /* write_at */

/*P*/
/****************************************************************/
/*								*/
/* char_at							*/
/*								*/
/****************************************************************/

char_at( x, y, data )

int	x, y;
char	data;

	{

	#if	TESTING

		if ( ( x < 0  ) ||
		     ( x > 23 ) ||
		     ( y < 0  ) ||
		     ( y > 79 ) )
			{
			printf( "char_at: row=%d col=%d", x, y );
			exit();
			}

		#endif
 	
	bios( 4, ESCAPE );
	bios( 4, '=' );
	bios( 4, 32 + x );
	bios( 4, 32 + y );
	bios( 4, data );

	} /* char_at */

/*P*/
/****************************************************************/
/*								*/
/* clear							*/
/*								*/
/****************************************************************/

clear()
	{
	bios( 4, 0x1a );
	}

/*P*/
/****************************************************************/
/*								*/
/* set_line							*/
/*								*/
/****************************************************************/

set_line( old_x, old_y, new_x, new_y )

int	old_x, old_y, new_x, new_y;

	{

	#if	SUPPORTED

		bios( 4, ESCAPE );
		bios( 4, 'L' );
		bios( 4, 32 + old_x );
		bios( 4, 32 + old_y );
		bios( 4, 32 + new_x );
		bios( 4, 32 + new_y );

		#endif

	} /* line */

/*P*/
/****************************************************************/
/*								*/
/* raw_kbhit - This function checks for a keyboard character	*/
/*	       WITHOUT going through the bios. We need this to	*/
/*	       do a kbhit with programs that use CDB, because	*/
/*	       CDB traps you on keyboard interrupts.		*/
/*								*/
/* raw_keyboard - Use this to get keys that are not converted	*/
/*		  by the bios. An example is the Numeric pad,	*/
/*		  which returns different hex values then the	*/
/*		  regular numbers.				*/
/*								*/
/****************************************************************/

#define		RxRDY			0x01
#define		KB_STATUS		7
#define		KB_DATA			5

raw_kbhit()

	{
	return( inp( KB_STATUS ) & RxRDY );
	} /* my_kbhit */

raw_keyboard()

	{
	while ( ! raw_kbhit() );
	return( inp( KB_DATA ) );
	}

/*P*/
/****************************************************************/
/*								*/
/* strncmp - compares string 1 and string 2 for equality up to	*/
/*	     n characters. For some reason this is not included	*/
/*	     in the BDS library, so we have to do it.		*/
/*								*/
/****************************************************************/

strncmp( s1, s2, n )

char	*s1, *s2;
int	n;

	{

	for( ; *s1 == *s2 && n; s1++, s2++, n-- )
		if ( ! *s1 )
			return( 0 );

	if ( n )
		return( *s1 - *s2 );
	else
		return( 0 );

	} /* strncmp */
