/*P*/
/****************************************************************/
/*								*/
/* screen.c							*/
/*								*/
/* These are the routines for updating the display - we draw	*/
/* the board, and the dice, etc. in these modules. A nice	*/
/* future enhancement is to make the pieces actually "move" on	*/
/* the board from point to point. I started, but never finished	*/
/* so this is the result - they "jump" instead.			*/
/*								*/
/****************************************************************/

#include	<stdio.h>
#include	"bkg.h"

/****************************************************************/
/*								*/
/* draw								*/
/*								*/
/* This function puts the board up on the screen. It is similar	*/
/* in positioning on both the PC and the Kaypro. The difference	*/
/* is in the way things are outlined - on the Kaypro we use the	*/
/* primitive graphics on the display. On the PC we use the	*/
/* character graphics to outline things. We could use the PC in	*/
/* color graphics mode, which would enable us to draw actual	*/
/* round players, and triangular points. The problem is that	*/
/* then we're limited in how many colors we can use... This	*/
/* may be a future enhancement, also... And! I should add some	*/
/* support for VT-100's, so I can run it on the VAX, and the	*/
/* VT-220, which has nice graphics that I know nothing about.	*/
/*								*/
/****************************************************************/

#define		WIDTH		58
#define		HEIGHT		15
#define		BS		0x08
#define		LF		0x0a

draw( side )

int	side;

	{

	int	i, j, disp;
	char	line[ WIDTH + 2 ];

	clear();

#ifdef	KAYPRO

	/* Just draw the lines...	*/

	set_line( 5, 0, 5, 116 );
	set_line( 61, 0, 61, 116 );
	set_line( 5, 0, 60, 0 );
	set_line( 5, 52, 60, 52 );
	set_line( 5, 64, 60, 64 );
	set_line( 5, 116, 60, 116 );

	set_line( X_DIE1 * 4 + 1, Y_DIE1 * 2, X_DIE1 * 4 + 1, Y_DIE1 * 2 + 18 );
	set_line( X_DIE1 * 4 + 17, Y_DIE1 * 2, X_DIE1 * 4 + 17, Y_DIE1 * 2 + 18 );
	set_line( X_DIE1 * 4 + 2, Y_DIE1 * 2, X_DIE1 * 4 + 16, Y_DIE1 * 2 );
	set_line( X_DIE1 * 4 + 2, Y_DIE1 * 2 + 18, X_DIE1 * 4 + 16, Y_DIE1 * 2 + 18 );

	set_line( X_DIE2 * 4 + 1, Y_DIE2 * 2, X_DIE2 * 4 + 1, Y_DIE2 * 2 + 18 );
	set_line( X_DIE2 * 4 + 17, Y_DIE2 * 2, X_DIE2 * 4 + 17, Y_DIE2 * 2 + 18 );
	set_line( X_DIE2 * 4 + 2, Y_DIE2 * 2, X_DIE2 * 4 + 16, Y_DIE2 * 2 );
	set_line( X_DIE2 * 4 + 2, Y_DIE2 * 2 + 18, X_DIE2 * 4 + 16, Y_DIE2 * 2 + 18 );

#endif

#ifdef	IBMPC

	/* fill the top and bottom line buffers	*/
	/* These hex codes are hard-coded,	*/
	/* which is bad, but. See the hardware	*/
	/* reference for more info.		*/

	for( i = 1; i < WIDTH; i++ )
		line[ i ] = 0xcd;
	line[ 0 ] = 0xc9;
	line[ WIDTH ] = 0xbb;
	line[ 26 ] = 0xcb;
	line[ 32 ] = 0xcb;
	line[ WIDTH + 1 ] = '\0';

	write_at( 1, 0, line, BOARD_COLOR );

	line[ 0 ] = 0xc8;
	line[ WIDTH ] = 0xbc;
	line[ 26 ] = 0xca;
	line[ 32 ] = 0xca;

	write_at( 15, 0, line, BOARD_COLOR );

	for( i = 1; i < WIDTH; i++ )
		line[ i ] = ' ';

	line[ 0 ] = line[ 26 ] = line[ 32 ] = line[ WIDTH ] = 0xba;
	for( i = 2; i < HEIGHT; i++ )
		write_at( i, 0, line, BOARD_COLOR );

	/* now do the die boxes */

	for( i = 1; i < 8; i++ )
		line[ i ] = 0xc4;

	line[ 0 ] = 0xda;
	line[ 8 ] = 0xbf;
	line[ 9 ] = 0x00;
	
	write_at( X_DIE1, Y_DIE1, line, DYE );
	write_at( X_DIE2, Y_DIE2, line, DYE );

	line[ 0 ] = 0xc0;
	line[ 8 ] = 0xd9;

	write_at( X_DIE1 + 4, Y_DIE1, line, DYE );
	write_at( X_DIE2 + 4, Y_DIE2, line, DYE );

	for( i = 1; i < 8; i++ )
		line[ i ] = ' ';

	line[ 0 ] = line[ 8 ] = 0xb3;

	for( i = 1; i <= 3; i++ )
		{
		write_at( X_DIE2 + i, Y_DIE2, line, DYE );
		write_at( X_DIE1 + i, Y_DIE1, line, DYE );
		} /* loopski */

#endif

#ifdef	VAX

	/* Not tested!!!		*/
	/* fill the top and bottom	*/

	line[ 0 ] = '+';
	for( i = 1; i < WIDTH; i++ )
		line[ i ] = '-';
	line[ WIDTH ] = '+';
	line[ WIDTH + 1 ] = '\0';

	write_at( 1, 0, line );
	write_at( 15, 0, line );

	for( psn = i = 0; i < HEIGHT; i++ )
		{
		line[ psn++ ] = '|';
		line[ psn++ ] = LF;
		line[ psn++ ] = BS;
		}

	line[ psn ] = '\0';

	write_at( 2, 0, buf );
	write_at( 2, 26, buf );
	write_at( 2, 32, buf );
	write_at( 2, 58, buf );

	/* now do the die boxes */

	write_at( X_DIE1, Y_DIE1, "+-------+" );
	for( i = 1; i <= 3; i++ )
		write_at( X_DIE1 + i, Y_DIE1, "|       |" );
	write_at( X_DIE1 + 4, Y_DIE1, "+-------+" );

	write_at( X_DIE2, Y_DIE2, "+-------+" );
	for( i = 1; i <= 3; i++ )
		write_at( X_DIE2 + i, Y_DIE2, "|       |" );
	write_at( X_DIE2 + 4, Y_DIE2, "+-------+" );

#endif

	/* This is common to everybody...	*/
	/* Note that if "side" is true, we	*/
	/* draw it with respect to white. Else	*/
	/* we draw it with respect to black.	*/

	for( i = 1; i < 13; i++ )
		{
		sprintf( line, "%2d", ( side ? 12 + i : i ) );
		disp = ( ( i * 4 ) - 2 );
		if ( i > 6 )
			disp += 8;
		write_at( 0, disp, line, NUM_COLOR );
		}

	for( i = 13; i < 25; i++ )
		{
		sprintf( line, "%2d", ( side ? i - 12 : i ) );
		disp = ( ( ( 25 - i ) * 4 ) - 2 );
		if ( i < 19 )
			disp += 8;
		write_at( 16, disp, line, NUM_COLOR );
		}

	} /* draw */

/*P*/
/****************************************************************/
/*								*/
/* show_cube							*/
/*								*/
/* This draws the double cube. If "own" is WHITE, then it is	*/
/* on white's side. If own is BLACK, ... Else it is in the	*/
/* middle of the board, and either person may double. As an	*/
/* engancement, we need to change the absolute line/column	*/
/* numbers below so that they are relative to the boards x,y	*/
/* position on the display. This would allow for easy movement	*/
/* later.							*/
/*								*/
/****************************************************************/

show_cube( own, val, side )

int	own, val, side;

	{

	char	buf[ 5 ], *blank_out;
	int	i;

#ifdef	IBMPC

	/* On a real compiler (non-BDS) we have	*/
	/* the powerful C languiage @ its best.	*/

	static char	line[ 3 ][ 6 ] = { { 0xda, 0xc4, 0xc4, 0xc4, 0xbf, 0x00 },
					   { 0xb3, 0x20, 0x20, 0x20, 0xb3, 0x00 },
					   { 0xc0, 0xc4, 0xc4, 0xc4, 0xd9, 0x00 } };

#endif
 
	blank_out = "     ";	/* 5 spaces */
	sprintf( buf, "%2d", val );

	if ( side )
		switch( own )
			{

			case BLACK:	own = WHITE;
					break;

			case WHITE:	own = BLACK;
					break;

			default:	break;

			} /* switch */
	
#ifdef	KAYPRO

	switch( own )
		{

		case WHITE:	set_line( 9, 54, 9, 62 );
				set_line( 17, 54, 17, 62 );
				set_line( 9, 54, 17, 54 );
				set_line( 9, 62, 17, 62 );
				write_at( 3, 28, buf, CUBE_COLOR );
				write_at( 7, 27, blank_out, CUBE_COLOR );
				write_at( 8, 27, blank_out, CUBE_COLOR );
				write_at( 9, 27, blank_out, CUBE_COLOR );
				write_at( 12, 27, blank_out, CUBE_COLOR );
				write_at( 13, 27, blank_out, CUBE_COLOR );
				write_at( 14, 27, blank_out, CUBE_COLOR );
				break;

		case BLACK:	set_line( 49, 54, 49, 62 );
				set_line( 57, 54, 57, 62 );
				set_line( 49, 54, 57, 54 );
				set_line( 49, 62, 57, 62 );
				write_at( 13, 28, buf, CUBE_COLOR );
				write_at( 2, 27, blank_out, CUBE_COLOR );
				write_at( 3, 27, blank_out, CUBE_COLOR );
				write_at( 4, 27, blank_out, CUBE_COLOR );
				write_at( 7, 27, blank_out, CUBE_COLOR );
				write_at( 8, 27, blank_out, CUBE_COLOR );
				write_at( 9, 27, blank_out, CUBE_COLOR );
				break;

		default:	set_line( 29, 54, 29, 62 );
				set_line( 37, 54, 37, 62 );
				set_line( 29, 54, 37, 54 );
				set_line( 29, 62, 37, 62 );
				write_at( 8, 28, buf, CUBE_COLOR );
				write_at( 2, 27, blank_out, CUBE_COLOR );
				write_at( 3, 27, blank_out, CUBE_COLOR );
				write_at( 4, 27, blank_out, CUBE_COLOR );
				write_at( 12, 27, blank_out, CUBE_COLOR );
				write_at( 13, 27, blank_out, CUBE_COLOR );
				write_at( 14, 27, blank_out, CUBE_COLOR );
				break;

		} /* switch */

#endif

#ifdef	IBMPC

	switch( own )
		{

		case WHITE:	for( i = 0; i < 3; i++ )
					write_at( 2 + i, 27, line[ i ], CUBE_COLOR ); 
				write_at( 3, 28, buf, CUBE_COLOR );
				write_at( 7, 27, blank_out, CUBE_COLOR );
				write_at( 8, 27, blank_out, CUBE_COLOR );
				write_at( 9, 27, blank_out, CUBE_COLOR );
				write_at( 12, 27, blank_out, CUBE_COLOR );
				write_at( 13, 27, blank_out, CUBE_COLOR );
				write_at( 14, 27, blank_out, CUBE_COLOR );
				break;

		case BLACK:	for( i = 0; i < 3; i++ )
					write_at( 12 + i, 27, line[ i ], CUBE_COLOR );
				write_at( 13, 28, buf, CUBE_COLOR );
				write_at( 2, 27, blank_out, CUBE_COLOR );
				write_at( 3, 27, blank_out, CUBE_COLOR );
				write_at( 4, 27, blank_out, CUBE_COLOR );
				write_at( 7, 27, blank_out, CUBE_COLOR );
				write_at( 8, 27, blank_out, CUBE_COLOR );
				write_at( 9, 27, blank_out, CUBE_COLOR );
				break;

		default:	for( i = 0; i < 3; i++ )
					write_at( 7 + i, 27, line[ i ], CUBE_COLOR );
				write_at( 8, 28, buf, CUBE_COLOR );
				write_at( 2, 27, blank_out, CUBE_COLOR );
				write_at( 3, 27, blank_out, CUBE_COLOR );
				write_at( 4, 27, blank_out, CUBE_COLOR );
				write_at( 12, 27, blank_out, CUBE_COLOR );
				write_at( 13, 27, blank_out, CUBE_COLOR );
				write_at( 14, 27, blank_out, CUBE_COLOR );
				break;

		} /* switch */

#endif

#ifdef	VAX

	/* Not completed.	*/

#endif

	} /* show_cube */


/*P*/
/****************************************************************/
/*								*/
/* roll								*/
/*								*/
/* This function rolls the dice, and returns the values on the	*/
/* dice to the caller. Then, it formats a message according to	*/
/* what was rolled, and prints it. The "col" parameter is set	*/
/* to the column after the printed message; this is so we can	*/
/* address back to here later if we need to. The variable	*/
/* "iter" is the number of loop iterations to do when rolling.	*/
/* This is simply to provide some variety in short/long rolls	*/
/* of the dice.							*/
/*								*/
/****************************************************************/

#define		MAX_ITER	30

roll( die_1, die_2, col )

int	*die_1, *die_2, *col;

	{

	int	i, iter;
	char	buf[ 80 ];

	/* If we're testing this, then just ask	*/
	/* and then display them.		*/

	if ( r_test )
		{
		char_at( X_INFO, Y_INFO, CTEOL, TEXT_COLOR );
		printf( "die 1 and 2: " );
		scanf( "%d %d", die_1, die_2 );
		*col = 0;
		show_die( 1, *die_1 );
		show_die( 0, *die_2 );
		}
	else
		{

		iter = ( rand() % MAX_ITER ) + 1;

		for( i = 1; i <= iter; i++ )
			{
			show_die( 1, ( *die_1 = ( rand() % 6 ) + 1 ) );
			show_die( 0, ( *die_2 = ( rand() % 6 ) + 1 ) );
			} /* for i */
		}

	if ( *die_1 == *die_2 )
		sprintf( buf, "%s rolls double %d's%c", NAME, *die_1, CTEOL );
 	else
		sprintf( buf, "%s rolls a %d and a %d%c", NAME, *die_1, *die_2, CTEOL );

	write_at( X_INFO + ( me == WHITE ? 0 : 1 ), Y_INFO, buf, TEXT_COLOR );
	*col = strlen( buf ) - 1;

	} /* roll */

/*P*/
/****************************************************************/
/*								*/
/* show_die							*/
/*								*/
/* The "show_die" function should be apparent. We display one	*/
/* or the other die using spaces and 'O''s. The only quirks are	*/
/* that some rolls can be displayed 90 degrees rotated, so we	*/
/* use "mirror" to do this. (Not a completely accurate variable	*/
/* name, come to think of it!)					*/
/*								*/
/****************************************************************/

show_die( where, rval )

int	where, rval;

	{

	int	x_base, y_base;
	int	i, mirror;

	x_base = ( where == 1 ? X_DIE1 : X_DIE2 );
	y_base = ( where == 1 ? Y_DIE1 : Y_DIE2 );

	/* 2, 3, and 6 can go either way */

	mirror = rand() % 2;

	/* this is a space-consuming way of	*/
	/* doing this, but it is very fast on a	*/
	/* cp/m system.				*/

	switch( rval )
		{
	
		case 1:	write_at( x_base + 1, y_base + 2, "     ", DYE );
			write_at( x_base + 2, y_base + 2, "  O  ", DYE );
			write_at( x_base + 3, y_base + 2, "     ", DYE );
			break;

		case 2:	if ( ! mirror )
				{
				write_at( x_base + 1, y_base + 2, "O    ", DYE );
				write_at( x_base + 2, y_base + 2, "     ", DYE );
				write_at( x_base + 3, y_base + 2, "    O", DYE );
				}
			else
				{
				write_at( x_base + 1, y_base + 2, "    O", DYE );
				write_at( x_base + 2, y_base + 2, "     ", DYE );
				write_at( x_base + 3, y_base + 2, "O    ", DYE );
				}

			break;

		case 3:	if ( ! mirror )
				{
				write_at( x_base + 1, y_base + 2, "O    ", DYE );
				write_at( x_base + 2, y_base + 2, "  O  ", DYE );
				write_at( x_base + 3, y_base + 2, "    O", DYE );
				}
			else
				{
				write_at( x_base + 1, y_base + 2, "    O", DYE );
				write_at( x_base + 2, y_base + 2, "  O  ", DYE );
				write_at( x_base + 3, y_base + 2, "O    ", DYE );
				}

			break;

		case 4:	write_at( x_base + 1, y_base + 2, "O   O", DYE );
			write_at( x_base + 2, y_base + 2, "     ", DYE );
			write_at( x_base + 3, y_base + 2, "O   O", DYE );
			break;

		case 5:	write_at( x_base + 1, y_base + 2, "O   O", DYE );
			write_at( x_base + 2, y_base + 2, "  O  ", DYE );
			write_at( x_base + 3, y_base + 2, "O   O", DYE );
			break;

		case 6:	if ( ! mirror )
				{
				write_at( x_base + 1, y_base + 2, "O   O", DYE );
				write_at( x_base + 2, y_base + 2, "O   O", DYE );
				write_at( x_base + 3, y_base + 2, "O   O", DYE );
				}
			else
				{
				write_at( x_base + 1, y_base + 2, "O O O", DYE );
				write_at( x_base + 2, y_base + 2, "     ", DYE );
				write_at( x_base + 3, y_base + 2, "O O O", DYE );
				}

			break;

		} /* switch */

	} /* show_die */
