PROGRAM Sort;
CONST
  LSize = 40;
TYPE
  List = ARRAY[1..LSize] of INTEGER;
VAR
  AList: List;
  Count: INTEGER;

PROCEDURE Insert(
  VAR L  { List to be sorted }
    :List;
  N      { No. of items to be sorted }
    :INTEGER
   );

VAR
  StageNo, Loc : INTEGER;
  StageOver: BOOLEAN;

PROCEDURE Swap( VAR X, Y : INTEGER );
VAR Temp:INTEGER;
BEGIN
  Temp := X;
  X := Y;
  Y := Temp
END;

BEGIN              { Insert }
  FOR StageNo := 1 TO N-1 DO
    BEGIN
      StageOver := False;
      Loc := StageNo+1;
      WHILE (Loc>1) AND NOT StageOver DO
        BEGIN
          IF L[Loc] < L[Loc-1]
            THEN Swap( L[Loc],L[Loc-1] )
            ELSE StageOver := True;
          Loc := Loc - 1
        END
    END
END;              { Insert }

BEGIN              { Try }
  FOR Count := 1 TO LSize DO
    AList[Count] := TRUNC(RANDOM*900);
  Insert( AList, LSize );
  FOR Count := 1 TO LSize DO
    Write( AList[Count]:4 )
END.