

(*------------------ Modules playloops and make choices ------------*)



(* (C) Copyright A.I.SOFTWARE                                       *)


PROCEDURE UPDATE_POSITION(LOC,TO_ND,ST:BYTE);
BEGIN

  PLAYERS[ST][LOC] := TO_ND;

END; (* UPDATE_POSITION *)



PROCEDURE GAME_OVER;
VAR

  I :BYTE;
  CH:CHAR;

BEGIN

  IF NOT TERMINATE THEN BEGIN

    MESSAGE(11);
    IF NUM_PLAYERS = 0 THEN

      CASE MODE OF
        1:MESSAGE(12);
        2:MESSAGE(13);
       END

    ELSE MESSAGE(14 + MODE);

  END;
  PROMPT(14);
  READER(1,CH);
  IF CH = 'Y' THEN RESTART := TRUE
  ELSE BEGIN MESSAGE(14);DELAY(2000);END;

END; (* GAME_OVER *)


PROCEDURE RECORD_MOVE;
VAR

  I :BYTE;

BEGIN

  IF NUM_MOVES <= MAX_MOVES_RECORDED THEN WITH THE_GAME[NUM_MOVES] DO BEGIN

    SMODE      := MODE;
    MOVE(BEFORE[1].C,SBEFORE[1].C,12);
    FOR I:= 1 TO 121 DO SCOLORS[I] := BOARD[I].COLOR;
    MOVE(PLAYERS[1][0],SPLAYERS[1][0],72);
    MOVE(PLAY_SETS[1].CT,SPLAY_SETS[1].CT,6);
    MOVE(CT_LAST_F,SCT_LAST_F,4);

  END;

END; (* RECORD_MOVE *)




OVERLAY PROCEDURE PLAYLOOP;
VAR

  FROM_ND,
  TO_ND,
  LOC,
  I,J,
  ST     :BYTE;
  OVER   :BOOLEAN;


  PROCEDURE CHECK_FOR_WINNER;
  VAR

    I,J:BYTE;

  BEGIN

    OVER := TRUE;
    FOR J := 1 TO NUM_SETS DO

      FOR I := 1 TO 10 DO

        CASE MODE OF

          1:IF (PLAYERS[PLAY_SETS[J].CT][I] < FIXED_LOC[PLAY_SETS[J].OP][1])
            OR (PLAYERS[PLAY_SETS[J].CT][I] > FIXED_LOC[PLAY_SETS[J].OP][10])
            THEN OVER:=FALSE;

          2:IF (PLAYERS[PLAY_SETS[J].OP][I] < FIXED_LOC[PLAY_SETS[J].CT][1])
            OR (PLAYERS[PLAY_SETS[J].OP][I] > FIXED_LOC[PLAY_SETS[J].CT][10])
            THEN OVER:=FALSE;

        END;

  END; (* CHECK_FOR_WINNER *)


BEGIN

  FROM_ND := 0;
  TO_ND   := 0;
  IF PLAY_MODE = NEW_GAME THEN BEGIN

    IF ME_FIRST THEN MODE := 1
    ELSE MODE := 2;
    NUM_MOVES := 0;
    RECORD_MOVE;

  END
  ELSE SING_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T);

  MESSAGE(4);
  OVER := FALSE;
  WHILE NOT OVER AND NOT TERMINATE AND NOT RESTART DO BEGIN

    CASE MODE OF
      1:BEGIN

          PROMPT(0);
          THINK(FROM_ND,TO_ND,LOC,ST);
          PROMPT(23);
          CT_LAST_F := FROM_ND;
          CT_LAST_T := TO_ND;

        END;
      2:BEGIN

          GET_MOVE(FROM_ND,TO_ND,LOC,ST);
          IF (NOT TERMINATE )AND (NOT BACKING) THEN BEGIN

            OP_LAST_F := FROM_ND;
            OP_LAST_T := TO_ND;

          END;

        END;
    END;

    IF (NOT TERMINATE) AND (NOT BACKING)  THEN BEGIN

      UPDATE_POSITION(LOC,TO_ND,ST);
      MOVEIT(FROM_ND,TO_ND,ST);
      CHECK_FOR_WINNER;
      IF NOT OVER THEN MODE := (MODE MOD 2) + 1;
      NUM_MOVES := NUM_MOVES + 1;
      RECORD_MOVE;
      SING_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T);

    END;
    BACKING   := FALSE;

  END;
  GAME_OVER;

END; (* OVERLAY PLAYLOOP *)


OVERLAY PROCEDURE HUMANS_PLAYLOOP;
VAR

  FROM_ND,
  TO_ND,
  LOC,
  I,
  ST,PLAYER,
  TEMP_MODE :BYTE;
  OVER      :BOOLEAN;


  PROCEDURE CHECK_FOR_WINNER;
  VAR

    I : BYTE;

  BEGIN

    OVER := TRUE;
    FOR I := 1 TO 10 DO

    IF ODD(MODE) THEN BEGIN

      IF (PLAYERS[PLAY_SETS[PLAYER].CT][I] < FIXED_LOC[PLAY_SETS[PLAYER].OP][1])
      OR (PLAYERS[PLAY_SETS[PLAYER].CT][I] > FIXED_LOC[PLAY_SETS[PLAYER].OP][10])
      THEN OVER:=FALSE;

    END
    ELSE BEGIN

      IF (PLAYERS[PLAY_SETS[PLAYER].OP][I] < FIXED_LOC[PLAY_SETS[PLAYER].CT][1])
      OR (PLAYERS[PLAY_SETS[PLAYER].OP][I] > FIXED_LOC[PLAY_SETS[PLAYER].CT][10])
      THEN OVER:=FALSE;

    END;

  END; (* CHECK_FOR_WINNER *)


BEGIN

  FROM_ND := 0;
  TO_ND   := 0;
  IF PLAY_MODE <> REASSUME THEN BEGIN

    NUM_MOVES := 0;
    MODE      := 1;
    RECORD_MOVE;

  END
  ELSE BEGIN

    IF MODE = 1
    THEN MULT_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T,NUM_PLAYERS)
    ELSE MULT_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T,MODE - 1);

  END;

  MESSAGE(5);
  OVER   := FALSE;
  WHILE (NOT OVER) AND (NOT TERMINATE) AND (NOT RESTART) DO BEGIN

    CASE MODE OF

      1:PLAYER := 1;
      2:PLAYER := 1;
      3:PLAYER := 2;
      4:PLAYER := 2;
      5:PLAYER := 3;
      6:PLAYER := 3;

    END;  (* CASE MODE *)


    IF ODD(MODE) THEN GET_MOVE(FROM_ND,TO_ND,LOC,PLAY_SETS[PLAYER].CT)
    ELSE              GET_MOVE(FROM_ND,TO_ND,LOC,PLAY_SETS[PLAYER].OP);
    IF (NOT TERMINATE )AND (NOT BACKING) THEN BEGIN

      IF ODD(MODE) THEN BEGIN

        UPDATE_POSITION(LOC,TO_ND,PLAY_SETS[PLAYER].CT);
        MOVEIT(FROM_ND,TO_ND,PLAY_SETS[PLAYER].CT);

      END
      ELSE BEGIN

        UPDATE_POSITION(LOC,TO_ND,PLAY_SETS[PLAYER].OP);
        MOVEIT(FROM_ND,TO_ND,PLAY_SETS[PLAYER].OP);

      END;
      CHECK_FOR_WINNER;
      OP_LAST_F := CT_LAST_F;
      OP_LAST_T := CT_LAST_T;
      CT_LAST_F := FROM_ND;
      CT_LAST_T := TO_ND;
      TEMP_MODE := MODE;
      IF NOT OVER THEN  MODE := (MODE MOD NUM_PLAYERS) + 1;
      NUM_MOVES := NUM_MOVES + 1;
      RECORD_MOVE;
      MULT_DISPLAY(FROM_ND,TO_ND,OP_LAST_F,OP_LAST_T,TEMP_MODE);

    END;
    BACKING := FALSE;

  END;
  GAME_OVER;

END; (* OVERLAY HUMANS_PLAYLOOP *)


OVERLAY PROCEDURE CHOICES;


  PROCEDURE ASSIGN_SETS(N:BYTE);
  BEGIN

    CASE N OF

      2:BEGIN

          NUM_SETS        := 1;
          PLAY_SETS[1].CT := 1;
          PLAY_SETS[1].OP := 4;

         END;
      4:BEGIN

          NUM_SETS        := 2;
          PLAY_SETS[1].CT := 6;
          PLAY_SETS[1].OP := 3;
          PLAY_SETS[2].CT := 2;
          PLAY_SETS[2].OP := 5;

        END;
      6:BEGIN

          NUM_SETS        := 3;
          PLAY_SETS[1].CT := 6;
          PLAY_SETS[1].OP := 3;
          PLAY_SETS[2].CT := 2;
          PLAY_SETS[2].OP := 5;
          PLAY_SETS[3].CT := 1;
          PLAY_SETS[3].OP := 4;

        END;

    END;

  END; (* ASSIGN_SETS *)


  PROCEDURE START_A_GAME;

    PROCEDURE HOW_MANY_SETS;
    VAR

      CH  :CHAR;

    BEGIN

      REPEAT

        PROMPT(3);
        READER(2,CH);
        CASE CH OF

         'S':ASSIGN_SETS(2);
         'D':ASSIGN_SETS(4);
         'T':ASSIGN_SETS(6);
         'I':HELP;
         'Q':START_OVER;

        END;

      UNTIL (CH <> 'I') OR RESTART OR TERMINATE;

    END; (* HOW_MANY_SETS *)


    PROCEDURE SKILL_LEVEL;
    VAR

      CH  :CHAR;

    BEGIN

      REPEAT

        PROMPT(4);
        READER(3,CH);
        CASE CH OF

          '1':DEG_DIFFICULTY := 1;
          '2':DEG_DIFFICULTY := 2;
          '3':DEG_DIFFICULTY := 3;
          '4':DEG_DIFFICULTY := 4;
          '5':DEG_DIFFICULTY := 5;
          'I':HELP;
          'Q':START_OVER;

        END;  (* CASE *)

      UNTIL (CH <> 'I') OR RESTART OR TERMINATE;

    END; (* SKILL_LEVEL *)


    PROCEDURE WHO_GOES_FIRST;
    VAR

      CH :CHAR;

    BEGIN

      PROMPT(5);
      READER(4,CH);
      CASE CH OF

        'Y','Y' : ME_FIRST := TRUE;
        'N','n' : ME_FIRST := FALSE;
        'Q','q' : START_OVER;

      END;

    END; (* WHO_GOES_FIRST *)


  BEGIN (* START_A_GAME *)

    HOW_MANY_SETS;
    IF NOT RESTART AND NOT TERMINATE THEN SKILL_LEVEL;
    IF NOT RESTART AND NOT TERMINATE THEN WHO_GOES_FIRST;

  END; (* START_A_GAME *)


  PROCEDURE REASSUME_GAME(VAR OK :BOOLEAN);
  BEGIN

    WHERE_IS_THE_GAME(OK);
    IF OK THEN GET_GAME(OK);
    MOVED_YET := FALSE;

  END;  (* REASSUME_GAME *)


  PROCEDURE HUMAN_PLAYERS;
  VAR

    CH :CHAR;

  BEGIN

    REPEAT

      PROMPT(7);
      READER(6,CH);
      IF CH IN ['2','4','6'] THEN BEGIN

        NUM_PLAYERS := ORD(CH) - 48;
        ASSIGN_SETS(NUM_PLAYERS);

      END
      ELSE IF CH = 'I' THEN HELP
      ELSE START_OVER;

    UNTIL (CH <> 'I') OR RESTART OR TERMINATE;

  END; (* HUMAN_PLAYERS *)


  PROCEDURE SELECT_MODE;
  VAR

    CH         :CHAR;
    OK         :BOOLEAN;

  BEGIN

    OK      := FALSE;
    REPEAT

      RESTART := FALSE;
      PROMPT(1);
      PROMPT(22);
      READER(5,CH);
      CASE CH OF

       'N','n':BEGIN

                 INIT;
                 PLAY_MODE := NEW_GAME;
                 START_A_GAME;
                 IF (NOT RESTART)AND(NOT TERMINATE) THEN BEGIN

                   OK := TRUE;
                   MESSAGE(2);

                 END;

               END;
       'R','r':BEGIN

                 PLAY_MODE := REASSUME;
                 REASSUME_GAME(OK);

               END;
       'H','h':BEGIN

                 INIT;
                 PLAY_MODE := HUMAN;
                 HUMAN_PLAYERS;
                 IF (NOT RESTART)AND(NOT TERMINATE) THEN OK := TRUE;

               END;
       'I','i':HELP;
       'Q','q':TERMINATE := TRUE;

      END;

    UNTIL OK OR TERMINATE;

  END; (* SELECT_MODE *)

BEGIN (* CHOICES *)

  MAIN_SCREEN;
  SELECT_MODE;
  MODE_AND_COLOR(4);

END;  (*OVERLAY  CHOICES *)


PROCEDURE START_OVER;
(* External to choices because it is also used by help *)

VAR

  I :BYTE;
  CH:CHAR;

BEGIN

  RESTART   := FALSE;
  TERMINATE := FALSE;
  MESSAGE(1);
  READER(1,CH);
  IF CH IN ['Y','y'] THEN RESTART   := TRUE
  ELSE                    TERMINATE := TRUE;

END; (* START_OVER *)



