' BOXES.BAS -- This module creates and highlights the boxes on the screen
' and keeps track of the box coordinates
' $INCLUDE: 'J.INC'

BoxDefs:    'Size/position for various boxes
	DATA   4, 15,  1, 22   : 'Guess List Box
	DATA  19, 32,  1,  5   : 'Guess Box
	DATA  41, 57,  1,  5   : 'Known Box
	DATA  65, 73,  1,  5   : 'Score Box
	DATA  19, 73,  6, 10   : 'Excluded Letters Box
	DATA  19, 73, 11, 15   : 'Used Letters Box
	DATA  19, 73, 16, 22	  : 'Note Box
	DATA   1, 79, 23, 25   : 'Message Box
	DATA  20, 60,  5, 20   : 'Main Menu Box 
	DATA  15, 65,  7, 18   : 'Maintenance Menu Box
	DATA  20, 60, 11, 13   : 'Another Game Box

DIM SHARED Box(1 TO MaxBox) AS BoxType

SUB InitBoxes
	RESTORE BoxDefs
	FOR Lp = 1 TO MaxBox
		READ Box(Lp).LftCol, Box(Lp).RtCol
		READ Box(Lp).TopRow, Box(Lp).BotRow
	NEXT Lp
END SUB

SUB MakeBox (BoxNum, Clr)
	COLOR Clr, Background, Background
	LftCol = Box(BoxNum).LftCol
	RtCol = Box(BoxNum).RtCol
	TopRow = Box(BoxNum).TopRow
	BotRow = Box(BoxNum).BotRow
	Htemp$ = STRING$(RtCol - LftCol - 1, 205)
	LOCATE TopRow, LftCol, 0
	PRINT CHR$(201); Htemp$; CHR$(187);
	FOR Lp = TopRow + 1 TO BotRow - 1
		LOCATE Lp, LftCol, 0
		PRINT CHR$(186);
		LOCATE Lp, RtCol, 0
		PRINT CHR$(186);
	NEXT Lp
	LOCATE BotRow, LftCol, 0
	PRINT CHR$(200); Htemp$; CHR$(188);
END SUB

SUB HighlightBox (BoxNum%)
	CALL MakeBox(BoxNum%, HighLight)
END SUB

SUB NormalBox (BoxNum%)
	CALL MakeBox(BoxNum%, Normal)
END SUB

SUB BoxCoords (BoxNum%, CallBox AS BoxType)
	CallBox = Box(BoxNum)
END SUB

