'SPLITTXT.BAS
'INDFMT(2,32)
'SOMETIMES, AN ASCII TEXT FILE IS TOO BIG TO BE PROPERLY READ BY THE USUAL
' ASCII TEXT EDITORS, SUCH AS "EDIT" AND "E", OR EVEN THE WINDOWS READERS,
' "NOTEPAD" AND "WORDPAD".
'TO ACCESS SUCH FILES, THE HUGE FILE MUST BE BROKEN UP INTO A SERIES OF
' SMALLER, MORE MANAGEABLE FILES.  AFTER ANY MODIFICATIONS OF THE INDIVIDUAL
' PIECES, THESE CAN BE RECOMBINED TO REFORE THE HUGE FILE AS BEFORE.

CONST LIM = 3000               'MAX NUMBER OF LINES IN EACH SMALLER FILE

DIM L AS STRING                'HOLDS A LINE OF TEXT
DIM OutFil AS STRING           'NAME OF OUTPUT SECTION BEING WRITTEN
DIM Filn AS STRING             'FILENAME.EXT OF SOURCE FILE
DIM Fil AS STRING              'THE FILENAME OF THE SOURCE
DIM Ext AS STRING              'THE EXTENSION OF THE SOURCE
DIM Cnt AS INTEGER             'THE COUNTER OF NUMBER OF LINES
DIM Where AS INTEGER           'RESULTS OF INSTR LOCATOR
DIM SECTION AS INTEGER         'EXTENSION NUMBER ON SERIES OF
                               ' OUTPUT SECTIONS

CLS                            'CLEAR THE SCREEN

PRINT "Specify the FILENAME.EXT of the huge file to be split up: "
LINE INPUT Filn
Where = INSTR(Filn, ".")       'LOOK FOR THE DOT IN THE FILESPEC
IF Where THEN                  'WAS A PERIOD SPECIFIED?
: Fil = LEFT$(Filn, Where - 1) 'SELECT PART TO LEFT OF PERIOD
: Ext = MID$(Filn, Where + 1)  'REST OF NAME IS EXTENSION
ELSE                           'SINCE NO PERIOD WAS SPECIFIED
: Ext = "TXT"                  'SELECT THE DEFAULT OF .TXT
: Fil = Filn                   'USE THE INPUT NAME AS THE FILENAME
END IF

PRINT "Processing "; Fil + "." + Ext + "..."

SECTION = 1                    'START WITH FIRST SECTION

OPEN Fil + "." + Ext FOR INPUT AS #1

DO WHILE NOT EOF(1)            'PROCESS THE ENTIRE SOURCE FILE
: OutFil = Fil + "." + MID$(STR$(SECTION), 2)'CREATE THE OUTPUT
:                              ' FILE SECTION NAME
: OPEN OutFil FOR OUTPUT AS #2 'OPEN THE OUTPUT SECTION
: PRINT "WRITING "; OutFil     'DISPLAY A STATUS REPORT
: Cnt = 1                      'INIT COUNTER OF LINES OF SMALL OUTPUT FILE
: DO WHILE NOT EOF(1)          'PROCESS ONE SMALL OUTPUT FILE
: : LINE INPUT #1, L           'READ A LINE FROM BIG SOURCE
: : PRINT #2, L                'SEND THIS LINE TO THE OUTPUT
: : IF Cnt >= LIM THEN         'IF OUTPUT IS FULL, QUIT
: : : EXIT DO                  'QUIT THE INNER LOOP
: : END IF
: : Cnt = Cnt + 1              'COUNT THIS LINE
: LOOP                         'GO BACK AND GET ANOTHER LINE

: CLOSE #2                     'FINISHED WITH THIS OUTPUT SECTION
: SECTION = SECTION + 1        'SET UP FOR NEXT SECTION
LOOP                           'GO CREATE THE NEXT SECTION

CLOSE #1                       'FINISHED WITH THE INPUT FILE
SYSTEM                         'RETURN TO DOS
'------------------------------

