/********** The Son of Tetris Project ************/

/************  get LEVEL value etc. ***********/

#include <conio.h>
#include <ctype.h>
#include <setjmp.h>
#include <stdio.h>

#include "sot.h"

#define LEVEL_COL 19
#define LEVEL_ROW 14
#define LEVEL_WIDTH 48
#define LEVEL_DEPTH 5

#define AG_COL 19
#define AG_ROW 18
#define AG_WIDTH 46
#define AG_DEPTH 5

#define CH_COL 19
#define CH_ROW 7
#define CH_WIDTH 46
#define CH_DEPTH 10

#define PG_COL 19
#define PG_ROW 10
#define PG_WIDTH 46
#define PG_DEPTH 8

#define NN_COL 19
#define NN_ROW 10
#define NN_WIDTH 46
#define NN_DEPTH 8

extern jmp_buf    end_game;

static void set_window(int left,int top,int right,int bot,void *store)
{
  textattr((BLACK << 4) + WHITE);
  gettext(left, top, right, bot, store);
  window(left,top,right,bot); gotoxy(1,1);
  cursor_on();
}

static void lose_window(int left,int top,int right,int bot,void *store)
{
  cursor_off();
  textattr((BLACK << 4) + LIGHTGRAY);
  window(1,1,80,25);
  puttext(left, top, right, bot, store);
}



unsigned get_level(void)
{
  int store[LEVEL_WIDTH * LEVEL_DEPTH * 2];
  unsigned result = 5;
  int char_in;

  set_window(LEVEL_COL,LEVEL_ROW,LEVEL_COL + LEVEL_WIDTH,LEVEL_ROW + LEVEL_DEPTH, store);
  cputs("Ŀ\n");
  cputs("                                          \n");
  cputs(" Enter your starting level (0-9) [5] >    \n");
  cputs("                                          \n");
  cputs("\n");

  gotoxy(41,3);
  char_in = getch();
  if (char_in == ESC)
    longjmp(end_game,1);
  if(isdigit(char_in))
    result = char_in - '0';
  putch(result + '0');

  lose_window(LEVEL_COL,LEVEL_ROW,LEVEL_COL + LEVEL_WIDTH,LEVEL_ROW + LEVEL_DEPTH, store);
  return(result);
} /* get_level */



void  get_new_name(char *name)
{
  int store[NN_WIDTH * NN_DEPTH * 2], count;

  set_window(NN_COL,NN_ROW,NN_COL + NN_WIDTH,NN_ROW + NN_DEPTH, store);
  cputs("Ŀ\n");
  cputs(" Brill score cobber!                      \n");
  cputs(" Enter your name >                        \n");
  cputs("\n");

  gotoxy(21,3);
  for (count = 0;
       count < 19;
       name++, count++)
  {
    *name = getche();
    if (*name == '\b')
    {
      count -= 2;
      if (count < -1)
      {
	*name = 0;
        lose_window(NN_COL,NN_ROW,NN_COL + NN_WIDTH,NN_ROW + NN_DEPTH, store);
	return;
      }
      putch(' '); putch('\b');
      name-=2;
    }
    if (*name == '\r')
      break;

    if (*name == ESC)
      longjmp(end_game,1);
  }
  *name = 0; /* Terminate string */

  lose_window(NN_COL,NN_ROW,NN_COL + NN_WIDTH,NN_ROW + NN_DEPTH, store);
}  /* get_new_name */



unsigned  get_another_go(long new_score) /* Dialogue between games */
{
  int store[AG_WIDTH * AG_DEPTH * 2], ch_store[CH_WIDTH * CH_DEPTH * 2];
  auto unsigned result = TRUE;
  char name[20];
  long score;
  int rank;

  champ_val(name, &score, TABLE_LEN);  /* get current bottom of table */

  if (score < new_score)
  {
    get_new_name(name);
    update_score_table(name, new_score);
  }

  set_window(CH_COL,CH_ROW,CH_COL + CH_WIDTH,CH_ROW + CH_DEPTH, ch_store);
  cputs("Ŀ\n");
  cputs("  SOT Champions                         \n");
  cputs("                                        \n");
  cputs("  1.                                    \n");
  cputs("  2.                                    \n");
  cputs("  3.                                    \n");
  cputs("  4.                                    \n");
  cputs("  5.                                    \n");
  cputs("                                        \n");
  cputs("\n");

  for (rank = 1; rank <= TABLE_LEN; rank++)
  {
    champ_val(name, &score, rank);
    gotoxy(7,rank+3);
    if (score)
      cprintf("%-20s  %8ld",name,score);
    else
      break;
  } /* for */



  set_window(AG_COL,AG_ROW,AG_COL + AG_WIDTH,AG_ROW + AG_DEPTH, store);
  cputs("Ŀ\n");
  cputs("                                        \n");
  cputs(" Do you want another go? (Y/N) [Y] >    \n");
  cputs("                                        \n");
  cputs("\n");

  gotoxy(39,3);
  if (toupper(getch()) == 'N')
  {
    result = FALSE;
    putch('N');
  }
  else
    putch('Y');

  lose_window(AG_COL,AG_ROW,AG_COL + AG_WIDTH,AG_ROW + AG_DEPTH, store);
  lose_window(CH_COL,CH_ROW,CH_COL + CH_WIDTH,CH_ROW + CH_DEPTH, ch_store);
  return(result);
} /* get_another_go */


unsigned pause_game(void)
{
  int store[PG_WIDTH * PG_DEPTH * 2];
  unsigned result = FALSE;

  set_window(PG_COL,PG_ROW,PG_COL + PG_WIDTH,PG_ROW + PG_DEPTH, store);
  cputs("Ŀ\n");
  cputs("                                          \n");
  cputs(" PAUSED...                                \n");
  cputs("                                          \n");
  cputs(" Press a key when you are ready to go on, \n");
  cputs(" or use ESC to quit >                     \n");
  cputs("                                          \n");
  cputs("\n");

  gotoxy(24,6);
  if (getch() == ESC)
    result = TRUE;

  lose_window(PG_COL,PG_ROW,PG_COL + PG_WIDTH,PG_ROW + PG_DEPTH, store);
  return(result);

} /* pause_game */

