1000 REM **********************************************************************
1010 REM *******                                                       ********
1020 REM ******                                                          ******
1030 REM *****        ANIMATION CREATION  Demonstration Program           *****
1040 REM ****                                                              ****
1050 REM ***     This program is intended to show you how to use the        ***
1060 REM **      screens created by the ANIMATION CREATION Builder in        **
1070 REM *       your own BASICA programs.  With BASICA, you may add          *
1080 REM **      sound or music by using the BASICA PLAY and SOUND           **
1090 REM ***     statements, or take advantage of other features in         ***
1100 REM ****    the language.                                             ****
1110 REM *****                                                            *****
1120 REM ******  All references are made to the BASIC manual.           *******
1130 REM *******                                                       ********
1140 REM **********************************************************************
1150 REM ***
1160 REM ***    IBM Personal Computer
1170 REM ***    (c) Copyright International Business Machines
1180 REM ***        Corporation 1983
1190 REM ***    Licensed Material
1200 REM ***    Program Property of IBM
1210 REM ***
1220 REM **********************************************************************
1230 REM ***
1240 REM ***                    VARIABLE DEFINITIONS
1250 REM ***
1260 REM ***   CHAR         --- checks existence of Color/Graphics adapter
1270 REM ***   CHUG$        --- component of string for chugging music
1280 REM ***   CHUG1$       --- first half of the chugging music string
1290 REM ***   CHUG2$       --- second half of the chugging music string
1300 REM ***   CNT1         --- counter used in FOR loops
1310 REM ***   DELAY        --- counter used to delay animation
1320 REM ***   IBMMONO      --- used to test for color display
1330 REM ***   OFFSET       --- offset into screen buffer
1340 REM ***   SCR$()       --- names of files to be loaded
1350 REM ***   S$           --- screen name   for the BLOAD subroutine
1360 REM ***   SN           --- screen number for the BLOAD subroutine
1370 REM ***   SW           --- screen width  for the BLOAD subroutine
1380 REM ***   WHISTLE$     --- string for train whistle music
1390 REM ***
1400 DEFINT C,D,I,O,S          'declare variables not ending in $ as integer
1410 DIM SCR$(7)               'holds 8 screen names (0 through 7)
1420 REM **********************************************************************
1430 REM ***
1440 REM ***                    CHECK FOR COLOR DISPLAY
1450 REM ***
1460 REM ***                    see the PEEK function in the BASIC manual
1470 REM ***
1480 REM **********************************************************************
1490 KEY OFF
1500 CLS                       'clear screen first - not necessary but nice
1510 COLOR 7,0,0
1520 DEF SEG = &HB800          'address of Color/Graphics Adapter
1530 POKE 100,ASC(" ")         'write a space to Color/Graphics Adapter
1540 CHAR = PEEK(100)          'read the character justed POKEd
1550 IF (CHAR = ASC(" ")) THEN GOTO 1730
1560 REM **********************************************************************
1570 REM ***
1580 REM ***                    OOPS !  DOES NOT HAVE COLOR ADAPTER !
1590 REM ***
1600 REM **********************************************************************
1610 LOCATE 13,10              'puts message at middle of screen
1620 PRINT "*** YOU MUST HAVE A COLOR DISPLAY TO RUN THIS DEMO !!! ***"
1630 PLAY "O0T180C"            'sound an alarm
1640 LOCATE 23,1               'puts DOS's "A>" on bottom of screen
1650 SYSTEM                    'cannot go on without Color/Graphics adapter
1660 REM **********************************************************************
1670 REM ***
1680 REM ***                    SWITCH TO COLOR DISPLAY
1690 REM ***
1700 REM ***                    see SWITCHING DISPLAYS in appendix I
1710 REM ***
1720 REM **********************************************************************
1730 DEF SEG = 0
1740 POKE &H410,(PEEK(&H410) AND &HCF) OR &H10
1750 SCREEN 1,0,0,0
1760 SCREEN 0,1,0,0
1770 WIDTH 40
1780 LOCATE ,,1,6,7
1790 REM **********************************************************************
1800 REM ***
1810 REM ***                    INITIALIZE VARIABLES
1820 REM ***
1830 REM **********************************************************************
1840 FOR  CNT1 = 1 TO 10
1850      KEY CNT1,""          'set function keys to null string ""
1860 NEXT CNT1
1870 CHUG$    = "O0L8FO1CO0FO1C"
1880 CHUG1$   = "MBMLT60  X CHUG$; T80  X CHUG$; T100 X CHUG$; T120 X CHUG$;"
1890 CHUG2$   = "MBMLT140 X CHUG$; T160 X CHUG$; T180 X CHUG$; T200 X CHUG$;"
1900 WHISTLE$ = "MBMLl1t255o2dp4dp1dp4dp1p1p1dp4dp1dp4dP64"
1910 REM **********************************************************************
1920 REM ***
1930 REM ***                    READ SCREEN NAMES FROM DATA STATEMENTS
1940 REM ***
1950 REM **********************************************************************
1960 FOR  CNT1 = 0 TO 7
1970      READ SCR$(CNT1)      'store names in SCR$() array
1980 NEXT CNT1
1990 REM **********************************************************************
2000 REM ***
2010 REM ***                    FILE NAMES OF SCREENS TO BE LOADED
2020 REM ***
2030 REM ***                    DATA statements are nonexecutable and can
2040 REM ***                    be placed anywhere in the program.
2050 REM ***
2060 REM ***                    See the DATA statement and also see the READ
2070 REM ***                    statement in your BASIC manual.
2080 REM ***
2090 REM **********************************************************************
2100 DATA "TRAIN.S41"
2110 DATA "TRAIN.S42"
2120 DATA "SUN.S41"
2130 DATA "SUN.S42"
2140 DATA "SUN.S43"
2150 DATA "SUN.S44"
2160 DATA "SUN.S45"
2170 DATA "SUN.S46"
2180 REM **********************************************************************
2190 REM ***
2200 REM ***                    LOAD THE SCREENS STORED ON DISKETTE
2210 REM ***
2220 REM ***                    Use the BLOAD subroutine to load them.
2230 REM ***                    SCR$(0) will be in screen 0,
2240 REM ***                    SCR$(1) will be in screen 1, etc.
2250 REM ***
2260 REM **********************************************************************
2270 FOR  CNT1 = 0 TO 7
2280      SN  = CNT1           'set  BLOAD screen number parameter
2290      SW  = 40             'set  BLOAD screen width  parameter
2300      S$  = SCR$(CNT1)     'set  BLOAD screen name   parameter
2310      GOSUB 3050           'call BLOAD to load in the screens
2320 NEXT CNT1
2330 REM **********************************************************************
2340 REM ***
2350 REM ***                    PRINT END MESSAGE AND SET F9 CONTROL POINT
2360 REM ***
2370 REM **********************************************************************
2380 COLOR 15,0,0              'set color for message to high intensity white
2390 FOR  CNT1 = 2 TO 7
2400      SCREEN ,,CNT1,0      'write to visual screen number 2 through 7
2410      LOCATE 25,1,0        'point to where message is to start
2420      PRINT "    Press Fn-F9 to end demonstration";
2430 NEXT CNT1
2440 ON KEY(9) GOSUB 3170      'control goes to line 3170 if F9 is pressed
2450 KEY(9) ON                 'but it must be turned on first
2460 REM **********************************************************************
2470 REM ***
2480 REM ***                    SCROLL THROUGH SCREENS FOR ANIMATION
2490 REM ***
2500 REM **********************************************************************
2510 REM ---- SHOW FIRST SCREEN AND PAUSE -------------------------------------
2520 SCREEN ,,0,0
2530 FOR DELAY = 1 TO 4000 : NEXT DELAY
2540 REM ----  PLAY THE TRAIN CHUGGING ----------------------------------------
2550 PLAY CHUG1$ + CHUG2$
2560 REM ----  THIS MAKES THE TRAIN IN SYNCH WITH THE CHUGGING MUSIC ----------
2570 FOR  CNT0 = 24 TO 4 STEP -1
2580      SCREEN ,,0,0   : FOR DELAY = 1 TO CNT0 * 10 : NEXT DELAY
2590      SCREEN ,,1,1   : FOR DELAY = 1 TO CNT0 * 10 : NEXT DELAY
2600 NEXT CNT0
2610 REM ----  PLAY THE TRAIN WHISTLE -----------------------------------------
2620 PLAY WHISTLE$
2630 REM ----  THIS MAKES THE TRAIN RUN AT A STEADY SPEED WHILE WHISTLING -----
2640 FOR  CNT0 = 1 TO 120
2650      SCREEN ,,0,0   : FOR DELAY = 1 TO 40 : NEXT DELAY
2660      SCREEN ,,1,1   : FOR DELAY = 1 TO 40 : NEXT DELAY
2670 NEXT CNT0
2680 REM ----  PAUSE AGAIN -------------------------------------------
2690 SCREEN ,,0,0
2700 FOR DELAY = 1 TO 4000 : NEXT DELAY
2710 REM ----  SHOW THE BEACH/BIRDS 8 TIMES --------------------------
2720 FOR  CNT0 = 1 TO 8
2730      SCREEN ,,2,2   : FOR DELAY = 1 TO 300 : NEXT DELAY
2740      SOUND 4150,3         'bird sound # 1
2750      SOUND 4050,2         'bird sound # 2
2760      SCREEN ,,3,3   : FOR DELAY = 1 TO 300 : NEXT DELAY
2770      SCREEN ,,4,4   : FOR DELAY = 1 TO 300 : NEXT DELAY
2780      SCREEN ,,5,5   : FOR DELAY = 1 TO 300 : NEXT DELAY
2790      SOUND 4050,2         'bird sound # 2
2800      SOUND 4150,3         'bird sound # 1
2810      SCREEN ,,6,6   : FOR DELAY = 1 TO 300 : NEXT DELAY
2820      SCREEN ,,7,7   : FOR DELAY = 1 TO 300 : NEXT DELAY
2830 NEXT CNT0
2840 GOTO 2520               'loop back to first set of screens until F9
2850 END                     'good practice to put END before subroutines
2860 REM **********************************************************************
2870 REM ***
2880 REM ***                  BLOAD SUBROUTINE
2890 REM ***
2900 REM ***                  --- SN = screen number
2910 REM ***                  --- SW = screen width
2920 REM ***                  --- S$ = screen filespec
2930 REM ***
2940 REM ***                  SW is 40 for 40x24 screens; 80 for 80x24 screens
2950 REM ***                  See the BLOAD statement and also the example in
2960 REM ***                  you BASIC manual.
2970 REM ***
2980 REM ***                  Up to 4 80x24 screens or 8 40x24 screens can be
2990 REM ***                  in the screen buffer at one time.
3000 REM ***
3010 REM ***                  You cannot have both 40x24 and 80x24 screens in
3020 REM ***                  the buffer at the same time !
3030 REM ***
3040 REM **********************************************************************
3050 DEF SEG = &HB800        'point SEG to color screen buffer
3060 OFFSET  = 2048 * SN * SW / 40
3070 BLOAD   S$,OFFSET       'load the screen image into the screen buffer
3080 SCREEN  ,,SN,0          'point to screen image just loaded
3090 LOCATE  25,1,0
3100 PRINT SPC(SW - 1);      'erase data on line 25 put there by the BUILDER
3110 RETURN                  'return to caller
3120 REM **********************************************************************
3130 REM ***
3140 REM ***                    EXIT ROUTINE -- CALLED BY PRESSING F9
3150 REM ***
3160 REM **********************************************************************
3170 COLOR 7,0,0
3180 WIDTH 80
3190 CLS
3200 SYSTEM
**