10  ' COMBAT - CONFLICT SIMULATION
20      CLEAR,,,32768!
25      ON KEY(1) GOSUB 8600
26      KEY(1) ON
30      DEFINT A-Z
40      GOSUB 890      'HEADING SCREEN
50      GOSUB 1300      'INSTRUCTIONS
60      GOSUB 270        'DRAW MAP
70      GOSUB 480       'SETUP TERRAIN ARRAYS
80      GOSUB 3830      'PLACE ARMY UNIT
90      FOR TURN = 1 TO 8
100        LET ARMY$ = "R"
110        GOSUB 4300   'RED ARMY MOVE
120        LET ARMY$ = "R"
130        GOSUB 5520   'RED ARMY ATTACK
140        LET ARMY$ = "U"
150        GOSUB 4300   'US ARMY MOVE
160        LET ARMY$ = "U"
170        GOSUB 5520   'US ARMY ATTACK
180     NEXT TURN
190      GOSUB 5400    'FIND WINNER
200      CLS
210      PRINT "PLAY AGAIN? (Yes/No)"
220      GOSUB 1220      'WAIT FOR REPLY
230      IF REPLY$ = "Y" OR REPLY$ = "y" THEN                                              RUN
240 END
250 '****************************************************************************
260 '
270 'DRAW MAP
280       COLOR 7,8
290       CLS
300       FOR V = 0 TO 168 STEP 24
310         FOR H = 4 TO 292 STEP 48
320           IF V = 0 AND H = 292 GOTO 330                                                     ELSE LINE (H+0,V+12)-(H+6,V+0)        'LEFT TOP
330          IF V = 0 AND H <> 292 THEN LINE (H+6,V+0)-(H+24,V+0)      'TOP
340          IF H <> 292 THEN  LINE (H+24,V+0)-(H+30,V+12)      'RIGHT TOP
350          IF V = 168 AND H  = 292 GOTO 360                                                   ELSE LINE (H+0,V+12)-(H+6,V+24)       'BOTTOM LEFT
360          IF H <> 292 THEN LINE (H+6,V+24)-(H+24,V+24)   'BOTTOM
370          IF H <> 292 THEN LINE (H+24,V+24)-(H+30,V+12)   'BOTTOM RIGHT
380        NEXT H
390      NEXT V
400      FOR V = 12 TO 174 STEP 24
410         FOR H = 34 TO 304 STEP 48
420          IF V = 12 THEN LINE (H+0,V+0)-(H+18,V+0)      'TOP
430          LINE (H+0,V+24)-(H+18,V+24)   'BOTTOM
440        NEXT H
450      NEXT V
460 RETURN
470 '***************************************************************************
480 'SETUP TERRAIN ARRAYS
490     DIM TERRAIN$(22,10)
500     DIM ATTACK(10,6)
510 '    W = WOODED
520 '    C = CITY
530 '    O = OFF MAP
540 '    L = LAKE OR RIVER
550     LET TERRAIN$(3,3) = "W"
560     LET TERRAIN$(2,6) = "W"
570     LET TERRAIN$(3,7) = "L"
580     LET TERRAIN$(5,6) = "W"
590     LET TERRAIN$(6,3) = "W"
600     LET TERRAIN$(1,7) = "C"
610     LET TERRAIN$(3,2) = "C"
620     LET TERRAIN$(4,5) = "C"
630     LET TERRAIN$(2,8) = "O"
640     LET TERRAIN$(4,8) = "O"
650     LET TERRAIN$(6,8) = "O"
660     LET TERRAIN$(8,8) = "O"
670     LET TERRAIN$(6,2) = "W"
680     LET TERRAIN$(6,3) = "W"
690     LET TERRAIN$(6,4) = "W"
700     LET TERRAIN$(6,5) = "W"
710     LET TERRAIN$(6,6) = "W"
720     LET TERRAIN$(10,8) = "O"
730     LET TERRAIN$(7,3) = "L"
740     LET TERRAIN$(7,4) = "W"
750     LET TERRAIN$(7,5) = "W"
760     LET TERRAIN$(7,6) = "W"
770     LET TERRAIN$(7,5) = "W"
780     LET TERRAIN$(12,8) = "O"
790    FOR H.CORD = 1 TO 12
800      FOR V.CORD = 1 TO 8
810        IF TERRAIN$(H.CORD,V.CORD) = "W" THEN                                               LET P.COLOR = GREEN:                                                            GOSUB 8280
820        IF TERRAIN$(H.CORD,V.CORD) = "C" THEN                                               LET P.COLOR = BROWN:                                                            GOSUB 8280
830        IF TERRAIN$(H.CORD,V.CORD) = "L" THEN                                                LET P.COLOR = LT.BLUE:                                                          GOSUB 8280
840      NEXT V.CORD
850    NEXT H.CORD
860 RETURN
870 '**************************************************************************
880 '
890 'HEADING SCREEN
900     KEY OFF
910     SCREEN 5
920    LET RED = 4
930    LET BROWN = 6
940    LET BLUE = 1
950    LET GREEN = 2
960    LET WHITE =15
970    LET LT.BLUE = 9
980    LET GRAY = 8
990    PALETTE 1,1     'BLUE
1000    PALETTE 2,2     'GREEN
1010    PALETTE 3,3     'CYAN
1020    PALETTE 4,4     'RED
1030    PALETTE 5,5     'MAGENTA
1040    PALETTE 6,6    'BROWN
1050    PALETTE 7,0     'BLACK
1060    PALETTE 8,8    'GRAY
1070    PALETTE 9,9    'LIGHT BLUE
1080      COLOR 7,15
1090      CLS
1100     LOCATE 3,1
1110    PRINT "             COMBAT"
1120    LOCATE 6,1
1130    PRINT "       CONFLICT SIMULATION"
1140    LOCATE 16,1
1150    PRINT "       HIT SPACE TO CONTINUE"
1160    GOSUB 1220      'WAIT
1170 RETURN
1180 '
1190 '***************************************************************************1136'
1200 '**************************************************************************
1210 '
1220 'WAIT FOR A REPLY
1230    DEF SEG=0: POKE 1050, PEEK(1052)        'CLEAR KEYBOARD BUFFER
1240    LET REPLY$ = INKEY$
1250    IF REPLY$ = "" THEN GOTO 1240
1260 RETURN
1270 '
1280 '**************************************************************************
1290 '
1300 'INSTRUCTIONS
1310    CLS
1320    PRINT "DO YOU WANT INSTRUCTIONS (YES/NO)?"
1330    GOSUB 1220      'WAIT FOR REPLY
1340    IF REPLY$ <> "Y" AND REPLY$ <> "y" THEN                                           GOTO 1400    'RETURN
1350    GOSUB 1430      'PRINT COLOR AND TERRAIN
1360    GOSUB 1960      'GAME TURN RULES
1370    GOSUB 2220      'MOVEMENT RULES
1380    GOSUB 2740      'COMBAT RULES
1390    GOSUB 3620      'HOW GAME IS WON
1400 RETURN
1410 '**************************************************************************
1420 '
1430 'PRINT COLOR AND TERRAIN
1440    CLS
1450    PRINT "        HEX COLORS AND TERRAIN"
1460    LET H = 1
1470    LET V = 10
1480    GOSUB 1860      'DRAW A HEX
1490    PAINT (5,15),2,7
1500    LOCATE 3,10
1510    PRINT "WOODED HEX -"
1520    LOCATE 4,10
1530    PRINT "MOVEMENT INTO A WOODED HEX "
1540    LOCATE 5,10
1550    PRINT "COUNTS AS TWO HEXES "
1560    LET H = 1
1570    LET V = 50
1580    GOSUB 1860      'DRAW A HEX
1590    PAINT (5,55),6,7
1600    LOCATE 8,10
1610    PRINT "CITY HEX "
1620    LET H = 1
1630    LET V = 80
1640    GOSUB 1860      'DRAW A HEX
1650    PAINT (5,85),4,7
1660    LOCATE 12,10
1670    PRINT "SOVIET RED ARMY UNIT"
1680    LET H = 1
1690    LET V = 110
1700    GOSUB 1860      'DRAW A HEX
1710    PAINT (5,115),1,7
1720    LOCATE 16,10
1730    PRINT "U.S. ARMY UNIT"
1740    LET H = 1
1750    LET V = 140
1760    GOSUB 1860      'DRAW A HEX
1770    PAINT (5,145),9,7
1780    LOCATE 19,10
1790    PRINT "RIVER OR LAKE HEX"
1800    LOCATE 23,10
1810    PRINT "HIT SPACE TO CONTINUE"
1820    GOSUB 1220      'WAIT FOR REPLY
1830 RETURN
1840 '
1850 '---------------------------------------------------------------------------
1860 'DRAW A HEX
1870      LINE (H+4,V+19)-(H+14,V+19)   'BOTTOM
1880      LINE (H+14,V+19)-(H+19,V+9)   'BOTTOM RIGHT
1890      LINE (H+0,V+9)-(H+4,V+0)        'LEFT TOP
1900      LINE (H+4,V+0)-(H+14,V+0)      'TO
1910      LINE (H+14,V+0)-(H+19,V+9)      'RIGHT TOP
1920      LINE (H+0,V+9)-(H+4,V+19)       'BOTTOM LEFT
1930 RETURN
1940 '
1950 '---------------------------------------------------------------------------
1960 'GAME TURN RULES
1970    CLS
1980    PRINT "           GAME TURN"
1990    PRINT
2000    PRINT "A GAME TURN CONSISTS OF FOUR STEPS"
2010    PRINT
2020    PRINT "STEP 1.  THE SOVIET PLAYER MOVES ANY OR"
2030    PRINT "         ALL OF HIS UNITS"
2040    PRINT
2050    PRINT "STEP 2.  THE SOVIET PLAYER MAY ATTACK"
2060    PRINT "         ANY U.S. UNIT IN A HEX NEXT"
2070    PRINT "         TO A RED ARMY UNIT"
2080    PRINT
2090    PRINT "STEP 3.  THE U.S. PLAYER MOVES ANY OR"
2100    PRINT "         ALL OF HIS UNITS"
2110    PRINT
2120    PRINT "STEP 4.  THE U.S. PLAYER MAY ATTACK "
2130    PRINT "         ANY SOVIET UNIT IN A HEX NEXT"
2140    PRINT "         TO A U.S. ARMY UNIT"
2150    PRINT
2160    LOCATE 23,10
2170    PRINT "HIT SPACE TO CONTINUE"
2180    GOSUB 1220      'WAIT FOR A REPLY
2190 RETURN
2200 '
2210 '---------------------------------------------------------------------------
2220 'MOVEMENT RULES
2230    CLS
2240    PRINT "       MOVEMENT RULES"
2250    PRINT
2260    PRINT "  DURING YOUR MOVEMENT TURN YOU MAY"
2270    PRINT "MOVE ANY OR ALL OF YOUR UNITS, "
2280    PRINT "OR NONE OF YOUR UNITS."
2290    PRINT
2300    PRINT "  YOU CANNOT MOVE INTO A HEX OCCUPIED"
2310    PRINT "BY ONE OF YOUR OWN OR AN ENEMY UNIT."
2320    PRINT
2330    PRINT "  YOU MAY NOT MOVE OFF THE MAP."
2340    PRINT
2350    PRINT "  YOU MAY MOVE EACH UNIT 1 TO 4 HEXES."
2360    PRINT
2370    PRINT "  IF YOU MOVE INTO A HEX NEXT TO"
2380    PRINT "AN ENEMY UNIT, YOU MUST STOP THERE."
2390    PRINT
2400    PRINT "  MOVEMENT INTO A WOODED HEX COUNTS"
2410    PRINT "AS TWO HEXES."
2420    PRINT
2430    PRINT "  YOU CANNOT MOVE INTO A RIVER OR"
2440    PRINT "LAKE HEX."
2450    LOCATE 23,10
2460    PRINT "HIT SPACE TO CONTINUE"
2470    GOSUB 1220      'WAIT FOR REPLY
2480 ' CONTINUE WITH MOVEMENT RULES
2490    CLS
2500    PRINT "        HOW TO MOVE YOUR UNITS"
2510    PRINT
2520    PRINT "  DURING YOUR MOVEMENT TURN, THE "
2530    PRINT "COMPUTER WILL ALLOW YOU TO MOVE YOUR"
2540    PRINT "UNITS ONE AT A TIME.  IT WILL TURN"
2550    PRINT "THE UNIT TO BE MOVED WHITE."
2560    PRINT
2570    PRINT "  IF YOU DO NOT WANT TO MOVE THE UNIT"
2580    PRINT "HIT THE SPACE BAR."
2590    PRINT
2600    PRINT "  TO MOVE THE UNIT UP, HIT CURSOR UP."
2610    PRINT
2620    PRINT "  TO MOVE THE UNIT DOWN, HIT CURSOR"
2630    PRINT "DOWN."
2640    PRINT
2650    PRINT "  TO MOVE THE UNIT DIAGONALLY "
2660    PRINT "HIT THE CURSOR LEFT OR RIGHT, THEN"
2670    PRINT "CURSOR UP OR DOWN."
2680    LOCATE 23,10
2690    PRINT "HIT SPACE TO CONTINUE"
2700    GOSUB 1220      'WAIT FOR REPLY
2710 RETURN
2720 '
2730 '---------------------------------------------------------------------------
2740 'COMBAT RULES
2750    CLS
2760    PRINT "              COMBAT RULES"
2770    PRINT
2780    PRINT "  TO ATTACK AN ENEMY UNIT YOUR UNIT(S)"
2790    PRINT "MUST BE IN A HEX NEXT TO THE ENEMY UNIT."
2800    PRINT
2810    PRINT "  YOU NEVER HAVE TO ATTACK IF YOU DON'T"
2820    PRINT "WANT TO."
2830    PRINT
2840    PRINT "  YOU MAY ATTACK AN ENEMY UNIT WITH"
2850    PRINT "ONE OR MORE OF YOUR UNITS."
2860    PRINT
2870    PRINT "  EACH UNIT MAY ATTACK ONLY ONCE PER "
2880    PRINT "TURN."
2890    PRINT
2900    PRINT "  A DEFENDING UNIT IN A WOODED HEX "
2910    PRINT "OR A CITY HEX HAS DOUBLE STRENGTH"
2920    PRINT "AND IS MORE DIFFICULT TO ATTACK."
2930    LOCATE 23,10
2940    PRINT "HIT SPACE TO CONTINUE"
2950    GOSUB 1220      'WAIT FOR REPLY
2960 ' COMBAT RESULTS
2970    CLS
2980    PRINT "             COMBAT RESULTS"
2990    PRINT
3000    PRINT "  COMBAT RESULTS ARE DETERMINED BY THE "
3010    PRINT "NUMBER OF UNITS ATTACKING AND A DICE"
3020    PRINT "ROLL.  THE MORE UNITS THAT ATTACK AN"
3030    PRINT "ENEMY UNIT, THE BETTER YOUR CHANCES"
3040    PRINT "FOR A FAVORABLE RESULT."
3050    PRINT
3060    PRINT "  THE POSSIBLE RESULTS ARE:"
3070    PRINT "DEFENDER ELIMINATED - ENEMY UNIT"
3080    PRINT "DESTROYED"
3090    PRINT "DEFENDER RETREATS - ENEMY MUST RETREAT."
3100    PRINT "ATTACKER RETREATS - YOU MUST RETREAT"
3110    PRINT "ATTACKER ELIMINATED -YOUR UNIT IS"
3120    PRINT "      DESTROYED"
3130    PRINT
3140    PRINT "  IF UNIT MUST RETREAT IT CANNOT MOVE"
3150    PRINT "INTO A HEX NEXT TO AN ENEMY UNIT.  IF"
3160    PRINT "UNIT CAN'T RETREAT IT IS ELIMINATED."
3170    LOCATE 23,10
3180    PRINT "HIT SPACE TO CONTINUE"
3190    GOSUB 1220      'WAIT FOR REPLY
3200 ' HOW TO ATTACK
3210    CLS
3220    PRINT "             HOW TO ATTACK"
3230    PRINT
3240    PRINT "  DURING YOUR ATTACK TURN THE COMPUTER "
3250    PRINT "SELECTS EACH UNIT THAT CAN MAKE AN "
3260    PRINT "ATTACK AND TURNS IT WHITE. "
3270    PRINT
3280    PRINT "  IF YOU DON'T WANT THAT UNIT TO ATTACK"
3290    PRINT "HIT THE SPACE BAR."
3300    PRINT
3310    PRINT "  IF YOU WANT THE UNIT TO ATTACK USE"
3320    PRINT "THE CURSOR KEYS TO SHOW WHICH DIRECTION"
3330    PRINT "TO ATTACK."
3340    PRINT
3350    PRINT "  USE CURSOR UP TO ATTACK UP, CURSOR"
3360    PRINT "DOWN TO ATTACK DOWN AND TO ATTACK "
3370    PRINT "DIAGONALLY, HIT THE CURSOR RIGHT OR"
3380    PRINT "LEFT, THEN CURSOR UP OR DOWN."
3390    LOCATE 23,1
3400    PRINT "HIT SPACE TO CONTINUE"
3410    GOSUB 1220      'WAIT FOR REPLY
3420 'RETREATS
3430    CLS
3440    PRINT "               RETREATS"
3450    PRINT
3460    PRINT "  IF YOUR UNIT(S) MUST RETREAT YOU "
3470    PRINT "HAVE ONE CHANCE TO MOVE EACH UNIT "
3480    PRINT "OUT OF DANGER.  IF YOU MAKE AN "
3490    PRINT "ILLEGAL MOVE OR MOVE INTO A HEX"
3500    PRINT "NEXT TO AN ENEMY UNIT, YOUR "
3510    PRINT "UNIT IS ELIMINATED."
3520    PRINT
3530    PRINT "  THE FIRST ATTACKING UNIT WILL MOVE"
3540    PRINT "INTO THE HEX VACATED BY THE RETREATING"
3550    PRINT "UNIT."
3560    LOCATE 23,1
3570    PRINT "HIT SPACE TO CONTINUE"
3580    GOSUB 1220      'WAIT
3590 RETURN
3600 '
3610 '---------------------------------------------------------------------------
3620 'HOW GAME IS WON
3630    CLS
3640    PRINT  "          HOW THE GAME IS WON"
3650    PRINT
3660    PRINT "  THE GAME LASTS 8 GAME TURNS.  THE"
3670    PRINT "PLAYER WHO HAS FULFILLED HIS MISSION"
3680    PRINT "AT THE END OF 10 TURNS WINS."
3690    PRINT
3700    PRINT "  THE MISSION OF THE SOVIET RED"
3710    PRINT "ARMY IS TO OCCUPY AT LEAST TWO"
3720    PRINT "OF THE CITIES ON THE MAP."
3730    PRINT
3740    PRINT "  THE MISSION OF THE U.S. ARMY"
3750    PRINT "IS TO PREVENT THE RED ARMY FROM"
3760    PRINT "OCCUPING MORE THAN ONE CITY."
3770    LOCATE 23,1
3780    PRINT "HIT SPACE TO CONTINUE"
3790    GOSUB 1220      'WAIT FOR REPLY
3800 RETURN
3810 '
3820 '**************************************************************************
3830 'PLACE ARMY UNITS
3840    DIM ARMY.LOC(10,3)
3850 '   LOCATION OF EACH ARMY
3860 '   1 = RED ARMY
3870 '   2 = US ARMY
3880    LET MAX.ARMY = 10
3890    LET ARMY.LOC(1,1) = 11
3900    LET ARMY.LOC(1,2) = 1
3910    LET ARMY.LOC(1,3) = 1
3920    LET ARMY.LOC(2,1) = 12
3930    LET ARMY.LOC(2,2) = 1
3940    LET ARMY.LOC(2,3) = 1
3950    LET ARMY.LOC(3,1) = 12
3960    LET ARMY.LOC(3,2) = 2
3970    LET ARMY.LOC(3,3) = 1
3980    LET ARMY.LOC(4,1) = 11
3990    LET ARMY.LOC(4,2) = 7
4000    LET ARMY.LOC(4,3) = 1
4010    LET ARMY.LOC(5,1) = 12
4020    LET ARMY.LOC(5,2) = 6
4030    LET ARMY.LOC(5,3) = 1
4040    LET ARMY.LOC(6,1) = 12
4050    LET ARMY.LOC(6,2) = 7
4060    LET ARMY.LOC(6,3) = 1
4070    LET ARMY.LOC(7,1) = 3
4080    LET ARMY.LOC(7,2) = 8
4090    LET ARMY.LOC(7,3) = 2
4100    LET ARMY.LOC(8,1) = 3
4110    LET ARMY.LOC(8,2) = 2
4120    LET ARMY.LOC(8,3) = 2
4130    LET ARMY.LOC(9,1) = 4
4140    LET ARMY.LOC(9,2) = 3
4150    LET ARMY.LOC(9,3) = 2
4160    LET ARMY.LOC(10,1) = 4
4170    LET ARMY.LOC(10,2) = 5
4180    LET ARMY.LOC(10,3) = 2
4190    FOR X = 1 TO MAX.ARMY
4200      IF ARMY.LOC(X,1) = 0 THEN GOTO 4260
4210      IF ARMY.LOC(X,3) = 1 THEN LET  P.COLOR = RED                                      ELSE LET P.COLOR = BLUE
4220      LET H.CORD = ARMY.LOC(X,1)
4230      LET V.CORD  = ARMY.LOC(X,2)
4240      IF P.COLOR = BLUE                                                                 THEN LET TERRAIN$(H.CORD,V.CORD) = TERRAIN$(H.CORD,V.CORD) + "U"                ELSE LET TERRAIN$(H.CORD,V.CORD) = TERRAIN$(H.CORD,V.CORD) + "R"
4250      GOSUB 8280    'PAINT HEX
4260    NEXT X
4270 RETURN
4280 '
4290 '**************************************************************************
4300 'MOVEMENT PHASE
4310 '  LH = OLD HORIZONAL HEX CO-ORDINATE
4320 '  LV = OLD VERTICAL HEX CO-ORDINATE
4330 '  NEWH = NEW HORIZONAL HEX CO-ORDINATE
4340 '  NEWV = NEW VERTICAL HEX CO-ORDINATE
4350    IF ARMY$ = "R" THEN LET CLR = RED:                                                  LET ARMY = 1
4360    IF ARMY$ = "U" THEN LET CLR = BLUE:                                                  LET ARMY = 2
4370    LOCATE 25,1
4380    IF ARMY$ = "R" THEN LET MSG$ = "RED ARMY MOVES "                                      ELSE LET MSG$ = "US ARMY MOVES     "
4390    GOSUB 8400
4400    FOR X = 1  TO MAX.ARMY
4410      IF ARMY.LOC(X,1) = 0 THEN GOTO 4500
4420      IF ARMY.LOC(X,3) <> ARMY THEN GOTO 4500
4430      LET LH = ARMY.LOC(X,1)
4440      LET LV = ARMY.LOC(X,2)
4450    LET H.CORD = LH
4460    LET V.CORD = LV
4470    LET P.COLOR = WHITE
4480      GOSUB 8280                     'PAINT HEX WHITE
4490      GOSUB 4540    'GET MOVE
4500    NEXT X
4510 RETURN
4520 '
4530 '---------------------------------------------------------------------------
4540 'GET MOVE
4550    LET MOVE = 1
4555    DEF SEG=0: POKE 1050,PEEK(1052) 'CLEAR KEYBOARD BUFFER
4560 ' GET CURSOR
4570 '  DEF SEG=0: POKE 1050,PEEK(1052) 'CLEAR KEYBOARD BUFFER
4580    LET REPLY$ = INKEY$
4590    IF REPLY$ = "" THEN GOTO 4580
4600    IF REPLY$ = " " THEN LET P.COLOR = CLR: GOSUB 8280:                                   GOTO 5360  'NO MORE MOVES
4610    IF LEFT$(REPLY$,1) <> CHR$(0) THEN BEEP:                                          GOTO 4580
4620    LET REPLY$ = RIGHT$(REPLY$,1)
4630    IF REPLY$ = CHR$(72) THEN LET NEWV = LV - 1:                                        LET NEWH = LH:                                                                  GOTO 4800
4640    IF REPLY$ = CHR$(80) THEN LET NEWV = LV + 1:                                        LET NEWH = LH:                                                                  GOTO 4800
4650    IF REPLY$ = CHR$(77) THEN LET NEWH = LH + 1:                                        LET NEWV = LV:                                                                  GOTO 4690
4660    IF REPLY$ <> CHR$(75) THEN BEEP:                                                  GOTO 4580
4670    LET NEWH = LH - 1
4680    LET NEWV = LV
4690 ' GET 2ND PART OF COMMAND
4700    LET REPLY$ = INKEY$
4710    IF REPLY$ = "" THEN GOTO 4690
4720    LET REPLY$ = RIGHT$(REPLY$,1)
4730    IF REPLY$ = CHR$(80) THEN GOTO 4750
4740    IF REPLY$ <> CHR$(72) THEN BEEP:                                                  GOTO 4580
4750 '
4760    IF COL$ = "ODD" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV  - 1
4770    IF COL$ = "ODD" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV
4780    IF COL$ = "EVEN" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV
4790    IF COL$ = "EVEN" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV + 1
4800 'CHECK FOR LEGAL MOVE
4810    IF NEWH < 1 THEN GOTO  4930     'ILLEGAL
4820    IF NEWH > 12 THEN GOTO 4930
4830    IF NEWV < 1 THEN GOTO 4930
4840    IF NEWV > 8 THEN GOTO 4930
4850    IF LEN(TERRAIN$(NEWH,NEWV)) = 2 THEN GOTO 4930 'HEX IS OCCUPIED
4860    IF TERRAIN$(NEWH,NEWV) = "O" THEN GOTO 4930 'OFF BOARD
4870    IF TERRAIN$(NEWH,NEWV) = "R" THEN GOTO 4930
4880    IF TERRAIN$(NEWH,NEWV) = "L" THEN GOTO 4930
4890    IF TERRAIN$(NEWH,NEWV) = "U" THEN GOTO 4930
4900    IF TERRAIN$(NEWH,NEWV) = "W" AND MOVE > 3 THEN GOTO 4930
4910    IF TERRAIN$(NEWH,NEWV) = "W" THEN LET MOVE = MOVE + 1 'EXTRA MOVE POINT FOR WOODS
4920    GOTO 4980       'MAKE MOVE
4930 'ILLEGAL MOVE
4940    BEEP
4950    LET MSG$ = "ILLEGAL MOVE"
4960    GOSUB 8400
4965    DEF SEG=0: POKE 1050,PEEK(1052) 'CLEAR KEYBOARD BUFFER
4970    GOTO 4560
4980 ' MOVE UNIT
4990    LET MSG$ = " "
5000    GOSUB 8400
5010    LET H.CORD = NEWH
5020    LET V.CORD = NEWV
5030    LET P.COLOR = CLR
5040    GOSUB 8280     'PAINT NEW LOC
5050      IF LEN(TERRAIN$(LH,LV)) = 1 THEN                                                  LET TERRAIN$(LH,LV) = "" ELSE                                                   LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
5060    LET H.CORD = LH
5070    LET V.CORD = LV
5080    LET P.COLOR = GRAY
5090      IF TERRAIN$(LH,LV) = "W" THEN                                                     LET P.COLOR = GREEN
5100      IF TERRAIN$(LH,LV) = "C" THEN                                                     LET P.COLOR = BROWN
5110    GOSUB 8280     'PAINT NEW LOC
5120      LET ARMY.LOC(X,1) = NEWH
5130      LET ARMY.LOC(X,2) = NEWV
5140      LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
5150      LET TERRAIN$(NEWH,NEWV) = TERRAIN$(NEWH,NEWV) + ARMY$
5160    LET MOVE = MOVE + 1
5170    IF MOVE > 4 THEN GOTO 5360
5180 ' CHECK IF MOVE IS NEXT TO ENEMY UNIT
5190    IF ARMY$ = "R" THEN LET ENEMY$ = "U"                                              ELSE LET ENEMY$ = "R"
5200    IF ((NEWH/2) - INT(NEWH/2)) < .5 THEN                                                 LET COL$ = "EVEN" ELSE                                                          LET COL$ = "ODD"
5210    IF RIGHT$(TERRAIN$(NEWH+1,NEWV),1) = ENEMY$ THEN GOTO 5360
5220    IF RIGHT$(TERRAIN$(NEWH-1,NEWV),1) = ENEMY$ THEN GOTO 5360
5230    IF RIGHT$(TERRAIN$(NEWH,NEWV+1),1) = ENEMY$ THEN GOTO 5360
5240    IF RIGHT$(TERRAIN$(NEWH,NEWV-1),1) = ENEMY$ THEN GOTO 5360
5250    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(NEWH+1,NEWV+1),1)) = ENEMY$               THEN GOTO 5360
5260    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(NEWH+1,NEWV-1),1)) = ENEMY$               THEN GOTO 5360
5270    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(NEWH-1,NEWV+1),1)) = ENEMY$               THEN GOTO 5360
5280    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(NEWH-1,NEWV-1),1)) = ENEMY$               THEN GOTO 5360
5290    LET LH = NEWH
5300    LET LV = NEWV
5310    LET H.CORD = LH
5320    LET V.CORD = LV
5330    LET P.COLOR = WHITE
5340    GOSUB 8280      'PAINT HEX WHITE
5350    GOTO 4560
5360 'END OF MOVE TURN
5370 RETURN
5380 '
5390 '---------------------------------------------------------------------------
5400 ' FIND WINNER
5410    LET SCORE = 0
5420    IF TERRAIN$(1,7) = "CR" THEN LET SCORE = SCORE + 1
5430    IF TERRAIN$(3,2) = "CR" THEN LET SCORE = SCORE + 1
5440    IF TERRAIN$(4,5) = "CR" THEN LET SCORE = SCORE + 1
5450    LOCATE 23,1
5460    IF SCORE > 1 THEN LET MSG$ = "RED ARMY WINS!     "                                ELSE LET MSG$ = "US ARMY WINS!     "
5470    GOSUB 8400      'PRINT MESSAGE
5480    GOSUB 1220      'WAIT FOR REPLY
5490 RETURN
5500 '
5510 '---------------------------------------------------------------------------
5520 'ATTACK PHASE
5530 'FIND EACH ARMY THAT CAN ATTACK
5540    ERASE ATTACK
5550    DIM ATTACK(10,7)
5560    IF ARMY$ = "U" THEN LET CLR = BLUE:                                               LET ARMY = 2
5570    IF ARMY$ = "R" THEN LET CLR = RED:                                                LET ARMY = 1
5580    IF ARMY$ = "R" THEN LET MSG$ = "RED ARMY ATTACKS "                                 ELSE LET MSG$ =  "US ARMY ATTACKS "
5590    GOSUB 8400      'PRINT MESSAGE
5600    FOR X = 1  TO MAX.ARMY
5610      IF ARMY.LOC(X,1) = 0 THEN GOTO 5670
5620      IF ARMY.LOC(X,3) <> ARMY THEN GOTO 5670
5630      LET LH = ARMY.LOC(X,1)
5640      LET LV = ARMY.LOC(X,2)
5650      GOSUB 5730    'CHECK IF ATTACK POSSIBLE
5660      IF ATTACK$ = "YES" THEN GOSUB 5900    'GET MOVEMENT FOR ATTACK
5670    NEXT X
5680    IF ATTACK(1,1) = 0 THEN GOTO 5700       'NO ATTACK THIS TURN
5690    GOSUB 6510      'GET RESULTS OF ATTACK
5700 RETURN
5710 '
5720 '---------------------------------------------------------------------------
5730 'CHECK IF UNIT CAN MAKE AN ATTACK
5740    LET ATTACK$ = "NO"
5750    IF ARMY$ = "R" THEN LET ENEMY$ = "U"                                              ELSE LET ENEMY$ = "R"
5760    IF ((LH/2) - INT(LH/2)) < .5 THEN                                                 LET COL$ = "EVEN" ELSE                                                          LET COL$ = "ODD"
5770    IF RIGHT$(TERRAIN$(LH+1,LV),1) = ENEMY$ THEN GOTO 5860
5780    IF RIGHT$(TERRAIN$(LH-1,LV),1) = ENEMY$ THEN GOTO 5860
5790    IF RIGHT$(TERRAIN$(LH,LV+1),1) = ENEMY$ THEN GOTO 5860
5800    IF RIGHT$(TERRAIN$(LH,LV-1),1) = ENEMY$ THEN GOTO 5860
5810    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(LH+1,LV+1),1)) = ENEMY$                   THEN GOTO 5860
5820    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(LH+1,LV-1),1)) = ENEMY$                    THEN GOTO 5860
5830    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(LH-1,LV+1),1)) = ENEMY$                   THEN GOTO 5860
5840    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(LH-1,LV-1),1)) = ENEMY$                    THEN GOTO 5860
5850    GOTO 5880       'NO ATTACK POSSIBLE
5860 ' ATTACK IS POSSIBLE
5870    LET ATTACK$= "YES"
5880 RETURN
5890 '
5900 'GET MOVEMENT FOR ATTACK
5910 ' GET CURSOR
5920    LET H.CORD = LH
5930    LET V.CORD = LV
5940    LET P.COLOR = WHITE
5950    GOSUB 8280      'PAINT HEX WHITE
5960    DEF SEG=0: POKE 1050,PEEK(1052) 'CLEAR KEYBOARD BUFFER
5970    LET REPLY$ = INKEY$
5980    IF REPLY$ = "" THEN GOTO 5970
5990    IF REPLY$ = " " THEN LET P.COLOR = CLR: GOSUB 8280:                                GOTO 6480  'NO ATTACK
6000    IF LEFT$(REPLY$,1) <> CHR$(0) THEN BEEP:                                          GOTO 5970
6010    LET REPLY$ = RIGHT$(REPLY$,1)
6020    IF REPLY$ = CHR$(72) THEN LET NEWV = LV - 1:                                        LET NEWH = LH:                                                                  GOTO 6190
6030    IF REPLY$ = CHR$(80) THEN LET NEWV = LV + 1:                                        LET NEWH = LH:                                                                  GOTO 6190
6040    IF REPLY$ = CHR$(77) THEN LET NEWH = LH + 1:                                        LET NEWV = LV:                                                                  GOTO 6080
6050    IF REPLY$ <> CHR$(75) THEN BEEP:                                                  GOTO 5970
6060    LET NEWH = LH - 1
6070    LET NEWV = LV
6080 ' GET 2ND PART OF COMMAND
6090    LET REPLY$ = INKEY$
6100    IF REPLY$ = "" THEN GOTO 6080
6110    LET REPLY$ = RIGHT$(REPLY$,1)
6120    IF REPLY$ = CHR$(80) THEN GOTO 6140
6130    IF REPLY$ <> CHR$(72) THEN BEEP:                                                  GOTO 6070
6140 '
6150    IF COL$ = "ODD" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV  - 1
6160    IF COL$ = "ODD" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV
6170    IF COL$ = "EVEN" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV
6180    IF COL$ = "EVEN" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV + 1
6190 'CHECK LEGAL MOVE
6200    IF NEWH < 1 THEN GOTO  6270     'ILLEGAL
6210    IF NEWH > 12 THEN GOTO 6270
6220    IF NEWV < 1 THEN GOTO 6270
6230    IF NEWV > 8 THEN GOTO 6270
6240    IF TERRAIN$(NEWH,NEWV) = "O" THEN GOTO 6270 'OFF BOARD
6250    IF RIGHT$(TERRAIN$(NEWH,NEWV),1) <> ENEMY$ THEN GOTO 6270 'NO ENEMY UNIT
6260    GOTO 6320       'RECORD ATTACK
6270 'ILLEGAL MOVE
6280    BEEP
6290    LET MSG$ =  "ILLEGAL MOVE"
6300    GOSUB 8400      'PRINT MSG
6310    GOTO 5910
6320 'RECORD ATTACK
6330    LET MSG$ = " "
6340    GOSUB 8400  'PRINT MSG
6350    LET P.COLOR = CLR
6360    GOSUB 8280      'RESTORE COLOR OF UNIT
6370    FOR Z = 1 TO MAX.ARMY   'FIND DEFENDER
6380      IF ARMY.LOC(Z,1) = NEWH AND ARMY.LOC(Z,2) = NEWV                                  THEN LET DEFENDER = Z:                                                          GOTO 6400
6390    NEXT Z
6400    FOR Z = 1 TO MAX.ARMY   'FIND DEFENDER IN ATTACK TABLE
6410      IF ATTACK(Z,1) = 0                                                                THEN LET ATTACK(Z,1) = DEFENDER:                                                GOTO 6440
6420      IF ATTACK(Z,1) = DEFENDER THEN GOTO 6440
6430    NEXT Z
6440    FOR Y = 2 TO 7
6450      IF ATTACK(Z,Y) = 0 THEN                                                            LET ATTACK(Z,Y) = X:                                                            GOTO 6470
6460    NEXT Y
6470 '  ATTACK IS RECORDED
6480 RETURN
6490 '
6500 '---------------------------------------------------------------------------
6510 'GET RESULTS OF ATTACK
6520    RANDOMIZE TIMER
6530    FOR Z = 1 TO 10
6540      IF ATTACK(Z,1) = 0 THEN GOTO 6570     'END OF ATTACKS
6550      GOSUB 6600    'ATTACK
6560    NEXT Z
6570 RETURN
6580 '
6590 '---------------------------------------------------------------------------
6600 'ATTACK
6610    LET ATTACKERS = 0
6620    FOR Y = 2 TO 7
6630      IF ATTACK(Z,Y) = 0 THEN GOTO 6660
6640      LET ATTACKERS = ATTACKERS + 1
6650    NEXT Y
6660    IF LEFT$(TERRAIN$(ARMY.LOC(ATTACK(Z,1),1),ARMY.LOC(ATTACK(Z,1),2)),1) = "W"                           THEN LET ATTACKERS = ATTACKERS - 1
6670    IF LEFT$(TERRAIN$(ARMY.LOC(ATTACK(Z,1),1),ARMY.LOC(ATTACK(Z,1),2)),1) = "C"                           THEN LET ATTACKERS = ATTACKERS - 1
6680    LET A = 2
6690    LET RESULT = INT((RND*6)+1) - ATTACKERS
6700    IF RESULT =< -2 THEN GOSUB 6770: GOTO 6740   'DEFENDER ELIMINATED
6710    IF RESULT <= 1 THEN GOSUB 6920: GOTO 6740    'DEFENDER RETREATS
6720    IF RESULT < 5 THEN GOSUB 7020: GOTO  6740    'ATTACKER RETREATS
6730    IF RESULT => 5 THEN GOSUB 7140: GOTO 6740    'ATTACKER ELIMINATED
6740 RETURN
6750 '
6760 '---------------------------------------------------------------------------
6770 'DEFENDER ELIMINATED
6780    LET LH = ARMY.LOC(ATTACK(Z,1),1)
6790    LET LV = ARMY.LOC(ATTACK(Z,1),2)
6800    LET ARMY.LOC(ATTACK(Z,1),1) = 0
6810    IF LEN(TERRAIN$(LH,LV)) = 1                                                       THEN LET TERRAIN$(LH,LV) = ""                                                   ELSE LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
6820    LET H.CORD = LH
6830    LET V.CORD = LV
6840    LET P.COLOR = GRAY
6850    IF TERRAIN$(LH,LV) = "W" THEN                                                     LET P.COLOR = GREEN
6860    IF TERRAIN$(LH,LV) = "C" THEN                                                     LET P.COLOR = BROWN
6870    GOSUB 8280      'PRINT LOC
6880    GOSUB 8040      'MOVE ATTACKER INTO HEX
6890 RETURN
6900 '
6910 '---------------------------------------------------------------------------
6920 'DEFENDER RETREATS
6930    LET A = 1
6940    IF ARMY$ = "R"                                                                    THEN LET R.ARMY$ = "U"                                                          ELSE LET R.ARMY$ = "R"
6950    LET LH = ARMY.LOC(ATTACK(Z,1),1)
6960    LET LV = ARMY.LOC(ATTACK(Z,1),2)
6970    LET DEFENDER$ = "YES"
6980    GOSUB 7280      'GET RETREAT MOVE
6990 RETURN
7000 '
7010 '---------------------------------------------------------------------------
7020 'ATTACKER RETREATS
7030    LET DEFENDER$ = "NO"
7040    LET R.ARMY$ = ARMY$
7050    FOR A = 2 TO 7
7060      IF ATTACK(Z,A) = 0 THEN GOTO 7110
7070      LET LH = ARMY.LOC(ATTACK(Z,A),1)
7080      LET LV = ARMY.LOC(ATTACK(Z,A),2)
7090      GOSUB 7280      'GET RETREAT MOVE
7100    NEXT A
7110 RETURN
7120 '
7130 '---------------------------------------------------------------------------
7140 'ATTACKER ELIMINATED
7150    LET LH = ARMY.LOC(ATTACK(Z,A),1)
7160    LET LV = ARMY.LOC(ATTACK(Z,A),2)
7170    LET ARMY.LOC(ATTACK(Z,A),1) = 0
7180    IF LEN(TERRAIN$(LH,LV)) = 1                                                       THEN LET TERRAIN$(LH,LV) = ""                                                   ELSE LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
7190    LET V.CORD = LV
7200    LET H.CORD = LH
7210    LET P.COLOR = GRAY
7220      IF TERRAIN$(LH,LV) = "W" THEN                                                     LET P.COLOR = GREEN
7230      IF TERRAIN$(LH,LV) = "C" THEN                                                     LET P.COLOR = BROWN
7240    GOSUB 8280      'PAINT HEX
7250 RETURN
7260 '
7270 '---------------------------------------------------------------------------
7280 'GET RETREAT MOVE
7290    IF R.ARMY$ = "U"                                                                  THEN LET R.ENEMY$ = "R"                                                         ELSE LET R.ENEMY$ = "U"
7300    IF R.ARMY$ = "R" THEN LET MSG$ = "RED ARMY RETREATS "                             ELSE LET MSG$ = "US ARMY RETREATS "
7310    GOSUB 8400      'PRINT MSG
7320    LET V.CORD = LV
7330    LET H.CORD = LH
7340    LET P.COLOR = WHITE
7350    GOSUB 8280      'PRINT HEX WHITE
7360    DEF SEG=0: POKE 1050,PEEK(1052) 'CLEAR KEYBOARD BUFFER
7370    LET REPLY$ = INKEY$
7380    IF REPLY$ = "" THEN GOTO 7370
7390    IF REPLY$ = " " THEN GOTO 7980   'UNIT ELIMINATED
7400    IF LEFT$(REPLY$,1) <> CHR$(0) THEN BEEP:                                          GOTO 7360
7410    LET REPLY$ = RIGHT$(REPLY$,1)
7420    IF REPLY$ = CHR$(72) THEN LET NEWV = LV - 1:                                        LET NEWH = LH:                                                                  GOTO 7590
7430    IF REPLY$ = CHR$(80) THEN LET NEWV = LV + 1:                                        LET NEWH = LH:                                                                  GOTO 7590
7440    IF REPLY$ = CHR$(77) THEN LET NEWH = LH + 1:                                        LET NEWV = LV:                                                                  GOTO 7480
7450    IF REPLY$ <> CHR$(75) THEN BEEP:                                                  GOTO 7360
7460    LET NEWH = LH - 1
7470    LET NEWV = LV
7480 ' GET 2ND PART OF COMMAND
7490    LET REPLY$ = INKEY$
7500    IF REPLY$ = "" THEN GOTO 7490
7510    LET REPLY$ = RIGHT$(REPLY$,1)
7520    IF REPLY$ = CHR$(80) THEN GOTO 7540
7530    IF REPLY$ <> CHR$(72) THEN BEEP:                                                  GOTO 7360
7540 '
7550    IF COL$ = "ODD" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV  - 1
7560    IF COL$ = "ODD" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV
7570    IF COL$ = "EVEN" AND REPLY$ = CHR$(72)                                              THEN LET NEWV = LV
7580    IF COL$ = "EVEN" AND REPLY$ = CHR$(80)                                              THEN LET NEWV = LV + 1
7590 'CHECK LEGAL MOVE
7600    IF NEWH < 1 THEN GOTO  7980     'ILLEGAL
7610    IF NEWH > 12 THEN GOTO 7980
7620    IF NEWV < 1 THEN GOTO 7980
7630    IF NEWV > 8 THEN GOTO 7980
7640    IF LEN(TERRAIN$(NEWH,NEWV)) = 2 THEN GOTO 7980 'HEX IS OCCUPIED
7650    IF TERRAIN$(NEWH,NEWV) = "O" THEN GOTO 7980 'OFF BOARD
7660    IF TERRAIN$(NEWH,NEWV) = "R" THEN GOTO 7980
7670    IF TERRAIN$(NEWH,NEWV) = "L" THEN GOTO 7980
7680    IF TERRAIN$(NEWH,NEWV) = "U" THEN GOTO 7980
7690 ' CHECK IF MOVE IS NEXT TO ENEMY UNIT
7700    IF ((NEWH/2) - INT(NEWH/2)) < .5 THEN                                                 LET COL$ = "EVEN" ELSE                                                          LET COL$ = "ODD"
7710    IF RIGHT$(TERRAIN$(NEWH+1,NEWV),1) = R.ENEMY$ THEN GOTO 7980
7720    IF RIGHT$(TERRAIN$(NEWH-1,NEWV),1) = R.ENEMY$ THEN GOTO 7980
7730    IF RIGHT$(TERRAIN$(NEWH,NEWV+1),1) = R.ENEMY$ THEN GOTO 7980
7740    IF RIGHT$(TERRAIN$(NEWH,NEWV-1),1) = R.ENEMY$ THEN GOTO 7980
7750    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(NEWH+1,NEWV+1),1)) = R.ENEMY$               THEN GOTO 7980
7760    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(NEWH+1,NEWV-1),1)) = R.ENEMY$               THEN GOTO 7980
7770    IF (COL$ = "EVEN") AND (RIGHT$(TERRAIN$(NEWH-1,NEWV+1),1)) = R.ENEMY$               THEN GOTO 7980
7780    IF (COL$ = "ODD") AND (RIGHT$(TERRAIN$(NEWH-1,NEWV-1),1)) = R.ENEMY$                 THEN GOTO 7980
7790 ' MOVE RETREATING UNIT
7800    IF R.ARMY$ = "R"                                                                  THEN LET CLR = RED                                                              ELSE LET CLR = BLUE
7810    LET H.CORD = NEWH
7820    LET V.CORD = NEWV
7830    LET P.COLOR = CLR
7840    GOSUB 8280      'PAINT NEW LOC
7850      IF LEN(TERRAIN$(LH,LV)) = 1 THEN                                                  LET TERRAIN$(LH,LV) = "" ELSE                                                   LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
7860    LET H.CORD = LH
7870    LET V.CORD = LV
7880    LET P.COLOR = GRAY
7890      IF TERRAIN$(LH,LV) = "W" THEN                                                     LET P.COLOR = GREEN
7900      IF TERRAIN$(LH,LV) = "C" THEN                                                     LET P.COLOR = BROWN
7910    GOSUB 8280      'PAINT OLD HEX
7920      LET ARMY.LOC(ATTACK(Z,A),1) = NEWH
7930      LET ARMY.LOC(ATTACK(Z,A),2) = NEWV
7940      LET TERRAIN$(NEWH,NEWV) = TERRAIN$(NEWH,NEWV) + R.ARMY$
7950    IF DEFENDER$ = "YES" THEN GOSUB 8040      'MOVE ATTACKER INTO HEX
7960    GOTO 8010      'END OF RETREAT
7970 '
7980 'RETREATING UNIT IS ELIMINATED
7990    IF DEFENDER$ = "YES"                                                              THEN GOSUB 6770                                                                 ELSE GOSUB 7140
8000    GOTO 8010      'END OF RETREAT
8010 RETURN
8020 '
8030 '---------------------------------------------------------------------------
8040 ' MOVE ATTACKER INTO EMPTY HEX
8050    LET NEWH = LH
8060    LET NEWV = LV
8070    LET LH = ARMY.LOC(ATTACK(Z,2),1)
8080    LET LV = ARMY.LOC(ATTACK(Z,2),2)
8090    IF ARMY$ = "R"                                                                    THEN LET CLR = RED                                                              ELSE LET CLR = BLUE
8110    LET V.CORD = NEWV
8120    LET H.CORD = NEWH
8130    LET P.COLOR = CLR
8140    GOSUB 8280      'PAINT NEW HEX
8150      IF LEN(TERRAIN$(LH,LV)) = 1 THEN                                                  LET TERRAIN$(LH,LV) = "" ELSE                                                   LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
8160    LET V.CORD = LV
8170    LET H.CORD = LH
8180    LET P.COLOR = GRAY
8190      IF TERRAIN$(LH,LV) = "C" THEN                                                     LET P.COLOR = BROWN
8200      IF TERRAIN$(LH,LV) = "W" THEN                                                     LET P.COLOR = GREEN
8210    GOSUB 8280      'PAINT OLD HEX
8220      LET ARMY.LOC(ATTACK(Z,2),1) = NEWH
8230      LET ARMY.LOC(ATTACK(Z,2),2) = NEWV
8240      LET TERRAIN$(LH,LV) = LEFT$(TERRAIN$(LH,LV),1)
8250      LET TERRAIN$(NEWH,NEWV) = TERRAIN$(NEWH,NEWV) + ARMY$
8260 RETURN
8270 '
8280 'PAINT A HEX
8290    LET V.POINT = ((V.CORD - 1) * 24) + 14
8300    IF ((H.CORD/2) - INT(H.CORD/2)) < .5                                              THEN LET COL$ = "EVEN"                                                          ELSE LET COL$ = "ODD"
8310    IF COL$ = "ODD"                                                                  THEN LET H.POINT = 25 + ((H.CORD -1) * 24)                                      ELSE LET H.POINT = 19 + ((H.CORD -1) * 24)
8320    LET H.COL = 3 + ((H.CORD-1)*3)
8330    IF COL$ = "ODD"                                                                   THEN LET V.COL = 2 + ((V.CORD-1)*3)                                             ELSE LET V.COL = 4 + ((V.CORD-1)*3)
8340    LOCATE V.COL,H.COL
8350    IF P.COLOR = BROWN                                                                THEN PRINT "C";
8360    IF P.COLOR = GREEN                                                                THEN PRINT "W";
8370    PAINT (H.POINT,V.POINT),P.COLOR,7
8380 RETURN
8390 '
8400 'PRINT A MESSAGE
8410    FOR CX = 1 TO LEN(MSG$)
8420      LOCATE CX,39
8430      PRINT MID$(MSG$,CX,1);
8440    NEXT CX
8450    FOR CX = CX TO 22
8460      LOCATE CX,39
8470      PRINT " ";
8480    NEXT CX
8490 RETURN
8500 '
8600 'F1 TRAP
8610    CH=1
8620    CV=2
8630    FOR C = 1 TO 8
8640            IF TERRAIN$(CH,CV)="" THEN LET TERRAIN$(CH,CV)="U": GOTO 8680
8650            LET CV=CV+1
8660            IF CV>8 THEN CV=0:CH=CH+1:
8670            GOTO 8640
8680            V.CORD=CV
8690            H.CORD=CH
8695            P.COLOR=BLUE
8696            GOSUB 8280
8697    NEXT C
8700 RETURN
