/* adviio.c - system dependant code for AdvInt */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#include <stdio.h>
#include <fcntl.h>

/* status values */
#define ST_OK	1
#define ST_ERR	0

/* external routines */
extern long lseek();

/* advinit - initialize */
/*
	This function parses the argument last and returns the
	data and log file names as well as the number of rows
	and columns on the user's screen.
*/
advinit(banner,argc,argv,dname,lname,prows,pcols)
  char *banner;	/* program banner text */
  int argc;	/* argc passed to main() */
  char *argv[];	/* argv passed to main() */
  char *dname;	/* data file name (output) */
  char *lname;	/* log file name (output) */
  int *prows;	/* number of screen rows (output) */
  int *pcols;	/* number of screen columns (output) */
{
    int i;
    
    /* print the banner text */
    printf("%s\n",banner);
    
    /* initialize and setup the defaults */
    dname[0] = '\0';
    lname[0] = '\0';
    *prows = 24;
    *pcols = 80;

    /* parse the command line */
    for (i = 1; i < argc; ++i)
	if (argv[i][0] == '-')
	    switch (argv[i][1]) {
	    case 'r':	/* set the number of screen rows */
	    case 'R':
		    *prows = atoi(&argv[i][2]);
		    break;
	    case 'c':	/* set the number of screen columns */
	    case 'C':
		    *pcols = atoi(&argv[i][2]);
		    break;
	    case 'l':	/* set the log file name */
	    case 'L':
		    lname = &argv[i][2];
	    	    break;
	    }
	else
	    strcpy(dname,argv[i]);

    /* make sure we got a data file name */
    if (dname[0] == '\0') {
	fprintf(stderr,
	    "usage: advint [-r<rows>] [-c<columns>] [-l<log-file>] <file>\n");
	exit(1);
    }

    /* add the default extension */
    strcat(dname,".dat");
}

/* advgetc - get a character from the terminal */
/*
	This routine reads a single character from the terminal.  The
	character should be echoed and the RETURN or ENTER key should
	cause a '\n' character to be returned.
*/
int advgetc()
{
/* This could be just:
	return (getchar());
*/
    int ch;
    if ((ch = bdos(1) & 0xFF) == '\r') {
	bdos(6,'\n');
	ch = '\n';
    }
    return (ch);
}

/* advputc - output a character to the terminal (newline is a '\n') */
/*
	This routine writes a single character to the terminal.  The
	character '\n' should result in the cursor being positioned
	at the first column of the next line.
*/
advputc(ch)
  int ch;	/* character to output */
{
/* This could be just:
	putchar(ch);
*/
    if (ch == '\n')
	bdos(6,'\r');
    bdos(6,ch);
}

/* advwaitc - wait for a key to be hit */
/*
	This function waits for a key to be hit.  If you can do this
	without echoing the character, you can wait for any character.
	If your runtime system does echo characters, your best bet
	would be to wait for the user to type RETURN or ENTER.
*/
advwaitc()
{
/* This could be just:
	while (getchar() != '\n');
*/
    bdos(7);
}

/* advlogc - output a character to the log file */
/*
	This routine writes a single character to an ASCII file.  It
	was added as a hook for the Aztec C runtime routines that
	require aputc() instead of putc() for ASCII files.  You should
	probably use putc() here.  Note that the file pointer passed
	as a parameter to this routine is the value returned from
	the fopen() routine called with the file mode of "w".
*/
advlogc(ch,fp)
  int ch;	/* character to output */
  FILE *fp;	/* output file pointer */
{	
/* This could be just:
	putc(ch,fp);
*/
    aputc(ch,fp); /* Aztec C uses aputc for ASCII output */
}

/* advcreate - create a binary data file */
/*
	This function *must* create the file in binary mode so that
	subsequent writes will also be in binary mode.  No character
	translations should be done during writes.  You probably
	won't need to modify this function unless your runtime
	library defaults to ASCII mode for files created with creat().
*/
int advcreate(name,pfd)
  char *name;	/* file name */
  int *pfd;	/* file descriptor (output) */
{
    /* create the file in ***BINARY*** mode */
    if ((*pfd = creat(name,0666)) < 0)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advopen - open a binary data file */
/*
	This function *must* open the file in binary mode so that
	subsequent reads will also be in binary mode.  No character
	translations should be done during reads.  You probably
	won't need to modify this function unless your runtime
	library defaults to ASCII mode for files opened with open().
*/
int advopen(name,pfd)
  char *name;	/* file name */
  int *pfd;	/* file descriptor (output) */
{
    /* open the file in ***BINARY*** mode */
    if ((*pfd = open(name,O_RDONLY)) < 0)
	return (ST_ERR);
	
    /* return successfully */
    return (ST_OK);
}

/* advclose - close a binary data file */
/*
	You probably won't need to modify this routine.  It was
	added as a hook to allow the use of non-UNIX style file
	I/O routines.
*/
int advclose(fd)
  int fd;	/* file descriptor */
{
    /* close the binary file */
    if (close(fd) != 0)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advseek - seek to a position in a binary data file */
/*
	You probably won't need to modify this routine.  It was
	added as a hook to allow the use of non-UNIX style file
	I/O routines.
*/
int advseek(fd,pos)
  int fd;	/* file descriptor */
  long pos;	/* new file position */
{
    /* seek to the position */
    if (lseek(fd,pos,0) != pos)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advread - read from a binary data file */
/*
	This function must read data in binary mode.  No character
	translations should be done here.
*/
int advread(fd,buf,len)
  int fd;	/* file descriptor */
  char *buf;	/* buffer address */
  int len;	/* number of bytes to read */
{
    /* read the data */
    if (read(fd,buf,len) != len)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advwrite - write to a binary data file */
/*
	This function must write data in binary mode.  No character
	translations should be done here.
*/
int advwrite(fd,buf,len)
  int fd;	/* file descriptor */
  char *buf;	/* buffer address */
  int len;	/* number of bytes to write */
{
    /* write the data */
    if (write(fd,buf,len) != len)
	return (ST_ERR);

    /* return successfully */
    return (ST_OK);
}

/* advsfile - get file name to restore */
/*
	You can probably leave this function as-is.  It was added
	to the machine/compiler specific module to provide a hook
	for using file requesters on machines like the Macintosh
	and the Atari-ST.
*/
int advsfile(name)
  char *name;	/* file name buffer (output) */
{  
    /* get the filename */
    trm_str("File to save (without the \".sav\")? ");
    trm_get(name);

    /* add the default extension */
    strcat(name,".sav");
    
    /* return status (ST_OK if the user typed something */
    return (*name != '.' ? ST_OK : ST_ERR);
}

/* advrfile - get file name to restore */
/*
	You can probably leave this function as-is.  It was added
	to the machine/compiler specific module to provide a hook
	for using file requesters on machines like the Macintosh
	and the Atari-ST.
*/
int advrfile(name)
  char *name;	/* file name buffer (output) */
{  
    /* get the filename */
    trm_str("File to restore (without the \".sav\")? ");
    trm_get(name);

    /* add the default extension */
    strcat(name,".sav");
    
    /* return status (ST_OK if the user typed something */
    return (*name != '.' ? ST_OK : ST_ERR);
}

/* advfatal - print a fatal error message and exit */
/*
	You can probably leave this function as-is.  It was added
	to the machine/compiler dependant module to provide a hook
	for using alert boxes on machines like the Macintosh and
	the Atari-ST.
*/
advfatal(msg)
  char *msg;	/* error message */
{
    trm_str(msg);
    trm_chr('\n');
    exit(1);
}

/* advpause - pause at the end of the adventure before returning to the OS */
/*
	This routine is provided as a hook for machines that clear the
	screen before returning to the OS.  It can be used to prevent
	the text that is displayed at the end of an adventure from
	being erased before the player has a chance to see it.
*/
advpause()
{
}

