/* advint.c - an interpreter for adventure games */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#include <setjmp.h>
#include "advint.h"
#include "advdbs.h"

#define BANNER \
"ADVINT v1.2a - Copyright (c) 1987, by David Betz"

/* global variables */
jmp_buf restart;

/* external variables */
extern int h_init;
extern int h_update;
extern int h_before;
extern int h_after;
extern int h_error;

/* main - the main routine */
main(argc,argv)
  int argc; char *argv[];
{
    char dname[50],lname[50];
    int rows,cols;

    /* initialize */
    advinit(BANNER,argc,argv,dname,lname,&rows,&cols);

    /* initialize terminal i/o */
    trm_init(rows,cols,lname[0] ? lname : NULL);

    /* initialize the database */
    db_init(dname);

    /* play the game */
    play();
}

/* play - the main loop */
play()
{
    /* establish the restart point */
    setjmp(restart);

    /* execute the initialization code */
    execute(h_init);

    /* turn handling loop */
    for (;;) {

	/* execute the update code */
	execute(h_update);

	/* parse the next input command */
	if (parse()) {
	    if (single())
		while (next() && single())
		    ;
	}

	/* parse error, call the error handling code */
	else
	    execute(h_error);
    }
}

/* single - handle a single action */
int single()
{
    /* execute the before code */
    switch (execute(h_before)) {
    case ABORT:	/* before handler aborted sequence */
	return (FALSE);
    case CHAIN:	/* execute the action handler */
	if (execute(getafield(getvalue(V_ACTION),A_CODE)) == ABORT)
	    return (FALSE);
    case FINISH:/* execute the after code */
	if (execute(h_after) == ABORT)
	    return (FALSE);
	break;
    }
    return (TRUE);
}
